/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.format.validate.ParsedIPAddress;
import java.io.Serializable;

public class ParsedHostIdentifierStringQualifier
implements Serializable,
Cloneable {
    private Integer networkPrefixLength;
    private final Integer port;
    private final CharSequence service;
    private ParsedIPAddress mask;
    private IPAddress mergedMask;
    private final CharSequence zone;

    ParsedHostIdentifierStringQualifier() {
        this(null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    ParsedHostIdentifierStringQualifier(CharSequence zone) {
        this(null, null, (CharSequence)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ParsedHostIdentifierStringQualifier(CharSequence zone, int port) {
        this(null, null, (CharSequence)var1_1, ParsedHostIdentifierStringQualifier.cachePorts((int)var2_2), null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ParsedHostIdentifierStringQualifier(Integer networkPrefixLength, CharSequence zone) {
        this((Integer)var1_1, null, (CharSequence)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ParsedHostIdentifierStringQualifier(ParsedIPAddress mask, CharSequence zone) {
        this(null, (ParsedIPAddress)var1_1, (CharSequence)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ParsedHostIdentifierStringQualifier(CharSequence zone, CharSequence service) {
        this(null, null, zone, null, service);
        void var2_2;
        void var1_1;
        if (var1_1 != null && var2_2 != null) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private ParsedHostIdentifierStringQualifier(Integer networkPrefixLength, ParsedIPAddress mask, CharSequence zone, Integer port, CharSequence service) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.networkPrefixLength = var1_1;
        this.mask = var2_2;
        this.zone = var3_3;
        this.port = port;
        this.service = service;
    }

    private static Integer cachePorts(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideMask(ParsedHostIdentifierStringQualifier other) {
        if (other.mask != null) {
            void var1_1;
            this.mask = var1_1.mask;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void overridePrefixLength(ParsedHostIdentifierStringQualifier other) {
        if (other.networkPrefixLength != null) {
            void var1_1;
            this.networkPrefixLength = var1_1.networkPrefixLength;
        }
    }

    /*
     * WARNING - void declaration
     */
    void overridePrefix(ParsedHostIdentifierStringQualifier other) {
        void var1_1;
        this.overridePrefixLength(other);
        this.overrideMask((ParsedHostIdentifierStringQualifier)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void merge(ParsedHostIdentifierStringQualifier other) {
        if (this.networkPrefixLength == null || other.networkPrefixLength != null && other.networkPrefixLength < this.networkPrefixLength) {
            this.networkPrefixLength = other.networkPrefixLength;
        }
        if (this.mask == null) {
            if (other.mask != null) {
                this.mask = other.mask;
                return;
            }
        } else if (other.mask != null) {
            void var1_1;
            this.mergedMask = this.getMaskLower().mask(var1_1.getMaskLower());
        }
    }

    IPAddress getMaskLower() {
        if (this.mergedMask != null) {
            return this.mergedMask;
        }
        if (this.mask != null) {
            return this.mask.getValForMask();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Integer getEquivalentPrefixLength() {
        void var1_1;
        IPAddress mask;
        Integer pref = this.getNetworkPrefixLength();
        if (pref == null && (mask = this.getMaskLower()) != null) {
            void var2_2;
            pref = var2_2.getBlockMaskPrefixLength(true);
        }
        return var1_1;
    }

    CharSequence getZone() {
        return this.zone;
    }

    Integer getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    Integer getPort() {
        return this.port;
    }

    CharSequence getService() {
        return this.service;
    }

    /*
     * WARNING - void declaration
     */
    IPAddress.IPVersion inferVersion(IPAddressStringParameters validationOptions) {
        if (this.networkPrefixLength != null) {
            void var1_1;
            if (this.networkPrefixLength > IPAddress.getBitCount(IPAddress.IPVersion.IPV4) && !var1_1.getIPv4Parameters().allowPrefixesBeyondAddressSize) {
                return IPAddress.IPVersion.IPV6;
            }
        } else if (this.mask != null) {
            if (this.mask.isProvidingIPv6()) {
                return IPAddress.IPVersion.IPV6;
            }
            if (this.mask.isProvidingIPv4()) {
                return IPAddress.IPVersion.IPV4;
            }
        }
        if (this.zone != null) {
            return IPAddress.IPVersion.IPV6;
        }
        return null;
    }

    protected ParsedHostIdentifierStringQualifier clone() {
        try {
            return (ParsedHostIdentifierStringQualifier)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "network prefix length: " + this.networkPrefixLength + " mask: " + this.mask + " zone: " + this.zone + " port: " + this.port + " service: " + this.service;
    }
}

