/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import java.io.Serializable;

public class ParsedHost
implements Serializable {
    private static final EmbeddedAddress NO_EMBEDDED_ADDRESS = new EmbeddedAddress();
    static final ParsedHostIdentifierStringQualifier NO_QUALIFIER = new ParsedHostIdentifierStringQualifier();
    private String[] normalizedLabels;
    private int[] separatorIndices;
    private boolean[] normalizedFlags;
    private final ParsedHostIdentifierStringQualifier labelsQualifier;
    private String service;
    private EmbeddedAddress embeddedAddress;
    String host;
    private final String originalStr;

    /*
     * WARNING - void declaration
     */
    public ParsedHost(String originalStr, IPAddressProvider valueProvider, ParsedHostIdentifierStringQualifier portQualifier) {
        this((String)var1_1, null, null, (ParsedHostIdentifierStringQualifier)var3_3, new EmbeddedAddress());
        void var2_2;
        void var3_3;
        void var1_1;
        this.embeddedAddress.addressProvider = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedHostIdentifierStringQualifier labelsQualifier) {
        this((String)var1_1, (int[])var2_2, (boolean[])var3_3, labelsQualifier, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedHostIdentifierStringQualifier labelsQualifier, EmbeddedAddress embeddedAddress) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.labelsQualifier = labelsQualifier;
        this.normalizedFlags = var3_3;
        this.separatorIndices = var2_2;
        this.originalStr = var1_1;
        this.embeddedAddress = embeddedAddress == null ? NO_EMBEDDED_ADDRESS : embeddedAddress;
    }

    public Integer getPort() {
        return this.labelsQualifier.getPort();
    }

    /*
     * WARNING - void declaration
     */
    public String getService() {
        void var1_1;
        CharSequence sv;
        String serv = this.service;
        if (serv == null && (sv = this.labelsQualifier.getService()) != null) {
            void var2_2;
            this.service = serv = var2_2.toString();
        }
        return var1_1;
    }

    public Integer getEquivalentPrefixLength() {
        return this.labelsQualifier.getEquivalentPrefixLength();
    }

    public IPAddress getMask() {
        return this.labelsQualifier.getMaskLower();
    }

    public IPAddressProvider getAddressProvider() {
        return this.embeddedAddress.addressProvider;
    }

    private boolean hasEmbeddedAddress() {
        return this.embeddedAddress.addressProvider != null;
    }

    public boolean isAddressString() {
        return this.getAddressProvider() != null;
    }

    public IPAddress asAddress() throws IncompatibleAddressException {
        if (this.hasEmbeddedAddress()) {
            return this.getAddressProvider().getProviderAddress();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String mapString(IPAddressProvider addressProvider) {
        void var1_1;
        if (addressProvider.isProvidingAllAddresses()) {
            return IPAddress.SEGMENT_WILDCARD_STR;
        }
        if (addressProvider.isProvidingPrefixOnly()) {
            return IPAddressNetwork.getPrefixString(addressProvider.getProviderNetworkPrefixLength());
        }
        if (var1_1.isProvidingEmpty()) {
            return "";
        }
        return this.originalStr;
    }

    /*
     * WARNING - void declaration
     */
    public IPAddressString asGenericAddressString() {
        if (this.hasEmbeddedAddress()) {
            IPAddressProvider addressProvider = this.getAddressProvider();
            if (addressProvider.isProvidingAllAddresses()) {
                return new IPAddressString(IPAddress.SEGMENT_WILDCARD_STR, addressProvider.getParameters());
            }
            if (addressProvider.isProvidingPrefixOnly()) {
                return new IPAddressString(IPAddressNetwork.getPrefixString(addressProvider.getProviderNetworkPrefixLength()), addressProvider.getParameters());
            }
            if (addressProvider.isProvidingEmpty()) {
                return new IPAddressString("", addressProvider.getParameters());
            }
            try {
                IPAddress iPAddress = addressProvider.getProviderAddress();
                return iPAddress.toAddressString();
            }
            catch (IncompatibleAddressException incompatibleAddressException) {
                void var1_1;
                return new IPAddressString(this.originalStr, var1_1.getParameters());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getNormalizedLabels() {
        void var1_1;
        String[] labels = this.normalizedLabels;
        if (this.normalizedLabels == null) {
            ParsedHost parsedHost = this;
            synchronized (parsedHost) {
                labels = this.normalizedLabels;
                if (this.normalizedLabels == null) {
                    if (this.hasEmbeddedAddress()) {
                        IPAddressProvider addressProvider = this.getAddressProvider();
                        try {
                            IPAddress addr = addressProvider.getProviderAddress();
                            if (addr != null) {
                                IPAddressSection section = addr.getSection();
                                this.normalizedLabels = section.getSegmentStrings();
                                return this.normalizedLabels;
                            }
                        }
                        catch (IncompatibleAddressException incompatibleAddressException) {}
                        labels = addressProvider.isProvidingEmpty() ? new String[]{} : new String[]{this.mapString(addressProvider)};
                    } else {
                        labels = new String[this.separatorIndices.length];
                        int lastSep = -1;
                        for (int i = 0; i < labels.length; ++i) {
                            int n;
                            int index = this.separatorIndices[i];
                            if (this.normalizedFlags != null && !this.normalizedFlags[i]) {
                                StringBuilder second = new StringBuilder(index - lastSep - 1);
                                for (int j = lastSep + 1; j < index; ++j) {
                                    char c = this.originalStr.charAt(j);
                                    second.append(c >= 'A' && c <= 'Z' ? (char)(c + 32) : c);
                                }
                                labels[i] = second.toString();
                            } else {
                                labels[i] = this.originalStr.substring((int)(n + true), index);
                            }
                            n = index;
                        }
                        this.separatorIndices = null;
                        this.normalizedFlags = null;
                    }
                    this.normalizedLabels = labels;
                }
            }
        }
        return var1_1;
    }

    public String getHost() {
        String string;
        String str = this.host;
        if (str == null) {
            if (this.originalStr.length() > 0) {
                ParsedHost parsedHost = this;
                synchronized (parsedHost) {
                    str = this.host;
                    if (str == null) {
                        if (this.hasEmbeddedAddress()) {
                            IPAddressProvider addressProvider = this.getAddressProvider();
                            try {
                                IPAddress addr = addressProvider.getProviderAddress();
                                if (addr != null) {
                                    this.host = addr.getSection().toCanonicalWildcardString();
                                    return this.host;
                                }
                            }
                            catch (IncompatibleAddressException incompatibleAddressException) {}
                            this.host = this.mapString(addressProvider);
                            return this.host;
                        }
                        StringBuilder builder = new StringBuilder(this.originalStr.length());
                        String[] labels = this.getNormalizedLabels();
                        builder.append(labels[0]);
                        for (int i = 1; i < labels.length; ++i) {
                            builder.append('.').append(labels[i]);
                        }
                        this.host = ((StringBuilder)((Object)string)).toString();
                        return this.host;
                    }
                }
            }
            string = this.host = this.originalStr;
        }
        return string;
    }

    static class EmbeddedAddress
    implements Serializable {
        boolean isUNCIPv6Literal;
        boolean isReverseDNS;
        AddressStringException addressStringException;
        IPAddressProvider addressProvider;

        EmbeddedAddress() {
        }
    }
}

