/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;

public class ParsedAddressGrouping {
    private static final Integer[] cache = new Integer[Short.MAX_VALUE];

    /*
     * WARNING - void declaration
     */
    public static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        int n;
        if (bytesPerSegment > 1) {
            void var2_2;
            void var1_1;
            if (var1_1 == 2) {
                return networkPrefixLength - 1 >> 4;
            }
            return (networkPrefixLength - 1) / var2_2;
        }
        return n - 1 >> 3;
    }

    /*
     * WARNING - void declaration
     */
    public static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        int n;
        if (bytesPerSegment > 1) {
            void var2_2;
            void var1_1;
            if (var1_1 == 2) {
                return networkPrefixLength >> 4;
            }
            return networkPrefixLength / var2_2;
        }
        return n >> 3;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        if (prefixLength != null) {
            void var2_2;
            void var1_1;
            int n;
            return ParsedAddressGrouping.getPrefixedSegmentPrefixLength(n, var1_1.intValue(), (int)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getPrefixedSegmentPrefixLength(int bitsPerSegment, int prefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        int n;
        int decrement = bitsPerSegment == 8 ? segmentIndex << 3 : (bitsPerSegment == 16 ? segmentIndex << 4 : segmentIndex * bitsPerSegment);
        return ParsedAddressGrouping.getDivisionPrefixLength(n, (int)(var1_1 - var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getDivisionPrefixLength(int divisionBits, int divisionPrefixedBits) {
        int n;
        if (divisionPrefixedBits <= 0) {
            return ParsedAddressGrouping.cache(0);
        }
        if (divisionPrefixedBits <= n) {
            void var1_1;
            return ParsedAddressGrouping.cache((int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getNetworkPrefixLength(int bitsPerSegment, int segmentPrefixLength, int segmentIndex) {
        void var1_1;
        int n;
        void var2_2;
        n = bitsPerSegment == 8 ? segmentIndex << 3 : (bitsPerSegment == 16 ? segmentIndex << 4 : var2_2 * n);
        return ParsedAddressGrouping.cache(n + var1_1);
    }

    public static boolean isPrefixSubnet(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, Integer networkPrefixLength, AddressNetwork.PrefixConfiguration prefixConfiguration, boolean fullRangeOnly) {
        int totalBitCount;
        if (networkPrefixLength == null || prefixConfiguration.prefixedSubnetsAreExplicit()) {
            return false;
        }
        if (networkPrefixLength < 0) {
            networkPrefixLength = 0;
        } else {
            int n = bitsPerSegment == 8 ? segmentCount << 3 : (totalBitCount = bitsPerSegment == 16 ? segmentCount << 4 : segmentCount * bitsPerSegment);
            if (networkPrefixLength >= totalBitCount) {
                return false;
            }
        }
        if (prefixConfiguration.allPrefixedAddressesAreSubnets()) {
            return true;
        }
        int i = totalBitCount = ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
        if (totalBitCount < segmentCount) {
            int segmentPrefixLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            do {
                int upper;
                int lower = lowerValueProvider.getValue(i);
                if (segmentPrefixLength == 0) {
                    if (lower != 0) {
                        return false;
                    }
                    upper = upperValueProvider.getValue(i);
                    if (fullRangeOnly) {
                        if (upper != segmentMaxValue) {
                            return false;
                        }
                    } else {
                        int upperOnes = Integer.numberOfTrailingZeros(~upper);
                        if (upperOnes > 0) {
                            if (upper >>> upperOnes != 0) {
                                return false;
                            }
                            fullRangeOnly = true;
                        } else if (upper != 0) {
                            return false;
                        }
                    }
                } else if (upper < bitsPerSegment) {
                    int upper2;
                    int segHostBits = bitsPerSegment - upper;
                    if (fullRangeOnly) {
                        int hostMask = ~(-1 << segHostBits);
                        if ((hostMask & lower) != 0) {
                            return false;
                        }
                        upper2 = upperValueProvider.getValue(i);
                        if ((hostMask & upper2) != hostMask) {
                            return false;
                        }
                    } else {
                        boolean bl;
                        int n = Integer.numberOfTrailingZeros(upper2);
                        if (n < segHostBits) {
                            return false;
                        }
                        upper2 = upperValueProvider.getValue(i);
                        int upperOnes = Integer.numberOfTrailingZeros(~upper2);
                        if (upperOnes < segHostBits) {
                            int upperZeros = Integer.numberOfTrailingZeros((upper2 | -1 << bitsPerSegment) >>> upperOnes);
                            if (upperOnes + upperZeros < segHostBits) {
                                return false;
                            }
                            bl = upperOnes > 0;
                        } else {
                            bl = true;
                        }
                    }
                }
                boolean bl = false;
            } while (++i < segmentCount);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer cache(int i) {
        int n;
        if (i >= 0 && i < cache.length) {
            void var1_1;
            Integer result = cache[i];
            if (result == null) {
                int n2 = i;
                Integer n3 = n2;
                ParsedAddressGrouping.cache[n2] = n3;
                result = n3;
            }
            return var1_1;
        }
        return n;
    }

    static {
        int i = 0;
        while (i <= 128) {
            int n = i++;
            ParsedAddressGrouping.cache[n] = n;
        }
    }
}

