/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.format.validate.ParsedIPAddress;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Objects;

public interface IPAddressProvider
extends Serializable {
    public static final NullProvider INVALID_PROVIDER = new NullProvider(IPType.INVALID){
        {
            void var1_1;
        }

        @Override
        public boolean isInvalid() {
            return true;
        }
    };
    public static final NullProvider NO_TYPE_PROVIDER = new NullProvider(null){
        {
            void var1_1;
        }

        @Override
        public boolean isUninitialized() {
            return true;
        }
    };
    public static final NullProvider EMPTY_PROVIDER = new NullProvider(IPType.EMPTY){
        {
            void var1_1;
        }

        @Override
        public boolean isProvidingEmpty() {
            return true;
        }
    };

    public IPType getType();

    public IPAddress getProviderAddress() throws IncompatibleAddressException;

    /*
     * WARNING - void declaration
     */
    default public int providerCompare(IPAddressProvider other) throws IncompatibleAddressException {
        void var1_1;
        void var3_3;
        IPAddress otherValue;
        if (this == other) {
            return 0;
        }
        IPAddress value = this.getProviderAddress();
        if (value != null && (otherValue = other.getProviderAddress()) != null) {
            void var2_2;
            return var2_2.compareTo(otherValue);
        }
        IPType thisType = this.getType();
        IPType otherType = other.getType();
        if (thisType == null) {
            if (otherType == null) {
                return 0;
            }
            return -1;
        }
        if (otherType == null) {
            return 1;
        }
        return var3_3.ordinal() - var1_1.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    default public boolean providerEquals(IPAddressProvider other) throws IncompatibleAddressException {
        void var1_1;
        if (this == other) {
            return true;
        }
        IPAddress value = this.getProviderAddress();
        if (value != null) {
            IPAddress otherValue = other.getProviderAddress();
            if (otherValue != null) {
                void var2_2;
                return var2_2.equals(var1_1);
            }
            return false;
        }
        return this.getType() == var1_1.getType();
    }

    /*
     * WARNING - void declaration
     */
    default public int providerHashCode() throws IncompatibleAddressException {
        IPAddress value = this.getProviderAddress();
        if (value != null) {
            void var1_1;
            return var1_1.hashCode();
        }
        return Objects.hashCode((Object)this.getType());
    }

    default public IPAddress.IPVersion getProviderIPVersion() {
        return null;
    }

    default public boolean isProvidingIPAddress() {
        return false;
    }

    default public boolean isProvidingPrefixOnly() {
        return false;
    }

    default public boolean isProvidingAllAddresses() {
        return false;
    }

    default public boolean isProvidingEmpty() {
        return false;
    }

    default public Integer getProviderNetworkPrefixLength() {
        return null;
    }

    default public boolean isInvalid() {
        return false;
    }

    default public boolean isUninitialized() {
        return false;
    }

    default public Boolean parsedEquals(IPAddressProvider other) {
        return null;
    }

    default public IPAddressStringParameters getParameters() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IPAddressProvider getProviderFor(IPAddress address, IPAddress hostAddress) {
        void var1_1;
        IPAddress iPAddress;
        return new CachedAddressProvider(iPAddress, (IPAddress)var1_1);
    }

    public static class AllCreator
    extends AdjustedAddressCreator {
        HostIdentifierString originator;
        ParsedHostIdentifierStringQualifier qualifier;

        /*
         * WARNING - void declaration
         */
        AllCreator(ParsedHostIdentifierStringQualifier qualifier, IPAddress.IPVersion adjustedVersion, HostIdentifierString originator, IPAddressStringParameters options) {
            super(qualifier.getEquivalentPrefixLength(), (IPAddress.IPVersion)var2_2, options);
            void var1_1;
            void var3_3;
            void var2_2;
            this.originator = var3_3;
            this.qualifier = var1_1;
        }

        @Override
        public IPType getType() {
            if (this.adjustedVersion != null) {
                return IPType.from(this.adjustedVersion);
            }
            return IPType.ALL;
        }

        @Override
        public boolean isProvidingAllAddresses() {
            return this.adjustedVersion == null;
        }

        @Override
        public Integer getProviderNetworkPrefixLength() {
            return this.qualifier.getEquivalentPrefixLength();
        }

        @Override
        public int providerHashCode() {
            if (this.adjustedVersion == null) {
                return IPAddress.SEGMENT_WILDCARD_STR.hashCode();
            }
            return super.hashCode();
        }

        @Override
        ParsedIPAddress.CachedIPAddresses<?> createAddresses() {
            if (this.qualifier.equals(ParsedHost.NO_QUALIFIER)) {
                return new ParsedIPAddress.CachedIPAddresses<IPAddress>(ParsedIPAddress.createAllAddress(this.adjustedVersion, this.qualifier, this.originator, this.options));
            }
            return new ParsedIPAddress.CachedIPAddresses<IPAddress>(ParsedIPAddress.createAllAddress(this.adjustedVersion, this.qualifier, this.originator, this.options), ParsedIPAddress.createAllAddress(this.adjustedVersion, this.qualifier.getZone() != null ? new ParsedHostIdentifierStringQualifier(this.qualifier.getZone()) : ParsedHost.NO_QUALIFIER, this.originator, this.options));
        }
    }

    public static class LoopbackCreator
    extends VersionedAddressCreator {
        private final CharSequence zone;

        /*
         * WARNING - void declaration
         */
        LoopbackCreator(IPAddressStringParameters options) {
            this(null, (IPAddressStringParameters)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        LoopbackCreator(CharSequence zone, IPAddressStringParameters options) {
            super((IPAddressStringParameters)var2_2);
            void var1_1;
            void var2_2;
            this.zone = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ParsedIPAddress.CachedIPAddresses<IPAddress> createAddresses() {
            void var1_1;
            Object result;
            InetAddress loopback = InetAddress.getLoopbackAddress();
            boolean isIPv62 = loopback instanceof Inet6Address;
            if (this.zone != null && this.zone.length() > 0 && isIPv62) {
                IPv6AddressNetwork.IPv6AddressCreator isIPv62 = this.options.getIPv6Parameters().getNetwork().getAddressCreator();
                result = (IPAddress)((ParsedAddressCreator)isIPv62).createAddressInternal(loopback.getAddress(), this.zone);
            } else {
                void var2_2;
                result = var2_2 != false ? this.options.getIPv6Parameters().getNetwork().getLoopback() : this.options.getIPv4Parameters().getNetwork().getLoopback();
            }
            return new ParsedIPAddress.CachedIPAddresses<void>(var1_1);
        }

        @Override
        public Integer getProviderNetworkPrefixLength() {
            return null;
        }
    }

    public static class MaskCreator
    extends AdjustedAddressCreator {
        /*
         * WARNING - void declaration
         */
        MaskCreator(Integer networkPrefixLength, IPAddress.IPVersion adjustedVersion, IPAddressStringParameters options) {
            super((Integer)var1_1, (IPAddress.IPVersion)var2_2, (IPAddressStringParameters)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public int providerHashCode() {
            if (this.adjustedVersion == null) {
                return ((CachedAddressProvider)this).getProviderNetworkPrefixLength();
            }
            return ((CachedAddressProvider)this).getProviderAddress().hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean providerEquals(IPAddressProvider valueProvider) {
            void var1_1;
            if (valueProvider == this) {
                return true;
            }
            if (this.adjustedVersion == null) {
                if (valueProvider.getType() == IPType.PREFIX_ONLY) {
                    return valueProvider.getProviderNetworkPrefixLength().intValue() == ((CachedAddressProvider)this).getProviderNetworkPrefixLength().intValue();
                }
                return false;
            }
            return super.providerEquals((IPAddressProvider)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int providerCompare(IPAddressProvider other) throws IncompatibleAddressException {
            void var1_1;
            if (this == other) {
                return 0;
            }
            if (this.adjustedVersion == null) {
                if (other.getType() == IPType.PREFIX_ONLY) {
                    return other.getProviderNetworkPrefixLength() - ((CachedAddressProvider)this).getProviderNetworkPrefixLength();
                }
                return IPType.PREFIX_ONLY.ordinal() - other.getType().ordinal();
            }
            IPAddress otherValue = other.getProviderAddress();
            if (otherValue != null) {
                void var2_2;
                return ((CachedAddressProvider)this).getProviderAddress().compareTo((AddressItem)var2_2);
            }
            return IPType.from(this.adjustedVersion).ordinal() - var1_1.getType().ordinal();
        }

        /*
         * WARNING - void declaration
         */
        private IPAddress createVersionedMask(IPAddress.IPVersion version, int bits, boolean withPrefixLength) {
            void var2_2;
            void var1_1;
            void var3_3;
            IPAddressNetwork network;
            IPAddressNetwork iPAddressNetwork = network = version.isIPv4() ? this.options.getIPv4Parameters().getNetwork() : this.options.getIPv6Parameters().getNetwork();
            if (var3_3 != false) {
                return network.getNetworkAddress(bits);
            }
            return var1_1.getNetworkMask((int)var2_2, false);
        }

        @Override
        public IPType getType() {
            if (this.adjustedVersion != null) {
                return IPType.from(this.adjustedVersion);
            }
            return IPType.PREFIX_ONLY;
        }

        @Override
        public boolean isProvidingPrefixOnly() {
            return this.adjustedVersion == null;
        }

        @Override
        ParsedIPAddress.CachedIPAddresses<?> createAddresses() {
            MaskCreator maskCreator = this;
            MaskCreator maskCreator2 = this;
            return new ParsedIPAddress.CachedIPAddresses<IPAddress>(maskCreator.createVersionedMask(maskCreator.adjustedVersion, ((CachedAddressProvider)this).getProviderNetworkPrefixLength(), true), maskCreator2.createVersionedMask(maskCreator2.adjustedVersion, ((CachedAddressProvider)this).getProviderNetworkPrefixLength(), false));
        }
    }

    public static abstract class AdjustedAddressCreator
    extends VersionedAddressCreator {
        protected final IPAddress.IPVersion adjustedVersion;
        protected final Integer networkPrefixLength;

        /*
         * WARNING - void declaration
         */
        AdjustedAddressCreator(Integer networkPrefixLength, IPAddress.IPVersion adjustedVersion, IPAddressStringParameters options) {
            super((IPAddressStringParameters)var3_3);
            void var2_2;
            void var1_1;
            void var3_3;
            this.networkPrefixLength = var1_1;
            this.adjustedVersion = var2_2;
        }

        @Override
        public boolean isProvidingIPAddress() {
            return this.adjustedVersion != null;
        }

        @Override
        public IPAddress.IPVersion getProviderIPVersion() {
            return this.adjustedVersion;
        }

        @Override
        public Integer getProviderNetworkPrefixLength() {
            return this.networkPrefixLength;
        }

        @Override
        public IPAddress getProviderAddress() {
            if (this.adjustedVersion == null) {
                return null;
            }
            return super.getProviderAddress();
        }
    }

    public static abstract class VersionedAddressCreator
    extends CachedAddressProvider {
        protected final IPAddressStringParameters options;

        /*
         * WARNING - void declaration
         */
        VersionedAddressCreator(IPAddressStringParameters options) {
            void var1_1;
            this.options = var1_1;
        }

        @Override
        public IPAddressStringParameters getParameters() {
            return this.options;
        }
    }

    public static class CachedAddressProvider
    implements IPAddressProvider {
        ParsedIPAddress.CachedIPAddresses<?> values;

        CachedAddressProvider() {
        }

        /*
         * WARNING - void declaration
         */
        private CachedAddressProvider(IPAddress address, IPAddress hostAddress) {
            void var2_2;
            void var1_1;
            this.values = new ParsedIPAddress.CachedIPAddresses<void>(var1_1, var2_2);
        }

        ParsedIPAddress.CachedIPAddresses<?> createAddresses() {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private ParsedIPAddress.CachedIPAddresses<?> getCachedAddresses() {
            void var1_1;
            ParsedIPAddress.CachedIPAddresses<?> val = this.values;
            if (val == null) {
                CachedAddressProvider cachedAddressProvider = this;
                synchronized (cachedAddressProvider) {
                    val = this.values;
                    if (val == null) {
                        this.values = val = this.createAddresses();
                    }
                }
            }
            return var1_1;
        }

        @Override
        public IPAddress getProviderAddress() {
            return this.getCachedAddresses().getAddress();
        }

        @Override
        public Integer getProviderNetworkPrefixLength() {
            return this.getProviderAddress().getNetworkPrefixLength();
        }

        @Override
        public IPAddress.IPVersion getProviderIPVersion() {
            return this.getProviderAddress().getIPVersion();
        }

        @Override
        public IPType getType() {
            return IPType.from(this.getProviderIPVersion());
        }

        @Override
        public boolean isProvidingIPAddress() {
            return true;
        }

        public String toString() {
            return String.valueOf(this.getProviderAddress());
        }
    }

    public static abstract class NullProvider
    implements IPAddressProvider {
        private IPType type;

        /*
         * WARNING - void declaration
         */
        public NullProvider(IPType type) {
            void var1_1;
            this.type = var1_1;
        }

        @Override
        public IPType getType() {
            return this.type;
        }

        @Override
        public IPAddress getProviderAddress() {
            return null;
        }

        @Override
        public int providerHashCode() {
            return Objects.hashCode((Object)this.getType());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean providerEquals(IPAddressProvider o) {
            if (this == o) {
                return true;
            }
            if (o instanceof NullProvider) {
                void var1_1;
                NullProvider other = (NullProvider)o;
                return this.getType() == var1_1.getType();
            }
            return false;
        }

        public String toString() {
            return String.valueOf((Object)this.getType());
        }
    }

    public static final class IPType
    extends Enum<IPType> {
        public static final /* enum */ IPType INVALID = new IPType();
        public static final /* enum */ IPType EMPTY = new IPType();
        public static final /* enum */ IPType IPV4 = new IPType();
        public static final /* enum */ IPType IPV6 = new IPType();
        public static final /* enum */ IPType PREFIX_ONLY = new IPType();
        public static final /* enum */ IPType ALL = new IPType();
        private static final /* synthetic */ IPType[] $VALUES;

        static IPType from(IPAddress.IPVersion version) {
            IPAddress.IPVersion iPVersion;
            switch (iPVersion) {
                case IPV4: {
                    return IPV4;
                }
                case IPV6: {
                    return IPV6;
                }
            }
            return null;
        }

        static {
            $VALUES = new IPType[]{INVALID, EMPTY, IPV4, IPV6, PREFIX_ONLY, ALL};
        }
    }
}

