/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.IPAddress;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.format.validate.ParsedIPAddress;

class IPAddressParseData
extends AddressParseData {
    private ParsedHostIdentifierStringQualifier qualifier = ParsedHost.NO_QUALIFIER;
    private int qualifierIndex = -1;
    private boolean hasPrefixSeparator;
    private boolean isZoned;
    private IPAddress.IPVersion ipVersion;
    private boolean is_inet_aton_joined;
    protected boolean has_inet_aton_value;
    protected boolean hasIPv4LeadingZeros;
    protected boolean isBinary;
    ParsedIPAddress mixedParsedAddress;
    private boolean isBase85;
    private boolean isBase85Zoned;

    /*
     * WARNING - void declaration
     */
    IPAddressParseData(CharSequence str) {
        super((CharSequence)var1_1);
        void var1_1;
    }

    AddressParseData getAddressParseData() {
        return this;
    }

    public IPAddress.IPVersion getProviderIPVersion() {
        return this.ipVersion;
    }

    /*
     * WARNING - void declaration
     */
    void setVersion(IPAddress.IPVersion val) {
        void var1_1;
        this.ipVersion = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isProvidingIPv6() {
        void var1_1;
        IPAddress.IPVersion version = this.getProviderIPVersion();
        return version != null && var1_1.isIPv6();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isProvidingIPv4() {
        void var1_1;
        IPAddress.IPVersion version = this.getProviderIPVersion();
        return version != null && var1_1.isIPv4();
    }

    /*
     * WARNING - void declaration
     */
    void set_inet_aton_joined(boolean val) {
        void var1_1;
        this.is_inet_aton_joined = var1_1;
    }

    boolean is_inet_aton_joined() {
        return this.is_inet_aton_joined;
    }

    /*
     * WARNING - void declaration
     */
    void set_has_inet_aton_value(boolean val) {
        void var1_1;
        this.has_inet_aton_value = var1_1;
    }

    boolean has_inet_aton_value() {
        return this.has_inet_aton_value;
    }

    /*
     * WARNING - void declaration
     */
    void setHasIPv4LeadingZeros(boolean val) {
        void var1_1;
        this.hasIPv4LeadingZeros = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void setHasBinaryDigits(boolean val) {
        void var1_1;
        this.isBinary = var1_1;
    }

    ParsedHostIdentifierStringQualifier getQualifier() {
        return this.qualifier;
    }

    /*
     * WARNING - void declaration
     */
    void setQualifier(ParsedHostIdentifierStringQualifier qualifier) {
        void var1_1;
        this.qualifier = var1_1;
    }

    void clearQualifier() {
        this.qualifierIndex = -1;
        IPAddressParseData iPAddressParseData = this;
        this.isZoned = false;
        iPAddressParseData.hasPrefixSeparator = false;
        iPAddressParseData.isBase85Zoned = false;
        this.qualifier = ParsedHost.NO_QUALIFIER;
    }

    /*
     * WARNING - void declaration
     */
    void setQualifierIndex(int index) {
        void var1_1;
        this.qualifierIndex = var1_1;
    }

    int getQualifierIndex() {
        return this.qualifierIndex;
    }

    boolean isZoned() {
        return this.isZoned;
    }

    /*
     * WARNING - void declaration
     */
    void setZoned(boolean val) {
        void var1_1;
        this.isZoned = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void setHasPrefixSeparator(boolean val) {
        void var1_1;
        this.hasPrefixSeparator = var1_1;
    }

    public boolean hasPrefixSeparator() {
        return this.hasPrefixSeparator;
    }

    public boolean isProvidingBase85IPv6() {
        return this.isBase85;
    }

    /*
     * WARNING - void declaration
     */
    void setBase85(boolean val) {
        void var1_1;
        this.isBase85 = var1_1;
    }

    boolean isBase85Zoned() {
        return this.isBase85Zoned;
    }

    /*
     * WARNING - void declaration
     */
    void setBase85Zoned(boolean val) {
        void var1_1;
        this.isBase85Zoned = var1_1;
    }

    boolean isCompressed() {
        return this.getAddressParseData().getConsecutiveSeparatorIndex() >= 0;
    }

    /*
     * WARNING - void declaration
     */
    boolean isCompressed(int index, int[] segmentData) {
        void var3_3;
        void var2_2;
        int n;
        int end = AddressParseData.getIndex(index, 15, segmentData);
        return (n = AddressParseData.getIndex(n, 6, (int[])var2_2)) == var3_3;
    }

    /*
     * WARNING - void declaration
     */
    boolean isCompressed(int index) {
        void var2_2;
        void var1_1;
        AddressParseData addressParseData = this.getAddressParseData();
        return this.isCompressed((int)var1_1, var2_2.getSegmentData());
    }

    public boolean isProvidingMixedIPv6() {
        return this.mixedParsedAddress != null;
    }

    /*
     * WARNING - void declaration
     */
    void setMixedParsedAddress(ParsedIPAddress val) {
        void var1_1;
        this.mixedParsedAddress = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        builder.append("ip version: ").append((Object)this.getProviderIPVersion());
        if (this.isProvidingIPv6()) {
            if (this.isProvidingMixedIPv6()) {
                if (this.isZoned()) {
                    builder.append(", with zone ");
                    this.printQualifier(builder);
                }
                if (this.hasPrefixSeparator()) {
                    builder.append(", with prefix length ");
                    this.printQualifier(builder);
                }
                builder.append(", with IPv4 embedded address: \n").append(this.mixedParsedAddress);
            } else {
                if (this.isProvidingBase85IPv6()) {
                    builder.append(" base 85");
                    if (this.isBase85Zoned()) {
                        builder.append(", with zone ");
                        this.printQualifier(builder);
                    }
                } else if (this.isZoned()) {
                    builder.append(", with zone ");
                    this.printQualifier(builder);
                }
                if (this.hasPrefixSeparator()) {
                    builder.append(", with prefix length ");
                    this.printQualifier(builder);
                }
                builder.append('\n');
            }
        } else if (this.isProvidingIPv4()) {
            if (this.hasPrefixSeparator()) {
                builder.append(", with prefix length  ");
                this.printQualifier(builder);
            }
            if (this.is_inet_aton_joined()) {
                builder.append(", with joined segments");
            }
            if (this.has_inet_aton_value()) {
                builder.append(", with at least one hex or octal value");
            }
            builder.append('\n');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void printQualifier(StringBuilder builder) {
        void var1_1;
        AddressParseData addressParseData = this.getAddressParseData();
        int qualifierIndex = this.getQualifierIndex();
        if (qualifierIndex >= 0) {
            void var2_2;
            void var3_3;
            CharSequence str = addressParseData.getString();
            builder.append(str.subSequence((int)var3_3, var2_2.length()));
            return;
        }
        var1_1.append("unknown");
    }
}

