/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import java.io.Serializable;
import java.math.BigInteger;

class AddressParseData
implements Serializable {
    private int[] segmentData;
    private int segmentCount;
    private boolean anyWildcard;
    private boolean isEmpty;
    private boolean isAll;
    private boolean isSingleSegment;
    private int consecutiveSepIndex = -1;
    private int consecutiveSepSegmentIndex = -1;
    private int addressEndIndex;
    protected final CharSequence str;

    /*
     * WARNING - void declaration
     */
    AddressParseData(CharSequence str) {
        void var1_1;
        this.str = var1_1;
    }

    CharSequence getString() {
        return this.str;
    }

    /*
     * WARNING - void declaration
     */
    void initSegmentData(int segmentCapacity) {
        void var1_1;
        int dataSize;
        dataSize = segmentCapacity == 4 ? 64 : (dataSize == 8 ? 128 : (dataSize == 1 ? 16 : (dataSize <<= 4)));
        this.segmentData = new int[var1_1];
    }

    void releaseSegmentData() {
        this.segmentData = null;
    }

    int[] getSegmentData() {
        return this.segmentData;
    }

    void incrementSegmentCount() {
        ++this.segmentCount;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    int getConsecutiveSeparatorSegmentIndex() {
        return this.consecutiveSepSegmentIndex;
    }

    /*
     * WARNING - void declaration
     */
    void setConsecutiveSeparatorSegmentIndex(int val) {
        void var1_1;
        this.consecutiveSepSegmentIndex = var1_1;
    }

    int getConsecutiveSeparatorIndex() {
        return this.consecutiveSepIndex;
    }

    /*
     * WARNING - void declaration
     */
    void setConsecutiveSeparatorIndex(int val) {
        void var1_1;
        this.consecutiveSepIndex = var1_1;
    }

    public boolean isProvidingEmpty() {
        return this.isEmpty;
    }

    /*
     * WARNING - void declaration
     */
    void setEmpty(boolean val) {
        void var1_1;
        this.isEmpty = var1_1;
    }

    boolean isAll() {
        return this.isAll;
    }

    void setAll() {
        this.isAll = true;
    }

    int getAddressEndIndex() {
        return this.addressEndIndex;
    }

    /*
     * WARNING - void declaration
     */
    void setAddressEndIndex(int val) {
        void var1_1;
        this.addressEndIndex = var1_1;
    }

    void setSingleSegment() {
        this.isSingleSegment = true;
    }

    boolean isSingleSegment() {
        return this.isSingleSegment;
    }

    void setHasWildcard() {
        this.anyWildcard = true;
    }

    boolean hasWildcard() {
        return this.anyWildcard;
    }

    /*
     * WARNING - void declaration
     */
    void unsetFlag(int segmentIndex, int flagIndicator) {
        void var2_2;
        void var1_1;
        int index = segmentIndex << 4;
        int[] nArray = this.getSegmentData();
        int[] nArray2 = nArray;
        void v1 = var1_1;
        nArray[v1] = nArray[v1] & ~var2_2;
    }

    /*
     * WARNING - void declaration
     */
    boolean getFlag(int segmentIndex, int flagIndicator) {
        void var2_2;
        void var1_1;
        int[] nArray = this.getSegmentData();
        return (nArray[var1_1 << 4] & var2_2) != 0;
    }

    /*
     * WARNING - void declaration
     */
    int getRadix(int segmentIndex, int indexIndicator) {
        void var1_1;
        void var2_2;
        int[] nArray = this.getSegmentData();
        int radix = nArray[segmentIndex << 4 | var2_2] & 0xFF;
        if (radix == 0) {
            return 16;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void setBitLength(int segmentIndex, int length) {
        void var2_2;
        void var1_1;
        int[] nArray = this.getSegmentData();
        int[] nArray2 = nArray;
        void v1 = var1_1 << 4;
        nArray[v1] = nArray[v1] | var2_2 << 8 & 0xFF00;
    }

    /*
     * WARNING - void declaration
     */
    void setIndex(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5) {
        void var3_3;
        int baseIndex = segmentIndex << 4;
        int[] nArray = this.getSegmentData();
        int[] segmentData = nArray;
        nArray[baseIndex | var2_2] = var3_3;
        segmentData[baseIndex | indexIndicator1] = value1;
        segmentData[baseIndex | indexIndicator2] = value2;
        segmentData[baseIndex | indexIndicator3] = value3;
        segmentData[baseIndex | indexIndicator4] = value4;
        segmentData[var1_1 | indexIndicator5] = value5;
    }

    /*
     * WARNING - void declaration
     */
    int getIndex(int segmentIndex, int indexIndicator) {
        void var2_2;
        return AddressParseData.getIndex(segmentIndex, (int)var2_2, this.getSegmentData());
    }

    /*
     * WARNING - void declaration
     */
    static int getIndex(int segmentIndex, int indexIndicator, int[] segmentData) {
        void var1_1;
        int n;
        return segmentData[n << 4 | var1_1];
    }

    /*
     * WARNING - void declaration
     */
    void set7IndexFlags(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5, int indexIndicator6, int value6) {
        void var3_3;
        int baseIndex = segmentIndex << 4;
        int[] nArray = this.getSegmentData();
        int[] segmentData = nArray;
        nArray[baseIndex | var2_2] = var3_3;
        segmentData[baseIndex | indexIndicator1] = value1;
        segmentData[baseIndex | indexIndicator2] = value2;
        segmentData[baseIndex | indexIndicator3] = value3;
        segmentData[baseIndex | indexIndicator4] = value4;
        segmentData[baseIndex | indexIndicator5] = value5;
        segmentData[var1_1 | indexIndicator6] = value6;
    }

    /*
     * WARNING - void declaration
     */
    void set8Index4ValuesFlags(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5, int indexIndicator6, int value6, int indexIndicator7, int value7, int indexIndicator8, long value8, int indexIndicator9, long value9, int indexIndicator10, long value10, int indexIndicator11, long value11) {
        void var1_1;
        void var3_3;
        int baseIndex = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        AddressParseData.setIndexValuesFlags(baseIndex, segmentData, indexIndicator0, (int)var3_3, indexIndicator1, value1, indexIndicator2, value2, indexIndicator3, value3, indexIndicator4, value4, indexIndicator5, value5, indexIndicator6, value6, indexIndicator8, value8, indexIndicator9, value9);
        segmentData[baseIndex | indexIndicator7] = value7;
        int index = baseIndex | indexIndicator10;
        segmentData[index] = (int)(value10 >>> 32);
        segmentData[index | 1] = (int)value10;
        index = var1_1 | indexIndicator11;
        segmentData[index] = (int)(value11 >>> 32);
        segmentData[var2_2 | 1] = (int)value11;
    }

    /*
     * WARNING - void declaration
     */
    void set7Index4ValuesFlags(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5, int indexIndicator6, int value6, int indexIndicator7, long value7, int indexIndicator8, long value8, int indexIndicator9, long value9, int indexIndicator10, long value10) {
        void var1_1;
        void var3_3;
        int baseIndex = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        AddressParseData.setIndexValuesFlags(baseIndex, segmentData, indexIndicator0, (int)var3_3, indexIndicator1, value1, indexIndicator2, value2, indexIndicator3, value3, indexIndicator4, value4, indexIndicator5, value5, indexIndicator6, value6, indexIndicator7, value7, indexIndicator8, value8);
        int index = baseIndex | indexIndicator9;
        segmentData[index] = (int)(value9 >>> 32);
        segmentData[index | 1] = (int)value9;
        index = var1_1 | indexIndicator10;
        segmentData[index] = (int)(value10 >>> 32);
        segmentData[var2_2 | 1] = (int)value10;
    }

    /*
     * WARNING - void declaration
     */
    void set8Index2ValuesFlags(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5, int indexIndicator6, int value6, int indexIndicator7, int value7, int indexIndicator8, long value8, int indexIndicator9, long value9) {
        void var3_3;
        void var2_2;
        int baseIndex = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        AddressParseData.setIndexValuesFlags(baseIndex, segmentData, (int)var2_2, (int)var3_3, indexIndicator1, value1, indexIndicator2, value2, indexIndicator3, value3, indexIndicator4, value4, indexIndicator5, value5, indexIndicator6, value6, indexIndicator8, value8, indexIndicator9, value9);
        segmentData[var1_1 | indexIndicator7] = value7;
    }

    /*
     * WARNING - void declaration
     */
    void set7Index2ValuesFlags(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5, int indexIndicator6, int value6, int indexIndicator7, long value7, int indexIndicator8, long value8) {
        void var3_3;
        void var2_2;
        void var1_1;
        int baseIndex = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        AddressParseData.setIndexValuesFlags((int)var1_1, segmentData, (int)var2_2, (int)var3_3, indexIndicator1, value1, indexIndicator2, value2, indexIndicator3, value3, indexIndicator4, value4, indexIndicator5, value5, indexIndicator6, value6, indexIndicator7, value7, indexIndicator8, value8);
    }

    /*
     * WARNING - void declaration
     */
    private static void setIndexValuesFlags(int baseIndex, int[] segmentData, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5, int indexIndicator6, int value6, int indexIndicator7, long value7, int indexIndicator8, long value8) {
        int n;
        void var3_3;
        segmentData[baseIndex | indexIndicator0] = var3_3;
        segmentData[baseIndex | indexIndicator1] = value1;
        segmentData[baseIndex | indexIndicator2] = value2;
        segmentData[baseIndex | indexIndicator3] = value3;
        segmentData[baseIndex | indexIndicator4] = value4;
        segmentData[baseIndex | indexIndicator5] = value5;
        segmentData[baseIndex | indexIndicator6] = value6;
        int index = baseIndex | indexIndicator7;
        segmentData[index] = (int)(value7 >>> 32);
        segmentData[index | 1] = (int)value7;
        index = n | indexIndicator8;
        segmentData[index] = (int)(value8 >>> 32);
        var1_1[var2_2 | 1] = (int)value8;
    }

    /*
     * WARNING - void declaration
     */
    void setValue(int segmentIndex, int indexIndicator, long value) {
        void var3_4;
        void var2_2;
        int index = segmentIndex << 4 | indexIndicator;
        int upperValue = (int)(value >>> 32);
        int lowerValue = (int)value;
        int[] nArray = this.getSegmentData();
        int[] segmentData = nArray;
        nArray[index] = var2_2;
        segmentData[var1_1 | 1] = var3_4;
    }

    /*
     * WARNING - void declaration
     */
    long getValue(int segmentIndex, int indexIndicator) {
        void var2_2;
        return AddressParseData.getValue(segmentIndex, (int)var2_2, this.getSegmentData());
    }

    /*
     * WARNING - void declaration
     */
    protected static long getValue(int segmentIndex, int indexIndicator, int[] segmentData) {
        int n;
        void var2_2;
        void var1_1;
        int index = segmentIndex << 4 | var1_1;
        long upperValue = segmentData[index];
        long lowerValue = 0xFFFFFFFFL & (long)var2_2[n | 1];
        long l = upperValue << 32 | lowerValue;
        return l;
    }

    /*
     * WARNING - void declaration
     */
    boolean isWildcard(int index) {
        void var1_1;
        return this.getFlag((int)var1_1, 65536);
    }

    /*
     * WARNING - void declaration
     */
    boolean isInferredUpperBoundary(int index) {
        void var1_1;
        return this.getFlag((int)var1_1, 0x400000);
    }

    /*
     * WARNING - void declaration
     */
    void toString(StringBuilder builder) {
        CharSequence str = this.getString();
        builder.append("address string: ").append(str).append('\n');
        int addressEndIndex = this.getAddressEndIndex();
        if (addressEndIndex > 0 && addressEndIndex < str.length()) {
            builder.append("address end: ").append(str.subSequence(addressEndIndex, str.length())).append('\n');
        }
        int segmentCount = this.getSegmentCount();
        builder.append("segment count: ").append(segmentCount).append('\n');
        if (segmentCount > 0) {
            for (int i = 0; i < segmentCount; ++i) {
                BigInteger lowerResult;
                BigInteger shiftMore;
                builder.append("segment ").append(i).append(":\n");
                boolean bl = this.isWildcard(i);
                if (bl) {
                    builder.append("\tis wildcard\n");
                    continue;
                }
                long lower = this.getValue(i, 2);
                long upper = this.getValue(i, 10);
                long extendedUpper = this.getValue(i, 12);
                long extendedLower = this.getValue(i, 4);
                if (extendedLower != 0L) {
                    BigInteger bigInteger = BigInteger.valueOf(extendedLower);
                    shiftMore = bigInteger.shiftLeft(64);
                    BigInteger notExtended = BigInteger.valueOf(lower);
                    lowerResult = shiftMore.or(notExtended);
                    builder.append("\tvalue: ").append(lowerResult).append('\n');
                    builder.append("\tvalue in hex: ").append(lowerResult.toString(16)).append('\n');
                } else {
                    builder.append("\tvalue: ").append(lower).append('\n');
                    builder.append("\tvalue in hex: ").append(Long.toHexString(lower)).append('\n');
                    lowerResult = null;
                }
                builder.append("\tstring: ").append(str.subSequence(this.getIndex(i, 6), this.getIndex(i, 7))).append('\n');
                builder.append("\tradix: ").append(this.getRadix(i, 0)).append('\n');
                builder.append("\tis standard: ").append(this.getFlag(i, 262144)).append('\n');
                if (extendedUpper != 0L) {
                    BigInteger notExtended;
                    shiftMore = BigInteger.valueOf(extendedUpper);
                    BigInteger result = (shiftMore = shiftMore.shiftLeft(64)).or(notExtended = BigInteger.valueOf(upper));
                    if (!result.equals(lowerResult)) {
                        builder.append("\tupper value: ").append(result).append('\n');
                        builder.append("\tupper value in hex: ").append(result.toString(16)).append('\n');
                        builder.append("\tupper string: ").append(str.subSequence(this.getIndex(i, 14), this.getIndex(i, 15))).append('\n');
                        builder.append("\tupper radix: ").append(this.getRadix(i, 8)).append('\n');
                        builder.append("\tis standard range: ").append(this.getFlag(i, 524288)).append('\n');
                    }
                } else if (upper != lower) {
                    builder.append("\tupper value: ").append(upper).append('\n');
                    builder.append("\tupper value in hex: ").append(Long.toHexString(upper)).append('\n');
                    builder.append("\tupper string: ").append(str.subSequence(this.getIndex(i, 14), this.getIndex(i, 15))).append('\n');
                    builder.append("\tupper radix: ").append(this.getRadix(i, 8)).append('\n');
                    builder.append("\tis standard range: ").append(this.getFlag(i, 524288)).append('\n');
                }
                if (!this.getFlag(i, 131072)) continue;
                builder.append("\thas single wildcard: \n");
            }
            builder.append("has a wildcard segment: ").append(this.hasWildcard()).append('\n');
            int consecutiveSepIndex = this.getConsecutiveSeparatorIndex();
            if (consecutiveSepIndex >= 0) {
                builder.append("has compressed segment(s) at character ").append(consecutiveSepIndex + 1).append('\n');
            }
            if (this.isSingleSegment()) {
                builder.append("is single segment\n");
            }
            return;
        }
        if (this.isProvidingEmpty()) {
            builder.append("is empty\n");
            return;
        }
        if (this.isAll()) {
            void var1_1;
            var1_1.append("is all addresses\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return var1_1.toString();
    }
}

