/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.standard;

import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.InconsistentPrefixException;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.IPAddressDivisionSeries;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.standard.IPAddressDivision;
import java.util.Arrays;

public class IPAddressDivisionGrouping
extends AddressDivisionGrouping
implements IPAddressDivisionSeries {
    private final IPAddressNetwork<?, ?, ?, ?, ?> network;
    protected static final RangeCache ZEROS_CACHE = new RangeCache();

    public IPAddressDivisionGrouping(IPAddressDivision[] divisions, IPAddressNetwork<?, ?, ?, ?, ?> network) throws AddressValueException {
        super(divisions);
        if (network == null) {
            throw new NullPointerException(IPAddressDivisionGrouping.getMessage("ipaddress.error.nullNetwork"));
        }
        this.network = network;
        int totalPrefixBits = 0;
        for (int i = 0; i < divisions.length; ++i) {
            IPAddressDivision division = divisions[i];
            Integer divPrefix = division.getDivisionPrefixLength();
            if (divPrefix != null) {
                this.cachedPrefixLength = IPAddressDivisionGrouping.cacheBits(totalPrefixBits + divPrefix);
                ++i;
                while (i < divisions.length) {
                    division = divisions[i];
                    divPrefix = division.getDivisionPrefixLength();
                    if (divPrefix == null || divPrefix != 0) {
                        throw new InconsistentPrefixException(divisions[i - 1], division, divPrefix);
                    }
                    ++i;
                }
                return;
            }
            totalPrefixBits += division.getBitCount();
        }
        this.cachedPrefixLength = NO_PREFIX_LENGTH;
    }

    /*
     * WARNING - void declaration
     */
    protected IPAddressDivisionGrouping(IPAddressDivision[] divisions, boolean checkSegs) {
        super((AddressDivision[])var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
        this.network = this.getNetwork();
        if (this.network == null) {
            throw new NullPointerException(IPAddressDivisionGrouping.getMessage("ipaddress.error.nullNetwork"));
        }
    }

    @Override
    public IPAddressNetwork<?, ?, ?, ?, ?> getNetwork() {
        return this.network;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPAddressDivision getDivision(int index) {
        void var1_1;
        return (IPAddressDivision)super.getDivision((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int isMore(AddressDivisionSeries other) {
        void var1_1;
        if (!this.isMultiple()) {
            if (other.isMultiple()) {
                return -1;
            }
            return 0;
        }
        if (!other.isMultiple()) {
            return 1;
        }
        if (((AddressDivisionGroupingBase)this).isSinglePrefixBlock() && other.isSinglePrefixBlock()) {
            void var1_2;
            void var2_3;
            int bits = this.getBitCount() - ((AddressDivisionGroupingBase)this).getPrefixLength();
            int otherBits = other.getBitCount() - other.getPrefixLength();
            return (int)(var2_3 - var1_2);
        }
        return this.getCount().compareTo(var1_1.getCount());
    }

    @Override
    public Integer getPrefixLength() {
        return this.getNetworkPrefixLength();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer getNetworkPrefixLength() {
        void var1_1;
        Integer ret = this.cachedPrefixLength;
        if (ret == null) {
            Integer result = IPAddressDivisionGrouping.calculatePrefix(this);
            if (result != null) {
                this.cachedPrefixLength = var1_1;
                return this.cachedPrefixLength;
            }
            this.cachedPrefixLength = NO_PREFIX_LENGTH;
            return null;
        }
        if (var1_1.intValue() == NO_PREFIX_LENGTH.intValue()) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isPrefixBlock() {
        void var1_1;
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null) {
            return false;
        }
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return true;
        }
        return ((AddressDivisionGrouping)this).containsPrefixBlock(var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int prefixLength) {
        void var1_1;
        return IPAddressDivisionGrouping.containsPrefixBlock(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSinglePrefixBlock(int prefixLength) {
        void var1_1;
        return IPAddressDivisionGrouping.containsSinglePrefixBlock(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSinglePrefixBlock() {
        void var1_1;
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null) {
            return false;
        }
        return ((AddressDivisionGrouping)this).containsSinglePrefixBlock(var1_1.intValue());
    }

    public boolean includesZeroHost() {
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return false;
        }
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return true;
        }
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            IPAddressDivision iPAddressDivision;
            IPAddressDivision div = this.getDivision(i);
            Integer segmentPrefixLength = div.getDivisionPrefixLength();
            if (segmentPrefixLength == null) continue;
            long l = -1L << div.getBitCount() - segmentPrefixLength ^ 0xFFFFFFFFFFFFFFFFL;
            if ((l & iPAddressDivision.getDivisionValue()) != 0L) {
                return false;
            }
            ++i;
            while (i < divCount) {
                iPAddressDivision = this.getDivision(i);
                if (!iPAddressDivision.includesZero()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        void var1_1;
        return other instanceof IPAddressDivisionGrouping && super.isSameGrouping((AddressDivisionGroupingBase)var1_1);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddressDivisionGrouping) {
            IPAddressDivisionGrouping iPAddressDivisionGrouping;
            iPAddressDivisionGrouping = iPAddressDivisionGrouping;
            return iPAddressDivisionGrouping.isSameGrouping(this);
        }
        return false;
    }

    public RangeList getZeroSegments() {
        return this.getZeroSegments(false);
    }

    public RangeList getZeroRangeSegments() {
        if (this.isPrefixed()) {
            return this.getZeroSegments(true);
        }
        return this.getZeroSegments();
    }

    protected static RangeList getNoZerosRange() {
        return RangeCache.NO_ZEROS;
    }

    /*
     * WARNING - void declaration
     */
    protected static RangeList getSingleRange(int index, int len) {
        void var1_2;
        int n;
        RangeCache rangeCache = ZEROS_CACHE.addRange(n, -1, (int)var1_2);
        return rangeCache.get();
    }

    /*
     * WARNING - void declaration
     */
    protected RangeList getZeroSegments(boolean includeRanges) {
        void var2_2;
        RangeCache cache = ZEROS_CACHE;
        int divisionCount = this.getDivisionCount();
        boolean isFullRangeHost = !this.getNetwork().getPrefixConfiguration().prefixedSubnetsAreExplicit() && ((AddressDivisionGroupingBase)this).isPrefixBlock();
        includeRanges &= isFullRangeHost;
        int currentIndex = -1;
        int lastIndex = -1;
        int currentCount = 0;
        for (int i = 0; i < divisionCount; ++i) {
            IPAddressDivision division = this.getDivision(i);
            boolean bl = division.isZero() || includeRanges && division.isPrefixed() && division.isSinglePrefixBlock(0L, division.getDivisionPrefixLength());
            if (bl) {
                if (++currentCount == 1) {
                    currentIndex = i;
                }
                if (i != divisionCount - 1) continue;
                cache = cache.addRange(currentIndex, lastIndex, currentCount);
                lastIndex = currentIndex + currentCount;
                continue;
            }
            if (currentCount <= 0) continue;
            cache = cache.addRange(currentIndex, lastIndex, currentCount);
            lastIndex = currentIndex + currentCount;
            currentCount = 0;
        }
        return var2_2.get();
    }

    static {
        if (RangeCache.PRELOAD_CACHE) {
            ZEROS_CACHE.preloadCache(-1);
        }
    }

    private static class RangeCache {
        static boolean PRELOAD_CACHE;
        static final RangeList NO_ZEROS;
        RangeCache[][] nextRange;
        RangeCache parent;
        RangeList zeroRanges;
        Range range;

        RangeCache() {
            this(null, 8, null);
            this.zeroRanges = NO_ZEROS;
        }

        /*
         * WARNING - void declaration
         */
        private RangeCache(RangeCache parent, int potentialZeroOffsets, Range range) {
            void var3_3;
            void var1_1;
            if (potentialZeroOffsets > 0) {
                this.nextRange = new RangeCache[potentialZeroOffsets][];
                for (int i = 0; i < potentialZeroOffsets; ++i) {
                    this.nextRange[i] = new RangeCache[potentialZeroOffsets - i];
                }
            }
            this.parent = var1_1;
            this.range = var3_3;
        }

        private void get(Range[] ranges, int rangesIndex) {
            while (true) {
                ranges[--rangesIndex] = this_.range;
                if (rangesIndex <= 0) break;
                RangeCache this_ = this_.parent;
            }
        }

        /*
         * WARNING - void declaration
         */
        public RangeList get() {
            RangeList rangeList;
            RangeList result = this.zeroRanges;
            if (result == null) {
                void var2_3;
                int depth = 0;
                RangeCache up = this.parent;
                while (up != null) {
                    ++depth;
                    up = up.parent;
                }
                Range[] ranges = new Range[depth];
                if (depth > 0) {
                    ranges[--depth] = this.range;
                    if (depth > 0) {
                        void var1_2;
                        this.parent.get(ranges, (int)var1_2);
                    }
                }
                this.zeroRanges = rangeList = new RangeList((Range[])var2_3);
            }
            return rangeList;
        }

        void preloadCache(int lastIndex) {
            if (this.nextRange != null) {
                int j;
                RangeCache[] next;
                int i;
                for (i = 0; i < this.nextRange.length; ++i) {
                    next = this.nextRange[i];
                    for (j = 0; j < next.length; ++j) {
                        Range newRange = lastIndex == -1 ? new Range(i + lastIndex + 1, j + 1) : IPAddressDivisionGrouping.ZEROS_CACHE.nextRange[i + lastIndex + 1][j].range;
                        int nextPotentialZeroIndex = i + lastIndex + j + 3;
                        int remainingPotentialZeroOffsets = 8 - nextPotentialZeroIndex;
                        RangeCache newRangeCache = new RangeCache(this, remainingPotentialZeroOffsets, newRange);
                        newRangeCache.get();
                        next[j] = newRangeCache;
                    }
                }
                for (i = 0; i < this.nextRange.length; ++i) {
                    next = this.nextRange[i];
                    for (j = 0; j < next.length; ++j) {
                        RangeCache nextCache = next[j];
                        Range nextRange = nextCache.range;
                        nextCache.preloadCache(nextRange.index + nextRange.length);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public RangeCache addRange(int currentIndex, int lastIndex, int currentCount) {
            RangeCache rangeCache;
            int n = currentIndex - lastIndex;
            int cacheOffset = n - 1;
            int cacheCount = currentCount - 1;
            RangeCache next = this.nextRange[cacheOffset][cacheCount];
            if (next == null) {
                RangeCache rangeCache2 = this;
                synchronized (rangeCache2) {
                    next = this.nextRange[cacheOffset][cacheCount];
                    if (next == null) {
                        void var1_2;
                        void var2_4;
                        Range newRange2;
                        int nextPotentialZeroIndex = lastIndex + 1;
                        int remainingPotentialZeroOffsets = 8 - nextPotentialZeroIndex;
                        if (this == ZEROS_CACHE) {
                            newRange2 = new Range(currentIndex, currentCount);
                        } else {
                            void newRange2;
                            RangeCache rootNext = IPAddressDivisionGrouping.ZEROS_CACHE.nextRange[newRange2][currentCount - 1];
                            if (rootNext == null) {
                                void var3_5;
                                newRange2 = new Range((int)newRange2, (int)var3_5);
                                IPAddressDivisionGrouping.ZEROS_CACHE.nextRange[newRange2][currentCount - 1] = new RangeCache(ZEROS_CACHE, 8, newRange2);
                            } else {
                                newRange2 = rootNext.range;
                            }
                        }
                        this.nextRange[cacheOffset][cacheCount] = rangeCache = new RangeCache(this, (int)var2_4, (Range)var1_2);
                    }
                }
            }
            return rangeCache;
        }

        static {
            NO_ZEROS = new RangeList(new Range[0]);
        }
    }

    public static class RangeList {
        final Range[] ranges;

        /*
         * WARNING - void declaration
         */
        RangeList(Range[] ranges) {
            void var1_1;
            if (ranges == null) {
                throw new NullPointerException();
            }
            this.ranges = var1_1;
        }

        public int size() {
            return this.ranges.length;
        }

        /*
         * WARNING - void declaration
         */
        public Range getRange(int index) {
            void var1_1;
            return this.ranges[var1_1];
        }

        public String toString() {
            return Arrays.asList(this.ranges).toString();
        }
    }

    public static class Range {
        public final int index;
        public final int length;

        /*
         * WARNING - void declaration
         */
        Range(int index, int length) {
            void var2_2;
            void var1_1;
            this.index = var1_1;
            this.length = var2_2;
        }

        public String toString() {
            return "[" + this.index + ',' + (this.index + this.length) + ']';
        }
    }
}

