/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.standard;

import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.IPAddressGenericDivision;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.util.AddressSegmentParams;

public abstract class IPAddressDivision
extends AddressDivision
implements IPAddressGenericDivision {
    private final Integer divisionNetworkPrefix;
    protected transient String cachedString;
    private transient Boolean isSinglePrefixBlock;

    protected IPAddressDivision() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected IPAddressDivision(Integer networkPrefixLength) {
        void var1_1;
        if (networkPrefixLength != null && networkPrefixLength < 0) {
            throw new PrefixLenException(networkPrefixLength);
        }
        this.divisionNetworkPrefix = var1_1;
    }

    @Override
    public boolean isPrefixed() {
        return this.divisionNetworkPrefix != null;
    }

    @Override
    public Integer getDivisionPrefixLength() {
        return this.divisionNetworkPrefix;
    }

    protected abstract long getDivisionNetworkMask(int var1);

    protected abstract long getDivisionHostMask(int var1);

    /*
     * WARNING - void declaration
     */
    public Integer getBlockMaskPrefixLength(boolean network) {
        void var3_3;
        void var1_1;
        int hostLength = this.getTrailingBitCount(network);
        long shifted = var1_1 != false ? ((this.getDivisionValue() ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue()) >>> hostLength : this.getDivisionValue() >>> hostLength;
        if (var3_3 == 0L) {
            void var2_2;
            return AddressDivisionGrouping.cacheBits(this.getBitCount() - var2_2);
        }
        return null;
    }

    public int getTrailingBitCount(boolean network) {
        if (network) {
            return Long.numberOfTrailingZeros(this.getDivisionValue() | -1L << this.getBitCount());
        }
        return Long.numberOfTrailingZeros(this.getDivisionValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isPrefixBlock(long segmentValue, long upperValue, int divisionPrefixLen) {
        void var1_1;
        void var3_2;
        if (divisionPrefixLen == 0) {
            return segmentValue == 0L && upperValue == this.getMaxValue();
        }
        void v0 = var3_2;
        return IPAddressDivision.testRange((long)var1_1, (long)v0, (long)v0, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSinglePrefixBlock(long segmentValue, long upperValue, int divisionPrefixLen) {
        void var3_2;
        void var1_1;
        if (divisionPrefixLen == 0) {
            return segmentValue == 0L && upperValue == this.getMaxValue();
        }
        void v0 = var1_1;
        return IPAddressDivision.testRange((long)v0, (long)v0, (long)var3_2, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    /*
     * WARNING - void declaration
     */
    boolean isSinglePrefixBlock(long segmentValue, int divisionPrefixLen) {
        void var3_2;
        void var1_1;
        return this.isSinglePrefixBlock((long)var1_1, this.getUpperDivisionValue(), (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int divisionPrefixLen) {
        void var1_1;
        IPAddressDivision iPAddressDivision = this;
        return iPAddressDivision.isPrefixBlock(iPAddressDivision.getDivisionValue(), this.getUpperDivisionValue(), (int)var1_1);
    }

    public boolean isPrefixBlock() {
        if (this.isPrefixed()) {
            IPAddressDivision iPAddressDivision = this;
            if (iPAddressDivision.containsPrefixBlock(iPAddressDivision.getDivisionPrefixLength())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSinglePrefixBlock(int divisionPrefixLen) {
        void var1_1;
        IPAddressDivision iPAddressDivision = this;
        return iPAddressDivision.isSinglePrefixBlock(iPAddressDivision.getDivisionValue(), this.getUpperDivisionValue(), (int)var1_1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isSinglePrefixBlock() {
        block2: {
            if (this.isSinglePrefixBlock != null) break block2;
            if (!this.isPrefixed()) ** GOTO lbl-1000
            v0 = this;
            if (v0.containsSinglePrefixBlock(v0.getDivisionPrefixLength())) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            this.isSinglePrefixBlock = v1;
        }
        return this.isSinglePrefixBlock;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString() {
        void var1_1;
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    if (this.isSinglePrefixBlock() || !this.isMultiple()) {
                        result = this.getDefaultLowerString();
                    } else if (!this.isFullRange() || (result = this.getDefaultSegmentWildcardString()) == null) {
                        void var3_4;
                        long upperValue = this.getUpperDivisionValue();
                        if (this.isPrefixBlock()) {
                            IPAddressDivision iPAddressDivision2 = this;
                            upperValue &= iPAddressDivision2.getDivisionNetworkMask(iPAddressDivision2.getDivisionPrefixLength());
                        }
                        IPAddressDivision iPAddressDivision3 = this;
                        result = iPAddressDivision3.getDefaultRangeString(iPAddressDivision3.getDivisionValue(), (long)var3_4, this.getDefaultTextualRadix());
                    }
                    this.cachedString = result;
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getWildcardString() {
        void var1_1;
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    if (!this.isPrefixed() || !this.isMultiple()) {
                        result = this.getString();
                    } else if (!this.isFullRange() || (result = this.getDefaultSegmentWildcardString()) == null) {
                        result = this.getDefaultRangeString();
                    }
                    this.cachedWildcardString = result;
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCachedDefaultLowerString() {
        void var1_1;
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    this.cachedString = result = this.getDefaultLowerString();
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        long upperValue = this.getUpperDivisionValue();
        IPAddressDivision iPAddressDivision = this;
        long mask = iPAddressDivision.getDivisionNetworkMask(iPAddressDivision.getDivisionPrefixLength());
        long l = upperValue & mask;
        IPAddressDivision.toUnsignedStringCased(l, (int)var1_1, 0, (boolean)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getPrefixAdjustedRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.getPrefixAdjustedRangeString((int)var1_1, (AddressSegmentParams)var2_2, (StringBuilder)var3_3);
    }
}

