/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.standard;

import inet.ipaddr.Address;
import inet.ipaddr.AddressComponent;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.IPAddressDivision;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AddressDivisionGrouping
extends AddressDivisionGroupingBase {
    /*
     * WARNING - void declaration
     */
    public AddressDivisionGrouping(AddressDivision[] divisions) {
        super((AddressDivisionBase[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AddressDivisionGrouping(AddressDivision[] divisions, boolean checkDivisions) {
        super((AddressDivisionBase[])var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressDivision getDivision(int index) {
        void var1_1;
        return (AddressDivision)super.getDivision((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var2_2;
        byte[] bytes = new byte[this.getBitCount() + 7 >> 3];
        int byteCount = bytes.length;
        int n = this.getDivisionCount();
        int byteIndex = byteCount - 1;
        int bitIndex = 8;
        block0: for (int k = n - 1; k >= 0; --k) {
            AddressDivision div = this.getDivision(k);
            long segmentValue = low ? div.getDivisionValue() : div.getUpperDivisionValue();
            for (int divBits = div.getBitCount(); divBits > 0; divBits -= bitIndex) {
                int n2 = byteIndex--;
                bytes[n2] = (byte)((long)bytes[n2] | segmentValue << 8 - bitIndex);
                segmentValue >>>= bitIndex;
                if (divBits < bitIndex) {
                    bitIndex -= divBits;
                    continue block0;
                }
                bitIndex = 8;
            }
        }
        return var2_2;
    }

    protected static Integer cacheBits(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int prefixLength) {
        AddressDivisionGrouping.checkSubnet(this, prefixLength);
        int divisionCount = this.getDivisionCount();
        int prevBitCount = 0;
        for (int i = 0; i < divisionCount; ++i) {
            AddressDivision division = this.getDivision(i);
            int n = division.getBitCount();
            int totalBitCount = n + prevBitCount;
            if (prefixLength < totalBitCount) {
                void var1_1;
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                AddressDivision addressDivision = division;
                if (!addressDivision.isPrefixBlock(addressDivision.getDivisionValue(), division.getUpperDivisionValue(), (int)var1_1)) {
                    return false;
                }
                ++i;
                while (i < divisionCount) {
                    AddressDivision addressDivision2 = this.getDivision(i);
                    if (!addressDivision2.isFullRange()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSinglePrefixBlock(int prefixLength) {
        AddressDivisionGrouping.checkSubnet(this, prefixLength);
        int divisionCount = this.getDivisionCount();
        int prevBitCount = 0;
        for (int i = 0; i < divisionCount; ++i) {
            AddressDivision division = this.getDivision(i);
            int n = division.getBitCount();
            int totalBitCount = n + prevBitCount;
            if (prefixLength >= totalBitCount) {
                if (division.isMultiple()) {
                    return false;
                }
            } else {
                void var1_1;
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                AddressDivision addressDivision = division;
                if (!addressDivision.isSinglePrefixBlock(addressDivision.getDivisionValue(), division.getUpperDivisionValue(), (int)var1_1)) {
                    return false;
                }
                ++i;
                while (i < divisionCount) {
                    AddressDivision addressDivision2 = this.getDivision(i);
                    if (!addressDivision2.isFullRange()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int res = this.hashCode;
        if (res == 0) {
            res = 1;
            int count = this.getDivisionCount();
            for (int i = 0; i < count; ++i) {
                AddressDivision combo = this.getDivision(i);
                res = AddressDivisionGrouping.adjustHashCode(res, combo.getDivisionValue(), combo.getUpperDivisionValue());
            }
            this.hashCode = res;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        void var1_1;
        return other instanceof AddressDivisionGrouping && super.isSameGrouping((AddressDivisionGroupingBase)var1_1);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivisionGrouping) {
            AddressDivisionGrouping addressDivisionGrouping;
            addressDivisionGrouping = addressDivisionGrouping;
            return addressDivisionGrouping.isSameGrouping(this);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static long getLongCount(IntUnaryOperator countProvider, int segCount) {
        void var2_2;
        if (segCount == 0) {
            return 1L;
        }
        long result = countProvider.applyAsInt(0);
        for (int i = 1; i < segCount; ++i) {
            result *= (long)countProvider.applyAsInt(i);
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends AddressSection, S extends AddressSegment> long longCount(R section, int segCount) {
        void var1_1;
        long l = AddressDivisionGrouping.getLongCount(i -> {
            AddressComponent addressComponent;
            void var1_2;
            AddressComponent segment = section.getSegment((int)var1_2);
            int n = segment.getUpperSegmentValue() - addressComponent.getSegmentValue() + 1;
            return n;
        }, (int)var1_1);
        return l;
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getPrefixedSegmentPrefixLength(int bitsPerSegment, int prefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getNetworkSegmentIndex(networkPrefixLength, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, (Integer)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getSegmentPrefixLength(int segmentBits, int segmentPrefixedBits) {
        void var1_1;
        return ParsedAddressGrouping.getDivisionPrefixLength(segmentBits, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static int getNetworkPrefixLength(int bitsPerSegment, int prefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getNetworkPrefixLength(bitsPerSegment, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends IPAddressSegment> void normalizePrefixBoundary(int sectionPrefixBits, S[] segments, int segmentBitCount, int segmentByteCount, Function<S, S> segProducer) {
        S segment;
        void var3_4;
        int networkSegmentIndex = AddressDivisionGrouping.getNetworkSegmentIndex(sectionPrefixBits, (int)var3_4, segmentBitCount);
        if (networkSegmentIndex >= 0 && !((IPAddressDivision)(segment = segments[networkSegmentIndex])).isPrefixed()) {
            void var2_3;
            var1_1[var0] = (IPAddressSegment)segProducer.apply(var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressSegment> S[] setPrefixedSegments(AddressNetwork<?> network, int sectionPrefixBits, S[] segments, int segmentBitCount, int segmentByteCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, BiFunction<S, Integer, S> segProducer) {
        void var2_3;
        int i;
        boolean allPrefsSubnet = network.getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        int n = i = sectionPrefixBits == 0 ? 0 : AddressDivisionGrouping.getNetworkSegmentIndex(sectionPrefixBits, segmentByteCount, segmentBitCount);
        while (i < segments.length) {
            Integer pref = AddressDivisionGrouping.getPrefixedSegmentPrefixLength(segmentBitCount, sectionPrefixBits, i);
            if (pref != null) {
                segments[i] = (AddressSegment)segProducer.apply(segments[i], pref);
                if (allPrefsSubnet && ++i < segments.length) {
                    S allSeg = segmentCreator.createSegment(0, AddressDivisionGrouping.cacheBits(0));
                    Arrays.fill(segments, i, segments.length, allSeg);
                }
            }
            ++i;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends AddressSection, S extends AddressSegment> S[] removePrefix(R original, S[] segments, int segmentBitCount, SegPrefFunction<S> prefixSetter) {
        void var1_2;
        Integer oldPrefix = original.getPrefixLength();
        if (oldPrefix != null) {
            segments = (AddressSegment[])segments.clone();
            int networkSegIndex = 0;
            if (oldPrefix > 0) {
                networkSegIndex = AddressDivisionGrouping.getNetworkSegmentIndex(oldPrefix, original.getBytesPerSegment(), segmentBitCount);
            }
            for (int i = networkSegIndex; i < segments.length; ++i) {
                Integer oldPref = AddressDivisionGrouping.getPrefixedSegmentPrefixLength(segmentBitCount, oldPrefix, i);
                segments[i] = (AddressSegment)prefixSetter.apply(segments[i], oldPref, null);
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean isCompatibleNetworks(AddressNetwork<?> one, AddressNetwork<?> two) {
        void var1_1;
        return one.getPrefixConfiguration().equals((Object)var1_1.getPrefixConfiguration());
    }

    protected static <S extends AddressSegment> S[] toSegments(S[] segments, byte[] bytes, int startIndex, int endIndex, int bytesPerSegment, int bitsPerSegment, AddressNetwork<S> network, Integer prefixLength) {
        S[] SArray;
        if (endIndex < 0 || endIndex > bytes.length) {
            throw new AddressValueException(endIndex);
        }
        if (startIndex < 0 || startIndex > endIndex) {
            throw new AddressValueException(startIndex);
        }
        AddressCreator<?, ?, ?, S> creator = network.getAddressCreator();
        int segmentCount = segments.length;
        int expectedByteCount = segmentCount * bytesPerSegment;
        int missingBytes = expectedByteCount + startIndex - endIndex;
        if (missingBytes < 0) {
            int expectedStartIndex = endIndex - expectedByteCount;
            int higherStartIndex = expectedStartIndex - 1;
            byte expectedExtendedValue = bytes[higherStartIndex];
            if (expectedExtendedValue != 0) {
                int n = bytes[expectedStartIndex] >>> 7;
                if (n != 0) {
                    if (expectedExtendedValue != -1) {
                        throw new AddressValueException(expectedExtendedValue);
                    }
                } else {
                    throw new AddressValueException(expectedExtendedValue);
                }
            }
            while (startIndex < higherStartIndex) {
                if (bytes[--higherStartIndex] == expectedExtendedValue) continue;
                throw new AddressValueException(expectedExtendedValue);
            }
            startIndex = expectedStartIndex;
            missingBytes = 0;
        }
        boolean allPrefixedAddressesAreSubnets = network.getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        int i = 0;
        int segmentIndex = 0;
        while (i < expectedByteCount) {
            Integer segmentPrefixLength = AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            if (allPrefixedAddressesAreSubnets && segmentPrefixLength != null && segmentPrefixLength == 0) {
                Object allSeg = creator.createSegment(0, AddressDivisionGrouping.cacheBits(0));
                if (!AddressDivisionGrouping.isCompatibleNetworks(network, allSeg.getNetwork())) {
                    throw new NetworkMismatchException((AddressItem)allSeg);
                }
                Arrays.fill(segments, segmentIndex, segmentCount, allSeg);
                break;
            }
            int value = 0;
            int k = bytesPerSegment + i;
            int j = i;
            if (j < missingBytes) {
                int n = bytes[startIndex] >>> 7;
                if (n == 0) {
                    j = missingBytes;
                } else {
                    int upper = Math.min(missingBytes, k);
                    while (j < upper) {
                        value <<= 8;
                        value |= 0xFF;
                        ++j;
                    }
                }
            }
            while (j < k) {
                int byteValue = 0xFF & bytes[startIndex + j - missingBytes];
                value <<= 8;
                value |= byteValue;
                ++j;
            }
            int n = k;
            Object seg = creator.createSegment(value, segmentPrefixLength);
            if (!AddressDivisionGrouping.isCompatibleNetworks(network, seg.getNetwork())) {
                throw new NetworkMismatchException((AddressItem)seg);
            }
            segments[segmentIndex] = seg;
            ++segmentIndex;
        }
        return SArray;
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends AddressSection, S extends AddressSegment> S[] createSingle(R original, AddressNetwork.AddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer) {
        void var1_2;
        int segmentCount = original.getSegmentCount();
        AddressSegment[] segs = segmentCreator.createSegmentArray(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            segs[i] = (AddressSegment)segProducer.apply(i);
        }
        return var1_2;
    }

    protected static <R extends AddressSegmentSeries> R getSingleLowestOrHighestSection(R section) {
        if (!(section.isMultiple() || section.isPrefixed() && section.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets())) {
            R r;
            return r;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected static <I extends AddressSegmentSeries, S extends AddressSegment> boolean split(AddressDivisionGroupingBase.SplitterSink<I, ?> beingSplit, Function<S[], I> transformer, AddressNetwork.AddressSegmentCreator<S> segmentCreator, S[] originalSegments, int networkSegmentIndex, int hostSegmentIndex, Integer prefixLength) {
        S s;
        S seg;
        int i;
        Object upperSeg = null;
        Object lowerSeg = null;
        boolean isSplit = false;
        for (i = 0; i < hostSegmentIndex; ++i) {
            seg = originalSegments[i];
            if (!seg.isMultiple()) continue;
            isSplit = true;
            int lower = seg.getSegmentValue();
            int upper = seg.getUpperSegmentValue();
            int size = upper - lower;
            int mid = lower + (size >>> 1);
            Integer pref = AddressDivisionGrouping.getSegmentPrefixLength(seg.getBitCount(), prefixLength, i);
            lowerSeg = segmentCreator.createSegment(lower, mid, pref);
            upperSeg = segmentCreator.createSegment(mid + 1, upper, pref);
            break;
        }
        if (i == networkSegmentIndex && !isSplit) {
            seg = originalSegments[i];
            int segBitCount = seg.getBitCount();
            Integer pref = AddressDivisionGrouping.getSegmentPrefixLength(segBitCount, prefixLength, i);
            int shiftAdjustment = segBitCount - pref;
            int lower = seg.getSegmentValue();
            int upper = seg.getUpperSegmentValue();
            int originalLower = lower;
            int originalUpper = upper;
            if ((lower >>>= shiftAdjustment) != (upper >>>= shiftAdjustment)) {
                isSplit = true;
                int size = upper - lower;
                int mid = lower + (size >>> 1);
                int next = mid + 1;
                mid = mid << shiftAdjustment | ~(-1 << shiftAdjustment);
                lowerSeg = segmentCreator.createSegment(originalLower, mid, pref);
                s = segmentCreator.createSegment(next <<= shiftAdjustment, originalUpper, pref);
            }
        }
        if (isSplit) {
            void var1_1;
            AddressDivisionGroupingBase.SplitterSink<I, ?> splitterSink;
            void var3_3;
            void var2_2;
            int len = originalSegments.length;
            AddressSegment[] lowerSegs = segmentCreator.createSegmentArray(len);
            AddressSegment[] upperSegs = var2_2.createSegmentArray(len);
            System.arraycopy(originalSegments, 0, lowerSegs, 0, i);
            System.arraycopy(originalSegments, 0, upperSegs, 0, i);
            int j = i + 1;
            lowerSegs[i] = lowerSeg;
            upperSegs[i] = s;
            System.arraycopy(originalSegments, j, lowerSegs, j, len - j);
            System.arraycopy(var3_3, j, upperSegs, j, len - j);
            splitterSink.setSplitValues((AddressSegmentSeries)transformer.apply(lowerSegs), (AddressSegmentSeries)var1_1.apply(upperSegs));
        }
        return isSplit;
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends AddressSection, S extends AddressSegment> Iterator<R> iterator(boolean useOriginal, R original, AddressCreator<?, R, ?, S> creator, Iterator<S[]> iterator, Integer prefixLength) {
        void var2_2;
        void var3_3;
        if (useOriginal) {
            void var1_1;
            return new Iterator<R>((AddressSection)var1_1){
                R orig;
                final /* synthetic */ AddressSection val$original;
                {
                    this.val$original = addressSection;
                    this.orig = this.val$original;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public R next() {
                    void var1_1;
                    if (this.orig == null) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.orig;
                    this.orig = null;
                    return var1_1;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<R>((Iterator)var3_3, (AddressCreator)var2_2, prefixLength){
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ AddressCreator val$creator;
            final /* synthetic */ Integer val$prefixLength;
            {
                this.val$iterator = iterator;
                this.val$creator = addressCreator;
                this.val$prefixLength = n;
            }

            @Override
            public R next() {
                if (!this.val$iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] addressSegmentArray = (AddressSegment[])this.val$iterator.next();
                return AddressDivisionGrouping.createIteratedSection((AddressSegment[])addressSegmentArray, (AddressCreator)this.val$creator, (Integer)this.val$prefixLength);
            }

            @Override
            public boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends Address, S extends AddressSegment> T createIteratedAddress(S[] next, AddressCreator<T, ?, ?, S> creator, Integer prefixLength) {
        void var2_2;
        S[] SArray;
        return (T)creator.createAddressInternal((AddressSegment[])SArray, (Integer)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends AddressSection, S extends AddressSegment> R createIteratedSection(S[] next, AddressCreator<?, R, ?, S> creator, Integer prefixLength) {
        void var2_2;
        S[] SArray;
        return (R)creator.createPrefixedSectionInternal((AddressSegment[])SArray, (Integer)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressSegment> Iterator<S[]> segmentsIterator(int divCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, Supplier<S[]> segSupplier, IntFunction<Iterator<S>> segIteratorProducer, Predicate<S[]> excludeFunc) {
        int n;
        void var3_3;
        void var2_2;
        void var1_1;
        return AddressDivisionGrouping.segmentsIterator(divCount, var1_1, (Supplier<S[]>)var2_2, var3_3, excludeFunc, divCount - 1, n, null);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressSegment> Iterator<S[]> segmentsIterator(int divCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, Supplier<S[]> segSupplier, IntFunction<Iterator<S>> segIteratorProducer, Predicate<S[]> excludeFunc, int networkSegmentIndex, int hostSegmentIndex, IntFunction<Iterator<S>> hostSegIteratorProducer) {
        void var3_3;
        void var1_1;
        int n;
        if (segSupplier != null) {
            void var2_2;
            return new Iterator<S[]>((Supplier)var2_2, excludeFunc){
                S[] result;
                final /* synthetic */ Supplier val$segSupplier;
                final /* synthetic */ Predicate val$excludeFunc;
                {
                    this.val$segSupplier = supplier;
                    this.val$excludeFunc = predicate;
                    this.result = (AddressSegment[])this.val$segSupplier.get();
                    if (this.val$excludeFunc != null && this.val$excludeFunc.test(this.result)) {
                        this.result = null;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.result != null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public S[] next() {
                    void var1_1;
                    if (this.result == null) {
                        throw new NoSuchElementException();
                    }
                    S[] res = this.result;
                    this.result = null;
                    return var1_1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S[]>((AddressNetwork.AddressSegmentCreator)var1_1, networkSegmentIndex, hostSegIteratorProducer, excludeFunc, hostSegmentIndex, (IntFunction)var3_3){
            private boolean done;
            private final Iterator<S>[] variations;
            private S[] nextSet;
            final /* synthetic */ AddressNetwork.AddressSegmentCreator val$segmentCreator;
            final /* synthetic */ int val$networkSegmentIndex;
            final /* synthetic */ IntFunction val$hostSegIteratorProducer;
            final /* synthetic */ Predicate val$excludeFunc;
            final /* synthetic */ int val$hostSegmentIndex;
            final /* synthetic */ IntFunction val$segIteratorProducer;
            {
                this.val$segmentCreator = addressSegmentCreator;
                this.val$networkSegmentIndex = n2;
                this.val$hostSegIteratorProducer = intFunction;
                this.val$excludeFunc = predicate;
                this.val$hostSegmentIndex = n3;
                this.val$segIteratorProducer = intFunction2;
                this.variations = new Iterator[n];
                this.nextSet = this.val$segmentCreator.createSegmentArray(n);
                this.updateVariations(0);
                for (int i = this.val$networkSegmentIndex + 1; i < n; ++i) {
                    this.variations[i] = (Iterator)this.val$hostSegIteratorProducer.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[i].next();
                }
                if (this.val$excludeFunc != null && this.val$excludeFunc.test(this.nextSet)) {
                    this.increment();
                }
            }

            /*
             * WARNING - void declaration
             */
            private void updateVariations(int start) {
                int i;
                for (i = start; i < this.val$hostSegmentIndex; ++i) {
                    this.variations[i] = (Iterator)this.val$segIteratorProducer.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[i].next();
                }
                if (i == this.val$networkSegmentIndex) {
                    void var1_1;
                    this.variations[i] = (Iterator)this.val$hostSegIteratorProducer.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[var1_1].next();
                }
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public S[] next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                return this.increment();
            }

            /*
             * WARNING - void declaration
             */
            private S[] increment() {
                void var1_1;
                AddressSegment[] previousSegs = null;
                for (int j = this.val$networkSegmentIndex; j >= 0; --j) {
                    while (this.variations[j].hasNext()) {
                        if (previousSegs == null) {
                            previousSegs = (AddressSegment[])this.nextSet.clone();
                        }
                        this.nextSet[j] = (AddressSegment)this.variations[j].next();
                        this.updateVariations(j + 1);
                        if (this.val$excludeFunc != null && this.val$excludeFunc.test(this.nextSet)) {
                            j = this.val$networkSegmentIndex;
                            continue;
                        }
                        return previousSegs;
                    }
                }
                this.done = true;
                if (previousSegs == null) {
                    return this.nextSet;
                }
                return var1_1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends Address, S extends AddressSegment> Iterator<T> iterator(boolean useOriginal, T original, AddressCreator<T, ?, ?, S> creator, Iterator<S[]> iterator, Integer prefixLength) {
        void var2_2;
        void var3_3;
        if (useOriginal) {
            void var1_1;
            return new Iterator<T>((Address)var1_1){
                T orig;
                final /* synthetic */ Address val$original;
                {
                    this.val$original = address;
                    this.orig = this.val$original;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public T next() {
                    void var1_1;
                    if (this.orig == null) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.orig;
                    this.orig = null;
                    return var1_1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<T>((Iterator)var3_3, (AddressCreator)var2_2, prefixLength){
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ AddressCreator val$creator;
            final /* synthetic */ Integer val$prefixLength;
            {
                this.val$iterator = iterator;
                this.val$creator = addressCreator;
                this.val$prefixLength = n;
            }

            @Override
            public boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] addressSegmentArray = (AddressSegment[])this.val$iterator.next();
                return AddressDivisionGrouping.createIteratedAddress((AddressSegment[])addressSegmentArray, (AddressCreator)this.val$creator, (Integer)this.val$prefixLength);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static BigInteger count(IntUnaryOperator segmentValueCountProvider, int segCount, int safeMultiplies, long safeLimit) {
        int i = 0;
        BigInteger result = BigInteger.ONE;
        if (segCount == 0) {
            return result;
        }
        while (true) {
            long curResult = segmentValueCountProvider.applyAsInt(i++);
            if (i == segCount) {
                return AddressDivisionGrouping.mult(result, curResult);
            }
            int limit = i + safeMultiplies;
            if (segCount <= limit) {
                while (i < segCount) {
                    curResult *= (long)segmentValueCountProvider.applyAsInt(i++);
                }
                return AddressDivisionGrouping.mult(result, curResult);
            }
            while (i < limit) {
                curResult *= (long)segmentValueCountProvider.applyAsInt(i++);
            }
            while (curResult <= safeLimit) {
                curResult *= (long)segmentValueCountProvider.applyAsInt(i++);
                if (i != segCount) continue;
                return AddressDivisionGrouping.mult(result, curResult);
            }
            result = AddressDivisionGrouping.mult(result, curResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static BigInteger mult(BigInteger currentResult, long newResult) {
        void var1_2;
        BigInteger bigInteger;
        if (newResult == 1L) {
            return currentResult;
        }
        BigInteger newBig = BigInteger.valueOf(newResult);
        if (currentResult == BigInteger.ONE) {
            return newBig;
        }
        return bigInteger.multiply((BigInteger)var1_2);
    }

    public static class StringOptions
    extends AddressDivisionGroupingBase.StringOptionsBase {
        public final Wildcards wildcards;
        public final boolean expandSegments;
        public final int base;
        public final String segmentStrPrefix;
        public final Character separator;
        public final String addrLabel;
        public final boolean reverse;
        public final boolean splitDigits;
        public final boolean uppercase;

        /*
         * WARNING - void declaration
         */
        protected StringOptions(int base, boolean expandSegments, Wildcards wildcards, String segmentStrPrefix, Character separator, String label, boolean reverse, boolean splitDigits, boolean uppercase) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.expandSegments = var2_2;
            this.wildcards = var3_3;
            this.base = var1_1;
            if (segmentStrPrefix == null) {
                throw new NullPointerException("segment str");
            }
            this.segmentStrPrefix = segmentStrPrefix;
            this.separator = separator;
            if (label == null) {
                throw new NullPointerException("label");
            }
            this.addrLabel = label;
            this.reverse = reverse;
            this.splitDigits = splitDigits;
            this.uppercase = uppercase;
        }

        public static class Builder {
            public static final Wildcards DEFAULT_WILDCARDS = new Wildcards();
            protected Wildcards wildcards = DEFAULT_WILDCARDS;
            protected boolean expandSegments;
            protected int base;
            protected String segmentStrPrefix = "";
            protected Character separator;
            protected String addrLabel = "";
            protected boolean reverse;
            protected boolean splitDigits;
            protected boolean uppercase;

            /*
             * WARNING - void declaration
             */
            public Builder(int base, char separator) {
                void var2_2;
                void var1_1;
                this.base = var1_1;
                this.separator = Character.valueOf((char)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public Builder setWildcards(Wildcards wildcards) {
                void var1_1;
                this.wildcards = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setReverse(boolean reverse) {
                void var1_1;
                this.reverse = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setSplitDigits(boolean splitDigits) {
                void var1_1;
                this.splitDigits = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setExpandedSegments(boolean expandSegments) {
                void var1_1;
                this.expandSegments = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setRadix(int base) {
                void var1_1;
                this.base = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setSeparator(Character separator) {
                void var1_1;
                this.separator = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setAddressLabel(String label) {
                void var1_1;
                this.addrLabel = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setSegmentStrPrefix(String prefix) {
                void var1_1;
                this.segmentStrPrefix = var1_1;
                return this;
            }

            public StringOptions toOptions() {
                return new StringOptions(this.base, this.expandSegments, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.reverse, this.splitDigits, this.uppercase);
            }
        }

        public static class Wildcards {
            public final String rangeSeparator;
            public final String wildcard;
            public final String singleWildcard;

            public Wildcards() {
                this(Address.RANGE_SEPARATOR_STR, Address.SEGMENT_WILDCARD_STR, null);
            }

            /*
             * WARNING - void declaration
             */
            public Wildcards(String wildcard, String singleWildcard) {
                this(Address.RANGE_SEPARATOR_STR, (String)var1_1, (String)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Wildcards(String rangeSeparator) {
                this((String)var1_1, null, null);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Wildcards(String rangeSeparator, String wildcard, String singleWildcard) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (rangeSeparator == null) {
                    rangeSeparator = Address.RANGE_SEPARATOR_STR;
                }
                this.rangeSeparator = var1_1;
                this.wildcard = var2_2;
                this.singleWildcard = var3_3;
            }

            public String toString() {
                return "range separator: " + this.rangeSeparator + "\nwildcard: " + this.wildcard + "\nsingle wildcard: " + this.singleWildcard;
            }
        }
    }

    @FunctionalInterface
    protected static interface SegPrefFunction<S> {
        public S apply(S var1, Integer var2, Integer var3);
    }

    protected static class StringCache {
        public String canonicalString;

        protected StringCache() {
        }
    }

    protected static class SectionCache<R extends AddressSegmentSeries> {
        public R lower;
        public R lowerNonZeroHost;
        public R upper;
        public boolean lowerNonZeroHostIsNull;
    }
}

