/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.standard;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.validate.ParsedIPAddress;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class AddressDivision
extends AddressDivisionBase {
    protected AddressDivision() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var1_1;
        int bitCount = this.getBitCount();
        byte[] bytes = new byte[this.getByteCount()];
        int byteIndex = bytes.length - 1;
        long segmentValue = var1_1 != false ? this.getDivisionValue() : this.getUpperDivisionValue();
        while (true) {
            int n = byteIndex--;
            bytes[n] = (byte)((long)bytes[n] | segmentValue);
            segmentValue >>= 8;
            if (bitCount <= 8) {
                return bytes;
            }
            bitCount -= 8;
        }
    }

    @Override
    public boolean isMultiple() {
        return this.getDivisionValue() != this.getUpperDivisionValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMinPrefixLengthForBlock() {
        void var1_1;
        int upperOnes;
        int result = this.getBitCount();
        if (!this.isMultiple()) {
            return result;
        }
        if (this.isFullRange()) {
            return 0;
        }
        int lowerZeros = Long.numberOfTrailingZeros(this.getDivisionValue());
        if (lowerZeros != 0 && (upperOnes = Long.numberOfTrailingZeros(this.getUpperDivisionValue() ^ 0xFFFFFFFFFFFFFFFFL)) != 0) {
            void var2_2;
            void var3_3;
            int prefixedBitCount = Math.min(lowerZeros, (int)var3_3);
            result -= var2_2;
        }
        return (int)var1_1;
    }

    @Override
    protected String getDefaultRangeSeparatorString() {
        return Address.RANGE_SEPARATOR_STR;
    }

    public long getMaxValue() {
        return -1L << this.getBitCount() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public boolean isZero() {
        return !this.isMultiple() && this.includesZero();
    }

    @Override
    public boolean includesZero() {
        return this.getDivisionValue() == 0L;
    }

    @Override
    public boolean isMax() {
        return !this.isMultiple() && this.includesMax();
    }

    @Override
    public boolean includesMax() {
        return this.getUpperDivisionValue() == this.getMaxValue();
    }

    public abstract long getDivisionValue();

    public abstract long getUpperDivisionValue();

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int res = this.hashCode;
        if (res == 0) {
            this.hashCode = res = AddressDivision.createHashCode(this.getDivisionValue(), this.getUpperDivisionValue());
        }
        return (int)var1_1;
    }

    @Override
    public BigInteger getValue() {
        return BigInteger.valueOf(this.getDivisionValue());
    }

    @Override
    public BigInteger getUpperValue() {
        return BigInteger.valueOf(this.getUpperDivisionValue());
    }

    /*
     * WARNING - void declaration
     */
    static boolean testRange(long lowerValue, long upperValue, long finalUpperValue, long networkMask, long hostMask) {
        void var2_2;
        long l = lowerValue;
        return l == (l & networkMask) && finalUpperValue == (var2_2 | hostMask);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPrefixBlock(long divisionValue, long upperValue, int divisionPrefixLen) {
        void var1_1;
        void var3_2;
        if (divisionPrefixLen == 0) {
            return divisionValue == 0L && upperValue == this.getMaxValue();
        }
        int bitCount = this.getBitCount();
        long divisionBitMask = -1L << bitCount ^ 0xFFFFFFFFFFFFFFFFL;
        long divisionPrefixMask = -1L << bitCount - divisionPrefixLen;
        long divisionNonPrefixMask = divisionPrefixMask ^ 0xFFFFFFFFFFFFFFFFL;
        void v0 = var3_2;
        return AddressDivision.testRange((long)var1_1, (long)v0, (long)v0, divisionPrefixMask & divisionBitMask, divisionNonPrefixMask);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSinglePrefixBlock(long divisionValue, long upperValue, int divisionPrefixLen) {
        void var3_2;
        void var1_1;
        int bitCount = this.getBitCount();
        long divisionBitMask = -1L << bitCount ^ 0xFFFFFFFFFFFFFFFFL;
        long divisionPrefixMask = -1L << bitCount - divisionPrefixLen;
        long divisionNonPrefixMask = divisionPrefixMask ^ 0xFFFFFFFFFFFFFFFFL;
        void v0 = var1_1;
        return AddressDivision.testRange((long)v0, (long)v0, (long)var3_2, divisionPrefixMask & divisionBitMask, divisionNonPrefixMask);
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(long value) {
        void var1_1;
        return !this.isMultiple() && var1_1 == this.getDivisionValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameValues(AddressDivisionBase other) {
        if (other instanceof AddressDivision) {
            void var1_1;
            AddressDivision otherDivision = (AddressDivision)other;
            return this.getDivisionValue() == otherDivision.getDivisionValue() && this.getUpperDivisionValue() == var1_1.getUpperDivisionValue();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivision) {
            void var1_1;
            AddressDivision other = (AddressDivision)o;
            return this.getBitCount() == other.getBitCount() && var1_1.isSameValues(this);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static ParsedIPAddress.Masker maskRange(long value, long upperValue, long maskValue, long maxValue) {
        void var2_1;
        return ParsedIPAddress.maskRange(value, (long)var2_1, maskValue, maxValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMaxDigitCount(int radix) {
        void var1_1;
        void var2_2;
        int defaultRadix = this.getDefaultTextualRadix();
        if (radix == var2_2) {
            return this.getMaxDigitCount();
        }
        return AddressDivision.getMaxDigitCount((int)var1_1, this.getBitCount(), this.getMaxValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int adjustLowerLeadingZeroCount(int leadingZeroCount, int radix) {
        void var2_2;
        void var1_1;
        return this.adjustLeadingZeroCount((int)var1_1, this.getDivisionValue(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int adjustUpperLeadingZeroCount(int leadingZeroCount, int radix) {
        void var2_2;
        void var1_1;
        return this.adjustLeadingZeroCount((int)var1_1, this.getUpperDivisionValue(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int adjustLeadingZeroCount(int leadingZeroCount, long value, int radix) {
        void var1_1;
        if (leadingZeroCount < 0) {
            void var2_2;
            int width = AddressDivision.getDigitCount((long)var2_2, radix);
            return Math.max(0, this.getMaxDigitCount(radix) - var1_1);
        }
        return (int)var1_1;
    }

    @Override
    protected String getWildcardString() {
        return super.getWildcardString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getLowerStringLength(int radix) {
        void var1_1;
        return AddressDivision.toUnsignedStringLength(this.getDivisionValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getUpperStringLength(int radix) {
        void var1_1;
        return AddressDivision.toUnsignedStringLength(this.getUpperDivisionValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getLowerString(int radix, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        AddressDivision.toUnsignedStringCased(this.getDivisionValue(), (int)var1_1, 0, (boolean)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getUpperString(int radix, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        AddressDivision.toUnsignedStringCased(this.getUpperDivisionValue(), (int)var1_1, 0, (boolean)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getUpperString((int)var1_1, (boolean)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getLowerString(int radix, int rangeDigits, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        AddressDivision.toUnsignedStringCased(this.getDivisionValue(), (int)var1_1, (int)var2_2, (boolean)var3_3, appendable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getSplitLowerString(int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        AddressDivision.toSplitUnsignedString(this.getDivisionValue(), (int)var1_1, (int)var2_2, (boolean)var3_3, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getSplitRangeString(String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        AddressDivision.toUnsignedSplitRangeString(this.getDivisionValue(), this.getUpperDivisionValue(), (String)var1_1, (String)var2_2, (int)var3_3, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getSplitRangeStringLength(String rangeSeparator, String wildcard, int leadingZeroCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return AddressDivision.toUnsignedSplitRangeStringLength(this.getDivisionValue(), this.getUpperDivisionValue(), (String)var1_1, (String)var2_2, (int)var3_3, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix);
    }

    @Override
    protected String getDefaultLowerString() {
        return AddressDivision.toDefaultString(this.getDivisionValue(), this.getDefaultTextualRadix());
    }

    @Override
    protected String getDefaultRangeString() {
        AddressDivision addressDivision = this;
        return addressDivision.getDefaultRangeString(addressDivision.getDivisionValue(), this.getUpperDivisionValue(), this.getDefaultTextualRadix());
    }

    /*
     * WARNING - void declaration
     */
    protected String getDefaultRangeString(long val1, long val2, int radix) {
        void var5_7;
        void chars2;
        if (radix == 10) {
            int quotient;
            int remainder2;
            int len1;
            int len2;
            if (val2 < 10L) {
                len2 = 1;
            } else if (val2 < 100L) {
                len2 = 2;
            } else if (val2 < 1000L) {
                len2 = 3;
            } else {
                return this.buildDefaultRangeString(radix);
            }
            int value2 = (int)val2;
            if (val1 < 10L) {
                len1 = 1;
            } else if (val1 < 100L) {
                len1 = 2;
            } else if (val1 < 1000L) {
                len1 = 3;
            } else {
                return this.buildDefaultRangeString(radix);
            }
            int value1 = (int)val1;
            char[] cArray = new char[len2 += len1 + 1];
            char[] chars2 = cArray;
            cArray[len1] = 45;
            char[] dig = DIGITS;
            do {
                quotient = value1 * 52429 >>> 19;
                remainder2 = value1 - ((quotient << 3) + (quotient << 1));
                chars2[--len1] = dig[remainder2];
            } while ((remainder2 = quotient) != 0);
            do {
                quotient = value2 * 52429 >>> 19;
                remainder2 = value2 - ((quotient << 3) + (quotient << 1));
                chars2[--len2] = dig[remainder2];
            } while ((value2 = quotient) != 0);
            return new String(chars2);
        }
        if (chars2 == 16) {
            void var2_17;
            int remainder;
            int quotient;
            int len1;
            void remainder2;
            int len2;
            void len12;
            if (len12 < 16L) {
                len2 = 1;
            } else if (len12 < 256L) {
                len2 = 2;
            } else if (len12 < 4096L) {
                len2 = 3;
            } else if (len12 < 65536L) {
                len2 = 4;
            } else {
                return this.buildDefaultRangeString((int)chars2);
            }
            int value2 = (int)len12;
            if (remainder2 < 16L) {
                len1 = 1;
            } else if (remainder2 < 256L) {
                len1 = 2;
            } else if (remainder2 < 4096L) {
                len1 = 3;
            } else if (remainder2 < 65536L) {
                len1 = 4;
            } else {
                return this.buildDefaultRangeString((int)chars2);
            }
            int value1 = (int)remainder2;
            char[] cArray = new char[len2 += len1 + 1];
            char[] chars3 = cArray;
            cArray[len1] = 45;
            char[] dig = DIGITS;
            do {
                quotient = value1 >>> 4;
                remainder = value1 - (quotient << 4);
                chars3[--len1] = dig[remainder];
            } while ((remainder = quotient) != 0);
            do {
                void var1_3;
                quotient = value2 >>> 4;
                remainder = value2 - (quotient << 4);
                chars3[--len2] = dig[var1_3];
            } while ((value2 = var2_17) != false);
            return new String(chars3);
        }
        return this.buildDefaultRangeString((int)var5_7);
    }

    /*
     * WARNING - void declaration
     */
    private String buildDefaultRangeString(int radix) {
        void var2_2;
        void var1_1;
        StringBuilder builder = new StringBuilder(20);
        this.getRangeString(IPAddress.RANGE_SEPARATOR_STR, 0, 0, "", (int)var1_1, false, false, builder);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static String toDefaultString(long val, int radix) {
        void var2_3;
        long l;
        int len;
        if (radix < 2 || radix > 85 || val < 0L) {
            throw new IllegalArgumentException();
        }
        if (val == 0L) {
            return "0";
        }
        if (val == 1L) {
            return "1";
        }
        if (radix == 10) {
            int quotient;
            int remainder;
            int value;
            if (val < 10L) {
                return String.valueOf(DIGITS, (int)val, 1);
            }
            if (val < 100L) {
                len = 2;
                value = (int)val;
            } else if (val < 1000L) {
                len = 3;
                value = (int)val;
            } else {
                return Long.toString(val, len);
            }
            char[] chars = new char[len];
            char[] dig = DIGITS;
            do {
                quotient = value * 52429 >>> 19;
                remainder = value - ((quotient << 3) + (quotient << 1));
                chars[--len] = dig[remainder];
            } while ((remainder = quotient) != 0);
            return new String(chars);
        }
        if (len == 16) {
            void var3_7;
            void var0_2;
            void var1_5;
            int value;
            long quotient;
            if (quotient < 16L) {
                return String.valueOf(DIGITS, (int)quotient, 1);
            }
            if (quotient < 256L) {
                len = 2;
                value = (int)quotient;
            } else if (quotient < 4096L) {
                len = 3;
                value = (int)quotient;
            } else if (quotient < 65536L) {
                if (quotient == 65535L) {
                    return "ffff";
                }
                value = (int)quotient;
                len = 4;
            } else {
                return Long.toString(quotient, len);
            }
            char[] chars = new char[len];
            char[] dig = DIGITS;
            do {
                int quotient2 = value >>> 4;
                int remainder = value - (quotient2 << 4);
                chars[--len] = dig[var1_5];
            } while ((var1_5 = var0_2) != false);
            return new String((char[])var3_7);
        }
        return Long.toString(l, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private static int toUnsignedSplitRangeStringLength(long lower, long upper, String rangeSeparator, String wildcard, int leadingZerosCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        void var2_1;
        int upperDigit;
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        int digitsLength = -1;
        int stringPrefixLength = stringPrefix.length();
        do {
            upperDigit = (int)(upper % (long)radix);
            int n = (int)(lower % (long)radix);
            upperDigit = n == 0 && upperDigit == radix - 1 ? 1 : 0;
            if (upperDigit != 0) {
                digitsLength += wildcard.length() + 1;
                continue;
            }
            digitsLength += (stringPrefixLength << 1) + 4;
        } while ((upper /= (long)radix) != (lower /= (long)radix));
        upperDigit = upper == 0L ? 0 : AddressDivision.toUnsignedStringLength((long)var2_1, radix);
        int remaining = upperDigit + leadingZerosCount;
        if (remaining > 0) {
            digitsLength += remaining * (stringPrefixLength + 2);
        }
        return digitsLength;
    }

    /*
     * WARNING - void declaration
     */
    private static void toSplitUnsignedString(long value, int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        void var3_3;
        int front = appendable.length();
        AddressDivision.appendDigits(value, radix, (int)var3_3, uppercase, splitDigitSeparator, stringPrefix, appendable);
        if (!reverseSplitDigits) {
            int stringPrefixLen = stringPrefix.length();
            front += stringPrefixLen;
            for (int back = appendable.length() - 1; front < back; front += stringPrefixLen, back -= stringPrefixLen) {
                void var2_2;
                char frontChar = appendable.charAt(front);
                appendable.setCharAt(front, appendable.charAt(back));
                appendable.setCharAt(back, (char)var2_2);
                front += 2;
                back -= 2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void toUnsignedSplitRangeString(long lower, long upper, String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        void var2_2;
        int front = appendable.length();
        AddressDivision.appendDigits(lower, (long)var2_2, rangeSeparator, wildcard, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
        if (!reverseSplitDigits) {
            int back = appendable.length() - 1;
            while (front < back) {
                void var1_12;
                char frontChar = appendable.charAt(front);
                appendable.setCharAt(front++, appendable.charAt(back));
                appendable.setCharAt(back--, (char)var1_12);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendDigits(long value, int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, String stringPrefix, StringBuilder appendable) {
        void var3_2;
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        char[] dig = uppercase ? UPPERCASE_DIGITS : DIGITS;
        int prefLen = stringPrefix.length();
        while (value2 >= radix) {
            int index;
            if (useInts) {
                int val = value2;
                value2 /= radix;
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = val % radix;
            } else {
                long val = value;
                if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                    useInts = true;
                    value2 = (int)value;
                }
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = (int)(val % (long)radix);
            }
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            appendable.append(dig[index]);
            appendable.append(splitDigitSeparator);
        }
        if (var3_2 == false) {
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            appendable.append(dig[value2]);
        }
    }

    private static void appendDigits(long lower, long upper, String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int lowerInt;
        int upperInt;
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        char[] dig = uppercase ? UPPERCASE_DIGITS : DIGITS;
        boolean previousWasFullRange = true;
        boolean useInts = upper <= Integer.MAX_VALUE;
        if (useInts) {
            upperInt = (int)upper;
            lowerInt = (int)lower;
        } else {
            upperInt = lowerInt = radix;
        }
        int prefLen = stringPrefix.length();
        while (true) {
            int k;
            int lowerDigit;
            int upperDigit;
            if (useInts) {
                int ud = upperInt;
                upperDigit = upperInt % radix;
                upperInt /= radix;
                if (ud == lowerInt) {
                    lowerInt = upperInt;
                    lowerDigit = upperDigit;
                } else {
                    lowerDigit = lowerInt % radix;
                    lowerInt /= radix;
                }
            } else {
                long ud = upper;
                upperDigit = (int)(upper % (long)radix);
                upper /= (long)radix;
                if (ud == lower) {
                    lower = upper;
                    lowerDigit = upperDigit;
                } else {
                    lowerDigit = (int)(lower % (long)radix);
                    lower /= (long)radix;
                }
                if (upper <= Integer.MAX_VALUE) {
                    useInts = true;
                    upperInt = (int)upper;
                    lowerInt = (int)lower;
                }
            }
            if (lowerDigit == upperDigit) {
                previousWasFullRange = false;
                if (reverseSplitDigits) {
                    if (prefLen > 0) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(dig[lowerDigit]);
                } else {
                    appendable.append(dig[lowerDigit]);
                    for (k = prefLen - 1; k >= 0; --k) {
                        appendable.append(stringPrefix.charAt(k));
                    }
                }
            } else {
                if (!previousWasFullRange) {
                    throw new IncompatibleAddressException(lower, upper, "ipaddress.error.splitMismatch");
                }
                previousWasFullRange = lowerDigit == 0 && upperDigit == radix - 1;
                if (previousWasFullRange && wildcard != null) {
                    if (reverseSplitDigits) {
                        appendable.append(wildcard);
                    } else {
                        for (k = wildcard.length() - 1; k >= 0; --k) {
                            appendable.append(wildcard.charAt(k));
                        }
                    }
                } else if (reverseSplitDigits) {
                    if (prefLen > 0) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(dig[lowerDigit]);
                    appendable.append(rangeSeparator);
                    appendable.append(dig[upperDigit]);
                } else {
                    appendable.append(dig[upperDigit]);
                    appendable.append(rangeSeparator);
                    appendable.append(dig[lowerDigit]);
                    for (k = prefLen - 1; k >= 0; --k) {
                        appendable.append(stringPrefix.charAt(k));
                    }
                }
            }
            if (upperInt == 0) break;
            appendable.append(splitDigitSeparator);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getRangeDigitCount(int radix) {
        void var1_1;
        if (!this.isMultiple()) {
            return 0;
        }
        if (radix == this.getDefaultTextualRadix()) {
            return this.getRangeDigitCountImpl();
        }
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        return AddressDivision.calculateRangeDigitCount((int)var1_1, this.getDivisionValue(), this.getUpperDivisionValue(), this.getMaxValue());
    }

    protected int getRangeDigitCountImpl() {
        return AddressDivision.calculateRangeDigitCount(this.getDefaultTextualRadix(), this.getDivisionValue(), this.getUpperDivisionValue(), this.getMaxValue());
    }

    private static int calculateRangeDigitCount(int radix, long value, long upperValue, long maxValue) {
        long max;
        long upperRemainder;
        long l;
        int factor = radix;
        int numDigits = 1;
        while ((l = value % (long)factor) == 0L && (upperRemainder = upperValue % (long)factor) == (max = maxValue / (long)factor == upperValue / (long)factor ? maxValue % (long)factor : (long)(factor - 1))) {
            if (upperValue - upperRemainder == value) {
                return numDigits;
            }
            ++numDigits;
            factor *= radix;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressSegment> Iterator<S> iterator(S original, AddressNetwork.AddressSegmentCreator<S> creator, Integer segmentPrefixLength, boolean isPrefixIterator, boolean isBlockIterator) {
        void var3_3;
        void var2_2;
        void var1_1;
        S s;
        S s2 = original;
        return AddressDivision.iterator(s2, s2.getSegmentValue(), original.getUpperSegmentValue(), s.getBitCount(), var1_1, (Integer)var2_2, (boolean)var3_3, isBlockIterator);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressSegment> Iterator<S> iterator(S original, final int originalLower, final int originalUpper, int bitCount, final AddressNetwork.AddressSegmentCreator<S> creator, final Integer segmentPrefixLength, boolean isPrefixIterator, final boolean isBlockIterator) {
        void var2_2;
        void var1_1;
        int upperShiftMask;
        int shiftMask;
        int shiftAdjustment;
        if (isPrefixIterator) {
            shiftAdjustment = bitCount - segmentPrefixLength;
            shiftMask = -1 << shiftAdjustment;
            upperShiftMask = ~shiftMask;
        } else {
            upperShiftMask = 0;
            shiftMask = 0;
            shiftAdjustment = 0;
        }
        if (original != null && !original.isMultiple()) {
            S s;
            return new Iterator<S>(){
                boolean done;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public S next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    if (isBlockIterator) {
                        return creator.createSegment(originalLower & shiftMask, originalUpper | upperShiftMask, segmentPrefixLength);
                    }
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (isPrefixIterator) {
            void var3_3;
            if (isBlockIterator) {
                return new Iterator<S>(){
                    private boolean notDone = true;
                    private int current = originalLower;
                    private int last = originalUpper;
                    {
                        this.current >>>= shiftAdjustment;
                        this.last >>>= shiftAdjustment;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.notDone;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public S next() {
                        void var2_3;
                        int blockLow;
                        if (!this.notDone) {
                            throw new NoSuchElementException();
                        }
                        int cur = this.current;
                        int n = blockLow = cur << shiftAdjustment;
                        Object result = creator.createSegment(n, n | upperShiftMask, segmentPrefixLength);
                        if (++cur > this.last) {
                            this.notDone = false;
                        } else {
                            void var1_1;
                            this.current = var1_1;
                        }
                        return var2_3;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return new Iterator<S>((int)var3_3, upperShiftMask, creator, segmentPrefixLength){
                private boolean notDone = true;
                private boolean notFirst;
                private int current = originalLower;
                private int last = originalUpper;
                final /* synthetic */ int val$shiftAdjustment;
                final /* synthetic */ int val$upperShiftMask;
                final /* synthetic */ AddressNetwork.AddressSegmentCreator val$creator;
                final /* synthetic */ Integer val$segmentPrefixLength;
                {
                    this.val$shiftAdjustment = n3;
                    this.val$upperShiftMask = n4;
                    this.val$creator = addressSegmentCreator;
                    this.val$segmentPrefixLength = n5;
                    this.current >>>= this.val$shiftAdjustment;
                    this.last >>>= this.val$shiftAdjustment;
                }

                @Override
                public boolean hasNext() {
                    return this.notDone;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public S next() {
                    void var1_1;
                    void var2_2;
                    int high;
                    if (!this.notDone) {
                        throw new NoSuchElementException();
                    }
                    int cur = this.current;
                    int blockLow = cur << this.val$shiftAdjustment;
                    int blockHigh = blockLow | this.val$upperShiftMask;
                    this.current = ++cur;
                    if (!this.notFirst) {
                        int low = originalLower;
                        this.notFirst = true;
                    }
                    if ((cur = cur <= this.last ? 1 : 0) != 0) {
                        void var3_3;
                        high = var3_3;
                    } else {
                        high = originalUpper;
                        this.notDone = false;
                    }
                    return this.val$creator.createSegment((int)var2_2, (int)var1_1, this.val$segmentPrefixLength);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S>((int)var1_1, (int)var2_2, creator, segmentPrefixLength){
            private boolean notDone = true;
            private int current = this.val$originalLower;
            private int last = this.val$originalUpper;
            final /* synthetic */ int val$originalLower;
            final /* synthetic */ int val$originalUpper;
            final /* synthetic */ AddressNetwork.AddressSegmentCreator val$creator;
            final /* synthetic */ Integer val$segmentPrefixLength;
            {
                this.val$originalLower = n;
                this.val$originalUpper = n2;
                this.val$creator = addressSegmentCreator;
                this.val$segmentPrefixLength = n3;
            }

            @Override
            public boolean hasNext() {
                return this.notDone;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public S next() {
                void var1_1;
                if (!this.notDone) {
                    throw new NoSuchElementException();
                }
                Object result = this.val$creator.createSegment(this.current, this.val$segmentPrefixLength);
                this.notDone = ++this.current <= this.last;
                return var1_1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressSegment> S setPrefixedSegment(S original, Integer oldSegmentPrefixLength, Integer newSegmentPrefixLength, boolean zeroed, AddressNetwork.AddressSegmentCreator<S> creator) {
        void var2_4;
        void var0_1;
        void var1_3;
        int newUpper2;
        int newLower;
        if (Objects.equals(oldSegmentPrefixLength, newSegmentPrefixLength)) {
            return original;
        }
        if (zeroed) {
            void var3_5;
            int prefixMask;
            int bitCount = original.getBitCount();
            if (oldSegmentPrefixLength != null) {
                if (newSegmentPrefixLength == null) {
                    prefixMask = -1 << bitCount - oldSegmentPrefixLength;
                } else if (oldSegmentPrefixLength > newSegmentPrefixLength) {
                    prefixMask = -1 << bitCount - newSegmentPrefixLength;
                    prefixMask |= ~(-1 << bitCount - oldSegmentPrefixLength);
                } else {
                    prefixMask = -1 << bitCount - oldSegmentPrefixLength;
                    prefixMask |= ~(-1 << bitCount - newSegmentPrefixLength);
                }
            } else {
                prefixMask = -1 << bitCount - newSegmentPrefixLength;
            }
            int value = original.getSegmentValue();
            int upperValue = original.getUpperSegmentValue();
            long maxValue = -1L << original.getBitCount() ^ 0xFFFFFFFFFFFFFFFFL;
            ParsedIPAddress.Masker masker = AddressDivision.maskRange(value, upperValue, prefixMask, maxValue);
            if (!masker.isSequential()) {
                throw new IncompatibleAddressException(original, "ipaddress.error.maskMismatch");
            }
            newLower = (int)masker.getMaskedLower(value, prefixMask);
            newUpper2 = (int)masker.getMaskedUpper(upperValue, (long)var3_5);
        } else {
            S newUpper;
            newLower = newUpper.getSegmentValue();
            newUpper2 = newUpper.getUpperSegmentValue();
        }
        return creator.createSegment((int)var1_3, (int)var0_1, (Integer)var2_4);
    }
}

