/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.large;

import inet.ipaddr.Address;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.IPAddressGenericDivision;
import inet.ipaddr.format.util.AddressSegmentParams;
import java.math.BigInteger;
import java.util.Arrays;

public class IPAddressLargeDivision
extends AddressDivisionBase
implements IPAddressGenericDivision {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final String EXTENDED_DIGITS_RANGE_SEPARATOR_STR = "\u00bb";
    private final BigInteger value;
    private final BigInteger upperValue;
    private final BigInteger maxValue;
    private final BigInteger upperValueMasked;
    private final BigInteger defaultRadix;
    private final int bitCount;
    private final Integer networkPrefixLength;
    private final boolean isSinglePrefixBlock;
    private final boolean isPrefixBlock;
    protected transient String cachedString;

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public BigInteger getUpperValue() {
        return this.upperValue;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] convert(byte[] bytes, int requiredByteCount, String key2) {
        byte[] byArray;
        void var1_1;
        int len = bytes.length;
        if (len < requiredByteCount) {
            byte[] oldBytes = bytes;
            bytes = new byte[requiredByteCount];
            int diff = bytes.length - oldBytes.length;
            int key2 = 0x80 & oldBytes[0];
            if (key2 != 0) {
                Arrays.fill(bytes, 0, diff, (byte)-1);
            }
            System.arraycopy(oldBytes, 0, bytes, (int)var1_1, oldBytes.length);
        } else if (len > var1_1) {
            int i = 0;
            do {
                String key2;
                if (bytes[i++] == 0) continue;
                throw new AddressValueException(key2, len);
            } while (--len > var1_1);
            bytes = Arrays.copyOfRange(bytes, i, bytes.length);
        }
        return byArray;
    }

    @Override
    public int getBitCount() {
        return this.bitCount;
    }

    @Override
    public boolean isMultiple() {
        return !this.getValue().equals(this.getUpperValue());
    }

    @Override
    public boolean includesZero() {
        return this.getValue().signum() == 0;
    }

    @Override
    public boolean includesMax() {
        return this.getUpperValue().equals(this.maxValue);
    }

    @Override
    public boolean isMax() {
        return this.includesMax() && !this.isMultiple();
    }

    @Override
    public boolean isZero() {
        return this.includesZero() && !this.isMultiple();
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        return IPAddressLargeDivision.convert(low ? this.getValue().toByteArray() : this.getUpperValue().toByteArray(), this.bitCount + 7 >>> 3, "");
    }

    @Override
    public int getDefaultTextualRadix() {
        return this.defaultRadix.intValue();
    }

    @Override
    public int getMaxDigitCount() {
        return IPAddressLargeDivision.getMaxDigitCount(this.defaultRadix.intValue(), this.bitCount, this.maxValue);
    }

    @Override
    public int getMaxDigitCount(int radix) {
        return IPAddressLargeDivision.getMaxDigitCount(radix, this.bitCount, this.maxValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int adjustLowerLeadingZeroCount(int leadingZeroCount, int radix) {
        void var2_2;
        void var1_1;
        return this.adjustLeadingZeroCount((int)var1_1, this.getValue(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int adjustUpperLeadingZeroCount(int leadingZeroCount, int radix) {
        void var2_2;
        void var1_1;
        return this.adjustLeadingZeroCount((int)var1_1, this.getUpperValue(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int adjustLeadingZeroCount(int leadingZeroCount, BigInteger value, int radix) {
        void var1_1;
        if (leadingZeroCount < 0) {
            void var3_3;
            void var2_2;
            int width = this.getDigitCount((BigInteger)var2_2, radix);
            return Math.max(0, this.getMaxDigitCount((int)var3_3) - var1_1);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int getDigitCount(BigInteger val, int radix) {
        void var2_3;
        void var1_1;
        BigInteger bigRadix = this.defaultRadix.intValue() == radix ? this.defaultRadix : BigInteger.valueOf(radix);
        return IPAddressLargeDivision.getDigitCount((BigInteger)var1_1, (BigInteger)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private String toDefaultString(BigInteger val, int radix, boolean uppercase, int choppedDigits) {
        void var2_2;
        void var3_3;
        void var1_1;
        BigInteger bigRadix = this.defaultRadix.intValue() == radix ? this.defaultRadix : BigInteger.valueOf(radix);
        return IPAddressLargeDivision.toDefaultString((BigInteger)var1_1, bigRadix, (boolean)var3_3, choppedDigits, IPAddressLargeDivision.getMaxDigitCount((int)var2_2, this.bitCount, null));
    }

    private static void toDefaultStringRecursive(BigInteger val, BigInteger radix, boolean uppercase, int choppedDigits, int digitCount, char[] dig, boolean highest, StringBuilder builder) {
        while (true) {
            Object intRadix2;
            if (val.compareTo(LONG_MAX) <= 0) {
                long longVal = val.longValue();
                int intRadix2 = radix.intValue();
                if (!highest) {
                    IPAddressLargeDivision.getLeadingZeros(digitCount - IPAddressLargeDivision.toUnsignedStringLength(longVal, intRadix2), builder);
                }
                IPAddressLargeDivision.toUnsignedStringCased(longVal, intRadix2, choppedDigits, uppercase, builder);
                return;
            }
            if (digitCount <= choppedDigits) break;
            int halfCount = digitCount >>> 1;
            BigInteger radixPower = IPAddressLargeDivision.getRadixPower(radix, halfCount);
            Object highLow = intRadix2.divideAndRemainder(radixPower);
            BigInteger high = highLow[0];
            Object low = highLow[1];
            if (highest && high.signum() == 0) {
                IPAddressLargeDivision.toDefaultStringRecursive((BigInteger)low, radix, uppercase, choppedDigits, halfCount, dig, true, builder);
                return;
            }
            IPAddressLargeDivision.toDefaultStringRecursive(high, radix, uppercase, Math.max(0, choppedDigits - halfCount), digitCount - halfCount, dig, highest, builder);
            highest = false;
            digitCount = halfCount;
        }
    }

    private boolean isExtendedDigits() {
        return IPAddressLargeDivision.isExtendedDigits(this.defaultRadix.intValue());
    }

    private static boolean isExtendedDigits(int radix) {
        return radix > 36;
    }

    /*
     * WARNING - void declaration
     */
    private static char[] getDigits(int radix, boolean uppercase) {
        void var1_1;
        if (IPAddressLargeDivision.isExtendedDigits(radix)) {
            return EXTENDED_DIGITS;
        }
        if (var1_1 != false) {
            return UPPERCASE_DIGITS;
        }
        return DIGITS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void appendUppercase(CharSequence str, int radix, StringBuilder appendable) {
        void var1_1;
        void var3_3;
        if (radix > 10 && !this.isExtendedDigits()) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                appendable.append(c);
            }
            return;
        }
        var3_3.append((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String toDefaultString(BigInteger val, BigInteger radix, boolean uppercase, int choppedDigits, int maxDigits) {
        StringBuilder builder;
        if (radix.compareTo(BIG_MIN_RADIX) < 0 || radix.compareTo(BIG_MAX_RADIX) > 0) {
            throw new IllegalArgumentException();
        }
        if (val.equals(BigInteger.ZERO)) {
            return "0";
        }
        if (val.equals(BigInteger.ONE)) {
            return "1";
        }
        char[] dig = IPAddressLargeDivision.getDigits(radix.intValue(), uppercase);
        if (maxDigits > 0) {
            if (maxDigits <= choppedDigits) {
                return "";
            }
            builder = new StringBuilder();
            IPAddressLargeDivision.toDefaultStringRecursive(val, radix, uppercase, choppedDigits, maxDigits, dig, true, builder);
        } else {
            builder = null;
            do {
                void var2_3;
                BigInteger[] divisorRemainder = val.divideAndRemainder(radix);
                BigInteger quotient = divisorRemainder[0];
                BigInteger remainder = divisorRemainder[1];
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(dig[var2_3.intValue()]);
                val = quotient;
            } while (val.signum() != 0);
            if (builder == null) {
                return "";
            }
            builder.reverse();
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString() {
        void var1_1;
        String result = this.cachedString;
        if (result == null) {
            IPAddressLargeDivision iPAddressLargeDivision = this;
            synchronized (iPAddressLargeDivision) {
                result = this.cachedString;
                if (result == null) {
                    if (this.isSinglePrefixBlock() || !this.isMultiple()) {
                        result = this.getDefaultLowerString();
                    } else if (!this.isFullRange() || (result = this.getDefaultSegmentWildcardString()) == null) {
                        result = this.isPrefixBlock() ? this.getDefaultMaskedRangeString() : this.getDefaultRangeString();
                    }
                    this.cachedString = result;
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCachedDefaultLowerString() {
        void var1_1;
        String result = this.cachedString;
        if (result == null) {
            IPAddressLargeDivision iPAddressLargeDivision = this;
            synchronized (iPAddressLargeDivision) {
                result = this.cachedString;
                if (result == null) {
                    this.cachedString = result = this.getDefaultLowerString();
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getWildcardString() {
        void var1_1;
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressLargeDivision iPAddressLargeDivision = this;
            synchronized (iPAddressLargeDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    if (!this.isPrefixed() || !this.isMultiple()) {
                        result = this.getString();
                    } else if (!this.isFullRange() || (result = this.getDefaultSegmentWildcardString()) == null) {
                        result = this.getDefaultRangeString();
                    }
                    this.cachedWildcardString = result;
                }
            }
        }
        return var1_1;
    }

    @Override
    protected String getDefaultLowerString() {
        return IPAddressLargeDivision.toDefaultString(this.getValue(), this.defaultRadix, false, 0, this.getMaxDigitCount());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getDefaultRangeString() {
        void var1_1;
        int maxDigitCount = this.getMaxDigitCount();
        return IPAddressLargeDivision.toDefaultString(this.getValue(), this.defaultRadix, false, 0, maxDigitCount) + this.getDefaultRangeSeparatorString() + IPAddressLargeDivision.toDefaultString(this.getUpperValue(), this.defaultRadix, false, 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected String getDefaultMaskedRangeString() {
        void var1_1;
        int maxDigitCount = this.getMaxDigitCount();
        return IPAddressLargeDivision.toDefaultString(this.getValue(), this.defaultRadix, false, 0, maxDigitCount) + this.getDefaultRangeSeparatorString() + IPAddressLargeDivision.toDefaultString(this.upperValueMasked, this.defaultRadix, false, 0, (int)var1_1);
    }

    @Override
    protected String getDefaultRangeSeparatorString() {
        if (this.isExtendedDigits()) {
            return EXTENDED_DIGITS_RANGE_SEPARATOR_STR;
        }
        return Address.RANGE_SEPARATOR_STR;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getLowerStringLength(int radix) {
        void var1_1;
        IPAddressLargeDivision iPAddressLargeDivision = this;
        return iPAddressLargeDivision.getDigitCount(iPAddressLargeDivision.getValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getUpperStringLength(int radix) {
        void var1_1;
        IPAddressLargeDivision iPAddressLargeDivision = this;
        return iPAddressLargeDivision.getDigitCount(iPAddressLargeDivision.getUpperValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getLowerString(int radix, boolean uppercase, StringBuilder appendable) {
        void var2_2;
        void var1_1;
        IPAddressLargeDivision iPAddressLargeDivision = this;
        appendable.append(iPAddressLargeDivision.toDefaultString(iPAddressLargeDivision.getValue(), (int)var1_1, (boolean)var2_2, 0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getLowerString(int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        void var2_2;
        void var3_3;
        void var1_1;
        IPAddressLargeDivision iPAddressLargeDivision = this;
        appendable.append(iPAddressLargeDivision.toDefaultString(iPAddressLargeDivision.getValue(), (int)var1_1, (boolean)var3_3, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getUpperString(int radix, boolean uppercase, StringBuilder appendable) {
        void var2_2;
        void var1_1;
        IPAddressLargeDivision iPAddressLargeDivision = this;
        appendable.append(iPAddressLargeDivision.toDefaultString(iPAddressLargeDivision.getUpperValue(), (int)var1_1, (boolean)var2_2, 0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        void var2_2;
        void var1_1;
        IPAddressLargeDivision iPAddressLargeDivision = this;
        appendable.append(iPAddressLargeDivision.toDefaultString(iPAddressLargeDivision.upperValueMasked, (int)var1_1, (boolean)var2_2, 0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void getSplitLowerString(int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        void var3_3;
        StringBuilder builder = new StringBuilder();
        this.getLowerString(radix, choppedDigits, (boolean)var3_3, builder);
        int prefLen = stringPrefix.length();
        for (int i = 0; i < builder.length(); ++i) {
            if (i > 0) {
                appendable.append(splitDigitSeparator);
            }
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            appendable.append(builder.charAt(reverseSplitDigits ? builder.length() - i - 1 : i));
        }
    }

    @Override
    protected void getSplitRangeString(String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        StringBuilder lowerBuilder = new StringBuilder();
        StringBuilder upperBuilder = new StringBuilder();
        this.getLowerString(radix, uppercase, lowerBuilder);
        this.getUpperString(radix, uppercase, upperBuilder);
        int diff = upperBuilder.length() - lowerBuilder.length();
        if (diff > 0) {
            StringBuilder newLowerBuilder = new StringBuilder();
            while (diff-- > 0) {
                newLowerBuilder.append('0');
            }
            newLowerBuilder.append((CharSequence)lowerBuilder);
            lowerBuilder = newLowerBuilder;
        }
        boolean previousWasFull = true;
        boolean nextMustBeFull = false;
        char[] dig = IPAddressLargeDivision.getDigits(radix, uppercase);
        char zeroDigit = dig[0];
        char highestDigit = dig[radix - 1];
        int len = lowerBuilder.length();
        int prefLen = stringPrefix.length();
        for (int i = 0; i < len; ++i) {
            int index = reverseSplitDigits ? len - i - 1 : i;
            char lower = lowerBuilder.charAt(index);
            char upper = upperBuilder.charAt(index);
            if (i > 0) {
                appendable.append(splitDigitSeparator);
            }
            if (lower == upper) {
                if (nextMustBeFull) {
                    throw new IncompatibleAddressException(lower, (long)upper, "ipaddress.error.splitMismatch");
                }
                if (prefLen > 0) {
                    appendable.append(stringPrefix);
                }
                appendable.append(lower);
                continue;
            }
            boolean isFullRange = lower == zeroDigit && upper == highestDigit;
            if (isFullRange) {
                appendable.append(wildcard);
            } else {
                if (nextMustBeFull) {
                    throw new IncompatibleAddressException(lower, (long)upper, "ipaddress.error.splitMismatch");
                }
                if (prefLen > 0) {
                    appendable.append(stringPrefix);
                }
                appendable.append(lower);
                appendable.append(rangeSeparator);
                appendable.append(upper);
            }
            if (reverseSplitDigits) {
                if (!previousWasFull) {
                    throw new IncompatibleAddressException(lower, (long)upper, "ipaddress.error.splitMismatch");
                }
                previousWasFull = isFullRange;
                continue;
            }
            nextMustBeFull = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getSplitRangeStringLength(String rangeSeparator, String wildcard, int leadingZeroCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        void var1_2;
        void remainingAfterLoop;
        int digitsLength = -1;
        int stringPrefixLength = stringPrefix.length();
        StringBuilder lowerBuilder = new StringBuilder();
        StringBuilder upperBuilder = new StringBuilder();
        this.getLowerString(radix, uppercase, lowerBuilder);
        this.getUpperString(radix, uppercase, upperBuilder);
        char[] dig = IPAddressLargeDivision.getDigits(radix, uppercase);
        char zeroDigit = dig[0];
        char highestDigit = dig[radix - 1];
        for (int i = 1; i <= upperBuilder.length(); ++i) {
            char c;
            if (i <= lowerBuilder.length()) {
                StringBuilder stringBuilder = lowerBuilder;
                c = stringBuilder.charAt(stringBuilder.length() - i);
            } else {
                c = '\u0000';
            }
            char lower = c;
            int upperIndex = upperBuilder.length() - i;
            char upper = upperBuilder.charAt(upperIndex);
            boolean bl = lower == zeroDigit && upper == highestDigit;
            if (bl) {
                digitsLength += wildcard.length() + 1;
                continue;
            }
            if (lower != upper) {
                digitsLength += (stringPrefixLength << 1) + 4;
                continue;
            }
            remainingAfterLoop += upperIndex + 1;
            break;
        }
        if (remainingAfterLoop > 0) {
            void var3_4;
            digitsLength += var3_4 * (stringPrefixLength + 2);
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getRangeDigitCount(int radix) {
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        if (!this.isMultiple()) {
            return 0;
        }
        BigInteger val = this.getValue();
        BigInteger upperVal = this.getUpperValue();
        int count = 1;
        BigInteger bigRadix = BigInteger.valueOf(radix);
        BigInteger bigUpper = BigInteger.valueOf(radix - 1);
        while (true) {
            void var3_4;
            BigInteger bigInteger;
            Object highLow = val.divideAndRemainder(bigRadix);
            BigInteger quotient = highLow[0];
            if ((highLow = highLow[1]).signum() != 0) break;
            highLow = upperVal.divideAndRemainder(bigRadix);
            BigInteger upperQuotient = highLow[0];
            if (!(bigInteger = bigInteger[1]).equals(bigUpper)) break;
            bigInteger = quotient;
            if (bigInteger.equals(var3_4)) {
                return count;
            }
            ++count;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getPrefixAdjustedRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.getPrefixAdjustedRangeString((int)var1_1, (AddressSegmentParams)var2_2, (StringBuilder)var3_3);
    }

    public boolean isPrefixBlock() {
        return this.isPrefixBlock;
    }

    @Override
    public boolean isSinglePrefixBlock() {
        return this.isSinglePrefixBlock;
    }

    @Override
    public Integer getDivisionPrefixLength() {
        return this.networkPrefixLength;
    }

    @Override
    public boolean isPrefixed() {
        return this.networkPrefixLength != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameValues(AddressDivisionBase otherSegment) {
        void var1_1;
        return otherSegment instanceof IPAddressLargeDivision && super.isSameValues((AddressDivisionBase)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IPAddressLargeDivision) {
            void var1_1;
            IPAddressLargeDivision otherSegments = (IPAddressLargeDivision)other;
            return this.getBitCount() == otherSegments.getBitCount() && var1_1.isSameValues(this);
        }
        return false;
    }
}

