/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.Address;
import inet.ipaddr.format.AddressDivisionBase;
import java.io.Serializable;
import java.math.BigInteger;

public interface AddressItem
extends Serializable,
Comparable<AddressItem> {
    /*
     * WARNING - void declaration
     */
    @Override
    default public int compareTo(AddressItem other) {
        void var1_1;
        return Address.DEFAULT_ADDRESS_COMPARATOR.compare(this, (AddressItem)var1_1);
    }

    default public BigInteger getCount() {
        return this.getUpperValue().subtract(this.getValue()).add(BigInteger.ONE);
    }

    public int getBitCount();

    default public int getByteCount() {
        return this.getBitCount() + 7 >>> 3;
    }

    default public boolean isMultiple() {
        return !this.getUpperValue().equals(this.getValue());
    }

    public byte[] getBytes(byte[] var1);

    public byte[] getUpperBytes(byte[] var1);

    public BigInteger getValue();

    public BigInteger getUpperValue();

    public boolean isZero();

    public boolean includesZero();

    public boolean isMax();

    public boolean includesMax();

    default public boolean isFullRange() {
        return this.includesZero() && this.includesMax();
    }

    /*
     * WARNING - void declaration
     */
    default public boolean containsPrefixBlock(int divisionPrefixLen) {
        void var1_1;
        void var2_2;
        if (divisionPrefixLen == 0) {
            return this.isFullRange();
        }
        BigInteger upper = this.getUpperValue();
        void v0 = var2_2;
        return AddressDivisionBase.testRange(this.getValue(), (BigInteger)v0, (BigInteger)v0, this.getBitCount(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public boolean containsSinglePrefixBlock(int divisionPrefixLen) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (divisionPrefixLen == 0) {
            return this.isFullRange();
        }
        BigInteger lower = this.getValue();
        BigInteger upper = this.getUpperValue();
        void v0 = var2_2;
        return AddressDivisionBase.testRange((BigInteger)v0, (BigInteger)v0, (BigInteger)var3_3, this.getBitCount(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public int getMinPrefixLengthForBlock() {
        void var1_1;
        BigInteger upper;
        int result = this.getBitCount();
        BigInteger lower = this.getValue();
        if (!lower.equals(upper = this.getUpperValue())) {
            long l;
            int upperOnes;
            long l2;
            int lowerZeros;
            while ((lowerZeros = Long.numberOfTrailingZeros(l2 = lower.longValue())) != 0 && (upperOnes = Long.numberOfTrailingZeros((l = upper.longValue()) ^ 0xFFFFFFFFFFFFFFFFL)) != 0) {
                int prefixedBitCount = Math.min(lowerZeros, upperOnes);
                result -= prefixedBitCount;
                if (prefixedBitCount < 64) break;
                lower = lower.shiftRight(64);
                if ((upper = upper.shiftRight(64)).signum() != 0) continue;
            }
        }
        return (int)var1_1;
    }
}

