/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.AddressComponent;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressComponentRange;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.AddressItemSpliteratorBase;
import inet.ipaddr.format.AddressSeriesSpliterator;
import inet.ipaddr.format.IPAddressDivisionSeries;
import inet.ipaddr.format.IPAddressGenericDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.string.AddressStringDivision;
import inet.ipaddr.format.string.AddressStringDivisionSeries;
import inet.ipaddr.format.string.IPAddressStringDivision;
import inet.ipaddr.format.string.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.format.util.AddressDivisionWriter;
import inet.ipaddr.format.util.AddressSegmentParams;
import inet.ipaddr.format.util.IPAddressStringWriter;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;

public abstract class AddressDivisionGroupingBase
implements AddressDivisionSeries {
    protected static final Integer NO_PREFIX_LENGTH = -1;
    static final BigInteger ALL_ONES = BigInteger.ZERO.not();
    protected static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static ResourceBundle bundle;
    protected transient ValueCache valueCache;
    private final AddressDivisionBase[] divisions;
    protected Integer cachedPrefixLength;
    private transient Boolean isMultiple;
    private transient BigInteger cachedCount;
    protected transient int hashCode;

    /*
     * WARNING - void declaration
     */
    public AddressDivisionGroupingBase(AddressDivisionBase[] divisions) {
        this((AddressDivisionBase[])var1_1, true);
        void var1_1;
    }

    public AddressDivisionGroupingBase(AddressDivisionBase[] divisions, boolean checkDivisions) {
        this.divisions = divisions;
        if (checkDivisions) {
            for (int i = 0; i < divisions.length; ++i) {
                if (divisions[i] != null) continue;
                throw new NullPointerException(AddressDivisionGroupingBase.getMessage("ipaddress.error.null.segment"));
            }
        }
    }

    protected static String getMessage(String key) {
        String string;
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressDivisionBase getDivision(int index) {
        void var1_1;
        return this.getDivisionsInternal()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    protected void initCachedValues(Integer cachedNetworkPrefixLength, BigInteger cachedCount) {
        void var2_2;
        void var1_1;
        this.cachedPrefixLength = cachedNetworkPrefixLength == null ? NO_PREFIX_LENGTH : var1_1;
        this.cachedCount = var2_2;
    }

    @Override
    public int getDivisionCount() {
        return this.getDivisionsInternal().length;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] getBytesInternal() {
        void var1_1;
        block3: {
            byte[] cached;
            block2: {
                if (this.hasNoValueCache()) break block2;
                cached = this.valueCache.lowerBytes;
                if (this.valueCache.lowerBytes != null) break block3;
            }
            this.valueCache.lowerBytes = cached = this.getBytesImpl(true);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(byte[] bytes, int index) {
        void var2_2;
        return AddressDivisionGroupingBase.getBytesCopy(bytes, (int)var2_2, this.getBytesInternal());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(byte[] bytes) {
        void var1_1;
        return this.getBytes((byte[])var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getBytesCopy(byte[] bytes, int startIndex, byte[] cached) {
        byte[] byArray;
        void var3_3;
        void var1_1;
        void var2_2;
        int byteCount = cached.length;
        if (bytes == null || bytes.length < byteCount + startIndex) {
            if (startIndex > 0) {
                byte[] bytes2 = new byte[byteCount + startIndex];
                if (bytes != null) {
                    System.arraycopy(bytes, 0, bytes2, 0, Math.min(startIndex, bytes.length));
                }
                System.arraycopy(cached, 0, bytes2, startIndex, byteCount);
                return bytes2;
            }
            return (byte[])cached.clone();
        }
        System.arraycopy(var2_2, 0, bytes, (int)var1_1, (int)var3_3);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] getUpperBytesInternal() {
        void var1_3;
        byte[] cached;
        if (this.hasNoValueCache()) {
            ValueCache cache = this.valueCache;
            this.valueCache.upperBytes = cached = this.getBytesImpl(false);
            if (!this.isMultiple()) {
                cache.lowerBytes = cached;
            }
        } else {
            ValueCache cache = this.valueCache;
            cached = cache.upperBytes;
            if (cache.upperBytes == null) {
                if (!this.isMultiple()) {
                    cached = cache.lowerBytes;
                    if (cache.lowerBytes != null) {
                        cache.upperBytes = cached;
                    } else {
                        ValueCache valueCache = cache;
                        valueCache.upperBytes = cached = this.getBytesImpl(false);
                        valueCache.lowerBytes = cached;
                    }
                } else {
                    var2_2.upperBytes = cached = this.getBytesImpl(false);
                }
            }
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        void var1_1;
        return this.getBytes((byte[])var1_1, 0);
    }

    protected abstract byte[] getBytesImpl(boolean var1);

    /*
     * WARNING - void declaration
     */
    protected void setBytes(byte[] bytes) {
        void var1_1;
        if (this.valueCache == null) {
            this.valueCache = new ValueCache();
        }
        this.valueCache.lowerBytes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BigInteger getValue() {
        void var1_1;
        BigInteger cached;
        if (this.hasNoValueCache() || (cached = this.valueCache.value) == null) {
            this.valueCache.value = cached = new BigInteger(1, this.getBytesInternal());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BigInteger getUpperValue() {
        void var1_3;
        BigInteger cached;
        if (this.hasNoValueCache()) {
            ValueCache cache = this.valueCache;
            this.valueCache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
            if (!this.isMultiple()) {
                cache.value = cached;
            }
        } else {
            ValueCache cache = this.valueCache;
            cached = cache.upperValue;
            if (cached == null) {
                if (!this.isMultiple()) {
                    cached = cache.value;
                    if (cached != null) {
                        cache.upperValue = cached;
                    } else {
                        ValueCache valueCache = cache;
                        valueCache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
                        valueCache.value = cached;
                    }
                } else {
                    var2_2.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
                }
            }
        }
        return var1_3;
    }

    protected boolean hasNoValueCache() {
        if (this.valueCache == null) {
            AddressDivisionGroupingBase addressDivisionGroupingBase = this;
            synchronized (addressDivisionGroupingBase) {
                if (this.valueCache == null) {
                    this.valueCache = new ValueCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isPrefixed() {
        return this.getPrefixLength() != null;
    }

    @Override
    public Integer getPrefixLength() {
        return this.cachedPrefixLength;
    }

    protected static Integer calculatePrefix(IPAddressDivisionSeries series) {
        int count = series.getDivisionCount();
        if (count > 0) {
            if (series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && !series.getDivision(count - 1).isPrefixed()) {
                return null;
            }
            int result = 0;
            for (int i = 0; i < count; ++i) {
                IPAddressGenericDivision div = series.getDivision(i);
                Integer prefix = div.getDivisionPrefixLength();
                if (prefix != null) {
                    return ParsedAddressGrouping.cache(result += prefix.intValue());
                }
                result += div.getBitCount();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMinPrefixLengthForBlock() {
        void var2_2;
        int count = this.getDivisionCount();
        int totalPrefix = this.getBitCount();
        for (int i = count - 1; i >= 0; --i) {
            void var3_3;
            AddressDivisionBase div = this.getDivision(i);
            int segBitCount = div.getBitCount();
            int segPrefix = div.getMinPrefixLengthForBlock();
            if (segPrefix == segBitCount) break;
            totalPrefix -= segBitCount;
            if (segPrefix == 0) continue;
            totalPrefix += var3_3;
            break;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BigInteger getCount() {
        void var1_1;
        BigInteger cached = this.cachedCount;
        if (cached == null) {
            this.cachedCount = cached = this.getCountImpl();
        }
        return var1_1;
    }

    protected BigInteger getCountImpl() {
        return AddressDivisionSeries.super.getCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMultiple() {
        void var1_1;
        Boolean result = this.isMultiple;
        if (result == null) {
            for (int i = this.getDivisionCount() - 1; i >= 0; --i) {
                AddressDivisionBase addressDivisionBase = this.getDivision(i);
                if (!addressDivisionBase.isMultiple()) continue;
                this.isMultiple = Boolean.TRUE;
                return this.isMultiple;
            }
            this.isMultiple = Boolean.FALSE;
            return this.isMultiple;
        }
        return var1_1.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    protected static int adjustHashCode(int currentHash, long lowerValue, long upperValue) {
        void var3_2;
        void var1_1;
        return AddressDivisionBase.adjustHashCode(currentHash, (long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int res = this.hashCode;
        if (res == 0) {
            res = 1;
            int count = this.getDivisionCount();
            for (int i = 0; i < count; ++i) {
                AddressDivisionBase combo = this.getDivision(i);
                BigInteger lower = combo.getValue();
                BigInteger upper = combo.getUpperValue();
                do {
                    long low = lower.longValue();
                    long up = upper.longValue();
                    lower = lower.shiftRight(64);
                    upper = upper.shiftRight(64);
                    res = AddressDivisionGroupingBase.adjustHashCode(res, low, up);
                } while (upper.signum() != 0);
            }
            this.hashCode = res;
        }
        return (int)var1_1;
    }

    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        int count = this.getDivisionCount();
        if (count != other.getDivisionCount()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            AddressDivisionBase two;
            AddressDivisionBase one = this.getDivision(i);
            if (one.equals(two = other.getDivision(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivisionGroupingBase) {
            AddressDivisionGroupingBase addressDivisionGroupingBase;
            addressDivisionGroupingBase = addressDivisionGroupingBase;
            return addressDivisionGroupingBase.isSameGrouping(this);
        }
        return false;
    }

    protected AddressDivisionBase[] getDivisionsInternal() {
        return this.divisions;
    }

    public String toString() {
        return Arrays.asList(this.getDivisionsInternal()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String[] getDivisionStrings() {
        void var1_1;
        String[] result = new String[this.getDivisionCount()];
        Arrays.setAll(result, i -> {
            void var1_1;
            return this.getDivision((int)var1_1).getWildcardString();
        });
        return var1_1;
    }

    @Override
    public boolean isZero() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean includesZero() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).includesZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMax() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).isMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean includesMax() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).includesMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            AddressDivisionBase addressDivisionBase = this.getDivision(i);
            if (addressDivisionBase.isFullRange()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static void checkSubnet(AddressDivisionSeries series, int prefixLength) throws PrefixLenException {
        if (prefixLength < 0 || prefixLength > series.getBitCount()) {
            void var1_1;
            AddressDivisionSeries addressDivisionSeries;
            throw new PrefixLenException((AddressItem)addressDivisionSeries, (int)var1_1);
        }
    }

    @Override
    public boolean isSinglePrefixBlock() {
        if (this.isPrefixed()) {
            AddressDivisionGroupingBase addressDivisionGroupingBase = this;
            if (addressDivisionGroupingBase.containsSinglePrefixBlock(addressDivisionGroupingBase.getPrefixLength())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPrefixBlock() {
        if (this.isPrefixed()) {
            AddressDivisionGroupingBase addressDivisionGroupingBase = this;
            if (addressDivisionGroupingBase.containsPrefixBlock(addressDivisionGroupingBase.getPrefixLength())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean containsPrefixBlock(IPAddressDivisionSeries series, int prefixLength) {
        AddressDivisionGroupingBase.checkSubnet(series, prefixLength);
        boolean isAllSubnets = series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (isAllSubnets && series.isPrefixed() && series.getNetworkPrefixLength() <= prefixLength) {
            return true;
        }
        int prevBitCount = 0;
        int divCount = series.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            IPAddressGenericDivision div = series.getDivision(i);
            int n = div.getBitCount();
            int totalBitCount = n + prevBitCount;
            if (prefixLength < totalBitCount) {
                void var1_1;
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                if (!div.containsPrefixBlock((int)var1_1)) {
                    return false;
                }
                if (isAllSubnets && div.isPrefixed()) {
                    return true;
                }
                ++i;
                while (i < divCount) {
                    div = series.getDivision(i);
                    if (!div.isFullRange()) {
                        return false;
                    }
                    if (isAllSubnets && div.isPrefixed()) {
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean containsSinglePrefixBlock(IPAddressDivisionSeries series, int prefixLength) {
        AddressDivisionGroupingBase.checkSubnet(series, prefixLength);
        boolean isAllSubnets = series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (isAllSubnets && series.isPrefixed() && series.getNetworkPrefixLength() < prefixLength) {
            return false;
        }
        int prevBitCount = 0;
        int divCount = series.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            IPAddressGenericDivision div = series.getDivision(i);
            int n = div.getBitCount();
            int totalBitCount = n + prevBitCount;
            if (prefixLength >= totalBitCount) {
                if (div.isMultiple()) {
                    return false;
                }
            } else {
                void var1_1;
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                if (!div.containsSinglePrefixBlock((int)var1_1)) {
                    return false;
                }
                if (isAllSubnets && div.isPrefixed()) {
                    return true;
                }
                ++i;
                while (i < divCount) {
                    div = series.getDivision(i);
                    if (!div.isFullRange()) {
                        return false;
                    }
                    if (isAllSubnets && div.isPrefixed()) {
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends AddressComponent> AddressComponentSpliterator<T> createSeriesSpliterator(T forIteration, Predicate<SplitterSink<T, T>> splitter, IteratorProvider<T, T> iteratorProvider, Function<T, BigInteger> sizer, Predicate<T> downSizer, ToLongFunction<T> longSizer) {
        void var3_3;
        void var2_2;
        void var1_1;
        T t;
        return new AddressSeriesSpliterator<T>(t, var1_1, var2_2, var3_3, downSizer, longSizer);
    }

    protected static AddressDivisionWriter getCachedParams(StringOptionsBase opts) {
        return opts.cachedParams;
    }

    /*
     * WARNING - void declaration
     */
    protected static void setCachedParams(StringOptionsBase opts, AddressDivisionWriter cachedParams) {
        void var1_1;
        opts.cachedParams = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        String propertyFileName = "IPAddressResources";
        String name = HostIdentifierException.class.getPackage().getName() + '.' + propertyFileName;
        try {
            bundle = ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException missingResourceException) {
            void var0;
            System.err.println("bundle " + (String)var0 + " is missing");
        }
    }

    protected static class StringOptionsBase {
        AddressDivisionWriter cachedParams;

        protected StringOptionsBase() {
        }
    }

    protected static class IPAddressStringParams<T extends IPAddressStringDivisionSeries>
    extends AddressStringParams<T>
    implements IPAddressStringWriter<T> {
        public static final IPAddressSection.WildcardOptions.WildcardOption DEFAULT_WILDCARD_OPTION = IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY;
        private IPAddressSection.WildcardOptions.WildcardOption wildcardOption = DEFAULT_WILDCARD_OPTION;
        private int[] expandSegment;
        private String addressSuffix = "";

        /*
         * WARNING - void declaration
         */
        public IPAddressStringParams(int radix, Character separator, boolean uppercase) {
            this((int)var1_1, (Character)var2_2, (boolean)var3_3, '\u0000');
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public IPAddressStringParams(int radix, Character separator, boolean uppercase, char zoneSeparator) {
            super((int)var1_1, (Character)var2_2, (boolean)var3_3, zoneSeparator);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public String getAddressSuffix() {
            return this.addressSuffix;
        }

        /*
         * WARNING - void declaration
         */
        public void setAddressSuffix(String suffix) {
            void var1_1;
            this.addressSuffix = var1_1;
        }

        @Override
        public boolean preferWildcards() {
            return this.wildcardOption == IPAddressSection.WildcardOptions.WildcardOption.ALL;
        }

        /*
         * WARNING - void declaration
         */
        public void setWildcardOption(IPAddressSection.WildcardOptions.WildcardOption option) {
            void var1_1;
            this.wildcardOption = var1_1;
        }

        public char getTrailingSegmentSeparator() {
            return this.separator.charValue();
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder appendSuffix(StringBuilder builder) {
            void var1_1;
            String suffix = this.getAddressSuffix();
            if (suffix != null) {
                void var2_2;
                builder.append((String)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public int getAddressSuffixLength() {
            String suffix = this.getAddressSuffix();
            if (suffix != null) {
                void var1_1;
                return var1_1.length();
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getLeadingZeros(int segmentIndex) {
            if (this.expandSegments) {
                return -1;
            }
            if (this.expandSegment != null && this.expandSegment.length > segmentIndex) {
                void var1_1;
                return this.expandSegment[var1_1];
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPAddressStringParams<T> clone() {
            void var1_1;
            IPAddressStringParams parms = (IPAddressStringParams)super.clone();
            if (this.expandSegment != null) {
                parms.expandSegment = (int[])this.expandSegment.clone();
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static int getPrefixIndicatorStringLength(IPAddressStringDivisionSeries addr) {
            if (addr.isPrefixed()) {
                void var0_1;
                int value = addr.getPrefixLength();
                if (value < 10) {
                    return 2;
                }
                if (var0_1 < 100) {
                    return 3;
                }
                return 4;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getStringLength(T addr) {
            void var2_2;
            int count = this.getSegmentsStringLength(addr);
            if (!this.isReverse() && !((AddressStringParams)this).preferWildcards()) {
                void var1_1;
                count += IPAddressStringParams.getPrefixIndicatorStringLength((IPAddressStringDivisionSeries)var1_1);
            }
            return (int)(var2_2 + this.getAddressSuffixLength() + this.getAddressLabelLength());
        }

        /*
         * WARNING - void declaration
         */
        public void appendPrefixIndicator(StringBuilder builder, IPAddressStringDivisionSeries addr) {
            if (addr.isPrefixed()) {
                void var2_2;
                void var1_1;
                var1_1.append('/').append(var2_2.getPrefixLength());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuilder append(StringBuilder builder, T addr, CharSequence zone) {
            void var1_1;
            void var3_3;
            IPAddressStringParams iPAddressStringParams = this;
            IPAddressStringParams iPAddressStringParams2 = this;
            iPAddressStringParams.appendSuffix(iPAddressStringParams.appendZone(iPAddressStringParams2.appendSegments(iPAddressStringParams2.appendLabel(builder), addr), (CharSequence)var3_3));
            if (!this.isReverse() && !((AddressStringParams)this).preferWildcards()) {
                void var2_2;
                this.appendPrefixIndicator(builder, (IPAddressStringDivisionSeries)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int appendSegment(int segmentIndex, StringBuilder builder, T part) {
            void var2_2;
            void var1_1;
            void var3_3;
            Integer prefix;
            IPAddressStringDivision seg = part.getDivision(segmentIndex);
            AddressNetwork.PrefixConfiguration config = part.getNetwork().getPrefixConfiguration();
            if (config.prefixedSubnetsAreExplicit() || ((AddressStringParams)this).preferWildcards() || (prefix = seg.getDivisionPrefixLength()) == null || prefix >= seg.getBitCount() || config.zeroHostsAreSubnets() && !var3_3.isPrefixBlock() || this.isSplitDigits()) {
                return seg.getStandardString(segmentIndex, this, builder);
            }
            if (seg.isSinglePrefixBlock()) {
                return seg.getLowerStandardString(segmentIndex, this, builder);
            }
            return seg.getPrefixAdjustedRangeString((int)var1_1, this, (StringBuilder)var2_2);
        }
    }

    protected static class AddressStringParams<T extends AddressStringDivisionSeries>
    implements AddressDivisionWriter,
    AddressSegmentParams,
    Cloneable {
        public static final AddressDivisionGrouping.StringOptions.Wildcards DEFAULT_WILDCARDS = new AddressDivisionGrouping.StringOptions.Wildcards();
        private AddressDivisionGrouping.StringOptions.Wildcards wildcards = DEFAULT_WILDCARDS;
        protected boolean expandSegments;
        private String segmentStrPrefix = "";
        private int radix;
        protected Character separator;
        private boolean uppercase;
        private boolean reverse;
        private boolean splitDigits;
        private String addressLabel = "";
        private char zoneSeparator;

        /*
         * WARNING - void declaration
         */
        public AddressStringParams(int radix, Character separator, boolean uppercase) {
            this((int)var1_1, (Character)var2_2, (boolean)var3_3, '\u0000');
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public AddressStringParams(int radix, Character separator, boolean uppercase, char zoneSeparator) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (radix < 2 || radix > 85) {
                throw new IllegalArgumentException();
            }
            this.radix = var1_1;
            this.separator = var2_2;
            this.uppercase = var3_3;
            this.zoneSeparator = zoneSeparator;
        }

        /*
         * WARNING - void declaration
         */
        public void setZoneSeparator(char zoneSeparator) {
            void var1_1;
            this.zoneSeparator = var1_1;
        }

        public String getAddressLabel() {
            return this.addressLabel;
        }

        /*
         * WARNING - void declaration
         */
        public void setAddressLabel(String str) {
            void var1_1;
            this.addressLabel = var1_1;
        }

        public Character getSeparator() {
            return this.separator;
        }

        /*
         * WARNING - void declaration
         */
        public void setSeparator(Character separator) {
            void var1_1;
            this.separator = var1_1;
        }

        @Override
        public AddressDivisionGrouping.StringOptions.Wildcards getWildcards() {
            return this.wildcards;
        }

        /*
         * WARNING - void declaration
         */
        public void setWildcards(AddressDivisionGrouping.StringOptions.Wildcards wc) {
            void var1_1;
            this.wildcards = var1_1;
        }

        public boolean preferWildcards() {
            return true;
        }

        @Override
        public int getLeadingZeros(int segmentIndex) {
            if (this.expandSegments) {
                return -1;
            }
            return 0;
        }

        @Override
        public String getSegmentStrPrefix() {
            return this.segmentStrPrefix;
        }

        /*
         * WARNING - void declaration
         */
        public void setSegmentStrPrefix(String segmentStrPrefix) {
            void var1_1;
            if (segmentStrPrefix == null) {
                throw new NullPointerException();
            }
            this.segmentStrPrefix = var1_1;
        }

        @Override
        public int getRadix() {
            return this.radix;
        }

        /*
         * WARNING - void declaration
         */
        public void setRadix(int radix) {
            void var1_1;
            this.radix = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setUppercase(boolean uppercase) {
            void var1_1;
            this.uppercase = var1_1;
        }

        @Override
        public boolean isUppercase() {
            return this.uppercase;
        }

        /*
         * WARNING - void declaration
         */
        public void setSplitDigits(boolean split) {
            void var1_1;
            this.splitDigits = var1_1;
        }

        @Override
        public boolean isSplitDigits() {
            return this.splitDigits;
        }

        @Override
        public Character getSplitDigitSeparator() {
            return this.separator;
        }

        @Override
        public boolean isReverseSplitDigits() {
            return this.reverse;
        }

        /*
         * WARNING - void declaration
         */
        public void setReverse(boolean rev) {
            void var1_1;
            this.reverse = var1_1;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        /*
         * WARNING - void declaration
         */
        public void expandSegments(boolean expand) {
            void var1_1;
            this.expandSegments = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder appendLabel(StringBuilder builder) {
            void var1_1;
            String str = this.getAddressLabel();
            if (str != null && str.length() > 0) {
                void var2_2;
                builder.append((String)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public int getAddressLabelLength() {
            String str = this.getAddressLabel();
            if (str != null) {
                void var1_1;
                return var1_1.length();
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        public int getSegmentsStringLength(T part) {
            void var2_2;
            int count = 0;
            if (part.getDivisionCount() != 0) {
                int divCount = part.getDivisionCount();
                for (int i = 0; i < divCount; ++i) {
                    count += this.appendSegment(i, null, part);
                }
                Character c = this.getSeparator();
                if (c != null) {
                    void var3_3;
                    count += var3_3 - true;
                }
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder appendSegments(StringBuilder builder, T part) {
            void var1_1;
            int count = part.getDivisionCount();
            if (count != 0) {
                boolean reverse = this.isReverse();
                int i = 0;
                Character separator = this.getSeparator();
                while (true) {
                    int segIndex = reverse ? count - i - 1 : i;
                    this.appendSegment(segIndex, builder, part);
                    if (++i == count) break;
                    if (separator == null) continue;
                    builder.append(separator);
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public int appendSingleDivision(AddressStringDivision seg, StringBuilder builder) {
            void var2_2;
            void var1_1;
            if (builder == null) {
                return this.getAddressLabelLength() + seg.getStandardString(0, this, null);
            }
            this.appendLabel(builder);
            var1_1.getStandardString(0, this, (StringBuilder)var2_2);
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        protected int appendSegment(int segmentIndex, StringBuilder builder, T part) {
            void var2_2;
            void var1_1;
            AddressStringDivision addressStringDivision = part.getDivision(segmentIndex);
            return addressStringDivision.getStandardString((int)var1_1, this, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public int getZoneLength(CharSequence zone) {
            if (zone != null && zone.length() > 0) {
                void var1_1;
                return var1_1.length() + 1;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        public int getStringLength(T addr, CharSequence zone) {
            void var1_2;
            int result = this.getStringLength(addr);
            if (zone != null) {
                void var2_3;
                result += this.getZoneLength((CharSequence)var2_3);
            }
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        public int getStringLength(T addr) {
            void var1_1;
            return this.getAddressLabelLength() + this.getSegmentsStringLength(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder appendZone(StringBuilder builder, CharSequence zone) {
            void var1_1;
            if (zone != null && zone.length() > 0) {
                void var2_2;
                builder.append(this.zoneSeparator).append((CharSequence)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder append(StringBuilder builder, T addr, CharSequence zone) {
            void var3_3;
            void var2_2;
            void var1_1;
            AddressStringParams addressStringParams = this;
            return addressStringParams.appendZone(addressStringParams.appendSegments(this.appendLabel((StringBuilder)var1_1), var2_2), (CharSequence)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getDivisionStringLength(AddressStringDivision seg) {
            void var1_1;
            return this.appendSingleDivision((AddressStringDivision)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuilder appendDivision(StringBuilder builder, AddressStringDivision seg) {
            void var1_1;
            void var2_2;
            this.appendSingleDivision((AddressStringDivision)var2_2, builder);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public String toString(T addr, CharSequence zone) {
            void var3_3;
            void var2_2;
            void var1_1;
            int length = this.getStringLength(addr, zone);
            StringBuilder builder = new StringBuilder(length);
            this.append(builder, var1_1, (CharSequence)var2_2);
            AddressStringParams.checkLengths((int)var3_3, builder);
            return builder.toString();
        }

        /*
         * WARNING - void declaration
         */
        public String toString(T addr) {
            void var1_1;
            return this.toString(var1_1, null);
        }

        public static void checkLengths(int length, StringBuilder builder) {
        }

        /*
         * WARNING - void declaration
         */
        public static AddressStringParams<AddressStringDivisionSeries> toParams(AddressDivisionGrouping.StringOptions opts) {
            void var1_1;
            AddressStringParams result = (AddressStringParams)AddressDivisionGroupingBase.getCachedParams(opts);
            if (result == null) {
                AddressDivisionGrouping.StringOptions stringOptions;
                result = new AddressStringParams(opts.base, opts.separator, opts.uppercase);
                result.expandSegments(opts.expandSegments);
                result.setWildcards(opts.wildcards);
                result.setSegmentStrPrefix(opts.segmentStrPrefix);
                result.setAddressLabel(opts.addrLabel);
                result.setReverse(opts.reverse);
                result.setSplitDigits(opts.splitDigits);
                AddressDivisionGroupingBase.setCachedParams(stringOptions, result);
            }
            return var1_1;
        }

        public AddressStringParams<T> clone() {
            try {
                AddressStringParams addressStringParams = (AddressStringParams)super.clone();
                return addressStringParams;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    protected static interface SplitterSink<S, T> {
        public void setSplitValues(S var1, S var2);

        public S getAddressItem();
    }

    protected static class AddressItemRangeSpliterator<S extends AddressComponentRange, T>
    extends AddressItemSpliteratorBase<S, T>
    implements SplitterSink<S, T> {
        private S forIteration;
        private Iterator<T> iterator;
        private S split1;
        private S split2;
        protected final IteratorProvider<S, T> iteratorProvider;
        private boolean isLowest;
        private final boolean isHighest;
        private Function<S, BigInteger> sizer;
        private Predicate<S> downSizer;
        private final ToLongFunction<S> longSizer;
        private long longSize;
        private BigInteger bigSize;
        final Predicate<SplitterSink<S, T>> splitter;

        /*
         * WARNING - void declaration
         */
        protected AddressItemRangeSpliterator(S forIteration, Predicate<SplitterSink<S, T>> splitter, IteratorProvider<S, T> iteratorProvider, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
            this(var1_1, (Predicate<SplitterSink<void, T>>)var2_2, (IteratorProvider<void, T>)var3_3, true, true, (Function<void, BigInteger>)sizer, (Predicate<void>)downSizer, (ToLongFunction<void>)longSizer);
            void var3_3;
            void var2_2;
            void var1_1;
            this.updateSizers();
        }

        /*
         * WARNING - void declaration
         */
        protected AddressItemRangeSpliterator(S forIteration, Predicate<SplitterSink<S, T>> splitter, IteratorProvider<S, T> iteratorProvider, boolean isLowest, boolean isHighest, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.forIteration = var1_1;
            this.iteratorProvider = var3_3;
            this.isLowest = isLowest;
            this.isHighest = isHighest;
            this.longSizer = longSizer;
            this.sizer = sizer;
            this.downSizer = downSizer;
            this.splitter = var2_2;
            this.updateSizers();
        }

        void updateSizers() {
            if (this.sizer != null) {
                boolean bl = this.isBig = this.downSizer == null || !this.downSizer.test(this.forIteration);
                if (!this.isBig) {
                    this.sizer = null;
                    this.downSizer = null;
                }
            } else {
                this.isBig = false;
            }
            this.longSize = -1L;
            this.bigSize = null;
        }

        /*
         * WARNING - void declaration
         */
        private long originalLongSize() {
            void var1_1;
            long size = this.longSize;
            if (size < 0L) {
                this.longSize = size = this.longSizer.applyAsLong(this.forIteration);
            }
            return (long)var1_1;
        }

        private long currentLongSize() {
            return this.originalLongSize() - this.iteratedCountL;
        }

        @Override
        public long estimateSize() {
            if (this.isBig) {
                if (this.currentBigSize().compareTo(LONG_MAX) <= 0) {
                    return this.currentBigSize().longValue();
                }
                return Long.MAX_VALUE;
            }
            return this.currentLongSize();
        }

        /*
         * WARNING - void declaration
         */
        private BigInteger originalBigSize() {
            void var1_1;
            BigInteger size = this.bigSize;
            if (this.bigSize == null) {
                this.bigSize = size = this.sizer.apply(this.forIteration);
            }
            return var1_1;
        }

        private BigInteger currentBigSize() {
            return this.originalBigSize().subtract(this.iteratedCountB);
        }

        @Override
        public S getAddressItem() {
            return this.forIteration;
        }

        @Override
        public int characteristics() {
            if (this.isBig) {
                return 4373;
            }
            return super.characteristics();
        }

        private Iterator<T> provideIterator() {
            if (this.iterator == null) {
                this.iterator = this.iteratorProvider.apply(this.isLowest, this.isHighest, this.forIteration);
            }
            return this.iterator;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.inForEach) {
                return false;
            }
            if (this.isBig ? this.iteratedCountB.signum() <= 0 || this.iteratedCountB.compareTo(this.originalBigSize()) < 0 : this.iteratedCountL < this.originalLongSize()) {
                void var1_1;
                AddressItemRangeSpliterator addressItemRangeSpliterator = this;
                return addressItemRangeSpliterator.tryAdvance(addressItemRangeSpliterator.provideIterator(), var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (this.inForEach) {
                return;
            }
            this.inForEach = true;
            try {
                if (this.isBig) {
                    AddressItemRangeSpliterator addressItemRangeSpliterator = this;
                    addressItemRangeSpliterator.forEachRemaining(addressItemRangeSpliterator.provideIterator(), action, this.originalBigSize());
                } else {
                    void var1_1;
                    AddressItemRangeSpliterator addressItemRangeSpliterator = this;
                    addressItemRangeSpliterator.forEachRemaining(addressItemRangeSpliterator.provideIterator(), var1_1, this.originalLongSize());
                }
                return;
            }
            finally {
                this.inForEach = false;
            }
        }

        protected boolean canSplit() {
            if (this.inForEach) {
                return false;
            }
            if (this.isBig) {
                return this.iteratedCountB.compareTo(this.originalBigSize().shiftRight(1)) < 0;
            }
            return this.iteratedCountL < this.originalLongSize() >> 1;
        }

        protected boolean split() {
            return this.splitter.test(this);
        }

        /*
         * WARNING - void declaration
         */
        protected AddressItemRangeSpliterator<S, T> createSpliterator(S split, boolean isLowest, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new AddressItemRangeSpliterator<void, T>(var1_1, this.splitter, this.iteratorProvider, (boolean)var2_2, false, (Function<void, BigInteger>)var3_3, (Predicate<void>)downSizer, (ToLongFunction<void>)longSizer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AddressItemRangeSpliterator<S, T> trySplit() {
            void var1_1;
            if (!this.canSplit() || !this.split()) {
                return null;
            }
            boolean hasIterated = this.isBig ? this.iteratedCountB.signum() > 0 : this.iteratedCountL > 0L;
            BigInteger splitSizeBig = null;
            long splitSize = -1L;
            if (hasIterated && (this.isBig ? this.iteratedCountB.compareTo(splitSizeBig = this.sizer.apply(this.split1)) >= 0 : this.iteratedCountL >= (splitSize = this.longSizer.applyAsLong(this.split1)))) {
                return null;
            }
            AddressItemRangeSpliterator addressItemRangeSpliterator = this;
            AddressItemRangeSpliterator<S, T> splitOff = addressItemRangeSpliterator.createSpliterator(addressItemRangeSpliterator.split1, this.isLowest, this.sizer, this.downSizer, this.longSizer);
            if (var1_1 != false) {
                void var3_3;
                void var2_2;
                if (this.isBig) {
                    if (splitOff.isBig) {
                        splitOff.iteratedCountB = this.iteratedCountB;
                    } else {
                        splitOff.iteratedCountL = this.iteratedCountB.longValue();
                    }
                    this.iteratedCountB = BigInteger.ZERO;
                } else {
                    splitOff.iteratedCountL = this.iteratedCountL;
                    this.iteratedCountL = 0L;
                }
                splitOff.iterator = this.iterator;
                this.iterator = null;
                splitOff.bigSize = var2_2;
                splitOff.longSize = var3_3;
            }
            this.forIteration = this.split2;
            this.isLowest = false;
            this.updateSizers();
            return splitOff;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setSplitValues(S left, S right) {
            void var2_2;
            void var1_1;
            this.split1 = var1_1;
            this.split2 = var2_2;
        }
    }

    @FunctionalInterface
    protected static interface IteratorProvider<S, T> {
        public Iterator<T> apply(boolean var1, boolean var2, S var3);
    }

    protected static class ValueCache {
        public byte[] lowerBytes;
        public byte[] upperBytes;
        public BigInteger value;
        public BigInteger upperValue;

        protected ValueCache() {
        }
    }
}

