/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.AddressGenericDivision;
import inet.ipaddr.format.AddressSegmentSpliterator;
import inet.ipaddr.format.large.IPAddressLargeDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.string.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.format.util.AddressSegmentParams;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.function.Supplier;

public abstract class AddressDivisionBase
implements AddressGenericDivision {
    private static final IPAddressSection.IPStringOptions OCTAL_PARAMS;
    private static final IPAddressSection.IPStringOptions HEX_PARAMS;
    private static final IPAddressSection.IPStringOptions DECIMAL_PARAMS;
    private static final String[] zeros;
    protected static final char[] DIGITS;
    public static final char[] EXTENDED_DIGITS;
    protected static final BigInteger BIG_MIN_RADIX;
    protected static final BigInteger BIG_MAX_RADIX;
    protected static final char[] UPPERCASE_DIGITS;
    protected static final char[] DOUBLE_DIGITS_DEC;
    private static TreeMap<Long, Integer> maxDigitMap;
    private static TreeMap<Long, BigInteger> radixPowerMap;
    protected transient String cachedWildcardString;
    private transient byte[] lowerBytes;
    private transient byte[] upperBytes;
    protected transient int hashCode;

    protected AddressDivisionBase() {
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSameValues(AddressDivisionBase other) {
        void var1_1;
        return this.getValue().equals(other.getValue()) && this.getUpperValue().equals(var1_1.getUpperValue());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivisionBase) {
            void var1_1;
            AddressDivisionBase other = (AddressDivisionBase)o;
            return this.getBitCount() == other.getBitCount() && var1_1.isSameValues(this);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static int createHashCode(long value, long upperValue) {
        void var2_1;
        long l;
        return AddressDivisionBase.adjustHashCode(1, l, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static int adjustHashCode(int currentHash, long value, long upperValue) {
        int n;
        void var1_1;
        long shifted = value >>> 32;
        int adjusted222 = (int)(shifted == 0L ? value : value ^ shifted);
        currentHash = currentHash * 31 + adjusted222;
        if (upperValue != var1_1) {
            void var3_2;
            long adjusted222 = upperValue >>> 32;
            int adjusted222 = (int)(adjusted222 == 0L ? upperValue : var3_2 ^ adjusted222);
            currentHash = currentHash * 31 + adjusted222;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int res = this.hashCode;
        if (res == 0) {
            res = 1;
            BigInteger lower = this.getValue();
            BigInteger upper = this.getUpperValue();
            do {
                long low = lower.longValue();
                long up = upper.longValue();
                lower = lower.shiftRight(64);
                upper = upper.shiftRight(64);
                res = AddressDivisionBase.adjustHashCode(res, low, up);
            } while (upper.signum() != 0);
            this.hashCode = res;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(byte[] bytes, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] cached = this.lowerBytes;
        if (this.lowerBytes == null) {
            this.lowerBytes = cached = this.getBytesImpl(true);
        }
        return this.getBytes((byte[])var1_1, (int)var2_2, (byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(byte[] bytes) {
        void var1_1;
        return this.getBytes((byte[])var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(byte[] provided, int startIndex, byte[] cached) {
        void var1_1;
        void var4_4;
        void var2_2;
        void var3_3;
        int byteCount = this.getBitCount() + 7 >> 3;
        if (provided == null || provided.length < byteCount + startIndex) {
            if (startIndex > 0) {
                byte[] bytes2 = new byte[byteCount + startIndex];
                if (provided != null) {
                    System.arraycopy(provided, 0, bytes2, 0, Math.min(startIndex, provided.length));
                }
                System.arraycopy(cached, 0, bytes2, startIndex, cached.length);
                return bytes2;
            }
            return (byte[])cached.clone();
        }
        System.arraycopy(var3_3, 0, provided, (int)var2_2, (int)var4_4);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getUpperBytes(byte[] bytes, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.isMultiple()) {
            return this.getBytes(bytes, index);
        }
        byte[] cached = this.upperBytes;
        if (this.upperBytes == null) {
            this.upperBytes = cached = this.getBytesImpl(false);
        }
        return this.getBytes((byte[])var1_1, (int)var2_2, (byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        void var1_1;
        return this.getUpperBytes((byte[])var1_1, 0);
    }

    protected abstract byte[] getBytesImpl(boolean var1);

    protected abstract int getDefaultTextualRadix();

    protected abstract int getMaxDigitCount();

    /*
     * WARNING - void declaration
     */
    protected static int getMaxDigitCount(int radix, int bitCount, BigInteger maxValue) {
        void var3_5;
        int result = AddressDivisionBase.getDigitCount(radix, bitCount);
        if (result > 0) {
            return result;
        }
        long key = (long)radix << 32 | (long)bitCount;
        Integer digs = maxDigitMap.get(key);
        if (digs == null) {
            void var0_1;
            void var2_3;
            if (maxValue == null) {
                void var1_2;
                maxValue = AddressDivisionBase.getMaxValue((int)var1_2);
            }
            digs = AddressDivisionBase.getDigitCount((BigInteger)var2_3, BigInteger.valueOf(radix));
            TreeMap newMaxDigitMap = (TreeMap)maxDigitMap.clone();
            newMaxDigitMap.put(key, digs);
            maxDigitMap = var0_1;
        }
        return var3_5.intValue();
    }

    /*
     * WARNING - void declaration
     */
    protected static BigInteger getMaxValue(int bitCount) {
        void var2_2;
        void var1_1;
        if (bitCount < 0) {
            throw new IllegalArgumentException();
        }
        int maxBytes = bitCount + 7 >>> 3;
        byte[] max = new byte[maxBytes];
        if (var1_1 > 0) {
            int topBits = bitCount % 8;
            if (topBits == 0) {
                topBits = 8;
            }
            max[0] = (byte)(~(-1 << topBits));
            for (int i = 1; i < max.length; ++i) {
                max[i] = -1;
            }
        }
        return new BigInteger(1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int getDigitCount(BigInteger val, BigInteger radix) {
        void var2_3;
        void var1_1;
        if (radix.compareTo(BIG_MIN_RADIX) < 0 || radix.compareTo(BIG_MAX_RADIX) > 0) {
            throw new IllegalArgumentException();
        }
        if (val.signum() == 0 || val.equals(BigInteger.ONE)) {
            return 1;
        }
        if (val.signum() > 0) {
            int smallRadix = radix.intValue();
            if (smallRadix == 16) {
                return AddressDivisionBase.getDigitCount(16, val.bitLength());
            }
            if (smallRadix == 8) {
                void var1_2;
                int result = 1;
                while ((val = val.shiftRight(3)).signum() != 0) {
                    ++result;
                }
                return (int)var1_2;
            }
            if (smallRadix == 4) {
                return AddressDivisionBase.getDigitCount(4, val.bitLength());
            }
            if (smallRadix == 2) {
                return val.bitLength();
            }
        }
        int result = 1;
        while ((val = val.divide((BigInteger)var1_1)).signum() != 0) {
            ++result;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected static int getMaxDigitCount(int radix, int bitCount, long maxValue) {
        int result = AddressDivisionBase.getDigitCount(radix, bitCount);
        if (result > 0) {
            return result;
        }
        if (radix == 10) {
            if (maxValue < 10L) {
                return 1;
            }
            if (maxValue < 100L) {
                return 2;
            }
            if (maxValue < 1000L) {
                return 3;
            }
            if (maxValue < 10000L) {
                return 4;
            }
            if (maxValue < 100000L) {
                return 5;
            }
            if (maxValue < 1000000L) {
                return 6;
            }
            if (maxValue < 10000000L) {
                return 7;
            }
            if (maxValue < 100000000L) {
                return 8;
            }
            if (maxValue < 1000000000L) {
                return 9;
            }
            if (maxValue < 10000000000L) {
                return 10;
            }
            if (maxValue < 100000000000L) {
                return 11;
            }
            if (maxValue < 1000000000000L) {
                return 12;
            }
            if (maxValue < 10000000000000L) {
                return 13;
            }
            if (maxValue < 100000000000000L) {
                return 14;
            }
            if (maxValue < 1000000000000000L) {
                return 15;
            }
            if (maxValue < 10000000000000000L) {
                return 16;
            }
            if (maxValue < 100000000000000000L) {
                return 17;
            }
            if (maxValue < 1000000000000000000L) {
                return 18;
            }
            return 19;
        }
        long key = (long)radix << 32 | (long)bitCount;
        Integer digs = maxDigitMap.get(key);
        if (digs == null) {
            void var0_1;
            result = 1;
            while ((maxValue /= (long)radix) != 0L) {
                ++result;
            }
            TreeMap newMaxDigitMap = (TreeMap)maxDigitMap.clone();
            newMaxDigitMap.put(key, result);
            maxDigitMap = var0_1;
        } else {
            void var1_3;
            result = var1_3.intValue();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static int getDigitCount(int radix, int bitCount) {
        if (bitCount <= 0) {
            if (bitCount == 0 && radix >= 2 && radix <= 85) {
                return 1;
            }
            throw new IllegalArgumentException();
        }
        switch (radix) {
            case 16: {
                return bitCount + 3 >> 2;
            }
            case 8: {
                return (bitCount + 2) / 3;
            }
            case 4: {
                return bitCount + 1 >> 1;
            }
            case 2: {
                void var1_1;
                return (int)var1_1;
            }
            case 10: {
                break;
            }
            default: {
                int n;
                if (radix >= 2 && n <= 85) break;
                throw new IllegalArgumentException();
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getDigitCount(long value, int radix) {
        void var3_2;
        int result = 1;
        if (radix == 16 && value >= 0L) {
            return AddressDivisionBase.getDigitCount(16, 64 - Long.numberOfLeadingZeros(value));
        }
        if (radix == 10 && value > -10L) {
            if (value < 10L) {
                return 1;
            }
            if (value < 100L) {
                return 2;
            }
            if (value < 1000L) {
                return 3;
            }
            value /= 1000L;
            result = 3;
        } else {
            if (radix == 8 && value >= 0L) {
                while ((value >>>= 3) != 0L) {
                    ++result;
                }
                return result;
            }
            if (radix == 4 && value >= 0L) {
                return AddressDivisionBase.getDigitCount(4, 64 - Long.numberOfLeadingZeros(value));
            }
            if (radix == 2 && value > 0L) {
                return 64 - Long.numberOfLeadingZeros(value);
            }
            if (radix < 2 || radix > 85) {
                throw new IllegalArgumentException();
            }
        }
        while ((value /= (long)radix) != 0L) {
            ++result;
        }
        return (int)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    protected static BigInteger getRadixPower(BigInteger radix, int power) {
        long key = (long)radix.intValue() << 32 | (long)power;
        BigInteger result = radixPowerMap.get(key);
        if (result == null) {
            void var1_4;
            void var2_5;
            if (radix.compareTo(BIG_MIN_RADIX) < 0 || radix.compareTo(BIG_MAX_RADIX) > 0) {
                throw new IllegalArgumentException();
            }
            if (power == 1) {
                result = radix;
            } else if ((power & 1) == 0) {
                BigInteger halfPower = AddressDivisionBase.getRadixPower(radix, power >> 1);
                result = halfPower.multiply(halfPower);
            } else {
                BigInteger bigInteger;
                void halfPower;
                BigInteger halfPower2 = AddressDivisionBase.getRadixPower(radix, (int)(halfPower - true >> 1));
                result = halfPower2.multiply(halfPower2).multiply(bigInteger);
            }
            TreeMap newRadixPowerMap = (TreeMap)radixPowerMap.clone();
            newRadixPowerMap.put((long)var2_5, result);
            radixPowerMap = var1_4;
        }
        return result;
    }

    protected abstract int adjustLowerLeadingZeroCount(int var1, int var2);

    protected abstract int adjustUpperLeadingZeroCount(int var1, int var2);

    private static void getSplitChar(int count, char splitDigitSeparator, String characters, String stringPrefix, StringBuilder builder) {
        while (count-- > 0) {
            if (stringPrefix.length() > 0) {
                builder.append(stringPrefix);
            }
            builder.append(characters);
            builder.append(splitDigitSeparator);
        }
        StringBuilder stringBuilder = builder;
        stringBuilder.setLength(stringBuilder.length() - 1);
    }

    private static void getSplitChar(int count, char splitDigitSeparator, char character, String stringPrefix, StringBuilder builder) {
        int prefLen = stringPrefix.length();
        while (count-- > 0) {
            if (prefLen > 0) {
                builder.append(stringPrefix);
            }
            builder.append(character);
            builder.append(splitDigitSeparator);
        }
        StringBuilder stringBuilder = builder;
        stringBuilder.setLength(stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private static void getSplitLeadingZeros(int leadingZeroCount, char splitDigitSeparator, String stringPrefix, StringBuilder builder) {
        void var3_3;
        void var2_2;
        void var1_1;
        AddressDivisionBase.getSplitChar(leadingZeroCount, (char)var1_1, '0', (String)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected static void getLeadingZeros(int leadingZeroCount, StringBuilder builder) {
        if (leadingZeroCount > 0) {
            int n;
            void var2_2;
            void var1_1;
            String[] stringArray = zeros;
            if (leadingZeroCount >= stringArray.length) {
                int increment = stringArray.length - 1;
                String incrementStr = stringArray[increment];
                while (leadingZeroCount >= increment) {
                    builder.append(incrementStr);
                    leadingZeroCount -= increment;
                }
                builder.append(stringArray[leadingZeroCount]);
                return;
            }
            var1_1.append((String)var2_2[n]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_3;
        void var1_2;
        int radix = this.getDefaultTextualRadix();
        switch (radix) {
            case 8: {
                IPAddressSection.IPStringOptions opts2 = OCTAL_PARAMS;
                break;
            }
            case 16: {
                IPAddressSection.IPStringOptions opts2 = HEX_PARAMS;
                break;
            }
            case 10: {
                IPAddressSection.IPStringOptions opts2 = DECIMAL_PARAMS;
                break;
            }
            default: {
                void opts;
                IPAddressSection.IPStringOptions opts2 = new IPAddressSection.IPStringOptions.Builder((int)opts).setWildcards(new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR)).toOptions();
            }
        }
        StringBuilder builder = new StringBuilder(34);
        AddressDivisionBase.toParams((IPAddressSection.IPStringOptions)var1_2).appendSingleDivision(this, builder);
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static AddressDivisionGroupingBase.AddressStringParams<IPAddressStringDivisionSeries> toParams(IPAddressSection.IPStringOptions opts) {
        void var1_1;
        AddressDivisionGroupingBase.IPAddressStringParams result = (AddressDivisionGroupingBase.IPAddressStringParams)AddressDivisionGroupingBase.getCachedParams(opts);
        if (result == null) {
            IPAddressSection.IPStringOptions iPStringOptions;
            result = new AddressDivisionGroupingBase.IPAddressStringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcards(opts.wildcards);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressLabel(opts.addrLabel);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            result.setRadix(opts.base);
            result.setUppercase(opts.uppercase);
            result.setSeparator(opts.separator);
            result.setZoneSeparator(opts.zoneSeparator);
            AddressDivisionGroupingBase.setCachedParams(iPStringOptions, result);
        }
        return var1_1;
    }

    protected abstract String getDefaultLowerString();

    protected abstract String getDefaultRangeString();

    protected String getDefaultSegmentWildcardString() {
        return null;
    }

    protected abstract String getDefaultRangeSeparatorString();

    /*
     * WARNING - void declaration
     */
    protected String getString() {
        void var1_1;
        String result = this.cachedWildcardString;
        if (result == null) {
            AddressDivisionBase addressDivisionBase = this;
            synchronized (addressDivisionBase) {
                result = this.cachedWildcardString;
                if (result == null) {
                    if (!this.isMultiple()) {
                        result = this.getDefaultLowerString();
                    } else if (!this.isFullRange() || (result = this.getDefaultSegmentWildcardString()) == null) {
                        result = this.getDefaultRangeString();
                    }
                    this.cachedWildcardString = result;
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String getCachedDefaultLowerString() {
        void var1_1;
        String result = this.cachedWildcardString;
        if (result == null) {
            AddressDivisionBase addressDivisionBase = this;
            synchronized (addressDivisionBase) {
                result = this.cachedWildcardString;
                if (result == null) {
                    this.cachedWildcardString = result = this.getDefaultLowerString();
                }
            }
        }
        return var1_1;
    }

    protected String getWildcardString() {
        return this.getString();
    }

    /*
     * WARNING - void declaration
     */
    protected void setDefaultAsFullRangeWildcardString() {
        String result;
        if (this.cachedWildcardString == null && (result = this.getDefaultSegmentWildcardString()) != null) {
            AddressDivisionBase addressDivisionBase = this;
            synchronized (addressDivisionBase) {
                void var1_1;
                this.cachedWildcardString = var1_1;
                return;
            }
        }
    }

    protected abstract int getLowerStringLength(int var1);

    protected abstract int getUpperStringLength(int var1);

    protected abstract void getLowerString(int var1, boolean var2, StringBuilder var3);

    protected abstract void getLowerString(int var1, int var2, boolean var3, StringBuilder var4);

    protected abstract void getUpperString(int var1, boolean var2, StringBuilder var3);

    protected abstract void getUpperStringMasked(int var1, boolean var2, StringBuilder var3);

    protected abstract void getSplitLowerString(int var1, int var2, boolean var3, char var4, boolean var5, String var6, StringBuilder var7);

    protected abstract void getSplitRangeString(String var1, String var2, int var3, boolean var4, char var5, boolean var6, String var7, StringBuilder var8);

    protected abstract int getSplitRangeStringLength(String var1, String var2, int var3, int var4, boolean var5, char var6, boolean var7, String var8);

    protected abstract int getRangeDigitCount(int var1);

    /*
     * WARNING - void declaration
     */
    protected static int toUnsignedStringLength(long value, int radix) {
        void var3_2;
        int result;
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        if (value > 65535L || (result = AddressDivisionBase.toUnsignedStringLengthFast((int)value, radix)) < 0) {
            void var2_1;
            long l;
            result = AddressDivisionBase.toUnsignedStringLengthSlow(l, (int)var2_1);
        }
        return (int)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int toUnsignedStringLengthSlow(long value, int radix) {
        void var3_2;
        int intValue;
        int count = 1;
        boolean useInts = value <= Integer.MAX_VALUE;
        int n = intValue = useInts ? (int)value : radix;
        while (intValue >= radix) {
            if (useInts) {
                intValue /= radix;
            } else if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                useInts = true;
                intValue = (int)value;
            }
            ++count;
        }
        return (int)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int toUnsignedStringLengthFast(int value, int radix) {
        if (value <= 1) {
            return 1;
        }
        if (radix == 10) {
            if (value < 10) {
                return 1;
            }
            if (value < 100) {
                return 2;
            }
            if (value < 1000) {
                return 3;
            }
            if (value < 10000) {
                return 4;
            }
            return 5;
        }
        if (radix == 16) {
            if (value < 16) {
                return 1;
            }
            if (value < 256) {
                return 2;
            }
            if (value < 4096) {
                return 3;
            }
            return 4;
        }
        if (radix == 8) {
            if (value < 8) {
                return 1;
            }
            if (value < 64) {
                return 2;
            }
            if (value < 512) {
                return 3;
            }
            if (value < 4096) {
                return 4;
            }
            if (value < 32768) {
                return 5;
            }
            return 6;
        }
        if (radix == 2) {
            void var1_1;
            int n;
            int digitCount = 15;
            int val = value;
            if (val >>> 8 == 0) {
                digitCount -= 8;
            } else {
                val >>>= 8;
            }
            if (val >>> 4 == 0) {
                digitCount -= 4;
            } else {
                val >>>= 4;
            }
            if (val >>> 2 == 0) {
                digitCount -= 2;
            } else {
                val >>>= 2;
            }
            if ((n & 2) != 0) {
                ++digitCount;
            }
            return (int)var1_1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected static StringBuilder toUnsignedStringCased(long value, int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        if (value > 65535L || !AddressDivisionBase.toUnsignedStringFastChopped((int)value, radix, choppedDigits, uppercase, appendable)) {
            void var3_2;
            void var2_1;
            long l;
            AddressDivisionBase.toUnsignedStringSlow(l, (int)var2_1, (int)var3_2, uppercase, appendable);
        }
        return appendable;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean toUnsignedStringFastChopped(int value, int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var1_1;
        if (AddressDivisionBase.toUnsignedStringFast(value, (int)var1_1, (boolean)var3_3, appendable)) {
            if (choppedDigits > 0) {
                void var2_2;
                StringBuilder stringBuilder = appendable;
                stringBuilder.setLength(stringBuilder.length() - var2_2);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static char[] getDigits(boolean uppercase, int radix) {
        void var1_1;
        if (uppercase || var1_1 > 36) {
            return UPPERCASE_DIGITS;
        }
        return DIGITS;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean toUnsignedStringFast(int value, int radix, boolean uppercase, StringBuilder appendable) {
        int remainder;
        void var1_1;
        int n;
        if (value <= 1) {
            appendable.append(value == 0 ? (char)'0' : '1');
            return true;
        }
        if (radix == 10) {
            int digIndex;
            if (value < 10) {
                char[] dig = AddressDivisionBase.getDigits(uppercase, radix);
                appendable.append(dig[value]);
                return true;
            }
            if (value < 100) {
                char[] dig = DOUBLE_DIGITS_DEC;
                int digIndex2 = value << 1;
                appendable.append(dig[digIndex2]);
                appendable.append(dig[digIndex2 + 1]);
                return true;
            }
            if (value < 200) {
                int index = appendable.length();
                appendable.append("127");
                if (value != 127) {
                    char[] dig = DOUBLE_DIGITS_DEC;
                    digIndex = value - 100 << 1;
                    appendable.setCharAt(++index, dig[digIndex]);
                    appendable.setCharAt(index + 1, dig[digIndex + 1]);
                }
                return true;
            }
            if (digIndex < 300) {
                int index = appendable.length();
                appendable.append("255");
                if (digIndex != 255) {
                    char[] dig = DOUBLE_DIGITS_DEC;
                    digIndex = digIndex - 200 << 1;
                    appendable.setCharAt(++index, dig[digIndex]);
                    appendable.setCharAt(index + 1, dig[n + 1]);
                }
                return true;
            }
            if (n < 1000) {
                appendable.append("   ");
            } else if (n < 10000) {
                appendable.append("    ");
            } else {
                appendable.append("     ");
            }
            char[] dig = DIGITS;
            int index = appendable.length();
            do {
                int quotient = n * 52429 >>> 19;
                remainder = n - ((quotient << 3) + (quotient << 1));
                appendable.setCharAt(--index, dig[remainder]);
            } while ((n = var1_1) != false);
            return true;
        }
        if (var1_1 == 16) {
            if (n < 16) {
                char[] dig = AddressDivisionBase.getDigits(remainder != 0, (int)var1_1);
                appendable.append(dig[n]);
                return true;
            }
            if (n < 256) {
                appendable.append("  ");
            } else if (n < 4096) {
                appendable.append("   ");
            } else {
                if (n == 65535) {
                    appendable.append(remainder != 0 ? "FFFF" : "ffff");
                    return true;
                }
                appendable.append("    ");
            }
            char[] dig = AddressDivisionBase.getDigits(remainder != 0, (int)var1_1);
            int index = appendable.length();
            do {
                remainder = n & 0xF;
                appendable.setCharAt(--index, dig[remainder]);
            } while ((n >>>= 4) != 0);
            return true;
        }
        if (var1_1 == 8) {
            char[] dig = DIGITS;
            if (n < 8) {
                appendable.append(dig[n]);
                return true;
            }
            if (n < 64) {
                appendable.append("  ");
            } else if (n < 512) {
                appendable.append("   ");
            } else if (n < 4096) {
                appendable.append("    ");
            } else if (n < 32768) {
                appendable.append("     ");
            } else {
                appendable.append("      ");
            }
            int index = appendable.length();
            do {
                void var2_2;
                remainder = n & 7;
                appendable.setCharAt(--index, dig[var2_2]);
            } while ((n >>>= 3) != 0);
            return true;
        }
        if (var1_1 == 2) {
            void var3_3;
            int digitIndex;
            if (n >>> 8 == 0) {
                if (n == 255) {
                    appendable.append("11111111");
                    return true;
                }
                digitIndex = n >>> 4 == 0 ? 4 : 8;
            } else {
                if (n == 65535) {
                    appendable.append("1111111111111111");
                    return true;
                }
                digitIndex = n >>> 4 == 0 ? 12 : 16;
            }
            while (--digitIndex > 0) {
                int index = n >>> digitIndex & 1;
                if (index != 1) continue;
                appendable.append('1');
                while (--digitIndex > 0) {
                    int digit = n >>> digitIndex & 1;
                    appendable.append(digit == 0 ? (char)'0' : '1');
                }
                break block3;
            }
            var3_3.append((n & 1) == 0 ? (char)'0' : '1');
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void toUnsignedStringSlow(long value, int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        void var3_3;
        void var2_2;
        int front = appendable.length();
        AddressDivisionBase.appendDigits(value, (int)var2_2, (int)var3_3, uppercase, appendable);
        int back = appendable.length() - 1;
        while (front < back) {
            void var1_7;
            char frontChar = appendable.charAt(front);
            appendable.setCharAt(front++, appendable.charAt(back));
            appendable.setCharAt(back--, (char)var1_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendDigits(long value, int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        void var3_2;
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        char[] dig = AddressDivisionBase.getDigits(uppercase, radix);
        while (value2 >= radix) {
            int index;
            if (useInts) {
                int val2 = value2;
                value2 /= radix;
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = val2 % radix;
            } else {
                long val = value;
                if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                    useInts = true;
                    value2 = (int)value;
                }
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = (int)(val % (long)radix);
            }
            appendable.append(dig[index]);
        }
        if (var3_2 == false) {
            appendable.append(dig[value2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendUppercase(CharSequence str, int radix, StringBuilder appendable) {
        void var1_1;
        void var3_3;
        if (radix > 10) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                appendable.append(c);
            }
            return;
        }
        var3_3.append((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int getFullRangeString(String wildcard, StringBuilder appendable) {
        String string;
        void var1_1;
        if (appendable == null) {
            return wildcard.length();
        }
        var1_1.append(string);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int getPrefixAdjustedRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var3_6;
        int n;
        void var1_1;
        void var2_3;
        void var4_7;
        int prefLen;
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        int radix = params.getRadix();
        int lowerLeadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
        int upperLeadingZeroCount = this.adjustUpperLeadingZeroCount(leadingZeroCount, radix);
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        String rangeSeparator = wildcards.rangeSeparator;
        int rangeDigitCount = wildcards.singleWildcard == null ? 0 : this.getRangeDigitCount(radix);
        if (rangeDigitCount == 0 && radix == this.getDefaultTextualRadix() && !this.isFullRange()) {
            void var2_5;
            String str = this.getString();
            String rangeSep = this.getDefaultRangeSeparatorString();
            String stringPrefix = params.getSegmentStrPrefix();
            prefLen = stringPrefix.length();
            if (lowerLeadingZeroCount == 0 && upperLeadingZeroCount == 0 && rangeSep.equals(rangeSeparator) && prefLen == 0) {
                if (appendable == null) {
                    return str.length();
                }
                if (params.isUppercase()) {
                    this.appendUppercase(str, radix, appendable);
                } else {
                    appendable.append(str);
                }
                return 0;
            }
            if (appendable == null) {
                int count = str.length() + (rangeSeparator.length() - rangeSep.length()) + lowerLeadingZeroCount + upperLeadingZeroCount;
                if (prefLen > 0) {
                    count += prefLen << 1;
                }
                return count;
            }
            int firstEnd = str.indexOf(rangeSep);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (lowerLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(lowerLeadingZeroCount, appendable);
            }
            appendable.append(str.substring(0, firstEnd));
            appendable.append(rangeSeparator);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (upperLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(upperLeadingZeroCount, appendable);
            }
            appendable.append(str.substring((int)(var2_5 + rangeSep.length())));
            return 0;
        }
        prefLen = this.adjustRangeDigits(prefLen);
        if (var4_7 < 0 && appendable == null) {
            int count;
            int charLength = this.getMaxDigitCount(radix);
            String string = var2_3.getSegmentStrPrefix();
            int prefLen2 = string.length();
            if (prefLen != 0) {
                count = charLength;
                if (prefLen2 > 0) {
                    count += prefLen2;
                }
                return count;
            }
            count = var1_1 << 1;
            if (prefLen2 > 0) {
                count += prefLen2 << 1;
            }
            n = count + rangeSeparator.length();
            return n;
        }
        if (n != 0) {
            return this.getRangeDigitString((int)var1_1, (AddressSegmentParams)var2_3, appendable);
        }
        return this.getRangeString((int)var1_1, (AddressSegmentParams)var2_3, lowerLeadingZeroCount, upperLeadingZeroCount, true, (StringBuilder)var3_6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getLowerStandardString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        int count = 0;
        String stringPrefix = params.getSegmentStrPrefix();
        int prefLen = stringPrefix.length();
        if (prefLen > 0) {
            if (appendable == null) {
                count = prefLen + 0;
            } else {
                appendable.append(stringPrefix);
            }
        }
        int radix = params.getRadix();
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        if (leadingZeroCount != 0) {
            if (appendable == null) {
                if (leadingZeroCount < 0) {
                    return count + this.getMaxDigitCount(radix);
                }
                count += leadingZeroCount;
            } else {
                leadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
                AddressDivisionBase.getLeadingZeros(leadingZeroCount, appendable);
            }
        }
        boolean uppercase = params.isUppercase();
        if (radix == this.getDefaultTextualRadix()) {
            String str = this.getCachedDefaultLowerString();
            if (appendable == null) {
                return count + str.length();
            }
            if (uppercase) {
                this.appendUppercase(str, radix, appendable);
            } else {
                void var2_2;
                appendable.append((String)var2_2);
            }
        } else {
            void var3_3;
            void var1_1;
            if (appendable == null) {
                return count + this.getLowerStringLength(radix);
            }
            this.getLowerString(radix, (boolean)var1_1, (StringBuilder)var3_3);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getStandardString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var3_4;
        void var1_1;
        String wildcard2;
        void var2_2;
        if (!this.isMultiple()) {
            int leadingZeroCount;
            boolean bl = params.isSplitDigits();
            if (bl) {
                int radix = params.getRadix();
                leadingZeroCount = params.getLeadingZeros(segmentIndex);
                leadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
                String stringPrefix = params.getSegmentStrPrefix();
                int prefLen = stringPrefix.length();
                if (appendable == null) {
                    int len = leadingZeroCount != 0 ? (leadingZeroCount < 0 ? this.getMaxDigitCount(radix) : this.getLowerStringLength(radix) + leadingZeroCount) : this.getLowerStringLength(radix);
                    int count = (len << 1) - 1;
                    if (prefLen > 0) {
                        count += len * prefLen;
                    }
                    return count;
                }
                char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
                boolean reverseSplitDigits = params.isReverseSplitDigits();
                boolean uppercase = params.isUppercase();
                if (reverseSplitDigits) {
                    this.getSplitLowerString(radix, 0, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
                    if (leadingZeroCount != 0) {
                        appendable.append(splitDigitSeparator);
                        AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
                    }
                } else {
                    void var2_3;
                    if (leadingZeroCount != 0) {
                        AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
                        appendable.append(splitDigitSeparator);
                    }
                    this.getSplitLowerString(radix, 0, (boolean)var2_3, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
                }
                return 0;
            }
            return this.getLowerStandardString(leadingZeroCount, (AddressSegmentParams)var2_2, appendable);
        }
        if (this.isFullRange() && (wildcard2 = var2_2.getWildcards().wildcard) != null) {
            boolean bl;
            if (wildcard2.equals(this.getDefaultSegmentWildcardString())) {
                this.setDefaultAsFullRangeWildcardString();
            }
            if (bl = var2_2.isSplitDigits()) {
                int radix = var2_2.getRadix();
                if (appendable == null) {
                    int stringPrefix = this.getMaxDigitCount(radix);
                    int wildcard2 = stringPrefix * (wildcard2.length() + 1) - 1;
                    return wildcard2;
                }
                char splitDigitSeparator = var2_2.getSplitDigitSeparator() == null ? (char)'\u0000' : var2_2.getSplitDigitSeparator().charValue();
                AddressDivisionBase.getSplitChar(this.getMaxDigitCount((int)var1_1), splitDigitSeparator, wildcard2, "", appendable);
                return 0;
            }
            return AddressDivisionBase.getFullRangeString(wildcard2, appendable);
        }
        return this.getRangeString((int)var1_1, (AddressSegmentParams)var2_2, (StringBuilder)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    protected int getRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var3_6;
        void var2_4;
        void var1_1;
        void var4_7;
        void var6_10;
        void rangeSep2;
        int prefLen;
        String stringPrefix;
        boolean splitDigits = params.isSplitDigits();
        int radix = params.getRadix();
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        String rangeSeparator = wildcards.rangeSeparator;
        int rangeDigitCount = wildcards.singleWildcard == null ? 0 : this.getRangeDigitCount(radix);
        int lowerLeadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
        int upperLeadingZeroCount = this.adjustUpperLeadingZeroCount(leadingZeroCount, radix);
        if (rangeDigitCount == 0 && radix == this.getDefaultTextualRadix() && !splitDigits && !this.isFullRange()) {
            void var1_2;
            String str = this.getWildcardString();
            String rangeSep2 = this.getDefaultRangeSeparatorString();
            stringPrefix = params.getSegmentStrPrefix();
            prefLen = stringPrefix.length();
            if (lowerLeadingZeroCount == 0 && upperLeadingZeroCount == 0 && prefLen == 0 && rangeSeparator.equals(rangeSep2)) {
                if (appendable == null) {
                    return str.length();
                }
                appendable.append(str);
                return 0;
            }
            if (appendable == null) {
                int count = str.length() + (rangeSeparator.length() - rangeSep2.length()) + lowerLeadingZeroCount + upperLeadingZeroCount;
                if (prefLen > 0) {
                    count += prefLen << 1;
                }
                return count;
            }
            int firstEnd = str.indexOf(rangeSep2);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (lowerLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(lowerLeadingZeroCount, appendable);
            }
            appendable.append(str.substring(0, firstEnd));
            appendable.append(rangeSeparator);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (upperLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(upperLeadingZeroCount, appendable);
            }
            appendable.append(var1_2.substring(firstEnd + rangeSep2.length()));
            return 0;
        }
        if (rangeSep2 == false && var6_10 < 0 && appendable == null) {
            void var2_5;
            int count;
            String string = stringPrefix.getSegmentStrPrefix();
            int prefLen2 = string.length();
            int charLength = this.getMaxDigitCount(prefLen);
            if (rangeDigitCount != 0) {
                count = charLength;
                if (prefLen2 > 0) {
                    count += prefLen2;
                }
                return count;
            }
            count = var2_5 << 1;
            if (prefLen2 > 0) {
                count += prefLen2 << 1;
            }
            int n = count + rangeSeparator.length();
            return n;
        }
        int n = this.adjustRangeDigits(rangeDigitCount);
        if (n != 0) {
            if (var4_7 != false) {
                return this.getSplitRangeDigitString((int)var1_1, (AddressSegmentParams)var2_4, appendable);
            }
            return this.getRangeDigitString((int)var1_1, (AddressSegmentParams)var2_4, appendable);
        }
        if (var4_7 != false) {
            return this.getSplitRangeString((int)var1_1, (AddressSegmentParams)var2_4, appendable);
        }
        return this.getRangeString((int)var1_1, (AddressSegmentParams)var2_4, lowerLeadingZeroCount, upperLeadingZeroCount, false, (StringBuilder)var3_6);
    }

    /*
     * WARNING - void declaration
     */
    protected int getSplitRangeDigitString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        int radix = params.getRadix();
        int leadingZerosCount = params.getLeadingZeros(segmentIndex);
        leadingZerosCount = this.adjustLowerLeadingZeroCount(leadingZerosCount, radix);
        String stringPrefix = params.getSegmentStrPrefix();
        if (appendable == null) {
            int len = this.getLowerStringLength(radix) + leadingZerosCount;
            int count = (len << 1) - 1;
            int prefLen = stringPrefix.length();
            if (prefLen > 0) {
                count += len * prefLen;
            }
            return count;
        }
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        AddressDivisionBase addressDivisionBase = this;
        int rangeDigits = addressDivisionBase.adjustRangeDigits(addressDivisionBase.getRangeDigitCount(radix));
        char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
        boolean reverseSplitDigits = params.isReverseSplitDigits();
        boolean uppercase = params.isUppercase();
        if (reverseSplitDigits) {
            AddressDivisionBase.getSplitChar(rangeDigits, splitDigitSeparator, wildcards.singleWildcard, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            this.getSplitLowerString(radix, rangeDigits, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
            if (leadingZerosCount > 0) {
                appendable.append(splitDigitSeparator);
                AddressDivisionBase.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
            }
        } else {
            void var3_4;
            void var2_3;
            if (leadingZerosCount != 0) {
                void var1_1;
                AddressDivisionBase.getSplitLeadingZeros((int)var1_1, splitDigitSeparator, stringPrefix, appendable);
                appendable.append(splitDigitSeparator);
            }
            this.getSplitLowerString(radix, rangeDigits, (boolean)var2_3, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            AddressDivisionBase.getSplitChar(rangeDigits, splitDigitSeparator, wildcards.singleWildcard, stringPrefix, (StringBuilder)var3_4);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int getRangeDigitString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var2_2;
        int radix = params.getRadix();
        int leadingZerosCount = params.getLeadingZeros(segmentIndex);
        leadingZerosCount = this.adjustLowerLeadingZeroCount(leadingZerosCount, radix);
        String stringPrefix = params.getSegmentStrPrefix();
        int prefLen = stringPrefix.length();
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        AddressDivisionBase addressDivisionBase = this;
        int rangeDigits = addressDivisionBase.adjustRangeDigits(addressDivisionBase.getRangeDigitCount(radix));
        if (appendable == null) {
            return this.getLowerStringLength(radix) + leadingZerosCount + prefLen;
        }
        if (prefLen > 0) {
            appendable.append(stringPrefix);
        }
        if (leadingZerosCount > 0) {
            AddressDivisionBase.getLeadingZeros(leadingZerosCount, appendable);
        }
        boolean uppercase = var2_2.isUppercase();
        this.getLowerString(radix, rangeDigits, uppercase, appendable);
        for (int i = 0; i < rangeDigits; ++i) {
            appendable.append(wildcards.singleWildcard);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    int adjustRangeDigits(int rangeDigits) {
        if (!(rangeDigits == 0 || this.includesZero() && rangeDigits != 1)) {
            void var1_1;
            return (int)var1_1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int getRangeString(int segmentIndex, AddressSegmentParams params, int lowerLeadingZerosCount, int upperLeadingZerosCount, boolean maskUpper, StringBuilder appendable) {
        void var2_4;
        void var1_2;
        void var3_5;
        String stringPrefix = params.getSegmentStrPrefix();
        int radix = params.getRadix();
        String rangeSeparator = params.getWildcards().rangeSeparator;
        boolean uppercase = params.isUppercase();
        return this.getRangeString(rangeSeparator, (int)var3_5, upperLeadingZerosCount, (String)var1_2, radix, (boolean)var2_4, maskUpper, appendable);
    }

    /*
     * WARNING - void declaration
     */
    protected int getRangeString(String rangeSeparator, int lowerLeadingZerosCount, int upperLeadingZerosCount, String stringPrefix, int radix, boolean uppercase, boolean maskUpper, StringBuilder appendable) {
        void var1_1;
        boolean hasStringPrefix;
        if (radix < 2 || radix > 85) {
            throw new IllegalArgumentException();
        }
        int prefLen = stringPrefix.length();
        boolean bl = hasStringPrefix = prefLen > 0;
        if (appendable == null) {
            void var1_2;
            int count = lowerLeadingZerosCount + upperLeadingZerosCount + this.getLowerStringLength(radix) + this.getUpperStringLength(radix) + rangeSeparator.length();
            if (hasStringPrefix) {
                count += prefLen << 1;
            }
            return (int)var1_2;
        }
        if (hasStringPrefix) {
            appendable.append(stringPrefix);
        }
        if (lowerLeadingZerosCount > 0) {
            void var2_3;
            AddressDivisionBase.getLeadingZeros((int)var2_3, appendable);
        }
        this.getLowerString(radix, uppercase, appendable);
        appendable.append((String)var1_1);
        if (hasStringPrefix) {
            appendable.append(stringPrefix);
        }
        if (upperLeadingZerosCount > 0) {
            void var3_4;
            AddressDivisionBase.getLeadingZeros((int)var3_4, appendable);
        }
        if (maskUpper) {
            this.getUpperStringMasked(radix, uppercase, appendable);
        } else {
            this.getUpperString(radix, uppercase, appendable);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int getSplitRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        void var2_3;
        String stringPrefix = params.getSegmentStrPrefix();
        int radix = params.getRadix();
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        leadingZeroCount = this.adjustUpperLeadingZeroCount(leadingZeroCount, radix);
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        boolean uppercase = params.isUppercase();
        char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
        boolean reverseSplitDigits = params.isReverseSplitDigits();
        String rangeSeparator = wildcards.rangeSeparator;
        if (appendable == null) {
            return this.getSplitRangeStringLength(rangeSeparator, wildcards.wildcard, leadingZeroCount, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix);
        }
        boolean hasLeadingZeros = leadingZeroCount != 0;
        if (hasLeadingZeros && !reverseSplitDigits) {
            AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            hasLeadingZeros = false;
        }
        this.getSplitRangeString(rangeSeparator, wildcards.wildcard, radix, uppercase, splitDigitSeparator, (boolean)var2_3, stringPrefix, appendable);
        if (hasLeadingZeros) {
            void var3_4;
            void var1_1;
            appendable.append(splitDigitSeparator);
            AddressDivisionBase.getSplitLeadingZeros((int)var1_1, splitDigitSeparator, stringPrefix, (StringBuilder)var3_4);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends AddressSegment> AddressComponentSpliterator<T> createSegmentSpliterator(T splitForIteration, int value, int upperValue, Supplier<Iterator<T>> iteratorProvider, IntBinaryIteratorProvider<T> subIteratorProvider, SegmentCreator<T> itemProvider) {
        void var3_3;
        void var2_2;
        void var1_1;
        T t;
        return new AddressSegmentSpliterator<T>(t, (int)var1_1, (int)var2_2, var3_3, subIteratorProvider, itemProvider);
    }

    /*
     * WARNING - void declaration
     */
    static boolean testRange(BigInteger lowerValue, BigInteger upperValue, BigInteger finalUpperValue, BigInteger networkMask, BigInteger hostMask) {
        void var1_1;
        void var2_2;
        void var3_3;
        BigInteger bigInteger = lowerValue;
        return bigInteger.equals(bigInteger.and((BigInteger)var3_3)) && var2_2.equals(var1_1.or(hostMask));
    }

    /*
     * WARNING - void declaration
     */
    static boolean testRange(BigInteger lowerValue, BigInteger upperValue, BigInteger finalUpperValue, int bitCount, int divisionPrefixLen) {
        void var3_4;
        void var2_2;
        void var1_1;
        BigInteger bigInteger;
        BigInteger networkMask = AddressDivisionGroupingBase.ALL_ONES.shiftLeft(bitCount - divisionPrefixLen);
        BigInteger hostMask = networkMask.not();
        return AddressDivisionBase.testRange(bigInteger, (BigInteger)var1_1, (BigInteger)var2_2, (BigInteger)var3_4, hostMask);
    }

    static {
        AddressDivisionGrouping.StringOptions.Wildcards rangeWildcard = new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR);
        OCTAL_PARAMS = new IPAddressSection.IPStringOptions.Builder(8).setSegmentStrPrefix("0").setWildcards(rangeWildcard).toOptions();
        HEX_PARAMS = new IPAddressSection.IPStringOptions.Builder(16).setSegmentStrPrefix("0x").setWildcards(rangeWildcard).toOptions();
        DECIMAL_PARAMS = new IPAddressSection.IPStringOptions.Builder(10).setWildcards(rangeWildcard).toOptions();
        String[] stringArray = new String[20];
        zeros = stringArray;
        stringArray[0] = "";
        for (int i = 1; i < 20; ++i) {
            AddressDivisionBase.zeros[i] = zeros[i - 1] + '0';
        }
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        EXTENDED_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '!', '#', '$', '%', '&', '(', ')', '*', '+', '-', ';', '<', '=', '>', '?', '@', '^', '_', '`', '{', '|', '}', '~'};
        BIG_MIN_RADIX = BigInteger.valueOf(2L);
        BIG_MAX_RADIX = BigInteger.valueOf(85L);
        UPPERCASE_DIGITS = IPAddressLargeDivision.EXTENDED_DIGITS;
        DOUBLE_DIGITS_DEC = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '3', '0', '3', '1', '3', '2', '3', '3', '3', '4', '3', '5', '3', '6', '3', '7', '3', '8', '3', '9', '4', '0', '4', '1', '4', '2', '4', '3', '4', '4', '4', '5', '4', '6', '4', '7', '4', '8', '4', '9', '5', '0', '5', '1', '5', '2', '5', '3', '5', '4', '5', '5', '5', '6', '5', '7', '5', '8', '5', '9', '6', '0', '6', '1', '6', '2', '6', '3', '6', '4', '6', '5', '6', '6', '6', '7', '6', '8', '6', '9', '7', '0', '7', '1', '7', '2', '7', '3', '7', '4', '7', '5', '7', '6', '7', '7', '7', '8', '7', '9', '8', '0', '8', '1', '8', '2', '8', '3', '8', '4', '8', '5', '8', '6', '8', '7', '8', '8', '8', '9', '9', '0', '9', '1', '9', '2', '9', '3', '9', '4', '9', '5', '9', '6', '9', '7', '9', '8', '9', '9'};
        maxDigitMap = new TreeMap();
        radixPowerMap = new TreeMap();
    }

    @FunctionalInterface
    protected static interface IntBinaryIteratorProvider<R> {
        public Iterator<R> applyAsInt(boolean var1, boolean var2, int var3, int var4);
    }

    @FunctionalInterface
    protected static interface SegmentCreator<R extends AddressSegment> {
        public R applyAsInt(int var1, int var2);
    }
}

