/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressStringParameters;
import inet.ipaddr.mac.MACAddressNetwork;

public class MACAddressStringParameters
extends AddressStringParameters
implements Comparable<MACAddressStringParameters> {
    public final AddressSize addressSize;
    public final boolean allowDashed;
    public final boolean allowSingleDashed;
    public final boolean allowColonDelimited;
    public final boolean allowDotted;
    public final boolean allowSpaceDelimited;
    private final MACAddressNetwork network;
    private MACAddressStringFormatParameters formatOpts;

    /*
     * WARNING - void declaration
     */
    public MACAddressStringParameters(boolean allowEmpty, boolean allowAll, AddressSize allAddresses, boolean allowSingleSegment, boolean allowDashed, boolean allowSingleDashed, boolean allowColonDelimited, boolean allowDotted, boolean allowSpaceDelimited, MACAddressStringFormatParameters formatOpts, MACAddressNetwork network) {
        super((boolean)var1_1, (boolean)var2_2, allowSingleSegment);
        void var3_3;
        void var2_2;
        void var1_1;
        this.allowDashed = allowDashed;
        this.allowSingleDashed = allowSingleDashed;
        this.allowColonDelimited = allowColonDelimited;
        this.allowDotted = allowDotted;
        this.allowSpaceDelimited = allowSpaceDelimited;
        this.formatOpts = formatOpts;
        this.addressSize = var3_3;
        this.network = network;
    }

    public MACAddressNetwork getNetwork() {
        if (this.network == null) {
            return Address.defaultMACNetwork();
        }
        return this.network;
    }

    public MACAddressStringFormatParameters getFormatParameters() {
        return this.formatOpts;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MACAddressStringParameters clone() {
        void var1_1;
        MACAddressStringParameters result = (MACAddressStringParameters)super.clone();
        ((MACAddressStringParameters)super.clone()).formatOpts = this.formatOpts.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(MACAddressStringParameters o) {
        void var2_2;
        int result = super.compareTo(o);
        if (result == 0 && (result = this.formatOpts.compareTo(o.formatOpts)) == 0 && (result = Boolean.compare(this.allowDashed, o.allowDashed)) == 0 && (result = Boolean.compare(this.allowSingleDashed, o.allowSingleDashed)) == 0 && (result = Boolean.compare(this.allowColonDelimited, o.allowColonDelimited)) == 0 && (result = Boolean.compare(this.allowDotted, o.allowDotted)) == 0 && (result = Boolean.compare(this.allowSpaceDelimited, o.allowSpaceDelimited)) == 0) {
            void var1_1;
            result = this.addressSize.ordinal() - var1_1.addressSize.ordinal();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o instanceof MACAddressStringParameters) {
            void var2_2;
            void var1_1;
            MACAddressStringParameters other = (MACAddressStringParameters)o;
            return super.equals(var1_1) && ((AddressStringParameters.AddressStringFormatParameters)this.formatOpts).equals(other.formatOpts) && this.allowDashed == other.allowDashed && this.allowSingleDashed == other.allowSingleDashed && this.allowColonDelimited == other.allowColonDelimited && this.allowDotted == other.allowDotted && this.allowSpaceDelimited == other.allowSpaceDelimited && this.addressSize == var2_2.addressSize;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int hash = ((AddressStringParameters.AddressStringFormatParameters)this.formatOpts).hashCode();
        if (this.allowAll) {
            hash |= 0x80;
        }
        if (this.allowDashed) {
            hash |= 0x100;
        }
        if (this.allowColonDelimited) {
            hash |= 0x200;
        }
        if (this.allowDotted) {
            hash |= 0x400;
        }
        if (this.allowSpaceDelimited) {
            hash |= 0x800;
        }
        if (this.allowSingleSegment) {
            hash |= 0x1000;
        }
        if (this.addressSize == AddressSize.MAC) {
            hash |= 0x2000;
        } else if (this.addressSize == AddressSize.EUI64) {
            hash |= 0x4000;
        }
        if (this.allowSingleDashed) {
            hash |= 0x8000;
        }
        if (this.allowEmpty) {
            hash |= 0x10000;
        }
        return (int)var1_1;
    }

    public static class MACAddressStringFormatParameters
    extends AddressStringParameters.AddressStringFormatParameters
    implements Comparable<MACAddressStringFormatParameters> {
        public final boolean allowShortSegments;

        /*
         * WARNING - void declaration
         */
        public MACAddressStringFormatParameters(boolean allowShortSegments, boolean allowLeadingZeros, boolean allowUnlimitedLeadingZeros, AddressStringParameters.RangeParameters rangeOptions, boolean allowWildcardedSeparator) {
            super((boolean)var2_2, (boolean)var3_3, rangeOptions, allowWildcardedSeparator);
            void var1_1;
            void var3_3;
            void var2_2;
            this.allowShortSegments = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(MACAddressStringFormatParameters o) {
            void var2_2;
            int result = super.compareTo(o);
            if (result == 0) {
                void var1_1;
                result = Boolean.compare(this.allowShortSegments, var1_1.allowShortSegments);
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o instanceof MACAddressStringFormatParameters) {
                void var2_2;
                void var1_1;
                MACAddressStringFormatParameters other = (MACAddressStringFormatParameters)o;
                return super.equals(var1_1) && this.allowShortSegments == var2_2.allowShortSegments;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int hash = super.hashCode();
            if (this.allowShortSegments) {
                hash |= 0x40;
            }
            return (int)var1_1;
        }

        public MACAddressStringFormatParameters clone() {
            try {
                return (MACAddressStringFormatParameters)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public static class Builder
        extends AddressStringParameters.AddressStringFormatParameters.BuilderBase {
            boolean allowShortSegments = true;

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setRangeOptions(AddressStringParameters.RangeParameters rangeOptions) {
                void var1_1;
                return (Builder)super.setRangeOptions((AddressStringParameters.RangeParameters)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder allowUnlimitedLeadingZeros(boolean allow) {
                void var1_1;
                return (Builder)super.allowUnlimitedLeadingZeros((boolean)var1_1);
            }

            MACAddressStringFormatParameters toParams() {
                return new MACAddressStringFormatParameters(this.allowShortSegments, this.allowLeadingZeros, this.allowUnlimitedLeadingZeros, this.rangeOptions, this.allowWildcardedSeparator);
            }
        }
    }

    public static class Builder
    extends AddressStringParameters.BuilderBase {
        private boolean allowDashed = true;
        private boolean allowSingleDashed = true;
        private boolean allowColonDelimited = true;
        private boolean allowDotted = true;
        private boolean allowSpaceDelimited = true;
        private AddressSize allAddresses = AddressSize.ANY;
        private MACAddressNetwork network;
        MACAddressStringFormatParameters.Builder formatBuilder;
        private static MACAddressStringFormatParameters DEFAULT_FORMAT_OPTS = new MACAddressStringFormatParameters.Builder().toParams();

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder allowEmpty(boolean allow) {
            void var1_1;
            return (Builder)super.allowEmpty((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder allowAll(boolean allow) {
            void var1_1;
            return (Builder)super.allowAll((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public MACAddressStringParameters toParams() {
            void var1_1;
            MACAddressStringFormatParameters formatOpts = this.formatBuilder == null ? DEFAULT_FORMAT_OPTS : this.formatBuilder.toParams();
            return new MACAddressStringParameters(this.allowEmpty, this.allowAll, this.allAddresses, this.allowSingleSegment, this.allowDashed, this.allowSingleDashed, this.allowColonDelimited, this.allowDotted, this.allowSpaceDelimited, (MACAddressStringFormatParameters)var1_1, this.network);
        }
    }

    public static final class AddressSize
    extends Enum<AddressSize> {
        public static final /* enum */ AddressSize MAC = new AddressSize();
        public static final /* enum */ AddressSize EUI64 = new AddressSize();
        public static final /* enum */ AddressSize ANY = new AddressSize();
        private static final /* synthetic */ AddressSize[] $VALUES;

        static {
            $VALUES = new AddressSize[]{MAC, EUI64, ANY};
        }
    }
}

