/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.MACAddressStringParameters;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.MACAddressProvider;
import inet.ipaddr.format.validate.Validator;
import inet.ipaddr.mac.MACAddress;

public class MACAddressString
implements HostIdentifierString,
Comparable<MACAddressString> {
    private static final MACAddressStringParameters DEFAULT_BASIC_VALIDATION_OPTIONS = new MACAddressStringParameters.Builder().toParams();
    public static final MACAddressString EMPTY_ADDRESS = new MACAddressString("");
    public static final MACAddressString ALL_ADDRESSES = new MACAddressString(IPAddress.SEGMENT_WILDCARD_STR);
    final MACAddressStringParameters validationOptions;
    final String fullAddr;
    private AddressStringException cachedException;
    private MACAddressProvider parsedAddress;
    private Boolean isValid;

    /*
     * WARNING - void declaration
     */
    public MACAddressString(String addr) {
        this((String)var1_1, DEFAULT_BASIC_VALIDATION_OPTIONS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MACAddressString(String addr, MACAddressStringParameters valOptions) {
        void var2_2;
        if (addr == null) {
            this.fullAddr = "";
        } else {
            void var1_1;
            addr = addr.trim();
            this.fullAddr = var1_1;
        }
        this.validationOptions = var2_2;
    }

    public MACAddressStringParameters getValidationOptions() {
        return this.validationOptions;
    }

    public boolean isEmpty() {
        if (this.isValid()) {
            try {
                return this.parsedAddress.getAddress() == null;
            }
            catch (IncompatibleAddressException incompatibleAddressException) {}
        }
        return false;
    }

    public boolean isValid() {
        if (this.isValid == null) {
            try {
                this.validate();
                return true;
            }
            catch (AddressStringException addressStringException) {
                return false;
            }
        }
        return this.isValid;
    }

    private boolean isValidated() throws AddressStringException {
        if (this.isValid != null) {
            if (this.cachedException != null) {
                throw this.cachedException;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() throws AddressStringException {
        if (this.isValidated()) {
            return;
        }
        MACAddressString mACAddressString = this;
        synchronized (mACAddressString) {
            if (this.isValidated()) {
                return;
            }
            try {
                this.parsedAddress = this.getValidator().validateAddress(this);
                this.isValid = Boolean.TRUE;
            }
            catch (AddressStringException e) {
                void var2_2;
                this.cachedException = e;
                this.isValid = Boolean.FALSE;
                throw var2_2;
            }
            return;
        }
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    public int hashCode() {
        if (this.isValid() && !this.isEmpty()) {
            return this.getAddress().hashCode();
        }
        return this.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(MACAddressString other) {
        void var1_1;
        if (this == other) {
            return 0;
        }
        if (this.isValid()) {
            if (other.isValid()) {
                MACAddress otherAddr;
                MACAddress addr = this.getAddress();
                if (addr != null && (otherAddr = other.getAddress()) != null) {
                    void var3_3;
                    void var2_2;
                    return var2_2.compareTo((AddressItem)var3_3);
                }
                return this.toString().compareTo(other.toString());
            }
            return 1;
        }
        if (other.isValid()) {
            return -1;
        }
        return this.toString().compareTo(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MACAddressString) {
            void var1_1;
            MACAddressString other = (MACAddressString)o;
            boolean stringsMatch = this.toString().equals(other.toString());
            if (stringsMatch && this.validationOptions == other.validationOptions) {
                return true;
            }
            if (this.isValid()) {
                if (other.isValid()) {
                    MACAddress value = this.getAddress();
                    if (value != null) {
                        MACAddress otherValue = other.getAddress();
                        if (otherValue != null) {
                            void var3_3;
                            return var3_3.equals(var1_1);
                        }
                        return false;
                    }
                    if (var1_1.getAddress() != null) {
                        return false;
                    }
                    return stringsMatch;
                }
            } else if (!var1_1.isValid()) {
                void var2_2;
                return (boolean)var2_2;
            }
        }
        return false;
    }

    public MACAddress getAddress() {
        if (this.isValid()) {
            try {
                return this.parsedAddress.getAddress();
            }
            catch (IncompatibleAddressException incompatibleAddressException) {}
        }
        return null;
    }

    public String toString() {
        return this.fullAddr;
    }
}

