/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressStringParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import inet.ipaddr.ipv6.IPv6AddressStringParameters;

public class IPAddressStringParameters
extends AddressStringParameters
implements Comparable<IPAddressStringParameters> {
    public final boolean allowPrefixOnly;
    public final boolean emptyIsLoopback;
    public final boolean allowPrefix;
    public final boolean allowMask;
    public final boolean allowIPv6;
    public final boolean allowIPv4;
    private IPv6AddressStringParameters ipv6Options;
    private IPv4AddressStringParameters ipv4Options;

    public IPAddress.IPVersion inferVersion() {
        if (this.allowIPv6) {
            if (!this.allowIPv4) {
                return IPAddress.IPVersion.IPV6;
            }
        } else if (this.allowIPv4) {
            return IPAddress.IPVersion.IPV4;
        }
        return null;
    }

    public Builder toBuilder() {
        return this.toBuilder(false);
    }

    /*
     * WARNING - void declaration
     */
    public Builder toBuilder(boolean isMixed) {
        void var2_2;
        void var1_1;
        Builder builder = new Builder();
        super.toBuilder(builder);
        Builder.access$002(builder, this.allowPrefixOnly);
        Builder.access$102(builder, this.emptyIsLoopback);
        Builder.access$202(builder, this.allowPrefix);
        Builder.access$302(builder, this.allowMask);
        Builder.access$402(builder, this.allowIPv6);
        Builder.access$502(builder, this.allowIPv4);
        builder.ipv4Builder = this.ipv4Options.toBuilder();
        builder.ipv6Builder = this.ipv6Options.toBuilder((boolean)var1_1);
        builder.allowSingleSegment = this.allowSingleSegment;
        builder.allowEmpty = this.allowEmpty;
        builder.allowAll = this.allowAll;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public IPAddressStringParameters(boolean allowEmpty, boolean allowAll, boolean allowSingleSegment, boolean emptyIsLoopback, boolean allowPrefix, boolean allowMask, boolean allowPrefixOnly, boolean allowIPv4, boolean allowIPv6, IPv4AddressStringParameters ipv4Options, IPv6AddressStringParameters ipv6Options) {
        super((boolean)var1_1, (boolean)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.allowPrefixOnly = allowPrefixOnly;
        this.emptyIsLoopback = emptyIsLoopback;
        this.allowPrefix = allowPrefix;
        this.allowMask = allowMask;
        this.allowIPv4 = allowIPv4;
        this.allowIPv6 = allowIPv6;
        this.ipv6Options = ipv6Options;
        this.ipv4Options = ipv4Options;
    }

    public IPv6AddressStringParameters getIPv6Parameters() {
        return this.ipv6Options;
    }

    public IPv4AddressStringParameters getIPv4Parameters() {
        return this.ipv4Options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPAddressStringParameters clone() {
        void var1_1;
        IPAddressStringParameters result = (IPAddressStringParameters)super.clone();
        ((IPAddressStringParameters)super.clone()).ipv4Options = this.ipv4Options.clone();
        result.ipv6Options = this.ipv6Options.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(IPAddressStringParameters o) {
        void var2_2;
        int result = super.compareTo(o);
        if (result == 0 && (result = this.ipv4Options.compareTo(o.ipv4Options)) == 0 && (result = this.ipv6Options.compareTo(o.ipv6Options)) == 0 && (result = Boolean.compare(this.emptyIsLoopback, o.emptyIsLoopback)) == 0 && (result = Boolean.compare(this.allowPrefix, o.allowPrefix)) == 0 && (result = Boolean.compare(this.allowPrefixOnly, o.allowPrefixOnly)) == 0 && (result = Boolean.compare(this.allowMask, o.allowMask)) == 0 && (result = Boolean.compare(this.allowIPv6, o.allowIPv6)) == 0) {
            void var1_1;
            result = Boolean.compare(this.allowIPv4, var1_1.allowIPv4);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o instanceof IPAddressStringParameters) {
            void var2_2;
            void var1_1;
            IPAddressStringParameters other = (IPAddressStringParameters)o;
            return super.equals(var1_1) && ((AddressStringParameters.AddressStringFormatParameters)this.ipv4Options).equals(other.ipv4Options) && ((AddressStringParameters.AddressStringFormatParameters)this.ipv6Options).equals(other.ipv6Options) && this.emptyIsLoopback == other.emptyIsLoopback && this.allowPrefix == other.allowPrefix && this.allowPrefixOnly == other.allowPrefixOnly && this.allowMask == other.allowMask && this.allowIPv6 == other.allowIPv6 && this.allowIPv4 == var2_2.allowIPv4;
        }
        return false;
    }

    public int hashCode() {
        int n = ((AddressStringParameters.AddressStringFormatParameters)this.ipv4Options).hashCode();
        int hash = n | ((AddressStringParameters.AddressStringFormatParameters)this.ipv6Options).hashCode() << 9;
        if (this.emptyIsLoopback) {
            hash |= 0x8000000;
        }
        if (this.allowPrefix) {
            hash |= 0x10000000;
        }
        if (this.allowMask) {
            hash |= 0x20000000;
        }
        if (this.allowEmpty) {
            hash |= 0x40000000;
        }
        if (this.allowSingleSegment) {
            hash |= Integer.MIN_VALUE;
        }
        return n;
    }

    public static abstract class IPAddressStringFormatParameters
    extends AddressStringParameters.AddressStringFormatParameters {
        public final boolean allowBinary;
        public final boolean allowPrefixesBeyondAddressSize;
        public final boolean allowPrefixLengthLeadingZeros;

        /*
         * WARNING - void declaration
         */
        public IPAddressStringFormatParameters(boolean allowBinary, boolean allowLeadingZeros, boolean allowPrefixLengthLeadingZeros, boolean allowUnlimitedLeadingZeros, AddressStringParameters.RangeParameters rangeOptions, boolean allowWildcardedSeparator, boolean allowPrefixesBeyondAddressSize) {
            super((boolean)var2_2, allowUnlimitedLeadingZeros, rangeOptions, allowWildcardedSeparator);
            void var3_3;
            void var1_1;
            void var2_2;
            this.allowBinary = var1_1;
            this.allowPrefixLengthLeadingZeros = var3_3;
            this.allowPrefixesBeyondAddressSize = allowPrefixesBeyondAddressSize;
        }

        /*
         * WARNING - void declaration
         */
        protected BuilderBase toBuilder(BuilderBase builder) {
            void var1_1;
            super.toBuilder(builder);
            builder.allowPrefixLengthLeadingZeros = this.allowPrefixLengthLeadingZeros;
            builder.allowPrefixesBeyondAddressSize = this.allowPrefixesBeyondAddressSize;
            builder.allowBinary = this.allowBinary;
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected int compareTo(IPAddressStringFormatParameters o) {
            void var2_2;
            int result = super.compareTo(o);
            if (result == 0 && (result = Boolean.compare(this.allowPrefixesBeyondAddressSize, o.allowPrefixesBeyondAddressSize)) == 0 && (result = Boolean.compare(this.allowPrefixLengthLeadingZeros, o.allowPrefixLengthLeadingZeros)) == 0) {
                void var1_1;
                result = Boolean.compare(this.allowBinary, var1_1.allowBinary);
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o instanceof IPAddressStringFormatParameters) {
                void var2_2;
                void var1_1;
                IPAddressStringFormatParameters other = (IPAddressStringFormatParameters)o;
                return super.equals(var1_1) && this.allowPrefixesBeyondAddressSize == other.allowPrefixesBeyondAddressSize && this.allowBinary == other.allowBinary && this.allowPrefixLengthLeadingZeros == var2_2.allowPrefixLengthLeadingZeros;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int hash = super.hashCode();
            if (this.allowPrefixesBeyondAddressSize) {
                hash |= 8;
            }
            return (int)var1_1;
        }

        protected static class BuilderBase
        extends AddressStringParameters.AddressStringFormatParameters.BuilderBase {
            protected boolean allowPrefixesBeyondAddressSize = false;
            protected boolean allowPrefixLengthLeadingZeros = true;
            protected boolean allowBinary = true;
            Builder parent;

            protected BuilderBase() {
            }

            public Builder getParentBuilder() {
                return this.parent;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public BuilderBase setRangeOptions(AddressStringParameters.RangeParameters rangeOptions) {
                void var1_1;
                return (BuilderBase)super.setRangeOptions((AddressStringParameters.RangeParameters)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public BuilderBase allowUnlimitedLeadingZeros(boolean allow) {
                void var1_1;
                return (BuilderBase)super.allowUnlimitedLeadingZeros((boolean)var1_1);
            }

            protected static void setMixedParentInst(IPv6AddressStringParameters.Builder parent, IPv4AddressStringParameters.Builder embedded) {
                IPv6AddressStringParameters.Builder builder;
                IPv4AddressStringParameters.Builder builder2 = embedded;
                ((BuilderBase)builder2).setMixedParent(builder);
            }

            protected void setMixedParent(IPv6AddressStringParameters.Builder parent) {
            }
        }
    }

    public static class Builder
    extends AddressStringParameters.BuilderBase {
        private boolean emptyIsLoopback = true;
        private boolean allowPrefix = true;
        private boolean allowMask = true;
        private boolean allowPrefixOnly = true;
        private boolean allowIPv4 = true;
        private boolean allowIPv6 = true;
        IPv4AddressStringParameters.Builder ipv4Builder;
        private static IPv4AddressStringParameters DEFAULT_IPV4_OPTS = new IPv4AddressStringParameters.Builder().toParams();
        IPv6AddressStringParameters.Builder ipv6Builder;
        private static IPv6AddressStringParameters DEFAULT_IPV6_OPTS = new IPv6AddressStringParameters.Builder().toParams();

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder allowEmpty(boolean allow) {
            void var1_1;
            return (Builder)super.allowEmpty((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder allowPrefix(boolean allow) {
            void var1_1;
            this.allowPrefix = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder allowMask(boolean allow) {
            void var1_1;
            this.allowMask = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder allowPrefixOnly(boolean allow) {
            void var1_1;
            this.allowPrefixOnly = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder allowAll(boolean allow) {
            void var1_1;
            return (Builder)super.allowAll((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder allowIPv4(boolean allow) {
            void var1_1;
            this.allowIPv4 = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder allowIPv6(boolean allow) {
            void var1_1;
            this.allowIPv6 = var1_1;
            return this;
        }

        public IPv6AddressStringParameters.Builder getIPv6AddressParametersBuilder() {
            if (this.ipv6Builder == null) {
                this.ipv6Builder = new IPv6AddressStringParameters.Builder();
            }
            this.ipv6Builder.parent = this;
            return this.ipv6Builder;
        }

        public IPv4AddressStringParameters.Builder getIPv4AddressParametersBuilder() {
            if (this.ipv4Builder == null) {
                this.ipv4Builder = new IPv4AddressStringParameters.Builder();
            }
            this.ipv4Builder.parent = this;
            return this.ipv4Builder;
        }

        /*
         * WARNING - void declaration
         */
        public IPAddressStringParameters toParams() {
            void var2_2;
            void var1_1;
            IPv4AddressStringParameters ipv4Opts = this.ipv4Builder == null ? DEFAULT_IPV4_OPTS : this.ipv4Builder.toParams();
            IPv6AddressStringParameters ipv6Opts = this.ipv6Builder == null ? DEFAULT_IPV6_OPTS : this.ipv6Builder.toParams();
            return new IPAddressStringParameters(this.allowEmpty, this.allowAll, this.allowSingleSegment, this.emptyIsLoopback, this.allowPrefix, this.allowMask, this.allowPrefixOnly, this.allowIPv4, this.allowIPv6, (IPv4AddressStringParameters)var1_1, (IPv6AddressStringParameters)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$002(Builder x0, boolean x1) {
            void var1_1;
            x0.allowPrefixOnly = var1_1;
            return x0.allowPrefixOnly;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$102(Builder x0, boolean x1) {
            void var1_1;
            x0.emptyIsLoopback = var1_1;
            return x0.emptyIsLoopback;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$202(Builder x0, boolean x1) {
            void var1_1;
            x0.allowPrefix = var1_1;
            return x0.allowPrefix;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$302(Builder x0, boolean x1) {
            void var1_1;
            x0.allowMask = var1_1;
            return x0.allowMask;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$402(Builder x0, boolean x1) {
            void var1_1;
            x0.allowIPv6 = var1_1;
            return x0.allowIPv6;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$502(Builder x0, boolean x1) {
            void var1_1;
            x0.allowIPv4 = var1_1;
            return x0.allowIPv4;
        }
    }
}

