/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.Validator;

public class IPAddressString
implements HostIdentifierString,
Comparable<IPAddressString> {
    public static final IPAddressStringParameters DEFAULT_VALIDATION_OPTIONS = new IPAddressStringParameters.Builder().toParams();
    private static final IPAddressString ipv4MappedPrefix = new IPAddressString("::ffff:0:0/96");
    final IPAddressStringParameters validationOptions;
    final String fullAddr;
    private AddressStringException validateException;
    private IPAddressProvider addressProvider = IPAddressProvider.NO_TYPE_PROVIDER;

    /*
     * WARNING - void declaration
     */
    public IPAddressString(String addr) {
        this((String)var1_1, DEFAULT_VALIDATION_OPTIONS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPAddressString(String addr, IPAddressStringParameters valOptions) {
        void var2_2;
        if (addr == null) {
            this.fullAddr = "";
        } else {
            void var1_1;
            addr = addr.trim();
            this.fullAddr = var1_1;
        }
        this.validationOptions = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    IPAddressString(String addrString, IPAddress address, IPAddressStringParameters valOptions) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.validationOptions = var3_3;
        this.fullAddr = var1_1;
        this.addressProvider = var2_2.getProvider();
    }

    public IPAddressStringParameters getValidationOptions() {
        return this.validationOptions;
    }

    public boolean isValid() {
        if (this.addressProvider.isUninitialized()) {
            try {
                this.validate();
                return true;
            }
            catch (AddressStringException addressStringException) {
                return false;
            }
        }
        return !this.addressProvider.isInvalid();
    }

    public void validate() throws AddressStringException {
        this.validate(null);
    }

    /*
     * WARNING - void declaration
     */
    private void checkIPv4Exception() throws AddressStringException {
        void var1_1;
        IPAddress.IPVersion version = this.addressProvider.getProviderIPVersion();
        if (version != null && var1_1.isIPv6()) {
            throw new AddressStringException("ipaddress.error.address.is.ipv6");
        }
        if (this.validateException != null) {
            throw this.validateException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkIPv6Exception() throws AddressStringException {
        void var1_1;
        IPAddress.IPVersion version = this.addressProvider.getProviderIPVersion();
        if (version != null && var1_1.isIPv4()) {
            throw new AddressStringException("ipaddress.error.address.is.ipv4");
        }
        if (this.validateException != null) {
            throw this.validateException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidated(IPAddress.IPVersion version) throws AddressStringException {
        if (!this.addressProvider.isUninitialized()) {
            void var1_1;
            if (version == null) {
                if (this.validateException != null) {
                    throw this.validateException;
                }
            } else if (version.isIPv4()) {
                this.checkIPv4Exception();
            } else if (var1_1.isIPv6()) {
                this.checkIPv6Exception();
            }
            return true;
        }
        return false;
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    /*
     * WARNING - void declaration
     */
    private void validate(IPAddress.IPVersion version) throws AddressStringException {
        if (this.isValidated(version)) {
            return;
        }
        IPAddressString iPAddressString = this;
        synchronized (iPAddressString) {
            if (this.isValidated(version)) {
                return;
            }
            try {
                this.addressProvider = this.getValidator().validateAddress(this);
            }
            catch (AddressStringException e) {
                void var1_2;
                this.validateException = e;
                this.addressProvider = IPAddressProvider.INVALID_PROVIDER;
                throw var1_2;
            }
            return;
        }
    }

    public int hashCode() {
        if (this.isValid()) {
            try {
                return this.addressProvider.providerHashCode();
            }
            catch (IncompatibleAddressException incompatibleAddressException) {}
        }
        return this.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(IPAddressString other) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (this == other) {
            return 0;
        }
        boolean isValid = this.isValid();
        boolean otherIsValid = other.isValid();
        if (var2_2 != false || var3_3 != false) {
            try {
                return this.addressProvider.providerCompare(other.addressProvider);
            }
            catch (IncompatibleAddressException incompatibleAddressException) {}
        }
        return this.toString().compareTo(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddressString) {
            void var1_1;
            IPAddressString other = (IPAddressString)o;
            boolean stringsMatch = this.toString().equals(other.toString());
            if (stringsMatch && this.validationOptions == other.validationOptions) {
                return true;
            }
            if (this.isValid()) {
                if (other.isValid()) {
                    Boolean directResult = this.addressProvider.parsedEquals(other.addressProvider);
                    if (directResult != null) {
                        void var3_3;
                        return var3_3.booleanValue();
                    }
                    try {
                        return this.addressProvider.providerEquals(other.addressProvider);
                    }
                    catch (IncompatibleAddressException incompatibleAddressException) {
                        return stringsMatch;
                    }
                }
            } else if (!var1_1.isValid()) {
                void var2_2;
                return (boolean)var2_2;
            }
        }
        return false;
    }

    public IPAddress getAddress() {
        if (!this.addressProvider.isInvalid()) {
            try {
                return this.toAddress();
            }
            catch (AddressStringException addressStringException) {
            }
            catch (IncompatibleAddressException incompatibleAddressException) {}
        }
        return null;
    }

    public IPAddress toAddress() throws AddressStringException, IncompatibleAddressException {
        this.validate();
        return this.addressProvider.getProviderAddress();
    }

    private static String toNormalizedString(IPAddressProvider addressProvider) throws IncompatibleAddressException {
        String string;
        String result;
        result = addressProvider.isProvidingAllAddresses() ? IPAddress.SEGMENT_WILDCARD_STR : (result.isProvidingEmpty() ? "" : (result.isProvidingPrefixOnly() ? IPAddressNetwork.getPrefixString(result.getProviderNetworkPrefixLength()) : (result.isProvidingIPAddress() ? result.getProviderAddress().toNormalizedString() : null)));
        return string;
    }

    public String toNormalizedString() {
        if (this.isValid()) {
            try {
                return IPAddressString.toNormalizedString(this.addressProvider);
            }
            catch (IncompatibleAddressException incompatibleAddressException) {}
        }
        return this.toString();
    }

    public String toString() {
        return this.fullAddr;
    }
}

