/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.format.AddressComponentRange;
import inet.ipaddr.format.IPAddressRange;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.util.AddressComponentRangeSpliterator;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;

public abstract class IPAddressSeqRange
implements IPAddressRange {
    private static final IPAddressSeqRange[] EMPTY_RANGES = new IPAddressSeqRange[0];
    protected final IPAddress lower;
    protected final IPAddress upper;
    private transient BigInteger count;
    private transient int hashCode;

    /*
     * WARNING - void declaration
     */
    protected <T extends IPAddress> IPAddressSeqRange(T first, T second, boolean preSet) {
        void var2_2;
        void var1_1;
        this.lower = var1_1;
        this.upper = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected <T extends IPAddress> IPAddressSeqRange(T first, T other, UnaryOperator<T> getLower, UnaryOperator<T> getUpper, UnaryOperator<T> prefixLenRemover) {
        void var1_1;
        void var3_3;
        void upper;
        void var2_2;
        boolean f = first.contains(other);
        if (f || other.contains(first)) {
            IPAddress addr = f ? (IPAddress)prefixLenRemover.apply((void)first) : (IPAddress)prefixLenRemover.apply((void)other);
            this.lower = (IPAddress)getLower.apply(addr);
            this.upper = (IPAddress)getUpper.apply(addr);
            return;
        }
        IPAddress firstLower = (IPAddress)getLower.apply(first);
        IPAddress otherLower = (IPAddress)getLower.apply(other);
        IPAddress firstUpper = (IPAddress)getUpper.apply(first);
        IPAddress otherUpper = (IPAddress)getUpper.apply(other);
        IPAddress lower = IPAddressSeqRange.compareLowValues(firstLower, otherLower) > 0 ? otherLower : firstLower;
        upper = IPAddressSeqRange.compareLowValues(firstUpper, otherUpper) < 0 ? var2_2 : upper;
        this.lower = (IPAddress)prefixLenRemover.apply(var3_3);
        this.upper = (IPAddress)prefixLenRemover.apply(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int compareLowValues(IPAddress one, IPAddress two) {
        void var1_1;
        IPAddress iPAddress;
        return AddressComparator.compareSegmentValues(false, iPAddress.getSection(), var1_1.getSection());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BigInteger getCount() {
        void var1_1;
        BigInteger result = this.count;
        if (result == null) {
            this.count = result = this.getCountImpl();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMultiple() {
        void var1_1;
        BigInteger count = this.count;
        if (count == null) {
            return IPAddressRange.super.isMultiple();
        }
        return !var1_1.equals(BigInteger.ONE);
    }

    protected BigInteger getCountImpl() {
        return IPAddressRange.super.getCount();
    }

    /*
     * WARNING - void declaration
     */
    protected static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressComponentRange, T> AddressComponentRangeSpliterator<S, T> createSpliterator(S forIteration, Predicate<IPAddressSeqRangeSplitterSink<S, T>> splitter, IPAddressSeqRangeIteratorProvider<S, T> iteratorProvider, ToLongFunction<S> longSizer) {
        void var3_3;
        void var2_2;
        void var1_1;
        S s;
        return new IPAddressSection.IPAddressSeqRangeSpliterator(s, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends AddressComponentRange, T> AddressComponentRangeSpliterator<S, T> createSpliterator(S forIteration, Predicate<IPAddressSeqRangeSplitterSink<S, T>> splitter, IPAddressSeqRangeIteratorProvider<S, T> iteratorProvider, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
        void var3_3;
        void var2_2;
        void var1_1;
        S s;
        return new IPAddressSection.IPAddressSeqRangeSpliterator(s, var1_1, var2_2, var3_3, downSizer, longSizer);
    }

    /*
     * WARNING - void declaration
     */
    protected static <I extends IPAddressSeqRange, T extends IPAddressRange, S extends AddressSegment> boolean split(IPAddressSeqRangeSplitterSink<I, T> sink, BiFunction<S[], S[], I> transformer, AddressNetwork.AddressSegmentCreator<S> segmentCreator, S[] originalSegmentsLower, S[] originalSegmentsUpper, int networkSegmentIndex, int hostSegmentIndex, Integer prefixLength) {
        S segUpper;
        int i;
        AddressSegment upperSeg = null;
        AddressSegment lowerSeg = null;
        boolean isSplit = false;
        for (i = 0; i < hostSegmentIndex; ++i) {
            int upper;
            S segLower = originalSegmentsLower[i];
            segUpper = originalSegmentsUpper[i];
            int lower = segLower.getSegmentValue();
            if (lower == (upper = segUpper.getSegmentValue())) continue;
            isSplit = true;
            int size = upper - lower;
            int mid = lower + (size >>> 1);
            lowerSeg = (AddressSegment)segmentCreator.createSegment(mid);
            upperSeg = (AddressSegment)segmentCreator.createSegment(mid + 1);
            break;
        }
        if (i == networkSegmentIndex && !isSplit) {
            S segLower = originalSegmentsLower[i];
            segUpper = originalSegmentsUpper[i];
            int segBitCount = segLower.getBitCount();
            Integer pref = IPAddressSection.getSegmentPrefixLength(segBitCount, prefixLength, i);
            int shiftAdjustment = segBitCount - pref;
            int lower = segLower.getSegmentValue();
            int upper = segUpper.getSegmentValue();
            if ((lower >>>= shiftAdjustment) != (upper >>>= shiftAdjustment)) {
                isSplit = true;
                int size = upper - lower;
                int mid = lower + (size >>> 1);
                int next = mid + 1;
                mid = mid << shiftAdjustment | ~(-1 << shiftAdjustment);
                lowerSeg = segmentCreator.createSegment(mid);
                upperSeg = segmentCreator.createSegment(next <<= shiftAdjustment);
            }
        }
        if (isSplit) {
            void var1_1;
            void var3_3;
            IPAddressSeqRangeSplitterSink<I, T> iPAddressSeqRangeSplitterSink;
            void var2_2;
            int len = originalSegmentsLower.length;
            Object[] lowerUpperSegs = segmentCreator.createSegmentArray(len);
            Object[] upperLowerSegs = segmentCreator.createSegmentArray(len);
            System.arraycopy(originalSegmentsLower, 0, lowerUpperSegs, 0, i);
            System.arraycopy(originalSegmentsLower, 0, upperLowerSegs, 0, i);
            int j = i + 1;
            lowerUpperSegs[i] = lowerSeg;
            upperLowerSegs[i] = upperSeg;
            Arrays.fill(lowerUpperSegs, j, lowerUpperSegs.length, segmentCreator.createSegment(lowerSeg.getMaxSegmentValue()));
            Arrays.fill(upperLowerSegs, j, upperLowerSegs.length, var2_2.createSegment(0));
            iPAddressSeqRangeSplitterSink.setSplitValues((IPAddressSeqRange)transformer.apply((S[])var3_3, (S[])lowerUpperSegs), (IPAddressSeqRange)var1_1.apply(upperLowerSegs, originalSegmentsUpper));
        }
        return isSplit;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends Address, S extends AddressSegment> Iterator<T> iterator(T original, AddressCreator<T, ?, ?, S> creator) {
        void var1_1;
        return IPAddressSection.iterator(original, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends IPAddress, S extends IPAddressSegment> Iterator<T> iterator(T lower, T upper, AddressCreator<T, ?, ?, S> creator, IPAddressSection.SegFunction<T, S> segProducer, IPAddressSection.SegFunction<S, Iterator<S>> segmentIteratorProducer, SegValueComparator<T> segValueComparator, int networkSegmentIndex, int hostSegmentIndex, IPAddressSection.SegFunction<S, Iterator<S>> prefixedSegIteratorProducer) {
        void var2_2;
        T t;
        int divCount = lower.getSegmentCount();
        ArrayList<Supplier<Iterator>> segIteratorProducerList = new ArrayList<Supplier<Iterator>>(divCount);
        final boolean[] finalValue = new boolean[divCount + 1];
        boolean notDiffering = true;
        finalValue[0] = true;
        IPAddressSegment allSegShared = null;
        for (int i = 0; i < divCount; ++i) {
            Iterator wrappedFinalIterator;
            Iterator iterator;
            IPAddressSection.SegFunction<Object, Iterator<Object>> segIteratorProducer = prefixedSegIteratorProducer != null && i >= networkSegmentIndex ? prefixedSegIteratorProducer : segmentIteratorProducer;
            IPAddressSegment lowerSeg = (IPAddressSegment)segProducer.apply(lower, i);
            final int indexi = i;
            if (notDiffering) {
                notDiffering = segValueComparator.apply(lower, upper, i);
                if (notDiffering) {
                    finalValue[i + 1] = true;
                    iterator = segIteratorProducer.apply(lowerSeg, i);
                    segIteratorProducerList.add(() -> iterator);
                    continue;
                }
                iterator = segIteratorProducer.apply((IPAddressSegment)creator.createSegment(((IPAddressSegment)((Object)iterator)).getSegmentValue(), ((IPAddressSegment)upper.getSegment(i)).getSegmentValue(), null), i);
                wrappedFinalIterator = new Iterator<S>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public S next() {
                        void var1_1;
                        IPAddressSegment next = (IPAddressSegment)iterator.next();
                        if (!iterator.hasNext()) {
                            finalValue[indexi + 1] = true;
                        }
                        return var1_1;
                    }
                };
                segIteratorProducerList.add(() -> wrappedFinalIterator);
                continue;
            }
            Iterator<S> firstIterator = segIteratorProducer.apply((IPAddressSegment)creator.createSegment(((IPAddressSegment)((Object)iterator)).getSegmentValue(), lower.getMaxSegmentValue(), null), i);
            final Iterator<S> finalIterator = segIteratorProducer.apply((IPAddressSegment)creator.createSegment(0, ((IPAddressSegment)upper.getSegment(i)).getSegmentValue(), null), i);
            wrappedFinalIterator = new Iterator<S>(){

                @Override
                public boolean hasNext() {
                    return finalIterator.hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public S next() {
                    void var1_1;
                    IPAddressSegment next = (IPAddressSegment)finalIterator.next();
                    if (!finalIterator.hasNext()) {
                        finalValue[indexi + 1] = true;
                    }
                    return var1_1;
                }
            };
            if (allSegShared == null) {
                allSegShared = (IPAddressSegment)creator.createSegment(0, lower.getMaxSegmentValue(), null);
            }
            IPAddressSegment allSeg = allSegShared;
            Supplier<Iterator> finalIteratorProducer = () -> {
                void var1_1;
                void var3_3;
                if (finalValue[indexi]) {
                    void var2_2;
                    return var2_2;
                }
                return (Iterator)var3_3.apply(allSeg, (int)var1_1);
            };
            ArrayList<Supplier<Iterator>> arrayList = segIteratorProducerList;
            arrayList.add(() -> {
                void var3_3;
                void var2_2;
                void var1_1;
                arrayList.set((int)var1_1, (Supplier<Iterator>)var2_2);
                return var3_3;
            });
        }
        IntFunction iteratorProducer = iteratorIndex -> {
            void var1_1;
            return (Iterator)((Supplier)segIteratorProducerList.get((int)var1_1)).get();
        };
        return IPAddressSection.iterator(null, creator, IPAddressSection.iterator(t.getSegmentCount(), var2_2, iteratorProducer, networkSegmentIndex, hostSegmentIndex, iteratorProducer));
    }

    public IPAddress getLower() {
        return this.lower;
    }

    public IPAddress getUpper() {
        return this.upper;
    }

    /*
     * WARNING - void declaration
     */
    public String toCanonicalString(String separator) {
        void var2_2;
        void var1_1;
        Function<IPAddress, String> stringer = Address::toCanonicalString;
        return this.toString(stringer, (String)var1_1, (Function<? super IPAddress, String>)var2_2);
    }

    public String toCanonicalString() {
        return this.toCanonicalString(" -> ");
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Function<? super IPAddress, String> lowerStringer, String separator, Function<? super IPAddress, String> upperStringer) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (String)var1_1.apply(this.getLower()) + (String)var2_2 + (String)var3_3.apply(this.getUpper());
    }

    public String toString() {
        return this.toCanonicalString();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int res = this.hashCode;
        if (res == 0) {
            this.hashCode = res = 31 * this.getLower().hashCode() + this.getUpper().hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o instanceof IPAddressSeqRange) {
            void var1_1;
            IPAddressSeqRange otherRange = (IPAddressSeqRange)o;
            return this.getLower().equals(otherRange.getLower()) && this.getUpper().equals(var1_1.getUpper());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int prefixLen) {
        IPAddressSection.checkSubnet(this.lower, prefixLen);
        int divCount = this.lower.getDivisionCount();
        int bitsPerSegment = this.lower.getBitsPerSegment();
        int i = IPAddressSeqRange.getHostSegmentIndex(prefixLen, this.lower.getBytesPerSegment(), bitsPerSegment);
        if (i < divCount) {
            void var1_1;
            void var3_3;
            AddressSegment div = this.lower.getSegment(i);
            AddressSegment upperDiv = this.upper.getSegment(i);
            int segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength((int)var3_3, prefixLen, i);
            AddressSegment addressSegment = div;
            if (!((IPAddressSegment)addressSegment).containsPrefixBlock(((IPAddressSegment)addressSegment).getSegmentValue(), ((IPAddressSegment)upperDiv).getSegmentValue(), (int)var1_1)) {
                return false;
            }
            ++i;
            while (i < divCount) {
                div = this.lower.getSegment(i);
                upperDiv = this.upper.getSegment(i);
                if (!((AddressDivision)((Object)div)).includesZero() || !((AddressDivision)((Object)upperDiv)).includesMax()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSinglePrefixBlock(int prefixLen) {
        IPAddressSection.checkSubnet(this.lower, prefixLen);
        int prevBitCount = 0;
        int divCount = this.lower.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            AddressSegment div = this.lower.getSegment(i);
            AddressSegment upperDiv = this.upper.getSegment(i);
            int n = div.getBitCount();
            int totalBitCount = n + prevBitCount;
            if (prefixLen >= totalBitCount) {
                if (!((IPAddressSegment)div).isSameValues(upperDiv)) {
                    return false;
                }
            } else {
                void var1_1;
                int divPrefixLen = Math.max(0, prefixLen - prevBitCount);
                AddressSegment addressSegment = div;
                if (!((IPAddressSegment)addressSegment).containsSinglePrefixBlock(((IPAddressSegment)addressSegment).getSegmentValue(), ((IPAddressSegment)upperDiv).getSegmentValue(), (int)var1_1)) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.lower.getSegment(i);
                    upperDiv = this.upper.getSegment(i);
                    if (!((AddressDivision)((Object)div)).includesZero() || !((AddressDivision)((Object)upperDiv)).includesMax()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    @Override
    public int getBitCount() {
        return this.getLower().getBitCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(byte[] bytes) {
        void var1_1;
        return this.getLower().getBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        void var1_1;
        return this.getUpper().getUpperBytes((byte[])var1_1);
    }

    @Override
    public BigInteger getValue() {
        return this.getLower().getValue();
    }

    @Override
    public BigInteger getUpperValue() {
        return this.getUpper().getValue();
    }

    @Override
    public boolean isZero() {
        return this.includesZero() && !this.isMultiple();
    }

    @Override
    public boolean includesZero() {
        return this.getLower().isZero();
    }

    @Override
    public boolean isMax() {
        return this.includesMax() && !this.isMultiple();
    }

    @Override
    public boolean includesMax() {
        return this.getUpper().isMax();
    }

    @FunctionalInterface
    protected static interface SegValueComparator<T> {
        public boolean apply(T var1, T var2, int var3);
    }

    @FunctionalInterface
    protected static interface IPAddressSeqRangeIteratorProvider<S, T>
    extends IPAddressSection.SeqRangeIteratorProvider<S, T> {
    }

    protected static interface IPAddressSeqRangeSplitterSink<S, T> {
        public void setSplitValues(S var1, S var2);

        public S getAddressItem();
    }
}

