/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.IPAddressDivision;
import inet.ipaddr.format.string.IPAddressStringDivisionSeries;
import inet.ipaddr.format.validate.ParsedIPAddress;
import java.math.BigInteger;

public abstract class IPAddressSegment
extends IPAddressDivision
implements AddressSegment {
    private final int value;
    private final int upperValue;

    /*
     * WARNING - void declaration
     */
    protected IPAddressSegment(int value) {
        void var1_1;
        if (value < 0) {
            throw new AddressValueException(value);
        }
        IPAddressSegment iPAddressSegment = this;
        iPAddressSegment.value = iPAddressSegment.upperValue = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected IPAddressSegment(int value, Integer segmentPrefixLength) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((int)v0, (int)v0, (Integer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected IPAddressSegment(int lower, int upper, Integer segmentPrefixLength) {
        super(segmentPrefixLength);
        void var3_3;
        void var2_2;
        void var1_1;
        if (lower < 0 || upper < 0) {
            throw new AddressValueException(lower < 0 ? (long)lower : (long)upper);
        }
        if (lower > upper) {
            int tmp = lower;
            lower = upper;
            upper = tmp;
        }
        if ((segmentPrefixLength = this.getSegmentPrefixLength()) == null || segmentPrefixLength >= this.getBitCount() || !this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            this.value = lower;
            this.upperValue = upper;
            return;
        }
        int mask = this.getSegmentNetworkMask(segmentPrefixLength);
        this.value = var1_1 & mask;
        this.upperValue = var2_2 | this.getSegmentHostMask(var3_3.intValue());
    }

    public abstract IPAddressNetwork<?, ?, ?, ?, ?> getNetwork();

    /*
     * WARNING - void declaration
     */
    protected static Integer getSplitSegmentPrefix(int bitsPerSegment, Integer networkPrefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, (Integer)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long getDivisionNetworkMask(int bits) {
        void var1_1;
        return this.getSegmentNetworkMask((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long getDivisionHostMask(int bits) {
        void var1_1;
        return this.getSegmentHostMask((int)var1_1);
    }

    protected abstract int getSegmentNetworkMask(int var1);

    protected abstract int getSegmentHostMask(int var1);

    @Override
    public int getMinPrefixLengthForBlock() {
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && this.isPrefixed() && this.getSegmentPrefixLength() == 0) {
            return 0;
        }
        return super.getMinPrefixLengthForBlock();
    }

    public static int getMaxSegmentValue(IPAddress.IPVersion version) {
        if (version.isIPv4()) {
            return 255;
        }
        return 65535;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isChangedByPrefix(Integer bits, boolean smallerOnly) {
        void var3_3;
        void var2_2;
        boolean hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, bits);
        }
        if (var2_2 != false) {
            if (this.isPrefixed()) {
                return hasBits && bits < this.getSegmentPrefixLength();
            }
        } else if (this.isPrefixed()) {
            void var1_1;
            return !hasBits || var1_1.intValue() != this.getSegmentPrefixLength().intValue();
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected <S extends IPAddressSegment> S toPrefixedSegment(Integer segmentPrefixLength, AddressNetwork.AddressSegmentCreator<S> creator) {
        void var3_3;
        void var2_2;
        boolean hasBits;
        int lower = this.getSegmentValue();
        int upper = this.getUpperSegmentValue();
        boolean bl = hasBits = segmentPrefixLength != null;
        if (lower != upper) {
            if (!hasBits) {
                return (S)((IPAddressSegment)creator.createSegment(lower, upper, null));
            }
            return (S)((IPAddressSegment)creator.createSegment(lower, upper, segmentPrefixLength));
        }
        if (hasBits) {
            void var1_1;
            return (S)((IPAddressSegment)creator.createSegment(lower, (Integer)var1_1));
        }
        return (S)((IPAddressSegment)var2_2.createSegment((int)var3_3));
    }

    @Override
    public boolean isPrefixBlock() {
        return this.isPrefixed() && this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() || super.isPrefixBlock();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isNetworkChangedByPrefix(Integer bits, boolean withPrefixLength) {
        void var1_1;
        void var3_3;
        void var2_2;
        boolean hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, bits);
        }
        withPrefixLength &= hasBits;
        boolean thisHasPrefix = this.isPrefixed();
        if (var2_2 != thisHasPrefix) {
            return true;
        }
        if (var3_3 == false || bits != this.getDivisionPrefixLength()) {
            return true;
        }
        return !this.containsPrefixBlock(var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isNetworkChangedByPrefixNonNull(int prefixBitCount) {
        void var1_1;
        return !this.isPrefixed() || prefixBitCount != this.getDivisionPrefixLength() || !this.containsPrefixBlock((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected <S extends IPAddressSegment> S toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength, AddressNetwork.AddressSegmentCreator<S> creator) {
        void var3_3;
        void var2_2;
        int newLower = this.getSegmentValue();
        int newUpper = this.getUpperSegmentValue();
        boolean hasPrefLen = segmentPrefixLength != null;
        if (hasPrefLen) {
            int mask = this.getSegmentNetworkMask(segmentPrefixLength);
            newLower &= mask;
            newUpper |= this.getSegmentHostMask(segmentPrefixLength);
        }
        boolean bl = withPrefixLength = withPrefixLength && hasPrefLen;
        if (newLower != newUpper) {
            if (!withPrefixLength) {
                return (S)((IPAddressSegment)creator.createSegment(newLower, newUpper, null));
            }
            return (S)((IPAddressSegment)creator.createSegment(newLower, newUpper, segmentPrefixLength));
        }
        if (var2_2 != false) {
            void var1_1;
            return (S)((IPAddressSegment)creator.createSegment(newLower, (Integer)var1_1));
        }
        return (S)((IPAddressSegment)var3_3.createSegment(newLower));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isChangedBy(int newValue, int newUpperValue, Integer segmentPrefixLength) throws IncompatibleAddressException {
        void var3_3;
        void var2_2;
        void var1_1;
        int value = this.getSegmentValue();
        int upperValue = this.getUpperSegmentValue();
        return value != var1_1 || upperValue != var2_2 || (this.isPrefixed() ? !this.getSegmentPrefixLength().equals(segmentPrefixLength) : var3_3 != null);
    }

    /*
     * WARNING - void declaration
     */
    protected static ParsedIPAddress.Masker maskRange(long value, long upperValue, long maskValue, long maxValue) {
        void var2_1;
        return AddressDivision.maskRange(value, (long)var2_1, maskValue, maxValue);
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends IPAddressSegment> S getLowestOrHighest(S original, AddressNetwork.AddressSegmentCreator<S> segmentCreator, boolean lowest) {
        S s;
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isAllSubnets = original.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (!(((AddressDivision)original).isMultiple() || isAllSubnets && original.isPrefixed())) {
            return original;
        }
        return (S)((IPAddressSegment)var1_1.createSegment(var2_2 != false ? original.getSegmentValue() : original.getUpperSegmentValue(), var3_3 != false ? null : s.getSegmentPrefixLength()));
    }

    public static int getBitCount(IPAddress.IPVersion version) {
        if (version.isIPv4()) {
            return 8;
        }
        return 16;
    }

    public static int getByteCount(IPAddress.IPVersion version) {
        if (version.isIPv4()) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(int value) {
        void var1_1;
        return super.matches((long)var1_1);
    }

    public int getValueCount() {
        return this.getUpperSegmentValue() - this.getSegmentValue() + 1;
    }

    @Override
    public BigInteger getCount() {
        return BigInteger.valueOf(this.getValueCount());
    }

    protected int highByte() {
        return IPAddressSegment.highByte(this.getSegmentValue());
    }

    protected int lowByte() {
        return IPAddressSegment.lowByte(this.getSegmentValue());
    }

    protected static int highByte(int value) {
        return value >> 8;
    }

    protected static int lowByte(int value) {
        return value & 0xFF;
    }

    @Override
    public long getMaxValue() {
        return this.getMaxSegmentValue();
    }

    @Override
    public boolean isMultiple() {
        return this.getSegmentValue() != this.getUpperSegmentValue();
    }

    @Override
    public int getSegmentValue() {
        return this.value;
    }

    @Override
    public int getUpperSegmentValue() {
        return this.upperValue;
    }

    @Override
    public long getDivisionValue() {
        return this.getSegmentValue();
    }

    @Override
    public long getUpperDivisionValue() {
        return this.getUpperSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    protected static <S extends IPAddressSegment> S removePrefix(S original, boolean zeroed, AddressNetwork.AddressSegmentCreator<S> creator) {
        S s;
        if (original.isPrefixed()) {
            void var3_3;
            void var2_2;
            int lower = original.getSegmentValue();
            int upper = original.getUpperSegmentValue();
            if (zeroed) {
                void var1_1;
                long maxValue;
                long upperValue;
                S s2 = original;
                int maskBits = s2.getSegmentNetworkMask(s2.getSegmentPrefixLength());
                long value = ((AddressDivision)original).getDivisionValue();
                ParsedIPAddress.Masker masker = IPAddressSegment.maskRange(value, upperValue = ((AddressDivision)original).getUpperDivisionValue(), maskBits, maxValue = ((AddressDivision)original).getMaxValue());
                if (!masker.isSequential()) {
                    throw new IncompatibleAddressException(original, maskBits, "ipaddress.error.maskMismatch");
                }
                return (S)((IPAddressSegment)creator.createSegment((int)masker.getMaskedLower(lower, maskBits), (int)masker.getMaskedUpper(upper, (long)var1_1), null));
            }
            return (S)((IPAddressSegment)var2_2.createSegment((int)var3_3, upper, null));
        }
        return s;
    }

    public Integer getSegmentPrefixLength() {
        return this.getDivisionPrefixLength();
    }

    @Override
    public int hashCode() {
        return IPAddressSegment.hash(this.getSegmentValue(), this.getUpperSegmentValue(), this.getBitCount());
    }

    /*
     * WARNING - void declaration
     */
    static int hash(int lower, int upper, int bitCount) {
        void var2_2;
        void var1_1;
        return lower | var1_1 << var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSameValues(AddressSegment otherSegment) {
        void var1_1;
        return this.getSegmentValue() == otherSegment.getSegmentValue() && this.getUpperSegmentValue() == var1_1.getUpperSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean containsSeg(AddressSegment other) {
        void var1_1;
        return other.getSegmentValue() >= this.getSegmentValue() && var1_1.getUpperSegmentValue() <= this.getUpperSegmentValue();
    }

    @Override
    public boolean includesZero() {
        return this.getSegmentValue() == 0;
    }

    @Override
    public boolean includesMax() {
        return this.getUpperSegmentValue() == this.getMaxSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    boolean containsPrefixBlock(int lowerVal, int upperVal, int divisionPrefixLen) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.isPrefixBlock((long)var1_1, (long)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    boolean containsSinglePrefixBlock(int lowerVal, int upperVal, int divisionPrefixLen) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.isSinglePrefixBlock((long)var1_1, (long)var2_2, (int)var3_3);
    }

    @Override
    protected String getDefaultSegmentWildcardString() {
        return Address.SEGMENT_WILDCARD_STR;
    }

    @Override
    public String toNormalizedString() {
        return this.toNormalizedString(IPAddressSection.IPStringCache.canonicalSegmentParams);
    }

    /*
     * WARNING - void declaration
     */
    public String toNormalizedString(IPAddressSection.IPStringOptions options) {
        void var2_2;
        void var1_1;
        AddressDivisionGroupingBase.IPAddressStringParams<IPAddressStringDivisionSeries> params = IPAddressSection.toIPParams(options);
        StringBuilder builder = new StringBuilder(params.getDivisionStringLength(this));
        return var1_1.appendDivision((StringBuilder)var2_2, this).toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static int toUnsignedStringLength(int value, int radix) {
        void var1_1;
        return AddressDivision.toUnsignedStringLength(value, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static StringBuilder toUnsignedString(int value, int radix, StringBuilder appendable) {
        void var2_2;
        void var1_1;
        return IPAddressSegment.toUnsignedStringCased(value, (int)var1_1, 0, false, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void setStandardString(CharSequence addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int originalLowerValue) {
        void var2_2;
        if (this.cachedString == null && var2_2 != false && (long)originalLowerValue == ((AddressDivision)this).getDivisionValue()) {
            void var3_3;
            void var1_1;
            this.cachedString = var1_1.subSequence((int)var3_3, lowerStringEndIndex).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    void setWildcardString(CharSequence addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int lowerValue) {
        void var2_2;
        if (this.cachedWildcardString == null && var2_2 != false && (long)lowerValue == ((AddressDivision)this).getDivisionValue() && (long)lowerValue == ((AddressDivision)this).getUpperDivisionValue()) {
            void var3_3;
            void var1_1;
            this.cachedWildcardString = var1_1.subSequence((int)var3_3, lowerStringEndIndex).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    void setStandardString(CharSequence addressStr, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedString == null) {
            if (this.isSinglePrefixBlock()) {
                void var2_2;
                if (var2_2 != false && (long)rangeLower == ((AddressDivision)this).getDivisionValue()) {
                    this.cachedString = addressStr.subSequence(lowerStringStartIndex, lowerStringEndIndex).toString();
                    return;
                }
            } else {
                void var3_3;
                if (this.isFullRange()) {
                    this.cachedString = IPAddress.SEGMENT_WILDCARD_STR;
                    return;
                }
                if (var3_3 != false && (long)rangeLower == ((AddressDivision)this).getDivisionValue()) {
                    long upper = ((AddressDivision)this).getUpperDivisionValue();
                    if (this.isPrefixed()) {
                        IPAddressSegment iPAddressSegment = this;
                        upper &= iPAddressSegment.getDivisionNetworkMask(iPAddressSegment.getDivisionPrefixLength());
                    }
                    if ((long)rangeUpper == upper) {
                        void var1_1;
                        this.cachedString = var1_1.subSequence(lowerStringStartIndex, upperStringEndIndex).toString();
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void setWildcardString(CharSequence addressStr, boolean isStandardRangeString, int lowerStringStartIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedWildcardString == null) {
            void var2_2;
            if (this.isFullRange()) {
                this.cachedWildcardString = IPAddress.SEGMENT_WILDCARD_STR;
                return;
            }
            if (var2_2 != false && (long)rangeLower == ((AddressDivision)this).getDivisionValue() && (long)rangeUpper == ((AddressDivision)this).getUpperDivisionValue()) {
                void var3_3;
                void var1_1;
                this.cachedWildcardString = var1_1.subSequence((int)var3_3, upperStringEndIndex).toString();
            }
        }
    }
}

