/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressSegmentSeries;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.InconsistentPrefixException;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.SizeMismatchException;
import inet.ipaddr.format.AddressComponentRange;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.standard.IPAddressDivision;
import inet.ipaddr.format.standard.IPAddressDivisionGrouping;
import inet.ipaddr.format.string.IPAddressStringDivisionSeries;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.format.validate.ParsedIPAddress;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;

public abstract class IPAddressSection
extends IPAddressDivisionGrouping
implements AddressSection,
IPAddressSegmentSeries {
    private static final IPAddressStringDivisionSeries[] EMPTY_PARTS = new IPAddressStringDivisionSeries[0];
    private transient PrefixCache prefixCache;
    static final Comparator<? super IPAddressSegmentSeries> mergeListComparator = (one, two) -> {
        int n;
        int comparison;
        Integer prefix2;
        Integer prefix1 = one.getPrefixLength();
        if ((prefix1 == (prefix2 = two.getPrefixLength()) ? 0 : (prefix1 == null ? -1 : (comparison = prefix2 == null ? 1 : prefix2.compareTo(prefix1)))) != 0) {
            return comparison;
        }
        if (prefix1 == null || prefix1 != 0) {
            int twoValue;
            int oneValue;
            int i;
            int networkSegIndex = prefix1 == null ? one.getSegmentCount() - 1 : IPAddressSection.getNetworkSegmentIndex(prefix1, one.getBytesPerSegment(), one.getBitsPerSegment());
            int hostSegIndex = prefix1 == null ? one.getSegmentCount() : IPAddressSection.getHostSegmentIndex(prefix1, one.getBytesPerSegment(), one.getBitsPerSegment());
            for (i = 0; i < hostSegIndex; ++i) {
                IPAddressSegment segOne = one.getSegment(i);
                IPAddressSegment segTwo = two.getSegment(i);
                oneValue = segOne.getSegmentValue();
                twoValue = segTwo.getSegmentValue();
                int oneUpperValue = segOne.getUpperSegmentValue();
                int twoUpperValue = segTwo.getUpperSegmentValue();
                if ((oneUpperValue = oneUpperValue - oneValue - (twoUpperValue - twoValue)) == 0) continue;
                return oneUpperValue;
            }
            for (i = 0; i <= networkSegIndex; ++i) {
                void var3_7;
                IPAddressSegment segOne = one.getSegment(i);
                IPAddressSegment segTwo = two.getSegment(i);
                oneValue = var3_7.getSegmentValue();
                n = oneValue - (twoValue = segTwo.getSegmentValue());
                if (n == 0) continue;
                return n;
            }
        }
        return n;
    };
    private static final AddressComparator.ValueComparator REVERSE_LOW_COMPARATOR = new AddressComparator.ValueComparator(true, false, true);
    private static final AddressComparator.ValueComparator REVERSE_HIGH_COMPARATOR = new AddressComparator.ValueComparator(true, true, true);

    /*
     * WARNING - void declaration
     */
    protected IPAddressSection(IPAddressSegment[] segments, boolean cloneSegments, boolean checkSegs) {
        super(cloneSegments ? (IPAddressDivision[])segments.clone() : segments, false);
        if (checkSegs) {
            void var3_5;
            IPAddressNetwork<?, ?, ?, ?, ?> network = ((IPAddressDivisionGrouping)this).getNetwork();
            Integer previousSegmentPrefix = null;
            int bitsPerSegment = this.getBitsPerSegment();
            for (int i = 0; i < segments.length; ++i) {
                IPAddressSegment segment = segments[i];
                if (!network.isCompatible(segment.getNetwork())) {
                    throw new NetworkMismatchException(segment);
                }
                Integer segPrefix = segment.getSegmentPrefixLength();
                if (previousSegmentPrefix == null) {
                    if (segPrefix != null) {
                        this.cachedPrefixLength = IPAddressSection.cacheBits(IPAddressSection.getNetworkPrefixLength(bitsPerSegment, segPrefix, i));
                    }
                } else if (segPrefix == null || segPrefix != 0) {
                    throw new InconsistentPrefixException(segments[i - 1], segment, segPrefix);
                }
                previousSegmentPrefix = segPrefix;
            }
            if (var3_5 == null) {
                this.cachedPrefixLength = NO_PREFIX_LENGTH;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressDivisionGrouping.RangeList zeroSegments, IPAddressDivisionGrouping.RangeList zeroRanges) {
        void var3_3;
        void var2_2;
        if (this.prefixCache == null) {
            this.prefixCache = new PrefixCache();
        }
        if (var2_2 != false) {
            this.setNetworkMaskPrefix(prefixLen);
        } else {
            void var1_1;
            this.setHostMaskPrefix((Integer)var1_1);
        }
        super.initCachedValues(cachedNetworkPrefix, cachedCount);
        PrefixCache.access$002(this.prefixCache, cachedMinPrefix);
        PrefixCache.access$102(this.prefixCache, Objects.equals(cachedEquivalentPrefix, var3_3));
        PrefixCache.access$202(this.prefixCache, cachedEquivalentPrefix);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSinglePrefixBlock() {
        void var1_1;
        if (!this.hasNoPrefixCache() && this.prefixCache.cachedIsSinglePrefixBlock != null) {
            return this.prefixCache.cachedIsSinglePrefixBlock;
        }
        boolean result = super.isSinglePrefixBlock();
        PrefixCache.access$102(this.prefixCache, result);
        if (result) {
            PrefixCache.access$202(this.prefixCache, this.getNetworkPrefixLength());
        }
        return (boolean)var1_1;
    }

    protected static IPAddressDivisionGrouping.RangeList getNoZerosRange() {
        return IPAddressDivisionGrouping.getNoZerosRange();
    }

    /*
     * WARNING - void declaration
     */
    protected static IPAddressDivisionGrouping.RangeList getSingleRange(int index, int len) {
        void var1_1;
        return IPAddressDivisionGrouping.getSingleRange(index, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean isCompatibleNetworks(AddressNetwork<?> one, AddressNetwork<?> two) {
        void var1_1;
        return AddressDivisionGrouping.isCompatibleNetworks(one, var1_1);
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() * this.getBitsPerSegment();
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount() * this.getBytesPerSegment();
    }

    @Override
    protected byte[] getBytesInternal() {
        return super.getBytesInternal();
    }

    public static int bitsPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public static int bytesPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    /*
     * WARNING - void declaration
     */
    protected long longZeroHostCount(int prefixLength, int segCount) {
        if (this.includesZeroHost(prefixLength)) {
            if (this.isMultiple()) {
                void var3_3;
                void var1_1;
                void var2_2;
                int bitsPerSegment = this.getBitsPerSegment();
                int prefixedSegment = IPAddressSection.getNetworkSegmentIndex(prefixLength, this.getBytesPerSegment(), bitsPerSegment);
                long l = IPAddressSection.getLongCount(arg_0 -> this.lambda$longZeroHostCount$0(prefixedSegment, (int)var2_2, (int)var1_1, arg_0), (int)(var3_3 + true));
                return l;
            }
            return 1L;
        }
        return 0L;
    }

    protected abstract BigInteger getZeroHostCountImpl(int var1, int var2);

    protected abstract BigInteger getCountImpl(int var1);

    @Override
    public BigInteger getCountImpl() {
        IPAddressSection iPAddressSection = this;
        return iPAddressSection.getCountImpl(iPAddressSection.getSegmentCount());
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean isPrefixSubnetSegs(IPAddressSegment[] sectionSegments, Integer networkPrefixLength, IPAddressNetwork<?, ?, ?, ?, ?> network, boolean fullRangeOnly) {
        void var3_3;
        void var2_2;
        void var1_1;
        IPAddressSegment[] iPAddressSegmentArray;
        int segmentCount = sectionSegments.length;
        if (segmentCount == 0) {
            return false;
        }
        IPAddressSegment seg = sectionSegments[0];
        return ParsedAddressGrouping.isPrefixSubnet(segmentIndex -> {
            void var1_1;
            return sectionSegments[var1_1].getSegmentValue();
        }, segmentIndex -> {
            void var1_1;
            return iPAddressSegmentArray[var1_1].getUpperSegmentValue();
        }, segmentCount, seg.getByteCount(), seg.getBitCount(), seg.getMaxSegmentValue(), (Integer)var1_1, var2_2.getPrefixConfiguration(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getNetworkSegmentIndex(networkPrefixLength, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        void var2_2;
        void var1_1;
        return ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Integer checkForPrefixMask(boolean network) {
        int front;
        int back;
        int count = this.getSegmentCount();
        if (count == 0) {
            return null;
        }
        int maxval = this.getSegment(0).getMaxSegmentValue();
        if (network) {
            back = 0;
        } else {
            back = front;
            front = 0;
        }
        int prefixLen = 0;
        for (int i = 0; i < count; ++i) {
            void var7_7;
            IPAddressSegment seg = this.getSegment(i);
            int n = seg.getSegmentValue();
            if (n != front) {
                Integer segmentPrefixLen = seg.getBlockMaskPrefixLength(network);
                if (segmentPrefixLen == null) {
                    return null;
                }
                prefixLen += segmentPrefixLen.intValue();
                ++i;
                while (i < count) {
                    n = this.getSegment(i).getSegmentValue();
                    if (n != back) {
                        return null;
                    }
                    ++i;
                }
                continue;
            }
            prefixLen += var7_7.getBitCount();
        }
        return IPAddressSection.cacheBits(prefixLen);
    }

    /*
     * WARNING - void declaration
     */
    public Integer getBlockMaskPrefixLength(boolean network) {
        void var2_2;
        Integer prefixLen;
        if (network) {
            if (this.hasNoPrefixCache() || (prefixLen = this.prefixCache.networkMaskPrefixLen) == null) {
                IPAddressSection iPAddressSection = this;
                prefixLen = iPAddressSection.setNetworkMaskPrefix(iPAddressSection.checkForPrefixMask(network));
            }
        } else if (this.hasNoPrefixCache() || (prefixLen = this.prefixCache.hostMaskPrefixLen) == null) {
            void var1_1;
            IPAddressSection iPAddressSection = this;
            prefixLen = iPAddressSection.setHostMaskPrefix(iPAddressSection.checkForPrefixMask((boolean)var1_1));
        }
        if (prefixLen < 0) {
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Integer setHostMaskPrefix(Integer prefixLen) {
        void var1_1;
        if (prefixLen == null) {
            prefixLen = PrefixCache.access$402(this.prefixCache, NO_PREFIX_LENGTH);
        } else {
            PrefixCache.access$402(this.prefixCache, prefixLen);
            PrefixCache.access$302(this.prefixCache, NO_PREFIX_LENGTH);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer setNetworkMaskPrefix(Integer prefixLen) {
        void var1_1;
        if (prefixLen == null) {
            prefixLen = PrefixCache.access$302(this.prefixCache, NO_PREFIX_LENGTH);
        } else {
            PrefixCache.access$302(this.prefixCache, prefixLen);
            PrefixCache.access$402(this.prefixCache, NO_PREFIX_LENGTH);
        }
        return var1_1;
    }

    protected static Integer cacheBits(int i) {
        return AddressDivisionGrouping.cacheBits(i);
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R getSubnetSegments(R original, Integer networkPrefixLength, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, boolean verifyMask, IntFunction<S> segProducer, IntUnaryOperator segmentMaskProducer, boolean singleOnly) {
        Object object;
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount())) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int count = original.getSegmentCount();
        boolean isAllSubnets = ((IPAddressDivisionGrouping)original).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && !singleOnly;
        for (int i = 0; i < count; ++i) {
            Object zeroSeg;
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i);
            int maskValue = segmentMaskProducer.applyAsInt(i);
            int value = seg.getSegmentValue();
            int upperValue = seg.getUpperSegmentValue();
            if (verifyMask) {
                ParsedIPAddress.Masker masker;
                if (isAllSubnets && segmentPrefixLength != null) {
                    int hostMask = seg.getSegmentHostMask(segmentPrefixLength);
                    maskValue |= hostMask;
                }
                if (!(masker = IPAddressSegment.maskRange(value, upperValue, maskValue, ((AddressDivision)seg).getMaxValue())).isSequential()) {
                    throw new IncompatibleAddressException(seg, "ipaddress.error.maskMismatch");
                }
                value = (int)masker.getMaskedLower(value, maskValue);
                upperValue = (int)masker.getMaskedUpper(upperValue, maskValue);
            } else {
                value &= maskValue;
                upperValue &= maskValue;
            }
            if (!seg.isChangedBy(value, upperValue, segmentPrefixLength)) continue;
            Object[] newSegments = (IPAddressSegment[])creator.createSegmentArray(original.getSegmentCount());
            original.getSegments(0, i, (AddressSegment[])newSegments, 0);
            newSegments[i] = (IPAddressSegment)creator.createSegment(value, upperValue, segmentPrefixLength);
            if (isAllSubnets && segmentPrefixLength != null) {
                if (++i < count) {
                    zeroSeg = (IPAddressSegment)creator.createSegment(0, IPAddressSection.cacheBits(0));
                    Arrays.fill(newSegments, i, count, zeroSeg);
                }
            } else {
                ++i;
                while (i < count) {
                    segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                    seg = (IPAddressSegment)segProducer.apply(i);
                    maskValue = segmentMaskProducer.applyAsInt(i);
                    value = seg.getSegmentValue();
                    upperValue = seg.getUpperSegmentValue();
                    if (verifyMask) {
                        Object masker;
                        if (isAllSubnets && segmentPrefixLength != null) {
                            int hostMask = seg.getSegmentHostMask(segmentPrefixLength);
                            maskValue |= hostMask;
                        }
                        if (!((ParsedIPAddress.Masker)(masker = IPAddressSegment.maskRange(value, upperValue, maskValue, ((AddressDivision)seg).getMaxValue()))).isSequential()) {
                            throw new IncompatibleAddressException(seg, "ipaddress.error.maskMismatch");
                        }
                        value = (int)((ParsedIPAddress.Masker)masker).getMaskedLower(value, maskValue);
                        upperValue = (int)((ParsedIPAddress.Masker)masker).getMaskedUpper(upperValue, maskValue);
                    } else {
                        value &= maskValue;
                        upperValue &= maskValue;
                    }
                    newSegments[i] = seg.isChangedBy(value, upperValue, segmentPrefixLength) ? (IPAddressSegment)creator.createSegment(value, upperValue, segmentPrefixLength) : seg;
                    if (isAllSubnets && segmentPrefixLength != null) {
                        if (++i >= count) break;
                        zeroSeg = (IPAddressSegment)creator.createSegment(0, IPAddressSection.cacheBits(0));
                        Arrays.fill(newSegments, i, count, object);
                        break;
                    }
                    ++i;
                }
            }
            return (R)creator.createPrefixedSectionInternal((IPAddressSegment[])newSegments, networkPrefixLength, singleOnly);
        }
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    protected static void checkSubnet(AddressDivisionSeries series, int prefixLength) throws PrefixLenException {
        void var1_1;
        AddressDivisionGrouping.checkSubnet(series, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        return AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, (Integer)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getSegmentPrefixLength(int bitsPerSegment, int segmentPrefixedBits) {
        void var1_1;
        return AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getPrefixedSegmentPrefixLength(int bitsPerSegment, int prefixLength, int segmentIndex) {
        void var2_2;
        void var1_1;
        return AddressDivisionGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends IPAddressSection, S extends IPAddressSegment> R createLowestOrHighestSection(R section, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, Supplier<Iterator<S[]>> nonZeroHostIteratorSupplier, IntFunction<S> segProducer, boolean lowest, boolean excludeZeroHost) {
        boolean create = true;
        IPAddressSection result = null;
        IPAddressSegment[] segs = null;
        if (lowest && excludeZeroHost && ((IPAddressDivisionGrouping)section).includesZeroHost()) {
            Iterator<S[]> it = nonZeroHostIteratorSupplier.get();
            if (!it.hasNext()) {
                create = false;
            } else {
                segs = (IPAddressSegment[])it.next();
            }
        } else {
            void var3_3;
            segs = (IPAddressSegment[])IPAddressSection.createSingle(section, creator, (IntFunction)var3_3);
        }
        if (create) {
            void var2_2;
            void var1_1;
            R r;
            Integer prefLength;
            result = ((IPAddressDivisionGrouping)section).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() || (prefLength = r.getNetworkPrefixLength()) == null ? creator.createSectionInternal(segs) : var1_1.createPrefixedSectionInternal(segs, (Integer)var2_2, true);
        }
        return (R)result;
    }

    @Override
    public int getSegmentCount() {
        return this.getDivisionCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPAddressSegment getSegment(int index) {
        void var1_1;
        return this.getSegmentsInternal()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPAddressSegment getDivision(int index) {
        void var1_1;
        return this.getSegmentsInternal()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int prefixLength) {
        IPAddressSection.checkSubnet(this, prefixLength);
        boolean isAllSubnets = ((IPAddressDivisionGrouping)this).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (isAllSubnets && this.isPrefixed() && this.getNetworkPrefixLength() <= prefixLength) {
            return true;
        }
        int divCount = this.getDivisionCount();
        int bitsPerSegment = this.getBitsPerSegment();
        int i = IPAddressSection.getHostSegmentIndex(prefixLength, this.getBytesPerSegment(), bitsPerSegment);
        if (i < divCount) {
            void var1_1;
            IPAddressSegment div = this.getDivision(i);
            int segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, prefixLength, i);
            if (!div.containsPrefixBlock((int)var1_1)) {
                return false;
            }
            if (isAllSubnets && div.isPrefixed()) {
                return true;
            }
            ++i;
            while (i < divCount) {
                div = this.getDivision(i);
                if (!div.isFullRange()) {
                    return false;
                }
                if (isAllSubnets && div.isPrefixed()) {
                    return true;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean contains(AddressSection other) {
        int count = this.getSegmentCount();
        if (count != other.getSegmentCount()) {
            return false;
        }
        boolean bl = this.isPrefixed() && ((IPAddressDivisionGrouping)this).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        int i = bl ? IPAddressSection.getNetworkSegmentIndex(this.getNetworkPrefixLength(), this.getBytesPerSegment(), this.getBitsPerSegment()) : count - 1;
        for (i = i; i >= 0; --i) {
            IPAddressSegment iPAddressSegment = this.getSegment(i);
            if (iPAddressSegment.contains(other.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        if (((IPAddressDivisionGrouping)this).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            for (int i = 0; i < divCount; ++i) {
                Integer n;
                IPAddressSegment div = this.getSegment(i);
                if (!div.isFullRange()) {
                    return false;
                }
                if ((n = ((IPAddressSegment)((Object)n)).getSegmentPrefixLength()) == null) {
                    continue;
                }
                break;
            }
        } else {
            return super.isFullRange();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkMaskSegmentCount(IPAddressSection mask) throws SizeMismatchException {
        if (mask.getSegmentCount() < this.getSegmentCount()) {
            void var1_1;
            throw new SizeMismatchException(this, (AddressItem)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean includesZeroHost() {
        void var1_1;
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return false;
        }
        return this.includesZeroHost(var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public boolean includesZeroHost(int networkPrefixLength) {
        void i;
        if (networkPrefixLength < 0 || networkPrefixLength > this.getBitCount()) {
            throw new PrefixLenException((AddressItem)this, networkPrefixLength);
        }
        if (((IPAddressDivisionGrouping)this).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && this.isPrefixed() && this.getNetworkPrefixLength() <= networkPrefixLength) {
            return true;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int bytesPerSegment = this.getBytesPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
        int divCount = this.getSegmentCount();
        while (i < divCount) {
            IPAddressSegment div = this.getSegment((int)i);
            Integer segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, (int)i);
            if (segmentPrefixLength != null) {
                int n = div.getSegmentHostMask(segmentPrefixLength);
                if (((long)n & ((AddressDivision)div).getDivisionValue()) != 0L) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    IPAddressSegment iPAddressSegment = this.getSegment((int)i);
                    if (!((AddressDivision)iPAddressSegment).includesZero()) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSingleNetwork() {
        void var2_2;
        void var1_1;
        void var3_5;
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return !this.isMultiple();
        }
        int prefixedSegmentIndex = IPAddressSection.getNetworkSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), this.getBitsPerSegment());
        if (prefixedSegmentIndex < 0) {
            return true;
        }
        for (int i = 0; i < prefixedSegmentIndex; ++i) {
            IPAddressSegment iPAddressSegment = this.getSegment(i);
            if (!((AddressDivision)iPAddressSegment).isMultiple()) continue;
            return false;
        }
        IPAddressSegment div = this.getSegment(prefixedSegmentIndex);
        int differing = div.getSegmentValue() ^ div.getUpperSegmentValue();
        if (differing == 0) {
            return true;
        }
        int bitsPerSegment = div.getBitCount();
        int highestDifferingBitInRange = Integer.numberOfLeadingZeros(differing) - (32 - bitsPerSegment);
        return IPAddressSection.getSegmentPrefixLength((int)var3_5, (Integer)var1_1, (int)var2_2) <= highestDifferingBitInRange;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R toPrefixBlock(R original, int networkPrefixLength, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> creator, SegFunction<Integer, S> segProducer) {
        void var2_3;
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        if (original.isNetworkSubnet(networkPrefixLength)) {
            return original;
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int segmentCount = original.getSegmentCount();
        IPAddressSegment[] result = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            Integer prefix = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            result[i] = (IPAddressSegment)segProducer.apply(prefix, i);
        }
        return (R)var2_3.createSectionInternal(result);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isNetworkSubnet(int networkPrefixLength) {
        void last2;
        void var3_4;
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), bitsPerSegment);
        if (prefixedSegmentIndex >= segmentCount) {
            if (networkPrefixLength == this.getBitCount()) {
                IPAddressSegment last2 = this.getSegment(segmentCount - 1);
                return !last2.isNetworkChangedByPrefixNonNull(last2.getBitCount());
            }
            return true;
        }
        int segPrefLength = IPAddressSection.getPrefixedSegmentPrefixLength((int)var3_4, (int)last2, prefixedSegmentIndex);
        if (this.getSegment(prefixedSegmentIndex).isNetworkChangedByPrefixNonNull(segPrefLength)) {
            return false;
        }
        if (!((IPAddressDivisionGrouping)this).getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            for (int i = prefixedSegmentIndex + 1; i < segmentCount; ++i) {
                if (this.getSegment(i).isFullRange()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static <R extends IPAddressSection, S extends IPAddressSegment> R removePrefixLength(R original, boolean zeroed, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, SegFunction<R, S> segProducer) throws IncompatibleAddressException {
        void var3_3;
        R r;
        void var1_1;
        void var2_2;
        if (!original.isPrefixed()) {
            return original;
        }
        IPAddressNetwork<?, R, ?, S, ?> iPAddressNetwork = creator.getNetwork();
        R mask = iPAddressNetwork.getNetworkMaskSection(zeroed ? ((AddressDivisionGroupingBase)original).getPrefixLength().intValue() : original.getBitCount());
        return IPAddressSection.getSubnetSegments(original, null, var2_2, (boolean)var1_1, i -> {
            void var2_2;
            void var1_1;
            return (IPAddressSegment)segProducer.apply(var1_1, (int)var2_2);
        }, arg_0 -> IPAddressSection.lambda$removePrefixLength$10((SegFunction)var3_3, mask, arg_0), false);
    }

    private boolean hasNoPrefixCache() {
        if (this.prefixCache == null) {
            IPAddressSection iPAddressSection = this;
            synchronized (iPAddressSection) {
                if (this.prefixCache == null) {
                    this.prefixCache = new PrefixCache();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMinPrefixLengthForBlock() {
        void var1_1;
        Integer result;
        if (this.hasNoPrefixCache() || (result = this.prefixCache.cachedMinPrefix) == null) {
            result = IPAddressSection.cacheBits(super.getMinPrefixLengthForBlock());
            PrefixCache.access$002(this.prefixCache, result);
        }
        return var1_1.intValue();
    }

    protected IPAddressSegment[] getSegmentsInternal() {
        return (IPAddressSegment[])this.getDivisionsInternal();
    }

    /*
     * WARNING - void declaration
     */
    public void getSegments(int start, int end, AddressSegment[] segs, int destIndex) {
        void var1_1;
        void var2_2;
        void var3_3;
        System.arraycopy(this.getDivisionsInternal(), start, var3_3, destIndex, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createEmbeddedSection(IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> creator, S[] segs, IPAddressSection encompassingSection) {
        void var1_1;
        void var2_2;
        return (R)creator.createEmbeddedSectionInternal((IPAddressSection)var2_2, (IPAddressSegment[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <S extends AddressSegment> Iterator<S[]> iterator(int divCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, IntFunction<Iterator<S>> segIteratorProducer, int networkSegmentIndex, int hostSegmentIndex, IntFunction<Iterator<S>> prefixedSegIteratorProducer) {
        void var3_3;
        void var2_2;
        void var1_1;
        return IPAddressSection.segmentsIterator(divCount, var1_1, null, var2_2, null, (int)var3_3, hostSegmentIndex, prefixedSegIteratorProducer);
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Address, S extends AddressSegment> Iterator<T> iterator(T original, AddressCreator<T, ?, ?, S> creator, Iterator<S[]> iterator) {
        void var2_2;
        void var1_1;
        T t;
        return IPAddressSection.iterator(original != null, t, var1_1, (Iterator<S[]>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    protected <S extends IPAddressSegment> boolean isZeroHost(S[] segments, int prefixLength) {
        void var1_1;
        return IPAddressSection.isZeroHost((int)prefixLength, (IPAddressSegment[])var1_1, (int)this.getBytesPerSegment(), (int)this.getBitsPerSegment(), (int)this.getBitCount());
    }

    protected static <S extends IPAddressSegment> boolean isZeroHost(int prefLen, S[] segments, int bytesPerSegment, int bitsPerSegment, int bitCount) {
        int prefixedSegmentIndex;
        if (segments.length == 0) {
            return false;
        }
        if (prefLen >= bitCount) {
            return false;
        }
        int divCount = segments.length;
        for (int i = prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(prefLen, bytesPerSegment, bitsPerSegment); i < divCount; ++i) {
            Integer segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, prefLen, prefixedSegmentIndex);
            S div = segments[i];
            if (segmentPrefixLength == null) continue;
            int mask = ((IPAddressSegment)div).getSegmentHostMask(segmentPrefixLength);
            if (((AddressDivision)div).isMultiple() || (mask & ((IPAddressSegment)div).getSegmentValue()) != 0) {
                return false;
            }
            ++i;
            while (i < divCount) {
                S s = segments[i];
                if (!((AddressDivision)s).isZero()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }

    public String[] getSegmentStrings() {
        return this.getDivisionStrings();
    }

    protected abstract boolean hasNoStringCache();

    public String toNormalizedString(IPStringOptions stringOptions) {
        return IPAddressSection.toNormalizedString(stringOptions, this);
    }

    /*
     * WARNING - void declaration
     */
    public static String toNormalizedString(IPStringOptions opts, IPAddressStringDivisionSeries section) {
        void var1_1;
        return IPAddressSection.toIPParams(opts).toString((IPAddressStringDivisionSeries)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static AddressDivisionGroupingBase.IPAddressStringParams<IPAddressStringDivisionSeries> toIPParams(IPStringOptions opts) {
        void var1_1;
        AddressDivisionGroupingBase.IPAddressStringParams result = (AddressDivisionGroupingBase.IPAddressStringParams)IPAddressSection.getCachedParams(opts);
        if (result == null) {
            IPStringOptions iPStringOptions;
            result = new AddressDivisionGroupingBase.IPAddressStringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcards(opts.wildcards);
            result.setWildcardOption(opts.wildcardOption);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressSuffix(opts.addrSuffix);
            result.setAddressLabel(opts.addrLabel);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            result.setZoneSeparator(opts.zoneSeparator);
            IPAddressSection.setCachedParams(iPStringOptions, result);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$removePrefixLength$10(SegFunction segProducer, IPAddressSection mask, int i) {
        void var2_2;
        void var1_1;
        return ((IPAddressSegment)segProducer.apply(var1_1, (int)var2_2)).getSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int lambda$longZeroHostCount$0(int prefixedSegment, int bitsPerSegment, int prefixLength, int i) {
        if (i == prefixedSegment) {
            void var2_4;
            void var1_2;
            void var3_5;
            IPAddressSegment seg = this.getSegment(i);
            int shift = seg.getBitCount() - IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, (int)var3_5, i);
            int n = (seg.getUpperSegmentValue() >>> shift) - (var1_2.getSegmentValue() >>> var2_4) + 1;
            return n;
        }
        return this.getSegment(i).getValueCount();
    }

    public static class IPStringOptions
    extends AddressDivisionGrouping.StringOptions {
        public final String addrSuffix;
        public final WildcardOptions.WildcardOption wildcardOption;
        public final char zoneSeparator;

        /*
         * WARNING - void declaration
         */
        protected IPStringOptions(int base, boolean expandSegments, WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, char zoneSeparator, String label, String suffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super((int)var1_1, (boolean)var2_2, wildcards, segmentStrPrefix, separator, label, reverse, splitDigits, uppercase);
            void var3_3;
            void var2_2;
            void var1_1;
            this.addrSuffix = suffix;
            this.wildcardOption = var3_3;
            this.zoneSeparator = zoneSeparator;
        }

        public static class Builder
        extends AddressDivisionGrouping.StringOptions.Builder {
            protected String addrSuffix = "";
            protected WildcardOptions.WildcardOption wildcardOption = WildcardOptions.WildcardOption.NETWORK_ONLY;
            protected char zoneSeparator = (char)37;

            /*
             * WARNING - void declaration
             */
            public Builder(int base) {
                this((int)var1_1, ' ');
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            protected Builder(int base, char separator) {
                super((int)var1_1, (char)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setWildcards(AddressDivisionGrouping.StringOptions.Wildcards wildcards) {
                void var1_1;
                return (Builder)super.setWildcards((AddressDivisionGrouping.StringOptions.Wildcards)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public Builder setAddressSuffix(String suffix) {
                void var1_1;
                this.addrSuffix = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setWildcardOptions(WildcardOptions wildcardOptions) {
                void var1_1;
                this.setWildcardOption(wildcardOptions.wildcardOption);
                return this.setWildcards(var1_1.wildcards);
            }

            /*
             * WARNING - void declaration
             */
            public Builder setWildcardOption(WildcardOptions.WildcardOption wildcardOption) {
                void var1_1;
                this.wildcardOption = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setReverse(boolean reverse) {
                void var1_1;
                return (Builder)super.setReverse((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setSplitDigits(boolean splitDigits) {
                void var1_1;
                return (Builder)super.setSplitDigits((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setExpandedSegments(boolean expandSegments) {
                void var1_1;
                return (Builder)super.setExpandedSegments((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setRadix(int base) {
                void var1_1;
                return (Builder)super.setRadix((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setSeparator(Character separator) {
                void var1_1;
                return (Builder)super.setSeparator((Character)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public Builder setZoneSeparator(char separator) {
                void var1_1;
                this.zoneSeparator = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setAddressLabel(String label) {
                void var1_1;
                return (Builder)super.setAddressLabel((String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setSegmentStrPrefix(String prefix) {
                void var1_1;
                return (Builder)super.setSegmentStrPrefix((String)var1_1);
            }

            @Override
            public IPStringOptions toOptions() {
                return new IPStringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.separator, this.zoneSeparator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    public static class WildcardOptions {
        public final WildcardOption wildcardOption;
        public final AddressDivisionGrouping.StringOptions.Wildcards wildcards;

        public WildcardOptions() {
            this(WildcardOption.NETWORK_ONLY);
        }

        /*
         * WARNING - void declaration
         */
        public WildcardOptions(WildcardOption wildcardOption) {
            this((WildcardOption)var1_1, new AddressDivisionGrouping.StringOptions.Wildcards());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public WildcardOptions(WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards) {
            void var2_2;
            void var1_1;
            this.wildcardOption = var1_1;
            this.wildcards = var2_2;
        }

        public static final class WildcardOption
        extends Enum<WildcardOption> {
            public static final /* enum */ WildcardOption NETWORK_ONLY = new WildcardOption();
            public static final /* enum */ WildcardOption ALL = new WildcardOption();
            private static final /* synthetic */ WildcardOption[] $VALUES;

            static {
                $VALUES = new WildcardOption[]{NETWORK_ONLY, ALL};
            }
        }
    }

    protected static class IPStringCache
    extends AddressDivisionGrouping.StringCache {
        public static final IPStringOptions hexParams;
        public static final IPStringOptions hexPrefixedParams;
        public static final IPStringOptions octalParams;
        public static final IPStringOptions octalPrefixedParams;
        public static final IPStringOptions binaryParams;
        public static final IPStringOptions canonicalSegmentParams;
        public String normalizedWildcardString;

        protected IPStringCache() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            WildcardOptions allWildcards = new WildcardOptions(WildcardOptions.WildcardOption.ALL);
            hexParams = new IPStringOptions.Builder(16).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).toOptions();
            hexPrefixedParams = new IPStringOptions.Builder(16).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).setAddressLabel("0x").toOptions();
            octalParams = new IPStringOptions.Builder(8).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).toOptions();
            octalPrefixedParams = new IPStringOptions.Builder(8).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).setAddressLabel("0").toOptions();
            binaryParams = new IPStringOptions.Builder(2).setSeparator(null).setExpandedSegments(true).setWildcardOptions((WildcardOptions)var0).toOptions();
            canonicalSegmentParams = new IPStringOptions.Builder(10, ' ').toOptions();
        }
    }

    static class IPAddressSeqRangeSpliterator<S extends AddressComponentRange, T>
    extends AddressDivisionGroupingBase.AddressItemRangeSpliterator<S, T>
    implements IPAddressSeqRange.IPAddressSeqRangeSplitterSink<S, T> {
        final Predicate<IPAddressSeqRange.IPAddressSeqRangeSplitterSink<S, T>> splitter;

        /*
         * WARNING - void declaration
         */
        IPAddressSeqRangeSpliterator(S forIteration, Predicate<IPAddressSeqRange.IPAddressSeqRangeSplitterSink<S, T>> splitter, SeqRangeIteratorProvider<S, T> iteratorProvider, ToLongFunction<S> longSizer) {
            super(var1_1, null, var3_3, null, null, longSizer);
            void var2_2;
            void var3_3;
            void var1_1;
            this.splitter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        IPAddressSeqRangeSpliterator(S forIteration, Predicate<IPAddressSeqRange.IPAddressSeqRangeSplitterSink<S, T>> splitter, SeqRangeIteratorProvider<S, T> iteratorProvider, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
            super(var1_1, null, var3_3, sizer, downSizer, longSizer);
            void var2_2;
            void var3_3;
            void var1_1;
            this.splitter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        IPAddressSeqRangeSpliterator(S forIteration, Predicate<IPAddressSeqRange.IPAddressSeqRangeSplitterSink<S, T>> splitter, SeqRangeIteratorProvider<S, T> iteratorProvider, boolean isLowest, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
            super(var1_1, null, var3_3, isLowest, false, sizer, downSizer, longSizer);
            void var2_2;
            void var3_3;
            void var1_1;
            this.splitter = var2_2;
        }

        @Override
        protected boolean split() {
            return this.splitter.test(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPAddressSeqRangeSpliterator<S, T> createSpliterator(S split, boolean isLowest, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPAddressSeqRangeSpliterator<void, T>(var1_1, this.splitter, (SeqRangeIteratorProvider)this.iteratorProvider, (boolean)var2_2, (Function<void, BigInteger>)var3_3, (Predicate<void>)downSizer, (ToLongFunction<void>)longSizer);
        }
    }

    @FunctionalInterface
    static interface SeqRangeIteratorProvider<S, T>
    extends AddressDivisionGroupingBase.IteratorProvider<S, T> {
    }

    @FunctionalInterface
    public static interface SegFunction<R, S> {
        public S apply(R var1, int var2);
    }

    protected static class PrefixCache {
        private Integer networkMaskPrefixLen;
        private Integer hostMaskPrefixLen;
        private Integer cachedMinPrefix;
        private Integer cachedEquivalentPrefix;
        private Boolean cachedIsSinglePrefixBlock;

        protected PrefixCache() {
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Integer access$002(PrefixCache x0, Integer x1) {
            void var1_1;
            x0.cachedMinPrefix = var1_1;
            return x0.cachedMinPrefix;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Boolean access$102(PrefixCache x0, Boolean x1) {
            void var1_1;
            x0.cachedIsSinglePrefixBlock = var1_1;
            return x0.cachedIsSinglePrefixBlock;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Integer access$202(PrefixCache x0, Integer x1) {
            void var1_1;
            x0.cachedEquivalentPrefix = var1_1;
            return x0.cachedEquivalentPrefix;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Integer access$402(PrefixCache x0, Integer x1) {
            void var1_1;
            x0.hostMaskPrefixLen = var1_1;
            return x0.hostMaskPrefixLen;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Integer access$302(PrefixCache x0, Integer x1) {
            void var1_1;
            x0.networkMaskPrefixLen = var1_1;
            return x0.networkMaskPrefixLen;
        }
    }
}

