/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressComponent;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.IPAddressDivisionGrouping;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class IPAddressNetwork<T extends IPAddress, R extends IPAddressSection, E extends IPAddressSection, S extends IPAddressSegment, J extends InetAddress>
extends AddressNetwork<S> {
    private final T[] subnetsMasksWithPrefix;
    private final T[] subnetMasks;
    private final T[] networkAddresses;
    private final T[] hostMasks;
    private final int[] networkSegmentMasks;
    private final int[] hostSegmentMasks;
    private transient T loopback;
    private IPAddressCreator<T, R, E, S, J> creator;

    protected IPAddressNetwork(Class<T> addressType) {
        IPAddress.IPVersion version = this.getIPVersion();
        int bitSize = IPAddress.getBitCount(version);
        this.subnetsMasksWithPrefix = (IPAddress[])Array.newInstance(addressType, bitSize + 1);
        this.subnetMasks = (IPAddress[])this.subnetsMasksWithPrefix.clone();
        this.networkAddresses = (IPAddress[])this.subnetsMasksWithPrefix.clone();
        this.hostMasks = (IPAddress[])this.subnetsMasksWithPrefix.clone();
        this.creator = this.createAddressCreator();
        int segmentBitSize = IPAddressSegment.getBitCount(version);
        int fullMask = ~(-1 << segmentBitSize);
        this.networkSegmentMasks = new int[segmentBitSize + 1];
        this.hostSegmentMasks = (int[])this.networkSegmentMasks.clone();
        for (int i = 0; i <= segmentBitSize; ++i) {
            int n = fullMask;
            int networkMask = this.networkSegmentMasks[i] = n & n << segmentBitSize - i;
            this.hostSegmentMasks[i] = ~networkMask & fullMask;
        }
    }

    public abstract IPAddress.IPVersion getIPVersion();

    protected abstract BiFunction<T, Integer, S> getSegmentProducer();

    protected abstract Function<T, R> getSectionProducer();

    protected abstract IPAddressCreator<T, R, E, S, J> createAddressCreator();

    public IPAddressCreator<T, R, E, S, J> getAddressCreator() {
        return this.creator;
    }

    public T getLoopback() {
        if (this.loopback == null) {
            IPAddressNetwork iPAddressNetwork = this;
            synchronized (iPAddressNetwork) {
                if (this.loopback == null) {
                    this.loopback = this.createLoopback();
                }
            }
        }
        return this.loopback;
    }

    protected abstract T createLoopback();

    /*
     * WARNING - void declaration
     */
    public int getSegmentNetworkMask(int segmentPrefixLength) {
        void var1_1;
        return this.networkSegmentMasks[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int getSegmentHostMask(int segmentPrefixLength) {
        void var1_1;
        return this.hostSegmentMasks[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public T getNetworkMask(int networkPrefixLength) {
        void var1_1;
        return this.getNetworkMask((int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public T getNetworkAddress(int networkPrefixLength) {
        void var1_1;
        return (T)this.getMask((int)var1_1, (IPAddress[])this.networkAddresses, true, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public T getNetworkMask(int networkPrefixLength, boolean withPrefixLength) {
        void var2_2;
        void var1_1;
        return (T)this.getMask((int)var1_1, (IPAddress[])(withPrefixLength ? this.subnetsMasksWithPrefix : this.subnetMasks), true, (boolean)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public R getNetworkMaskSection(int networkPrefixLength) {
        void var1_1;
        return (R)((IPAddressSection)this.getSectionProducer().apply(this.getNetworkMask((int)var1_1, true)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T getMask(int networkPrefixLength, T[] cache, boolean network, boolean withPrefixLength, boolean networkAddress) {
        AddressComponent lastSegment;
        AddressComponent segment;
        void var13_17;
        int zerosSubnetIndex;
        int onesSubnetIndex;
        IPAddress iPAddress;
        int bits = networkPrefixLength;
        IPAddress.IPVersion version = this.getIPVersion();
        int addressBitLength = IPAddress.getBitCount(version);
        if (bits < 0) throw new PrefixLenException(bits, version);
        if (bits > addressBitLength) {
            throw new PrefixLenException(bits, version);
        }
        int cacheIndex = bits;
        void subnet = cache[cacheIndex];
        if (subnet != null) return (T)iPAddress;
        if (network != false) {
            onesSubnetIndex = addressBitLength;
            zerosSubnetIndex = 0;
        } else {
            onesSubnetIndex = 0;
            zerosSubnetIndex = addressBitLength;
        }
        void onesSubnet = cache[onesSubnetIndex];
        void zerosSubnet = cache[zerosSubnetIndex];
        if (onesSubnet == null || zerosSubnet == null) {
            var13_17 = cache;
            synchronized (var13_17) {
                Object[] newSegments;
                AddressCreator creator;
                int segmentCount = IPAddress.getSegmentCount(version);
                int bitsPerSegment = IPAddress.getBitsPerSegment(version);
                int bytesPerSegment = IPAddress.getBytesPerSegment(version);
                onesSubnet = cache[onesSubnetIndex];
                if (onesSubnet == null) {
                    creator = this.getAddressCreator();
                    newSegments = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
                    int maxSegmentValue = IPAddress.getMaxSegmentValue(version);
                    if (network != false && withPrefixLength != false) {
                        segment = (IPAddressSegment)creator.createSegment(maxSegmentValue, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, addressBitLength));
                        Arrays.fill(newSegments, 0, newSegments.length - 1, segment);
                        int n = bitsPerSegment;
                        lastSegment = (IPAddressSegment)creator.createSegment(maxSegmentValue, IPAddressSection.getSegmentPrefixLength(n, n));
                        newSegments[newSegments.length - 1] = lastSegment;
                        segment = creator.createAddressInternal((IPAddressSegment[])newSegments, IPAddressNetwork.cacheBits(addressBitLength));
                    } else {
                        segment = (IPAddressSegment)creator.createSegment(maxSegmentValue);
                        Arrays.fill(newSegments, segment);
                        segment = creator.createAddressInternal((IPAddressSegment[])newSegments);
                    }
                    this.initMaskCachedValues(((IPAddress)segment).getSection(), (boolean)network, (boolean)withPrefixLength, (boolean)networkAddress, addressBitLength, onesSubnetIndex, segmentCount, bitsPerSegment, bytesPerSegment);
                    cache[onesSubnetIndex] = segment;
                }
                if ((lastSegment = cache[zerosSubnetIndex]) == null) {
                    IPAddressSegment seg;
                    creator = this.getAddressCreator();
                    newSegments = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
                    if (network != false && withPrefixLength != false) {
                        seg = (IPAddressSegment)creator.createSegment(0, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, 0));
                        Arrays.fill(newSegments, seg);
                        lastSegment = creator.createAddressInternal((IPAddressSegment[])newSegments, IPAddressNetwork.cacheBits(0));
                        if (this.getPrefixConfiguration().zeroHostsAreSubnets() && networkAddress == false) {
                            lastSegment = ((IPAddress)lastSegment).getLower();
                        }
                    } else {
                        seg = (IPAddressSegment)creator.createSegment(0);
                        Arrays.fill(newSegments, seg);
                        lastSegment = creator.createAddressInternal((IPAddressSegment[])newSegments);
                    }
                    this.initMaskCachedValues(((IPAddress)lastSegment).getSection(), (boolean)network, (boolean)withPrefixLength, (boolean)networkAddress, addressBitLength, zerosSubnetIndex, segmentCount, bitsPerSegment, bytesPerSegment);
                    cache[zerosSubnetIndex] = lastSegment;
                }
            }
        }
        var13_17 = cache;
        synchronized (var13_17) {
            void var3_3;
            void onesSubnetIndex2 = cache[cacheIndex];
            if (onesSubnetIndex2 != null) return (T)iPAddress;
            BiFunction<void, Integer, S> segProducer = this.getSegmentProducer();
            int segmentCount = IPAddress.getSegmentCount(version);
            int bitsPerSegment = IPAddress.getBitsPerSegment(version);
            int bytesPerSegment = IPAddress.getBytesPerSegment(version);
            int prefix = bits;
            IPAddressSegment onesSegment = (IPAddressSegment)segProducer.apply((void)segment, 0);
            IPAddressSegment zerosSegment = (IPAddressSegment)segProducer.apply((void)lastSegment, 0);
            AddressCreator creator = this.getAddressCreator();
            ArrayList<IPAddressSegment> segmentList = new ArrayList<IPAddressSegment>(segmentCount);
            int i = 0;
            while (bits > 0) {
                if (bits > bitsPerSegment) {
                    segmentList.add(network != false ? onesSegment : zerosSegment);
                } else {
                    IPAddressSegment segment2 = null;
                    int offset = (bits - 1) % bitsPerSegment + 1;
                    int entry = offset;
                    for (int j = 0; j < segmentCount; ++j, entry += bitsPerSegment) {
                        void prev;
                        if (entry == cacheIndex || (prev = cache[entry]) == null) continue;
                        segment2 = (IPAddressSegment)segProducer.apply(prev, j);
                        break;
                    }
                    if (segment2 == null) {
                        int mask = this.getSegmentNetworkMask(bits);
                        segment2 = network != false ? (withPrefixLength != false ? (IPAddressSegment)creator.createSegment(mask, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bits)) : (IPAddressSegment)creator.createSegment(mask)) : (IPAddressSegment)creator.createSegment(this.getSegmentHostMask(bits));
                    }
                    segmentList.add(segment2);
                }
                ++i;
                bits -= bitsPerSegment;
            }
            while (i < segmentCount) {
                segmentList.add(network != false ? zerosSegment : onesSegment);
                ++i;
            }
            IPAddressSegment[] newSegments = (IPAddressSegment[])creator.createSegmentArray(segmentList.size());
            segmentList.toArray(newSegments);
            if (network != false && withPrefixLength != false) {
                iPAddress = creator.createAddressInternal(newSegments, IPAddressNetwork.cacheBits(prefix));
                if (this.getPrefixConfiguration().zeroHostsAreSubnets() && networkAddress == false) {
                    iPAddress = iPAddress.getLower();
                }
            } else {
                iPAddress = creator.createAddressInternal(newSegments);
            }
            this.initMaskCachedValues(iPAddress.getSection(), (boolean)var3_3, (boolean)withPrefixLength, (boolean)networkAddress, addressBitLength, prefix, segmentCount, bitsPerSegment, bytesPerSegment);
            var2_2[cacheIndex] = iPAddress;
            return (T)iPAddress;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initMaskCachedValues(IPAddressSection section, boolean network, boolean withPrefixLength, boolean networkAddress, int addressBitLength, int networkPrefixLength, int segmentCount, int bitsPerSegment, int bytesPerSegment) {
        void var3_4;
        void var2_2;
        void var1_1;
        BigInteger cachedCount2;
        Integer cachedNetworkPrefix;
        Integer cachedEquivalentPrefix;
        Integer cachedMinPrefix;
        IPAddressDivisionGrouping.RangeList zeroSegments;
        IPAddressDivisionGrouping.RangeList zeroRanges;
        boolean hasZeroRanges = network ? addressBitLength - networkPrefixLength >= bitsPerSegment : networkPrefixLength >= bitsPerSegment;
        IPAddressDivisionGrouping.RangeList noZeros = IPAddressSection.getNoZerosRange();
        if (hasZeroRanges) {
            int rangeLen;
            int rangeIndex;
            int segmentIndex;
            if (network) {
                rangeIndex = segmentIndex = IPAddressSection.getNetworkSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment) + 1;
                rangeLen = segmentCount - segmentIndex;
            } else {
                rangeIndex = 0;
                rangeLen = IPAddressSection.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, segmentIndex);
            }
            zeroRanges = IPAddressSection.getSingleRange(rangeIndex, rangeLen);
            zeroSegments = network && withPrefixLength && !this.getPrefixConfiguration().prefixedSubnetsAreExplicit() ? noZeros : zeroRanges;
        } else {
            zeroSegments = zeroRanges = noZeros;
        }
        Integer npl = IPAddressNetwork.cacheBits(networkPrefixLength);
        if (network && withPrefixLength) {
            if (this.getPrefixConfiguration().prefixedSubnetsAreExplicit() || this.getPrefixConfiguration().zeroHostsAreSubnets() && !networkAddress) {
                cachedEquivalentPrefix = cachedMinPrefix = IPAddressNetwork.cacheBits(addressBitLength);
                cachedNetworkPrefix = npl;
                cachedCount2 = BigInteger.ONE;
            } else {
                void cachedCount;
                cachedMinPrefix = cachedNetworkPrefix = npl;
                cachedEquivalentPrefix = cachedNetworkPrefix;
                cachedCount2 = BigInteger.valueOf(2L).pow((int)(cachedCount - networkPrefixLength));
            }
        } else {
            cachedEquivalentPrefix = cachedMinPrefix = IPAddressNetwork.cacheBits((int)cachedCount);
            cachedNetworkPrefix = null;
            cachedCount2 = BigInteger.ONE;
        }
        var1_1.initCachedValues(npl, (boolean)var2_2, (Integer)var3_4, cachedMinPrefix, cachedEquivalentPrefix, cachedCount2, zeroSegments, zeroRanges);
    }

    protected static Integer cacheBits(int i) {
        return IPAddressSection.cacheBits(i);
    }

    public static String getPrefixString(int networkPrefixLength) {
        int n;
        return new StringBuilder(HostIdentifierStringValidator.MAX_PREFIX_CHARS + 1).append('/').append(n).toString();
    }

    public static abstract class IPAddressCreator<T extends IPAddress, R extends IPAddressSection, E extends IPAddressSection, S extends IPAddressSegment, J extends InetAddress>
    extends AddressCreator<T, R, E, S> {
        private IPAddressNetwork<T, R, E, S, J> owner;

        /*
         * WARNING - void declaration
         */
        protected IPAddressCreator(IPAddressNetwork<T, R, E, S, J> owner) {
            void var1_1;
            this.owner = var1_1;
        }

        public IPAddressNetwork<T, R, E, S, J> getNetwork() {
            return this.owner;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected S createSegmentInternal(int value, Integer segmentPrefixLength, CharSequence addressStr, int originalVal, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex) {
            void var1_2;
            void var3_4;
            void var2_3;
            IPAddressSegment segment = (IPAddressSegment)this.createSegment(value, (Integer)var2_3);
            segment.setStandardString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            segment.setWildcardString((CharSequence)var3_4, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected S createRangeSegmentInternal(int lower, int upper, Integer segmentPrefixLength, CharSequence addressStr, int originalLower, int originalUpper, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex) {
            void var1_2;
            void var3_4;
            void var2_3;
            IPAddressSegment segment = (IPAddressSegment)this.createSegment(lower, (int)var2_3, (Integer)var3_4);
            segment.setStandardString(addressStr, isStandardString, isStandardRangeString, lowerStringStartIndex, lowerStringEndIndex, upperStringEndIndex, originalLower, originalUpper);
            segment.setWildcardString(addressStr, isStandardRangeString, lowerStringStartIndex, upperStringEndIndex, originalLower, originalUpper);
            return var1_2;
        }

        @Override
        protected abstract R createSectionInternal(S[] var1);

        protected abstract R createEmbeddedSectionInternal(IPAddressSection var1, S[] var2);

        /*
         * WARNING - void declaration
         */
        @Override
        protected R createPrefixedSectionInternal(S[] segments, Integer prefix) {
            void var2_2;
            void var1_1;
            return (R)this.createPrefixedSectionInternal((IPAddressSegment[])var1_1, (Integer)var2_2, false);
        }

        @Override
        protected abstract R createPrefixedSectionInternal(S[] var1, Integer var2, boolean var3);

        /*
         * WARNING - void declaration
         */
        protected T createAddressInternal(S[] segments) {
            void var1_1;
            IPAddressCreator iPAddressCreator = this;
            return iPAddressCreator.createAddress(iPAddressCreator.createSectionInternal((IPAddressSegment[])var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected T createAddressInternal(S[] segments, Integer prefix, boolean singleOnly) {
            void var3_3;
            void var2_2;
            void var1_1;
            IPAddressCreator iPAddressCreator = this;
            return iPAddressCreator.createAddress(iPAddressCreator.createPrefixedSectionInternal((IPAddressSegment[])var1_1, (Integer)var2_2, (boolean)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        protected T createAddressInternal(S[] segments, Integer prefix) {
            void var2_2;
            void var1_1;
            IPAddressCreator iPAddressCreator = this;
            return iPAddressCreator.createAddress(iPAddressCreator.createPrefixedSectionInternal((IPAddressSegment[])var1_1, (Integer)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        protected R createSectionInternal(byte[] bytes, int segmentCount, Integer prefix) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (R)((IPAddressSection)this.createSectionInternal((byte[])var1_1, (int)var2_2, (Integer)var3_3, false));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected T createAddressInternal(byte[] bytes, CharSequence zone) {
            void var2_2;
            void var1_1;
            IPAddressCreator iPAddressCreator = this;
            return iPAddressCreator.createAddressInternal(iPAddressCreator.createSectionInternal((byte[])var1_1, this.getAddressSegmentCount(), null), (CharSequence)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected T createAddressInternal(R section, CharSequence zone, HostIdentifierString from) {
            void var1_1;
            void var3_3;
            void var2_2;
            T result = this.createAddressInternal(section, (CharSequence)var2_2);
            ((IPAddress)result).cache((HostIdentifierString)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected T createAddressInternal(R section, HostIdentifierString from) {
            void var1_1;
            void var2_2;
            T result = this.createAddress(section);
            ((IPAddress)result).cache((HostIdentifierString)var2_2);
            return var1_1;
        }

        protected abstract T createAddressInternal(R var1, CharSequence var2);

        public abstract T createAddress(R var1);

        protected abstract int getAddressSegmentCount();
    }
}

