/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressConversionException;
import inet.ipaddr.AddressSection;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressSegmentSeries;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.IPAddressRange;
import inet.ipaddr.format.standard.IPAddressDivisionGrouping;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.util.function.Function;

public abstract class IPAddress
extends Address
implements IPAddressSegmentSeries,
IPAddressRange {
    public static final IPAddressConverter DEFAULT_ADDRESS_CONVERTER = new IPAddressConverter.DefaultAddressConverter();
    HostName fromHost;
    private static final IPv6Address[] EMPTY_IPV6_ADDRESS = new IPv6Address[0];
    private static final IPv4Address[] EMPTY_IPV4_ADDRESS = new IPv4Address[0];

    /*
     * WARNING - void declaration
     */
    protected IPAddress(IPAddressSection section) {
        super((AddressSection)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected IPAddress(Function<Address, AddressSection> supplier) {
        super((Function<Address, AddressSection>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPAddressString toAddressString() {
        if (this.fromString == null) {
            void var1_1;
            IPAddressStringParameters params = this.createFromStringParams();
            this.fromString = new IPAddressString(this.toCanonicalString(), this, (IPAddressStringParameters)var1_1);
        }
        return this.getAddressfromString();
    }

    protected abstract IPAddressStringParameters createFromStringParams();

    protected IPAddressString getAddressfromString() {
        return (IPAddressString)this.fromString;
    }

    /*
     * WARNING - void declaration
     */
    void cache(HostIdentifierString string) {
        if (string instanceof HostName) {
            this.fromHost = (HostName)string;
            IPAddress iPAddress = this;
            this.fromString = new IPAddressString(this.fromHost.toString(), iPAddress, iPAddress.fromHost.validationOptions.addressOptions);
            return;
        }
        if (string instanceof IPAddressString) {
            void var1_1;
            this.fromString = (IPAddressString)var1_1;
        }
    }

    protected IPAddressProvider getProvider() {
        if (this.isPrefixed()) {
            if (this.getNetwork().getPrefixConfiguration().prefixedSubnetsAreExplicit() || !this.isPrefixBlock()) {
                IPAddress iPAddress = this;
                return IPAddressProvider.getProviderFor(iPAddress, iPAddress.withoutPrefixLength());
            }
            IPAddress iPAddress = this;
            return IPAddressProvider.getProviderFor(iPAddress, iPAddress.toZeroHost(true).withoutPrefixLength());
        }
        IPAddress iPAddress = this;
        return IPAddressProvider.getProviderFor(iPAddress, iPAddress);
    }

    @Override
    public abstract IPAddressNetwork<?, ?, ?, ?, ?> getNetwork();

    @Override
    public IPAddressSection getSection() {
        return (IPAddressSection)super.getSection();
    }

    public int getMaxSegmentValue() {
        return IPAddressSegment.getMaxSegmentValue(this.getIPVersion());
    }

    static int getMaxSegmentValue(IPVersion version) {
        return IPAddressSegment.getMaxSegmentValue(version);
    }

    @Override
    public int getBytesPerSegment() {
        return IPAddressSegment.getByteCount(this.getIPVersion());
    }

    static int getBytesPerSegment(IPVersion version) {
        return IPAddressSegment.getByteCount(version);
    }

    @Override
    public int getBitsPerSegment() {
        return IPAddressSegment.getBitCount(this.getIPVersion());
    }

    static int getBitsPerSegment(IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    public static int getSegmentCount(IPVersion version) {
        if (version.isIPv4()) {
            return 4;
        }
        return 8;
    }

    public static int getBitCount(IPVersion version) {
        if (version.isIPv4()) {
            return 32;
        }
        return 128;
    }

    public abstract IPAddress getLower();

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    @Override
    public IPVersion getIPVersion() {
        return this.getSection().getIPVersion();
    }

    public IPv4Address toIPv4() {
        return null;
    }

    public IPv6Address toIPv6() {
        return null;
    }

    public abstract IPAddressSeqRange toSequentialRange();

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isFromSameString(HostIdentifierString other) {
        if (this.fromString != null && other instanceof IPAddressString) {
            void var1_1;
            void var2_2;
            IPAddressString fromString = (IPAddressString)this.fromString;
            IPAddressString otherString = (IPAddressString)other;
            return fromString == otherString || fromString.fullAddr.equals(otherString.fullAddr) && var2_2.validationOptions == var1_1.validationOptions;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(IPAddress other) {
        void var1_1;
        return super.contains((Address)var1_1);
    }

    @Override
    public String toNormalizedWildcardString() {
        return this.getSection().toNormalizedWildcardString();
    }

    @Override
    public String toCanonicalWildcardString() {
        return this.getSection().toCanonicalWildcardString();
    }

    @Override
    public Integer getNetworkPrefixLength() {
        return this.getSection().getNetworkPrefixLength();
    }

    public boolean includesZeroHost() {
        return ((IPAddressDivisionGrouping)this.getSection()).includesZeroHost();
    }

    protected abstract IPAddress toZeroHost(boolean var1);

    public boolean isSingleNetwork() {
        return this.getSection().isSingleNetwork();
    }

    /*
     * WARNING - void declaration
     */
    public Integer getBlockMaskPrefixLength(boolean network) {
        void var1_1;
        return this.getSection().getBlockMaskPrefixLength((boolean)var1_1);
    }

    public abstract IPAddressSeqRange spanWithRange(IPAddress var1) throws AddressConversionException;

    public abstract IPAddress mask(IPAddress var1) throws AddressConversionException, IncompatibleAddressException;

    public abstract IPAddress withoutPrefixLength();

    public static final class IPVersion
    extends Enum<IPVersion> {
        public static final /* enum */ IPVersion IPV4 = new IPVersion();
        public static final /* enum */ IPVersion IPV6 = new IPVersion();
        private static final /* synthetic */ IPVersion[] $VALUES;

        public static IPVersion[] values() {
            return (IPVersion[])$VALUES.clone();
        }

        public final boolean isIPv4() {
            return this == IPV4;
        }

        public final boolean isIPv6() {
            return this == IPV6;
        }

        public final String toString() {
            if (this.isIPv4()) {
                return "IPv4";
            }
            return "IPv6";
        }

        static {
            $VALUES = new IPVersion[]{IPV4, IPV6};
        }
    }
}

