/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.Validator;
import inet.ipaddr.ipv6.IPv6Address;
import java.util.Objects;

public class HostName
implements HostIdentifierString,
Comparable<HostName> {
    private static IPAddress[] EMPTY_ADDRS = new IPAddress[0];
    public static final HostNameParameters DEFAULT_VALIDATION_OPTIONS = new HostNameParameters.Builder().toParams();
    private static final HostNameParameters DEFAULT_SOCKET_ADDR_VALIDATION_OPTIONS = DEFAULT_VALIDATION_OPTIONS.toBuilder().expectPort(true).toParams();
    private final String host;
    private transient String normalizedWildcardString;
    private ParsedHost parsedHost;
    private HostNameException validationException;
    final HostNameParameters validationOptions;

    public HostNameParameters getValidationOptions() {
        return this.validationOptions;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() throws HostNameException {
        if (this.parsedHost != null) {
            return;
        }
        if (this.validationException != null) {
            throw this.validationException;
        }
        HostName hostName = this;
        synchronized (hostName) {
            if (this.parsedHost != null) {
                return;
            }
            if (this.validationException != null) {
                throw this.validationException;
            }
            try {
                this.parsedHost = this.getValidator().validateHost(this);
            }
            catch (HostNameException e) {
                void var2_2;
                this.validationException = e;
                throw var2_2;
            }
            return;
        }
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    public boolean isValid() {
        if (this.parsedHost != null) {
            return true;
        }
        if (this.validationException != null) {
            return false;
        }
        try {
            this.validate();
            return true;
        }
        catch (HostNameException hostNameException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String toNormalizedWildcardString() {
        void var1_1;
        String result = this.normalizedWildcardString;
        if (result == null) {
            this.normalizedWildcardString = result = this.toNormalizedString(true);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void translateReserved(IPv6Address addr, String str, StringBuilder builder) {
        if (!addr.hasZone()) {
            builder.append(str);
            return;
        }
        int index = str.indexOf(37);
        StringBuilder translated = builder;
        translated.append(str, 0, index);
        translated.append("%25");
        for (int i = index + 1; i < str.length(); ++i) {
            void var3_4;
            char c = str.charAt(i);
            if (Validator.isReserved(c)) {
                translated.append('%');
                IPAddressSegment.toUnsignedString(c, 16, translated);
                continue;
            }
            translated.append((char)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String toNormalizedString(boolean wildcard) {
        if (this.isValid()) {
            void var2_4;
            StringBuilder builder = new StringBuilder();
            if (this.isAddress()) {
                HostName.toNormalizedString(this.asAddress(), wildcard, builder);
            } else if (this.isAddressString()) {
                builder.append(this.asAddressString().toNormalizedString());
            } else {
                builder.append(this.parsedHost.getHost());
                Integer networkPrefixLength = this.parsedHost.getEquivalentPrefixLength();
                if (networkPrefixLength != null) {
                    builder.append('/');
                    IPAddressSegment.toUnsignedString(networkPrefixLength, 10, builder);
                } else {
                    IPAddress mask = this.parsedHost.getMask();
                    if (mask != null) {
                        builder.append('/').append(mask.toNormalizedString());
                    }
                }
            }
            Integer port = this.parsedHost.getPort();
            if (port != null) {
                HostName.toNormalizedString(port, builder);
            } else {
                String service = this.parsedHost.getService();
                if (service != null) {
                    void var1_3;
                    builder.append(':').append((String)var1_3);
                }
            }
            return var2_4.toString();
        }
        return this.host;
    }

    /*
     * WARNING - void declaration
     */
    private static void toNormalizedString(int port, StringBuilder builder) {
        void var1_1;
        int n;
        builder.append(':');
        IPAddressSegment.toUnsignedString(n, 10, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void toNormalizedString(IPAddress addr, boolean wildcard, StringBuilder builder) {
        IPAddress iPAddress;
        void var1_1;
        void var2_3;
        if (addr.isIPv6()) {
            if (!wildcard && addr.isPrefixed()) {
                void var3_4;
                void var1_2;
                builder.append('[');
                String normalized = addr.toNormalizedString();
                int index = normalized.indexOf(47);
                HostName.translateReserved(addr.toIPv6(), normalized.substring(0, index), builder);
                builder.append(']').append(var1_2.substring((int)var3_4));
                return;
            }
            builder.append('[');
            HostName.translateReserved(addr.toIPv6(), addr.toNormalizedWildcardString(), builder);
            builder.append(']');
            return;
        }
        var2_3.append(var1_1 != false ? addr.toNormalizedWildcardString() : iPAddress.toNormalizedString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof HostName && this.matches((HostName)var1_1);
    }

    public int hashCode() {
        return this.toNormalizedWildcardString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(HostName host) {
        void var1_1;
        if (this == host) {
            return true;
        }
        if (this.isValid()) {
            if (host.isValid()) {
                void var2_2;
                void var3_3;
                ParsedHost parsedHost = this.parsedHost;
                ParsedHost otherParsedHost = host.parsedHost;
                if (parsedHost.isAddressString()) {
                    return otherParsedHost.isAddressString() && parsedHost.asGenericAddressString().equals(otherParsedHost.asGenericAddressString()) && Objects.equals(parsedHost.getPort(), otherParsedHost.getPort()) && Objects.equals(parsedHost.getService(), otherParsedHost.getService());
                }
                if (otherParsedHost.isAddressString()) {
                    return false;
                }
                String thisHost = parsedHost.getHost();
                String otherHost = otherParsedHost.getHost();
                if (!var3_3.equals(otherHost)) {
                    return false;
                }
                return Objects.equals(parsedHost.getEquivalentPrefixLength(), otherParsedHost.getEquivalentPrefixLength()) && Objects.equals(parsedHost.getMask(), otherParsedHost.getMask()) && Objects.equals(parsedHost.getPort(), otherParsedHost.getPort()) && Objects.equals(var2_2.getService(), var1_1.getService());
            }
            return false;
        }
        return !var1_1.isValid() && this.toString().equals(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(HostName other) {
        void var1_1;
        if (this.isValid()) {
            void var2_2;
            if (!other.isValid()) return 1;
            ParsedHost parsedHost = this.parsedHost;
            ParsedHost otherParsedHost = other.parsedHost;
            if (parsedHost.isAddressString()) {
                if (!otherParsedHost.isAddressString()) return -1;
                int result = parsedHost.asGenericAddressString().compareTo(otherParsedHost.asGenericAddressString());
                if (result != 0) {
                    return result;
                }
            } else {
                if (otherParsedHost.isAddressString()) {
                    return 1;
                }
                String[] normalizedLabels = parsedHost.getNormalizedLabels();
                String[] otherNormalizedLabels = otherParsedHost.getNormalizedLabels();
                int oneLen = normalizedLabels.length;
                int twoLen = otherNormalizedLabels.length;
                int minLen = Math.min(oneLen, twoLen);
                for (int i = 1; i <= minLen; ++i) {
                    String one = normalizedLabels[oneLen - i];
                    String two = otherNormalizedLabels[twoLen - i];
                    int result = one.compareTo(two);
                    if (result == 0) continue;
                    return result;
                }
                if (oneLen != twoLen) {
                    return oneLen - twoLen;
                }
                Integer networkPrefixLength = parsedHost.getEquivalentPrefixLength();
                Integer otherPrefixLength = otherParsedHost.getEquivalentPrefixLength();
                if (networkPrefixLength != null) {
                    if (otherPrefixLength == null) return 1;
                    if (networkPrefixLength.intValue() != otherPrefixLength.intValue()) {
                        return otherPrefixLength - networkPrefixLength;
                    }
                } else {
                    if (otherPrefixLength != null) {
                        return -1;
                    }
                    IPAddress mask = parsedHost.getMask();
                    IPAddress otherMask = otherParsedHost.getMask();
                    if (mask != null) {
                        if (otherMask == null) return 1;
                        int ret = mask.compareTo(otherMask);
                        if (ret != 0) {
                            return ret;
                        }
                    } else if (otherMask != null) {
                        return -1;
                    }
                }
            }
            Integer portOne = parsedHost.getPort();
            Integer portTwo = otherParsedHost.getPort();
            if (portOne != null) {
                void var3_5;
                if (portTwo == null) return 1;
                int ret = var3_5.intValue() - portTwo;
                if (ret != 0) {
                    return ret;
                }
            } else if (portTwo != null) {
                return -1;
            }
            String serviceOne = var2_2.getService();
            String serviceTwo = var1_1.getService();
            if (serviceOne != null) {
                if (serviceTwo == null) return 1;
                int ret = serviceOne.compareTo(serviceTwo);
                if (ret == 0) return 0;
                return ret;
            }
            if (serviceTwo == null) return 0;
            return -1;
        }
        if (!var1_1.isValid()) return this.toString().compareTo(var1_1.toString());
        return -1;
    }

    public boolean isAddress() {
        return this.isAddressString() && this.parsedHost.asAddress() != null;
    }

    public boolean isAddressString() {
        return this.isValid() && this.parsedHost.isAddressString();
    }

    public IPAddressString asAddressString() {
        if (this.isAddressString()) {
            return this.parsedHost.asGenericAddressString();
        }
        return null;
    }

    public IPAddress asAddress() {
        if (this.isAddress()) {
            return this.parsedHost.asAddress();
        }
        return null;
    }

    public String toString() {
        return this.host;
    }
}

