/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.mac.MACAddressNetwork;
import java.math.BigInteger;
import java.util.function.Function;

public abstract class Address
implements AddressSegmentSeries {
    public static final String RANGE_SEPARATOR_STR = "-";
    public static final String ALTERNATIVE_RANGE_SEPARATOR_STR = "\u00bb";
    public static final String SEGMENT_WILDCARD_STR = "*";
    public static final String SEGMENT_SQL_WILDCARD_STR = "%";
    public static final String SEGMENT_SQL_SINGLE_WILDCARD_STR = "_";
    public static final AddressComparator DEFAULT_ADDRESS_COMPARATOR = new AddressComparator.CountComparator(true);
    public static final AddressComparator ADDRESS_LOW_VALUE_COMPARATOR = new AddressComparator.ValueComparator(true, false);
    public static final AddressComparator ADDRESS_HIGH_VALUE_COMPARATOR = new AddressComparator.ValueComparator(true, true);
    private static MACAddressNetwork macNetwork;
    private static IPv6AddressNetwork ipv6Network;
    private static IPv4AddressNetwork ipv4Network;
    final AddressSection addressSection;
    protected HostIdentifierString fromString;

    /*
     * WARNING - void declaration
     */
    protected Address(AddressSection section) {
        void var1_1;
        this.addressSection = var1_1;
        if (!this.getNetwork().isCompatible(this.addressSection.getNetwork())) {
            throw new NetworkMismatchException(this.addressSection);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Address(Function<Address, AddressSection> supplier) {
        void var1_1;
        this.addressSection = (AddressSection)var1_1.apply(this);
        if (!this.getNetwork().isCompatible(this.addressSection.getNetwork())) {
            throw new NetworkMismatchException(this.addressSection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPv6AddressNetwork defaultIpv6Network() {
        if (ipv6Network != null) return ipv6Network;
        Class<Address> clazz = Address.class;
        synchronized (Address.class) {
            if (ipv6Network != null) return ipv6Network;
            ipv6Network = new IPv6AddressNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipv6Network;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPv4AddressNetwork defaultIpv4Network() {
        if (ipv4Network != null) return ipv4Network;
        Class<Address> clazz = Address.class;
        synchronized (Address.class) {
            if (ipv4Network != null) return ipv4Network;
            ipv4Network = new IPv4AddressNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipv4Network;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MACAddressNetwork defaultMACNetwork() {
        if (macNetwork != null) return macNetwork;
        Class<Address> clazz = Address.class;
        synchronized (Address.class) {
            if (macNetwork != null) return macNetwork;
            macNetwork = new MACAddressNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return macNetwork;
        }
    }

    @Override
    public int getSegmentCount() {
        return this.getSection().getSegmentCount();
    }

    @Override
    public int getDivisionCount() {
        return this.getSection().getDivisionCount();
    }

    @Override
    public int getBitCount() {
        return this.getSection().getBitCount();
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    public AddressSection getSection() {
        return this.addressSection;
    }

    @Override
    public boolean isMultiple() {
        return this.getSection().isMultiple();
    }

    @Override
    public boolean isPrefixed() {
        return this.getSection().isPrefixed();
    }

    @Override
    public Integer getPrefixLength() {
        return this.getSection().getPrefixLength();
    }

    @Override
    public int getMinPrefixLengthForBlock() {
        return this.getSection().getMinPrefixLengthForBlock();
    }

    @Override
    public BigInteger getCount() {
        return this.getSection().getCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(byte[] bytes) {
        void var1_1;
        return this.getSection().getBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        void var1_1;
        return this.getSection().getUpperBytes((byte[])var1_1);
    }

    @Override
    public BigInteger getValue() {
        return this.getSection().getValue();
    }

    @Override
    public BigInteger getUpperValue() {
        return this.getSection().getUpperValue();
    }

    @Override
    public boolean isZero() {
        return this.getSection().isZero();
    }

    @Override
    public boolean includesZero() {
        return this.getSection().includesZero();
    }

    @Override
    public boolean isMax() {
        return this.getSection().isMax();
    }

    @Override
    public boolean includesMax() {
        return this.getSection().includesMax();
    }

    @Override
    public boolean isFullRange() {
        return this.getSection().isFullRange();
    }

    public int hashCode() {
        return this.getSection().hashCode();
    }

    protected abstract boolean isFromSameString(HostIdentifierString var1);

    /*
     * WARNING - void declaration
     */
    public boolean isSameAddress(Address other) {
        void var1_1;
        return other == this || this.getSection().equals(var1_1.getSection());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Address) {
            void var1_1;
            Address other = (Address)o;
            if (this.isFromSameString(other.fromString)) {
                return true;
            }
            return this.isSameAddress((Address)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Address other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        return this.getSection().contains(var1_1.getSection());
    }

    @Override
    public String toNormalizedString() {
        return this.getSection().toNormalizedString();
    }

    @Override
    public String toCanonicalString() {
        return this.getSection().toCanonicalString();
    }

    public String toString() {
        return this.toCanonicalString();
    }

    @Override
    public boolean isPrefixBlock() {
        return this.getSection().isPrefixBlock();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int prefixLength) {
        void var1_1;
        return this.getSection().containsPrefixBlock((int)var1_1);
    }

    @Override
    public boolean isSinglePrefixBlock() {
        return this.getSection().isSinglePrefixBlock();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSinglePrefixBlock(int prefixLength) {
        void var1_1;
        return this.getSection().containsSinglePrefixBlock((int)var1_1);
    }

    @FunctionalInterface
    public static interface SegmentValueProvider {
        public int getValue(int var1);
    }
}

