/*
 * Decompiled with CFR 0.152.
 */
package androidx.arch.core.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class SafeIterableMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    Entry<K, V> mStart;
    private Entry<K, V> mEnd;
    private final WeakHashMap<SupportRemove<K, V>, Boolean> mIterators = new WeakHashMap();
    private int mSize = 0;

    /*
     * WARNING - void declaration
     */
    protected Entry<K, V> get(K k) {
        void var2_2;
        Entry<K, V> currentNode = this.mStart;
        while (currentNode != null && !currentNode.mKey.equals(k)) {
            currentNode = currentNode.mNext;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public V putIfAbsent(K key, V v) {
        void var2_2;
        void var1_1;
        Entry<K, V> entry = this.get(key);
        if (entry != null) {
            void var3_3;
            return var3_3.mValue;
        }
        this.put(var1_1, var2_2);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Entry<K, V> put(K key, V v) {
        void var1_1;
        void var2_2;
        Entry<K, void> newEntry = new Entry<K, void>(key, var2_2);
        ++this.mSize;
        if (this.mEnd == null) {
            this.mStart = newEntry;
            this.mEnd = this.mStart;
            return newEntry;
        }
        this.mEnd.mNext = newEntry;
        newEntry.mPrevious = this.mEnd;
        this.mEnd = newEntry;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public V remove(K key) {
        void var1_1;
        Entry<K, V> toRemove = this.get(key);
        if (toRemove == null) {
            return null;
        }
        --this.mSize;
        if (!this.mIterators.isEmpty()) {
            for (SupportRemove<K, V> supportRemove : this.mIterators.keySet()) {
                supportRemove.supportRemove(toRemove);
            }
        }
        if (toRemove.mPrevious != null) {
            toRemove.mPrevious.mNext = toRemove.mNext;
        } else {
            this.mStart = toRemove.mNext;
        }
        if (toRemove.mNext != null) {
            toRemove.mNext.mPrevious = toRemove.mPrevious;
        } else {
            this.mEnd = toRemove.mPrevious;
        }
        toRemove.mNext = null;
        toRemove.mPrevious = null;
        return var1_1.mValue;
    }

    public int size() {
        return this.mSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        void var1_1;
        AscendingIterator<K, V> iterator = new AscendingIterator<K, V>(this.mStart, this.mEnd);
        this.mIterators.put(iterator, Boolean.FALSE);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<Map.Entry<K, V>> descendingIterator() {
        void var1_1;
        DescendingIterator<K, V> iterator = new DescendingIterator<K, V>(this.mEnd, this.mStart);
        this.mIterators.put(iterator, Boolean.FALSE);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IteratorWithAdditions iteratorWithAdditions() {
        void var1_1;
        IteratorWithAdditions iterator = new IteratorWithAdditions(this);
        this.mIterators.put(iterator, Boolean.FALSE);
        return var1_1;
    }

    public Map.Entry<K, V> eldest() {
        return this.mStart;
    }

    public Map.Entry<K, V> newest() {
        return this.mEnd;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        void var2_2;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeIterableMap)) {
            return false;
        }
        SafeIterableMap map = (SafeIterableMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator<Map.Entry<K, V>> iterator1 = this.iterator();
        Iterator<Map.Entry<K, V>> iterator2 = map.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            void var3_3;
            Map.Entry<K, V> next1 = iterator1.next();
            Map.Entry<K, V> next2 = iterator2.next();
            if ((next1 != null || next2 == null) && (next1 == null || var3_3.equals(next2))) continue;
            return false;
        }
        return !var2_2.hasNext() && !var1_1.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int h = 0;
        for (Map.Entry<K, V> kvEntry : this) {
            void var3_3;
            h += var3_3.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return var1_1.toString();
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K mKey;
        final V mValue;
        Entry<K, V> mNext;
        Entry<K, V> mPrevious;

        /*
         * WARNING - void declaration
         */
        Entry(K key, V value) {
            void var2_2;
            void var1_1;
            this.mKey = var1_1;
            this.mValue = var2_2;
        }

        @Override
        public K getKey() {
            return this.mKey;
        }

        @Override
        public V getValue() {
            return this.mValue;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("An entry modification is not supported");
        }

        public String toString() {
            return this.mKey + "=" + this.mValue;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            void var1_1;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            return this.mKey.equals(entry.mKey) && this.mValue.equals(var1_1.mValue);
        }

        @Override
        public int hashCode() {
            return this.mKey.hashCode() ^ this.mValue.hashCode();
        }
    }

    public static abstract class SupportRemove<K, V> {
        abstract void supportRemove(Entry<K, V> var1);
    }

    static class AscendingIterator<K, V>
    extends ListIterator<K, V> {
        /*
         * WARNING - void declaration
         */
        AscendingIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Entry<K, V> forward(Entry<K, V> entry) {
            return entry.mNext;
        }

        @Override
        Entry<K, V> backward(Entry<K, V> entry) {
            return entry.mPrevious;
        }
    }

    private static class DescendingIterator<K, V>
    extends ListIterator<K, V> {
        /*
         * WARNING - void declaration
         */
        DescendingIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Entry<K, V> forward(Entry<K, V> entry) {
            return entry.mPrevious;
        }

        @Override
        Entry<K, V> backward(Entry<K, V> entry) {
            return entry.mNext;
        }
    }

    public class IteratorWithAdditions
    extends SupportRemove<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private Entry<K, V> mCurrent;
        private boolean mBeforeStart = true;
        final /* synthetic */ SafeIterableMap this$0;

        /*
         * WARNING - void declaration
         */
        IteratorWithAdditions(SafeIterableMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        void supportRemove(Entry<K, V> entry) {
            if (entry == this.mCurrent) {
                this.mCurrent = this.mCurrent.mPrevious;
                this.mBeforeStart = this.mCurrent == null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.mBeforeStart) {
                return this.this$0.mStart != null;
            }
            return this.mCurrent != null && this.mCurrent.mNext != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            Entry entry;
            IteratorWithAdditions iteratorWithAdditions;
            if (this.mBeforeStart) {
                this.mBeforeStart = false;
                IteratorWithAdditions iteratorWithAdditions2 = this;
                iteratorWithAdditions = iteratorWithAdditions2;
                entry = iteratorWithAdditions2.this$0.mStart;
            } else {
                IteratorWithAdditions iteratorWithAdditions3 = this;
                iteratorWithAdditions = iteratorWithAdditions3;
                entry = iteratorWithAdditions3.mCurrent != null ? this.mCurrent.mNext : null;
            }
            iteratorWithAdditions.mCurrent = entry;
            return this.mCurrent;
        }
    }

    private static abstract class ListIterator<K, V>
    extends SupportRemove<K, V>
    implements Iterator<Map.Entry<K, V>> {
        Entry<K, V> mExpectedEnd;
        Entry<K, V> mNext;

        /*
         * WARNING - void declaration
         */
        ListIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            void var1_1;
            void var2_2;
            this.mExpectedEnd = var2_2;
            this.mNext = var1_1;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void supportRemove(Entry<K, V> entry) {
            void var1_1;
            if (this.mExpectedEnd == entry && entry == this.mNext) {
                this.mNext = null;
                this.mExpectedEnd = null;
            }
            if (this.mExpectedEnd == entry) {
                this.mExpectedEnd = this.backward(this.mExpectedEnd);
            }
            if (this.mNext == var1_1) {
                this.mNext = this.nextNode();
            }
        }

        private Entry<K, V> nextNode() {
            if (this.mNext == this.mExpectedEnd || this.mExpectedEnd == null) {
                return null;
            }
            ListIterator listIterator = this;
            return listIterator.forward(listIterator.mNext);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> next() {
            void var1_1;
            Entry<K, V> result = this.mNext;
            this.mNext = this.nextNode();
            return var1_1;
        }

        abstract Entry<K, V> forward(Entry<K, V> var1);

        abstract Entry<K, V> backward(Entry<K, V> var1);
    }
}

