/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.internal;

import com.sun.jna.internal.Cleaner;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner {
    private static final Cleaner INSTANCE = new Cleaner();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private Thread cleanerThread;
    private CleanerRef firstCleanable;

    public static Cleaner getCleaner() {
        return INSTANCE;
    }

    private Cleaner() {
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Cleanable register(Object obj, Runnable cleanupTask) {
        void var2_2;
        void var1_1;
        return this.add(new CleanerRef(this, var1_1, this.referenceQueue, (Runnable)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private synchronized CleanerRef add(CleanerRef ref) {
        ReferenceQueue<Object> referenceQueue = this.referenceQueue;
        synchronized (referenceQueue) {
            void var1_1;
            if (this.firstCleanable == null) {
                this.firstCleanable = ref;
            } else {
                ref.setNext(this.firstCleanable);
                this.firstCleanable.setPrevious(ref);
                this.firstCleanable = ref;
            }
            if (this.cleanerThread == null) {
                Logger.getLogger(Cleaner.class.getName()).log(Level.FINE, "Starting CleanerThread");
                this.cleanerThread = new CleanerThread(this);
                this.cleanerThread.start();
            }
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized boolean remove(CleanerRef ref) {
        ReferenceQueue<Object> referenceQueue = this.referenceQueue;
        synchronized (referenceQueue) {
            void var3_4;
            void var1_1;
            boolean inChain = false;
            if (ref == this.firstCleanable) {
                this.firstCleanable = ref.getNext();
                inChain = true;
            }
            if (ref.getPrevious() != null) {
                ref.getPrevious().setNext(ref.getNext());
            }
            if (ref.getNext() != null) {
                ref.getNext().setPrevious(ref.getPrevious());
            }
            if (ref.getPrevious() != null || ref.getNext() != null) {
                inChain = true;
            }
            ref.setNext(null);
            var1_1.setPrevious(null);
            return (boolean)var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(Cleaner x0, CleanerRef x1) {
        void var1_1;
        return x0.remove((CleanerRef)var1_1);
    }

    static /* synthetic */ ReferenceQueue access$100(Cleaner x0) {
        return x0.referenceQueue;
    }

    static /* synthetic */ CleanerRef access$200(Cleaner x0) {
        return x0.firstCleanable;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Thread access$302(Cleaner x0, Thread x1) {
        void var1_1;
        x0.cleanerThread = var1_1;
        return x0.cleanerThread;
    }

    private static class CleanerRef
    extends PhantomReference<Object>
    implements Cleanable {
        private final Cleaner cleaner;
        private final Runnable cleanupTask;
        private CleanerRef previous;
        private CleanerRef next;

        /*
         * WARNING - void declaration
         */
        public CleanerRef(Cleaner cleaner, Object referent, ReferenceQueue<? super Object> q, Runnable cleanupTask) {
            super(var2_2, var3_3);
            void var1_1;
            void var3_3;
            void var2_2;
            this.cleaner = var1_1;
            this.cleanupTask = cleanupTask;
        }

        @Override
        public void clean() {
            if (Cleaner.access$000(this.cleaner, this)) {
                this.cleanupTask.run();
            }
        }

        CleanerRef getPrevious() {
            return this.previous;
        }

        /*
         * WARNING - void declaration
         */
        void setPrevious(CleanerRef previous) {
            void var1_1;
            this.previous = var1_1;
        }

        CleanerRef getNext() {
            return this.next;
        }

        /*
         * WARNING - void declaration
         */
        void setNext(CleanerRef next) {
            void var1_1;
            this.next = var1_1;
        }

        static /* synthetic */ CleanerRef access$400(CleanerRef x0) {
            return x0.next;
        }

        static /* synthetic */ Runnable access$500(CleanerRef x0) {
            return x0.cleanupTask;
        }
    }

    public static interface Cleanable {
        public void clean();
    }
}

