/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidJVMKt;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000,\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\b\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a3\u0010\u000f\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u001b\u0010\u0012\u001a\u00020\u000e*\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a#\u0010\u0015\u001a\u00020\u000e*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0017\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0011H\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0017\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0011H\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0019\u001a\u001b\u0010\u001f\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u001b\u0010\u001f\u001a\u00020\u0011*\u00020\u00002\u0006\u0010 \u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001d\u0010!"}, d2={"", "randomBytes", "Lkotlin/uuid/Uuid;", "uuidFromRandomBytes", "([B)Lkotlin/uuid/Uuid;", "", "index", "", "getLongAtCommonImpl", "([BI)J", "dst", "dstOffset", "startIndex", "endIndex", "", "formatBytesIntoCommonImpl", "(J[BIII)V", "", "checkHyphenAt", "(Ljava/lang/String;I)V", "value", "setLongAtCommonImpl", "([BIJ)V", "hexDashString", "uuidParseHexDashCommonImpl", "(Ljava/lang/String;)Lkotlin/uuid/Uuid;", "hexString", "uuidParseHexCommonImpl", "maxLength", "truncateForErrorMessage$UuidKt__UuidKt", "(Ljava/lang/String;I)Ljava/lang/String;", "truncateForErrorMessage", "maxSize", "([BI)Ljava/lang/String;"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uuid.kt\nkotlin/uuid/UuidKt__UuidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,648:1\n1#2:649\n*E\n"})
class UuidKt__UuidKt
extends UuidKt__UuidJVMKt {
    @ExperimentalUuidApi
    public static final Uuid uuidFromRandomBytes(byte[] randomBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(randomBytes, "randomBytes");
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return Uuid.Companion.fromByteArray(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static final long getLongAtCommonImpl(byte[] $this$getLongAtCommonImpl, int index) {
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$getLongAtCommonImpl, "<this>");
        return ((long)$this$getLongAtCommonImpl[index] & 0xFFL) << 56 | ((long)$this$getLongAtCommonImpl[index + 1] & 0xFFL) << 48 | ((long)$this$getLongAtCommonImpl[index + 2] & 0xFFL) << 40 | ((long)$this$getLongAtCommonImpl[index + 3] & 0xFFL) << 32 | ((long)$this$getLongAtCommonImpl[index + 4] & 0xFFL) << 24 | ((long)$this$getLongAtCommonImpl[index + 5] & 0xFFL) << 16 | ((long)$this$getLongAtCommonImpl[index + 6] & 0xFFL) << 8 | (long)byArray[var1_1 + 7] & 0xFFL;
    }

    @ExperimentalUuidApi
    public static final void formatBytesIntoCommonImpl(long $this$formatBytesIntoCommonImpl, byte[] dst, int dstOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        int reversedIndex = 7 - startIndex;
        int n = 8 - endIndex;
        if (n <= reversedIndex) {
            while (true) {
                int shift = reversedIndex << 3;
                int n2 = (int)($this$formatBytesIntoCommonImpl >> shift & 0xFFL);
                int byteDigits = HexExtensionsKt.getBYTE_TO_LOWER_CASE_HEX_DIGITS()[n2];
                dst[dstIndex++] = (byte)(byteDigits >> 8);
                dst[dstIndex++] = (byte)byteDigits;
                if (reversedIndex == n) break;
                --reversedIndex;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkHyphenAt(String $this$checkHyphenAt, int index) {
        Intrinsics.checkNotNullParameter($this$checkHyphenAt, "<this>");
        if (!($this$checkHyphenAt.charAt(index) == '-')) {
            void var1_1;
            String string;
            string = "Expected '-' (hyphen) at index " + index + ", but was '" + string.charAt((int)var1_1) + '\'';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void setLongAtCommonImpl(byte[] $this$setLongAtCommonImpl, int index, long value) {
        Intrinsics.checkNotNullParameter($this$setLongAtCommonImpl, "<this>");
        for (int reversedIndex = 7; reversedIndex >= 0; --reversedIndex) {
            int shift = reversedIndex << 3;
            $this$setLongAtCommonImpl[i++] = (byte)(value >> shift);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final Uuid uuidParseHexDashCommonImpl(String hexDashString) {
        void var3_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
        long part1 = HexExtensionsKt.hexToLong$default(hexDashString, 0, 8, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 8);
        long part2 = HexExtensionsKt.hexToLong$default(hexDashString, 9, 13, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 13);
        long part3 = HexExtensionsKt.hexToLong$default(hexDashString, 14, 18, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 18);
        long part4 = HexExtensionsKt.hexToLong$default(hexDashString, 19, 23, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 23);
        long part5 = HexExtensionsKt.hexToLong$default(string, 24, 36, null, 4, null);
        void msb = var1_1 << 32 | var3_2 << 16 | part3;
        long lsb = part4 << 48 | part5;
        return Uuid.Companion.fromLongs((long)msb, lsb);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final Uuid uuidParseHexCommonImpl(String hexString) {
        void var3_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        long msb = HexExtensionsKt.hexToLong$default(hexString, 0, 16, null, 4, null);
        long lsb = HexExtensionsKt.hexToLong$default(string, 16, 32, null, 4, null);
        return Uuid.Companion.fromLongs((long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String truncateForErrorMessage$UuidKt__UuidKt(String $this$truncateForErrorMessage, int maxLength) {
        void var1_1;
        String string;
        if ($this$truncateForErrorMessage.length() <= maxLength) {
            return $this$truncateForErrorMessage;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(0, (int)var1_1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return stringBuilder.append(string2).append("...").toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final String truncateForErrorMessage$UuidKt__UuidKt(byte[] $this$truncateForErrorMessage, int maxSize) {
        void var1_1;
        return ArraysKt.joinToString$default($this$truncateForErrorMessage, null, (CharSequence)"[", (CharSequence)"]", (int)var1_1, null, null, 49, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String access$truncateForErrorMessage(String $receiver, int maxLength) {
        void var1_1;
        return UuidKt__UuidKt.truncateForErrorMessage$UuidKt__UuidKt($receiver, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String access$truncateForErrorMessage(byte[] $receiver, int maxSize) {
        void var1_1;
        return UuidKt__UuidKt.truncateForErrorMessage$UuidKt__UuidKt($receiver, (int)var1_1);
    }
}

