/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.SecureRandomHolder;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidSerialized;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000f\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001b\u0010\u000b\u001a\u00020\n*\u00020\u00072\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0004\b\u000b\u0010\f\u001a3\u0010\u0012\u001a\u00020\u0011*\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a#\u0010\u0015\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nH\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0017\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0017H\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0017\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0017H\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001a\u001a\u0014\u0010\u001e\u001a\u00020\u0000*\u00020\u001dH\u0087\b\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0014\u0010 \u001a\u00020\u001d*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b \u0010!\u001a\u0013\u0010#\u001a\u00020\u0000*\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$\u001a\u001b\u0010#\u001a\u00020\u0000*\u00020\"2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b#\u0010%\u001a\u001b\u0010&\u001a\u00020\"*\u00020\"2\u0006\u0010\u0003\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b&\u0010'\u001a#\u0010&\u001a\u00020\"*\u00020\"2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b&\u0010(\u001a\u0014\u0010)\u001a\u00020\n*\u00020\nH\u0080\b\u00a2\u0006\u0004\b)\u0010*"}, d2={"Lkotlin/uuid/Uuid;", "secureRandomUuid", "()Lkotlin/uuid/Uuid;", "uuid", "", "serializedUuid", "(Lkotlin/uuid/Uuid;)Ljava/lang/Object;", "", "", "index", "", "getLongAt", "([BI)J", "dst", "dstOffset", "startIndex", "endIndex", "", "formatBytesInto", "(J[BIII)V", "value", "setLongAt", "([BIJ)V", "", "hexDashString", "uuidParseHexDash", "(Ljava/lang/String;)Lkotlin/uuid/Uuid;", "hexString", "uuidParseHex", "Ljava/util/UUID;", "toKotlinUuid", "(Ljava/util/UUID;)Lkotlin/uuid/Uuid;", "toJavaUuid", "(Lkotlin/uuid/Uuid;)Ljava/util/UUID;", "Ljava/nio/ByteBuffer;", "getUuid", "(Ljava/nio/ByteBuffer;)Lkotlin/uuid/Uuid;", "(Ljava/nio/ByteBuffer;I)Lkotlin/uuid/Uuid;", "putUuid", "(Ljava/nio/ByteBuffer;Lkotlin/uuid/Uuid;)Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;ILkotlin/uuid/Uuid;)Ljava/nio/ByteBuffer;", "reverseBytes", "(J)J"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuidJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n1#1,277:1\n277#1:278\n277#1:279\n277#1:280\n277#1:281\n277#1:282\n277#1:283\n277#1:284\n277#1:285\n*S KotlinDebug\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n139#1:278\n140#1:279\n184#1:280\n185#1:281\n224#1:282\n225#1:283\n271#1:284\n272#1:285\n*E\n"})
class UuidKt__UuidJVMKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final Uuid secureRandomUuid() {
        void var0;
        byte[] randomBytes = new byte[16];
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(randomBytes);
        return UuidKt.uuidFromRandomBytes((byte[])var0);
    }

    @ExperimentalUuidApi
    public static final Object serializedUuid(Uuid uuid) {
        Uuid uuid2;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return new UuidSerialized(uuid.getMostSignificantBits(), uuid2.getLeastSignificantBits());
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final long getLongAt(byte[] $this$getLongAt, int index) {
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$getLongAt, "<this>");
        return UuidKt.getLongAtCommonImpl(byArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final void formatBytesInto(long $this$formatBytesInto, byte[] dst, int dstOffset, int startIndex, int endIndex) {
        void var3_2;
        void var2_1;
        long l;
        Intrinsics.checkNotNullParameter(dst, "dst");
        UuidKt.formatBytesIntoCommonImpl(l, (byte[])var2_1, (int)var3_2, startIndex, endIndex);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final void setLongAt(byte[] $this$setLongAt, int index, long value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$setLongAt, "<this>");
        UuidKt.setLongAtCommonImpl(byArray, (int)var1_1, (long)var2_2);
    }

    @ExperimentalUuidApi
    public static final Uuid uuidParseHexDash(String hexDashString) {
        String string;
        Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
        return UuidKt.uuidParseHexDashCommonImpl(string);
    }

    @ExperimentalUuidApi
    public static final Uuid uuidParseHex(String hexString) {
        String string;
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return UuidKt.uuidParseHexCommonImpl(string);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final Uuid toKotlinUuid(UUID $this$toKotlinUuid) {
        UUID uUID;
        Intrinsics.checkNotNullParameter($this$toKotlinUuid, "<this>");
        return Uuid.Companion.fromLongs($this$toKotlinUuid.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final UUID toJavaUuid(Uuid $this$toJavaUuid) {
        Uuid uuid;
        Intrinsics.checkNotNullParameter($this$toJavaUuid, "<this>");
        long l = uuid.getLeastSignificantBits();
        long mostSignificantBits = uuid.getMostSignificantBits();
        return new UUID(mostSignificantBits, l);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final Uuid getUuid(ByteBuffer $this$getUuid) {
        void var3_2;
        void var1_1;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if ($this$getUuid.position() + 15 >= $this$getUuid.limit()) {
            throw new BufferUnderflowException();
        }
        long msb = $this$getUuid.getLong();
        long lsb = $this$getUuid.getLong();
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l = msb;
            msb = Long.reverseBytes(l);
            l = lsb;
            lsb = Long.reverseBytes(l);
        }
        return Uuid.Companion.fromLongs((long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final Uuid getUuid(ByteBuffer $this$getUuid, int index) {
        void var2_2;
        ByteBuffer byteBuffer;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$getUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + index + ", with limit: " + $this$getUuid.limit() + ' ');
        }
        long msb = $this$getUuid.getLong(index);
        long lsb = $this$getUuid.getLong((int)(var1_1 + 8));
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l = msb;
            msb = Long.reverseBytes(l);
            l = lsb;
            lsb = Long.reverseBytes(l);
        }
        return Uuid.Companion.fromLongs((long)var2_2, lsb);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final ByteBuffer putUuid(ByteBuffer $this$putUuid, Uuid uuid) {
        ByteBuffer byteBuffer;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        long l = var1_1.getLeastSignificantBits();
        long msb = var1_1.getMostSignificantBits();
        if ($this$putUuid.position() + 15 >= $this$putUuid.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            void lsb;
            $this$putUuid.putLong(msb);
            byteBuffer = $this$putUuid.putLong((long)lsb);
        } else {
            ByteBuffer byteBuffer2;
            long l2 = msb;
            $this$putUuid.putLong(Long.reverseBytes(l2));
            l2 = l;
            byteBuffer = byteBuffer2.putLong(Long.reverseBytes(l2));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final ByteBuffer putUuid(ByteBuffer $this$putUuid, int index, Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        long l = var2_2.getLeastSignificantBits();
        long msb = var2_2.getMostSignificantBits();
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$putUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + index + ", with limit: " + $this$putUuid.limit() + ' ');
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(index, msb);
            byteBuffer = $this$putUuid.putLong(index + 8, (long)lsb);
        } else {
            void var1_1;
            ByteBuffer byteBuffer2;
            long l2 = msb;
            $this$putUuid.putLong(index, Long.reverseBytes(l2));
            l2 = lsb;
            byteBuffer = byteBuffer2.putLong((int)(var1_1 + 8), Long.reverseBytes(l2));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    public static final long reverseBytes(long $this$reverseBytes) {
        return Long.reverseBytes($this$reverseBytes);
    }
}

