/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import kotlin.Deprecated;
import kotlin.DeprecatedSinceKotlin;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.UByteArray;
import kotlin.ULong;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00000\u00012\u00060\u0002j\u0002`\u0003:\u00016B\u0019\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ^\u0010\u000e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\t26\u0010\r\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00028\u00000\nH\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ^\u0010\u0011\u001a\u00028\u0000\"\u0004\b\u0000\u0010\t26\u0010\r\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00028\u00000\nH\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0014J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001c\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u001a\u0010 \u001a\u00020\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0096\u0002\u00a2\u0006\u0004\b \u0010!J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0000H\u0097\u0002\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b'\u0010(J\u001b\u0010-\u001a\u00020,2\n\u0010+\u001a\u00060)j\u0002`*H\u0002\u00a2\u0006\u0004\b-\u0010.R \u0010\u0005\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0012\n\u0004\b\u0005\u0010/\u0012\u0004\b2\u00103\u001a\u0004\b0\u00101R \u0010\u0006\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0012\n\u0004\b\u0006\u0010/\u0012\u0004\b5\u00103\u001a\u0004\b4\u00101\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lkotlin/uuid/Uuid;", "", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "", "mostSignificantBits", "leastSignificantBits", "<init>", "(JJ)V", "T", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "action", "toLongs", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Lkotlin/ULong;", "toULongs", "", "toString", "()Ljava/lang/String;", "toHexDashString", "toHexString", "", "toByteArray", "()[B", "Lkotlin/UByteArray;", "toUByteArray-TcUX1vc", "toUByteArray", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "compareTo", "(Lkotlin/uuid/Uuid;)I", "hashCode", "()I", "writeReplace", "()Ljava/lang/Object;", "Ljava/io/ObjectInputStream;", "Lkotlin/internal/ReadObjectParameterType;", "input", "", "readObject", "(Ljava/io/ObjectInputStream;)V", "J", "getMostSignificantBits", "()J", "getMostSignificantBits$annotations", "()V", "getLeastSignificantBits", "getLeastSignificantBits$annotations", "Companion"})
@SinceKotlin(version="2.0")
@ExperimentalUuidApi
public final class Uuid
implements Serializable,
Comparable<Uuid> {
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    private static final Uuid NIL = new Uuid(0L, 0L);
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_BITS = 128;

    /*
     * WARNING - void declaration
     */
    private Uuid(long mostSignificantBits, long leastSignificantBits) {
        void var3_2;
        void var1_1;
        this.mostSignificantBits = var1_1;
        this.leastSignificantBits = var3_2;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getMostSignificantBits$annotations() {
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getLeastSignificantBits$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private final <T> T toLongs(Function2<? super Long, ? super Long, ? extends T> action) {
        void var1_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var1_1.invoke(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private final <T> T toULongs(Function2<? super ULong, ? super ULong, ? extends T> action) {
        void var1_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var1_1.invoke(ULong.box-impl(ULong.constructor-impl(this.getMostSignificantBits())), ULong.box-impl(ULong.constructor-impl(this.getLeastSignificantBits())));
    }

    public final String toString() {
        return this.toHexDashString();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.1")
    public final String toHexDashString() {
        void var1_1;
        byte[] bytes = new byte[36];
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 0, 0, 4);
        bytes[8] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 9, 4, 6);
        bytes[13] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 14, 6, 8);
        bytes[18] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 19, 0, 2);
        bytes[23] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 24, 2, 8);
        return StringsKt.decodeToString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String toHexString() {
        void var1_1;
        byte[] bytes = new byte[32];
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 0, 0, 8);
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 16, 0, 8);
        return StringsKt.decodeToString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        byte[] bytes = new byte[16];
        UuidKt.setLongAt(bytes, 0, this.mostSignificantBits);
        UuidKt.setLongAt(bytes, 8, this.leastSignificantBits);
        return var1_1;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalUnsignedTypes
    public final byte[] toUByteArray-TcUX1vc() {
        return UByteArray.constructor-impl(this.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)other).mostSignificantBits && this.leastSignificantBits == ((Uuid)var1_1).leastSignificantBits;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SinceKotlin(version="2.1")
    public final int compareTo(Uuid other) {
        void var1_1;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.mostSignificantBits != other.mostSignificantBits) {
            return Long.compareUnsigned(ULong.constructor-impl(this.mostSignificantBits), ULong.constructor-impl(other.mostSignificantBits));
        }
        return Long.compareUnsigned(ULong.constructor-impl(this.leastSignificantBits), ULong.constructor-impl(var1_1.leastSignificantBits));
    }

    public final int hashCode() {
        return Long.hashCode(this.mostSignificantBits ^ this.leastSignificantBits);
    }

    private final Object writeReplace() {
        return UuidKt.serializedUuid(this);
    }

    private final void readObject(ObjectInputStream input) {
        throw new InvalidObjectException("Deserialization is supported via proxy only");
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Uuid(long mostSignificantBits, long leastSignificantBits, DefaultConstructorMarker $constructor_marker) {
        this((long)var1_1, (long)var3_2);
        void var3_2;
        void var1_1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0015\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u0015\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0015\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001c\u0010\u0018J\r\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u001eR\u0014\u0010#\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010$R*\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u00070&j\b\u0012\u0004\u0012\u00020\u0007`'8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010\u0003\u001a\u0004\b(\u0010)"}, d2={"Lkotlin/uuid/Uuid$Companion;", "", "<init>", "()V", "", "mostSignificantBits", "leastSignificantBits", "Lkotlin/uuid/Uuid;", "fromLongs", "(JJ)Lkotlin/uuid/Uuid;", "Lkotlin/ULong;", "fromULongs-eb3DHEI", "fromULongs", "", "byteArray", "fromByteArray", "([B)Lkotlin/uuid/Uuid;", "Lkotlin/UByteArray;", "ubyteArray", "fromUByteArray-GBYM_sE", "fromUByteArray", "", "uuidString", "parse", "(Ljava/lang/String;)Lkotlin/uuid/Uuid;", "hexDashString", "parseHexDash", "hexString", "parseHex", "random", "()Lkotlin/uuid/Uuid;", "NIL", "Lkotlin/uuid/Uuid;", "getNIL", "", "SIZE_BYTES", "I", "SIZE_BITS", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getLEXICAL_ORDER", "()Ljava/util/Comparator;", "getLEXICAL_ORDER$annotations", "LEXICAL_ORDER"})
    public static final class Companion {
        private Companion() {
        }

        public final Uuid getNIL() {
            return NIL;
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid fromLongs(long mostSignificantBits, long leastSignificantBits) {
            void var3_2;
            void var1_1;
            if (mostSignificantBits == 0L && leastSignificantBits == 0L) {
                return this.getNIL();
            }
            return new Uuid((long)var1_1, (long)var3_2, null);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid fromULongs-eb3DHEI(long l, long l2) {
            void var3_2;
            void var1_1;
            return this.fromLongs((long)var1_1, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid fromByteArray(byte[] byteArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            if (!(((byte[])byteArray).length == 16)) {
                byteArray = "Expected exactly 16 bytes, but was " + UuidKt__UuidKt.access$truncateForErrorMessage((byte[])byteArray, 32) + " of size " + ((byte[])byteArray).length;
                throw new IllegalArgumentException(byteArray.toString());
            }
            return this.fromLongs(UuidKt.getLongAt((byte[])byteArray, 0), UuidKt.getLongAt((byte[])var1_1, 8));
        }

        /*
         * WARNING - void declaration
         */
        @SinceKotlin(version="2.1")
        @ExperimentalUnsignedTypes
        public final Uuid fromUByteArray-GBYM_sE(byte[] byArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter(byArray, "$v$c$kotlin-UByteArray$-ubyteArray$0");
            return this.fromByteArray((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid parse(String uuidString) {
            void var1_1;
            Intrinsics.checkNotNullParameter(uuidString, "uuidString");
            switch (uuidString.length()) {
                case 36: {
                    return UuidKt.uuidParseHexDash(uuidString);
                }
                case 32: {
                    return UuidKt.uuidParseHex(uuidString);
                }
            }
            throw new IllegalArgumentException("Expected either a 36-char string in the standard hex-and-dash UUID format or a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(uuidString, 64) + "\" of length " + var1_1.length());
        }

        /*
         * WARNING - void declaration
         */
        @SinceKotlin(version="2.1")
        public final Uuid parseHexDash(String hexDashString) {
            void var1_1;
            Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
            if (!(hexDashString.length() == 36)) {
                hexDashString = "Expected a 36-char string in the standard hex-and-dash UUID format, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(hexDashString, 64) + "\" of length " + hexDashString.length();
                throw new IllegalArgumentException(hexDashString.toString());
            }
            return UuidKt.uuidParseHexDash((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid parseHex(String hexString) {
            void var1_1;
            Intrinsics.checkNotNullParameter(hexString, "hexString");
            if (!(hexString.length() == 32)) {
                hexString = "Expected a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(hexString, 64) + "\" of length " + hexString.length();
                throw new IllegalArgumentException(hexString.toString());
            }
            return UuidKt.uuidParseHex((String)var1_1);
        }

        public final Uuid random() {
            return UuidKt.secureRandomUuid();
        }

        public final Comparator<Uuid> getLEXICAL_ORDER() {
            return ComparisonsKt.naturalOrder();
        }

        @Deprecated(message="Use naturalOrder<Uuid>() instead", replaceWith=@ReplaceWith(expression="naturalOrder<Uuid>()", imports={"kotlin.comparisons.naturalOrder"}))
        @DeprecatedSinceKotlin(warningSince="2.1")
        public static /* synthetic */ void getLEXICAL_ORDER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

