/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ExperimentalTime;
import kotlin.time.Instant;
import kotlin.time.InstantParseResult;
import kotlin.time.UnboundLocalDateTime;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\u0015\n\u0002\b\u0005\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0003\u00a2\u0006\u0004\b\b\u0010\t\u001a.\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0082\b\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a.\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0082\b\u00a2\u0006\u0004\b\u0012\u0010\u0011\u001a\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001b\u0010\u0018\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u001b\u0010\u001b\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\"\u001f\u0010\u001d\u001a\u00020\u0015*\u00020\u00058\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001e\"\u001f\u0010!\u001a\u00020\u0015*\u00020\u00058\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010 \u001a\u0004\b!\u0010\u001e\"\u0014\u0010#\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010$\"\u0014\u0010%\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010$\"\u0014\u0010&\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010$\"\u0014\u0010'\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010$\"\u0014\u0010(\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010)\"\u0014\u0010+\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b+\u0010)\"\u0014\u0010,\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010)\"\u0014\u0010-\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b-\u0010)\"\u0014\u0010.\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b.\u0010)\"\u0014\u0010/\u001a\u00020\u00138\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b/\u0010)\"\u0014\u00100\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b0\u0010)\"\u0014\u00101\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b1\u0010)\"\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\"\u0014\u00105\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00104\"\u0014\u00106\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00104\"\u0014\u00107\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00104"}, d2={"", "isoString", "Lkotlin/time/InstantParseResult;", "parseIso", "(Ljava/lang/CharSequence;)Lkotlin/time/InstantParseResult;", "Lkotlin/time/Instant;", "instant", "", "formatIso", "(Lkotlin/time/Instant;)Ljava/lang/String;", "", "a", "b", "Lkotlin/Function0;", "", "action", "safeAddOrElse", "(JJLkotlin/jvm/functions/Function0;)J", "safeMultiplyOrElse", "", "year", "", "isLeapYear", "(I)Z", "monthLength", "(IZ)I", "maxLength", "truncateForErrorMessage", "(Ljava/lang/CharSequence;I)Ljava/lang/String;", "isDistantPast", "(Lkotlin/time/Instant;)Z", "isDistantPast$annotations", "(Lkotlin/time/Instant;)V", "isDistantFuture", "isDistantFuture$annotations", "DISTANT_PAST_SECONDS", "J", "DISTANT_FUTURE_SECONDS", "MIN_SECOND", "MAX_SECOND", "DAYS_PER_CYCLE", "I", "DAYS_0000_TO_1970", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "HOURS_PER_DAY", "SECONDS_PER_DAY", "NANOS_PER_SECOND", "NANOS_PER_MILLI", "MILLIS_PER_SECOND", "", "POWERS_OF_TEN", "[I", "asciiDigitPositionsInIsoStringAfterYear", "colonsInIsoOffsetString", "asciiDigitsInIsoOffsetString"})
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlin/time/InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Instant.kt\nkotlin/time/UnboundLocalDateTime\n*L\n1#1,864:1\n1#2:865\n479#3,28:866\n*S KotlinDebug\n*F\n+ 1 Instant.kt\nkotlin/time/InstantKt\n*L\n689#1:866,28\n*E\n"})
public final class InstantKt {
    private static final long DISTANT_PAST_SECONDS = -3217862419201L;
    private static final long DISTANT_FUTURE_SECONDS = 3093527980800L;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final int DAYS_0000_TO_1970 = 719528;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    public static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int[] POWERS_OF_TEN;
    private static final int[] asciiDigitPositionsInIsoStringAfterYear;
    private static final int[] colonsInIsoOffsetString;
    private static final int[] asciiDigitsInIsoOffsetString;

    private static final boolean isDistantPast(Instant $this$isDistantPast) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$isDistantPast, "<this>");
        return instant.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalTime
    @InlineOnly
    public static /* synthetic */ void isDistantPast$annotations(Instant instant) {
    }

    private static final boolean isDistantFuture(Instant $this$isDistantFuture) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$isDistantFuture, "<this>");
        return instant.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalTime
    @InlineOnly
    public static /* synthetic */ void isDistantFuture$annotations(Instant instant) {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ExperimentalTime
    private static final InstantParseResult parseIso(CharSequence isoString) {
        void var0_1;
        void this_$iv;
        void $this$toInstant_u24lambda_u240$iv;
        void var3_7;
        int n;
        int nanosecond;
        int n2;
        int year;
        int yearStrLength2;
        int n3;
        CharSequence s = isoString;
        int i = 0;
        if (s.length() == 0) {
            return new InstantParseResult.Failure("An empty string is not a valid Instant", isoString);
        }
        char c = s.charAt(0);
        switch (c) {
            case '+': 
            case '-': {
                ++i;
                n3 = c;
                break;
            }
            default: {
                n3 = 32;
            }
        }
        int yearSign = n3;
        int yearStart22 = i;
        int absYear = 0;
        while (i < s.length()) {
            char c2 = s.charAt(i);
            boolean bl = '0' <= c2 ? c2 < ':' : false;
            if (!bl) break;
            absYear = absYear * 10 + (s.charAt(i) - 48);
            ++i;
        }
        if ((yearStrLength2 = i - yearStart22) > 10) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected at most 10 digits for the year number, got " + yearStrLength2 + " digits");
        }
        if (yearStrLength2 == 10 && Intrinsics.compare(s.charAt(yearStart22), 50) >= 0) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected at most 9 digits for the year number or year 1000000000, got " + yearStrLength2 + " digits");
        }
        if (yearStrLength2 < 4) {
            return InstantKt.parseIso$parseFailure(isoString, "The year number must be padded to 4 digits, got " + yearStrLength2 + " digits");
        }
        if (yearSign == 43 && yearStrLength2 == 4) {
            return InstantKt.parseIso$parseFailure(isoString, "The '+' sign at the start is only valid for year numbers longer than 4 digits");
        }
        if (yearSign == 32 && yearStrLength2 != 4) {
            return InstantKt.parseIso$parseFailure(isoString, "A '+' or '-' sign is required for year numbers longer than 4 digits");
        }
        int n4 = year = yearSign == 45 ? -absYear : absYear;
        if (s.length() < i + 16) {
            return InstantKt.parseIso$parseFailure(isoString, "The input string is too short");
        }
        Object yearStart22 = InstantKt.parseIso$expect(isoString, "'-'", i, InstantKt::parseIso$lambda$0);
        if (yearStart22 != null) {
            InstantParseResult.Failure yearStrLength2 = yearStart22;
            return yearStrLength2;
        }
        yearStart22 = InstantKt.parseIso$expect(isoString, "'-'", i + 3, InstantKt::parseIso$lambda$2);
        if (yearStart22 != null) {
            InstantParseResult.Failure yearStrLength2 = yearStart22;
            return yearStrLength2;
        }
        yearStart22 = InstantKt.parseIso$expect(isoString, "'T' or 't'", i + 6, InstantKt::parseIso$lambda$4);
        if (yearStart22 != null) {
            InstantParseResult.Failure yearStrLength2 = yearStart22;
            return yearStrLength2;
        }
        yearStart22 = InstantKt.parseIso$expect(isoString, "':'", i + 9, InstantKt::parseIso$lambda$6);
        if (yearStart22 != null) {
            InstantParseResult.Failure yearStrLength2 = yearStart22;
            return yearStrLength2;
        }
        yearStart22 = InstantKt.parseIso$expect(isoString, "':'", i + 12, InstantKt::parseIso$lambda$8);
        if (yearStart22 != null) {
            InstantParseResult.Failure yearStrLength2 = yearStart22;
            return yearStrLength2;
        }
        for (Object j : (Object)asciiDigitPositionsInIsoStringAfterYear) {
            InstantParseResult.Failure failure = InstantKt.parseIso$expect(isoString, "an ASCII digit", i + j, InstantKt::parseIso$lambda$10);
            if (failure == null) continue;
            InstantParseResult.Failure failure2 = failure;
            return failure2;
        }
        int month = InstantKt.parseIso$twoDigitNumber(s, i + 1);
        int day = InstantKt.parseIso$twoDigitNumber(s, i + 4);
        int hour = InstantKt.parseIso$twoDigitNumber(s, i + 7);
        int minute = InstantKt.parseIso$twoDigitNumber(s, i + 10);
        int second = InstantKt.parseIso$twoDigitNumber(s, i + 13);
        if (s.charAt(i + 15) == '.') {
            int fractionStrLength;
            int fractionStart;
            int fraction = 0;
            for (i = fractionStart = i + 16; i < s.length(); ++i) {
                char c3 = s.charAt(i);
                boolean bl = '0' <= c3 ? c3 < ':' : false;
                if (!bl) break;
                fraction = fraction * 10 + (s.charAt(i) - 48);
            }
            boolean bl = (fractionStrLength = i - fractionStart) > 0 ? fractionStrLength < 10 : false;
            if (!bl) return InstantKt.parseIso$parseFailure(isoString, "1..9 digits are supported for the fraction of the second, got " + fractionStrLength + " digits");
            n2 = fraction * POWERS_OF_TEN[9 - fractionStrLength];
        } else {
            i += 15;
            n2 = nanosecond = 0;
        }
        if (i >= s.length()) {
            return InstantKt.parseIso$parseFailure(isoString, "The UTC offset at the end of the string is missing");
        }
        char sign22 = s.charAt(i);
        switch (sign22) {
            case 'Z': 
            case 'z': {
                if (s.length() != i + 1) return InstantKt.parseIso$parseFailure(isoString, "Extra text after the instant at position " + (i + 1));
                n = 0;
                break;
            }
            case '+': 
            case '-': {
                int offsetSecond;
                int n5;
                int offsetStrLength = s.length() - i;
                if (offsetStrLength > 9) {
                    CharSequence fractionStart = s;
                    int n6 = fractionStart.length();
                    return InstantKt.parseIso$parseFailure(isoString, "The UTC offset string \"" + InstantKt.truncateForErrorMessage(((Object)fractionStart.subSequence(i, n6)).toString(), 16) + "\" is too long");
                }
                if (offsetStrLength % 3 != 0) {
                    CharSequence fractionStart = s;
                    int n7 = fractionStart.length();
                    return InstantKt.parseIso$parseFailure(isoString, "Invalid UTC offset string \"" + ((Object)fractionStart.subSequence(i, n7)).toString() + '\"');
                }
                for (int j : colonsInIsoOffsetString) {
                    if (i + j >= s.length()) break;
                    if (s.charAt(i + j) == ':') continue;
                    return InstantKt.parseIso$parseFailure(isoString, "Expected ':' at index " + (i + j) + ", got '" + s.charAt(i + j) + '\'');
                }
                for (int j : asciiDigitsInIsoOffsetString) {
                    if (i + j >= s.length()) break;
                    n5 = s.charAt(i + j);
                    if (48 <= n5 ? n5 < 58 : false) continue;
                    return InstantKt.parseIso$parseFailure(isoString, "Expected an ASCII digit at index " + (i + j) + ", got '" + s.charAt(i + j) + '\'');
                }
                int offsetHour = InstantKt.parseIso$twoDigitNumber(s, i + 1);
                int offsetMinute = offsetStrLength > 3 ? InstantKt.parseIso$twoDigitNumber(s, i + 4) : 0;
                int n8 = offsetSecond = offsetStrLength > 6 ? InstantKt.parseIso$twoDigitNumber(s, i + 7) : 0;
                if (offsetMinute > 59) {
                    return InstantKt.parseIso$parseFailure(isoString, "Expected offset-minute-of-hour in 0..59, got " + offsetMinute);
                }
                if (offsetSecond > 59) {
                    return InstantKt.parseIso$parseFailure(isoString, "Expected offset-second-of-minute in 0..59, got " + offsetSecond);
                }
                if (offsetHour > 17 && (offsetHour != 18 || offsetMinute != 0 || offsetSecond != 0)) {
                    void var1_2;
                    void j = var1_2;
                    n5 = j.length();
                    return InstantKt.parseIso$parseFailure(isoString, "Expected an offset in -18:00..+18:00, got " + ((Object)j.subSequence(i, n5)).toString());
                }
                n = (offsetHour * 3600 + offsetMinute * 60 + offsetSecond) * (sign22 == '-' ? -1 : 1);
                break;
            }
            default: {
                void var2_3;
                return InstantKt.parseIso$parseFailure(isoString, "Expected the UTC offset at position " + (int)var2_3 + ", got '" + sign22 + '\'');
            }
        }
        int offsetSeconds = n;
        if (!(month > 0 ? month < 13 : false)) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected a month number in 1..12, got " + month);
        }
        if (!(day > 0 ? day <= InstantKt.monthLength(month, InstantKt.isLeapYear(year)) : false)) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected a valid day-of-month for month " + month + " of year " + year + ", got " + day);
        }
        if (hour > 23) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected hour in 0..23, got " + hour);
        }
        if (minute > 59) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected minute-of-hour in 0..59, got " + minute);
        }
        if (second > 59) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected second-of-minute in 0..59, got " + second);
        }
        UnboundLocalDateTime sign22 = new UnboundLocalDateTime((int)var3_7, month, day, hour, minute, second, nanosecond);
        int offsetSeconds$iv = offsetSeconds;
        void $this$toInstant_u24lambda_u240_u240$iv = $this$toInstant_u24lambda_u240$iv = this_$iv;
        long y$iv = $this$toInstant_u24lambda_u240$iv.getYear();
        long total$iv = 365L * y$iv;
        total$iv = y$iv >= 0L ? (total$iv += (y$iv + 3L) / 4L - (y$iv + 99L) / 100L + (y$iv + 399L) / 400L) : (total$iv -= y$iv / -4L - y$iv / -100L + y$iv / -400L);
        total$iv += (long)((367 * $this$toInstant_u24lambda_u240_u240$iv.getMonth() - 362) / 12);
        total$iv += (long)($this$toInstant_u24lambda_u240_u240$iv.getDay() - 1);
        if ($this$toInstant_u24lambda_u240_u240$iv.getMonth() > 2) {
            total$iv += -1L;
            if (!InstantKt.isLeapYear($this$toInstant_u24lambda_u240_u240$iv.getYear())) {
                total$iv += -1L;
            }
        }
        long epochDays$iv = total$iv - 719528L;
        int daySeconds$iv = $this$toInstant_u24lambda_u240$iv.getHour() * 3600 + $this$toInstant_u24lambda_u240$iv.getMinute() * 60 + $this$toInstant_u24lambda_u240$iv.getSecond();
        long l = epochDays$iv * 86400L + (long)daySeconds$iv - (long)offsetSeconds$iv;
        daySeconds$iv = this_$iv.getNanosecond();
        long p0 = l;
        return new InstantParseResult.Success(p0, (int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    private static final String formatIso(Instant instant) {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$formatIso_u24lambda_u240 = stringBuilder = new StringBuilder();
        UnboundLocalDateTime ldt = UnboundLocalDateTime.Companion.fromInstant(instant);
        StringBuilder $this$formatIso_u24lambda_u240_u240 = $this$formatIso_u24lambda_u240;
        int number = ldt.getYear();
        if (Math.abs(number) < 1000) {
            StringBuilder innerBuilder = new StringBuilder();
            if (number >= 0) {
                Intrinsics.checkNotNullExpressionValue(innerBuilder.append(number + 10000).deleteCharAt(0), "deleteCharAt(...)");
            } else {
                Intrinsics.checkNotNullExpressionValue(innerBuilder.append(number - 10000).deleteCharAt(1), "deleteCharAt(...)");
            }
            $this$formatIso_u24lambda_u240_u240.append((CharSequence)innerBuilder);
        } else {
            if (number >= 10000) {
                $this$formatIso_u24lambda_u240_u240.append('+');
            }
            $this$formatIso_u24lambda_u240_u240.append(number);
        }
        $this$formatIso_u24lambda_u240.append('-');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getMonth());
        $this$formatIso_u24lambda_u240.append('-');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getDay());
        $this$formatIso_u24lambda_u240.append('T');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getHour());
        $this$formatIso_u24lambda_u240.append(':');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getMinute());
        $this$formatIso_u24lambda_u240.append(':');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getSecond());
        if (ldt.getNanosecond() != 0) {
            void var3_4;
            UnboundLocalDateTime unboundLocalDateTime;
            $this$formatIso_u24lambda_u240.append('.');
            int zerosToStrip = 0;
            while (ldt.getNanosecond() % POWERS_OF_TEN[zerosToStrip + 1] == 0) {
                ++zerosToStrip;
            }
            int n = zerosToStrip;
            zerosToStrip = n - n % 3;
            int numberToOutput = unboundLocalDateTime.getNanosecond() / POWERS_OF_TEN[zerosToStrip];
            unboundLocalDateTime = String.valueOf((int)(var3_4 + POWERS_OF_TEN[9 - zerosToStrip]));
            Intrinsics.checkNotNull(unboundLocalDateTime, "null cannot be cast to non-null type java.lang.String");
            String string = ((String)((Object)unboundLocalDateTime)).substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            $this$formatIso_u24lambda_u240.append(string);
        }
        var2_2.append('Z');
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final long safeAddOrElse(long a, long b, Function0 action) {
        void var2_2;
        long l;
        long sum = a + b;
        if ((a ^ sum) < 0L && (l ^ var2_2) >= 0L) {
            action.invoke();
            throw new KotlinNothingValueException();
        }
        return sum;
    }

    /*
     * WARNING - void declaration
     */
    private static final long safeMultiplyOrElse(long a, long b, Function0 action) {
        long l;
        void var2_2;
        if (b == 1L) {
            return a;
        }
        if (a == 1L) {
            return b;
        }
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long total = a * b;
        if (total / b != a || a == Long.MIN_VALUE && b == -1L || var2_2 == Long.MIN_VALUE && l == -1L) {
            action.invoke();
            throw new KotlinNothingValueException();
        }
        return total;
    }

    public static final boolean isLeapYear(int year) {
        int n;
        return (year & 3) == 0 && (year % 100 != 0 || n % 400 == 0);
    }

    /*
     * WARNING - void declaration
     */
    private static final int monthLength(int $this$monthLength, boolean isLeapYear) {
        switch ($this$monthLength) {
            case 2: {
                void var1_1;
                if (var1_1 != false) {
                    return 29;
                }
                return 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    /*
     * WARNING - void declaration
     */
    private static final String truncateForErrorMessage(CharSequence $this$truncateForErrorMessage, int maxLength) {
        void var1_1;
        CharSequence charSequence;
        if ($this$truncateForErrorMessage.length() <= maxLength) {
            return ((Object)$this$truncateForErrorMessage).toString();
        }
        return ((Object)charSequence.subSequence(0, (int)var1_1)).toString() + "...";
    }

    /*
     * WARNING - void declaration
     */
    private static final InstantParseResult.Failure parseIso$parseFailure(CharSequence $isoString, String error) {
        CharSequence charSequence;
        void var1_1;
        return new InstantParseResult.Failure((String)var1_1 + " when parsing an Instant from \"" + InstantKt.truncateForErrorMessage($isoString, 64) + '\"', charSequence);
    }

    /*
     * WARNING - void declaration
     */
    private static final InstantParseResult.Failure parseIso$expect(CharSequence $isoString, String what, int where, Function1<? super Character, Boolean> predicate) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        void var3_3;
        char c = $isoString.charAt(where);
        if (((Boolean)var3_3.invoke(Character.valueOf(c))).booleanValue()) {
            return null;
        }
        return InstantKt.parseIso$parseFailure(charSequence, "Expected " + (String)var1_1 + ", but got '" + c + "' at position " + (int)var2_2);
    }

    private static final boolean parseIso$lambda$0(char it) {
        return it == '-';
    }

    private static final boolean parseIso$lambda$2(char it) {
        return it == '-';
    }

    private static final boolean parseIso$lambda$4(char it) {
        char c;
        return it == 'T' || c == 't';
    }

    private static final boolean parseIso$lambda$6(char it) {
        return it == ':';
    }

    private static final boolean parseIso$lambda$8(char it) {
        return it == ':';
    }

    private static final boolean parseIso$lambda$10(char it) {
        if ('0' <= it) {
            char c;
            return c < ':';
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseIso$twoDigitNumber(CharSequence s, int index) {
        void var1_1;
        CharSequence charSequence;
        return (s.charAt(index) - 48) * 10 + (charSequence.charAt((int)(var1_1 + true)) - 48);
    }

    /*
     * WARNING - void declaration
     */
    private static final void formatIso$lambda$0$appendTwoDigits(Appendable $this$formatIso_u24lambda_u240_u24appendTwoDigits, StringBuilder $this_buildString, int number) {
        void var2_2;
        void var1_1;
        if (number < 10) {
            Appendable appendable;
            appendable.append('0');
        }
        var1_1.append((int)var2_2);
    }

    public static final /* synthetic */ String access$formatIso(Instant instant) {
        return InstantKt.formatIso(instant);
    }

    public static final /* synthetic */ InstantParseResult access$parseIso(CharSequence isoString) {
        return InstantKt.parseIso(isoString);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String access$truncateForErrorMessage(CharSequence $receiver, int maxLength) {
        void var1_1;
        return InstantKt.truncateForErrorMessage($receiver, (int)var1_1);
    }

    static {
        int[] nArray = new int[10];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray2[1] = 10;
        nArray2[2] = 100;
        nArray2[3] = 1000;
        nArray2[4] = 10000;
        nArray2[5] = 100000;
        nArray2[6] = 1000000;
        nArray2[7] = 10000000;
        nArray2[8] = 100000000;
        nArray2[9] = 1000000000;
        POWERS_OF_TEN = nArray2;
        int[] nArray3 = new int[10];
        nArray2 = nArray3;
        nArray3[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        nArray2[6] = 10;
        nArray2[7] = 11;
        nArray2[8] = 13;
        nArray2[9] = 14;
        asciiDigitPositionsInIsoStringAfterYear = nArray2;
        int[] nArray4 = new int[2];
        nArray2 = nArray4;
        nArray4[0] = 3;
        nArray2[1] = 6;
        colonsInIsoOffsetString = nArray2;
        int[] nArray5 = new int[6];
        nArray2 = nArray5;
        nArray5[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        asciiDigitsInIsoOffsetString = nArray2;
    }
}

