/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.CopyActionContext;
import kotlin.io.path.CopyActionResult;
import kotlin.io.path.DefaultCopyActionContext;
import kotlin.io.path.ExceptionsCollector;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.io.path.FileVisitorBuilder;
import kotlin.io.path.IllegalFileNameException;
import kotlin.io.path.LinkFollowing;
import kotlin.io.path.OnErrorResult;
import kotlin.io.path.PathsKt;
import kotlin.io.path.PathsKt__PathReadWriteKt;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a~\u0010\u000e\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002Q\b\u0002\u0010\n\u001aK\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0001\u0012\u0017\u0012\u00150\u0006j\u0002`\u0007\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u00bb\u0001\u0010\u000e\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002Q\b\u0002\u0010\n\u001aK\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0001\u0012\u0017\u0012\u00150\u0006j\u0002`\u0007\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u00022\u0006\u0010\f\u001a\u00020\u000b2C\b\u0002\u0010\u0013\u001a=\u0012\u0004\u0012\u00020\u0010\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0001\u0012\u0004\u0012\u00020\u00110\u0002\u00a2\u0006\u0002\b\u0012H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0014\u001a\u0013\u0010\u0018\u001a\u00020\u0015*\u00020\u0011H\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0013\u0010\u0018\u001a\u00020\u0015*\u00020\tH\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0019\u001a\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001d\u0010 \u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u001d*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a&\u0010'\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0082\b\u00a2\u0006\u0004\b%\u0010&\u001a&\u0010+\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010(2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0082\b\u00a2\u0006\u0004\b)\u0010*\u001a3\u00100\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00000,2\u0006\u0010\u0004\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u00002\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b.\u0010/\u001a)\u00103\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00000,2\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b1\u00102\u001a5\u0010:\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00000,2\u0006\u00104\u001a\u00020\u00002\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206H\u0002\u00a2\u0006\u0004\b8\u00109\u001a)\u0010>\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u00002\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b<\u0010=\u001a\u001f\u0010B\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b@\u0010A\u001a\u0013\u0010C\u001a\u00020\u001a*\u00020\u0000H\u0000\u00a2\u0006\u0004\bC\u0010\u001c\u001a\u001b\u0010F\u001a\u00020\u001a*\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\bD\u0010E"}, d2={"Ljava/nio/file/Path;", "target", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "source", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "Lkotlin/io/path/OnErrorResult;", "onError", "", "followLinks", "overwrite", "copyToRecursively", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function3;ZZ)Ljava/nio/file/Path;", "Lkotlin/io/path/CopyActionContext;", "Lkotlin/io/path/CopyActionResult;", "Lkotlin/ExtensionFunctionType;", "copyAction", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function3;ZLkotlin/jvm/functions/Function3;)Ljava/nio/file/Path;", "Ljava/nio/file/FileVisitResult;", "toFileVisitResult$PathsKt__PathRecursiveFunctionsKt", "(Lkotlin/io/path/CopyActionResult;)Ljava/nio/file/FileVisitResult;", "toFileVisitResult", "(Lkotlin/io/path/OnErrorResult;)Ljava/nio/file/FileVisitResult;", "", "deleteRecursively", "(Ljava/nio/file/Path;)V", "", "deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/Path;)Ljava/util/List;", "deleteRecursivelyImpl", "Lkotlin/io/path/ExceptionsCollector;", "collector", "Lkotlin/Function0;", "function", "collectIfThrows$PathsKt__PathRecursiveFunctionsKt", "(Lkotlin/io/path/ExceptionsCollector;Lkotlin/jvm/functions/Function0;)V", "collectIfThrows", "R", "tryIgnoreNoSuchFileException$PathsKt__PathRecursiveFunctionsKt", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "tryIgnoreNoSuchFileException", "Ljava/nio/file/SecureDirectoryStream;", "parent", "handleEntry$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/SecureDirectoryStream;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/io/path/ExceptionsCollector;)V", "handleEntry", "enterDirectory$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/SecureDirectoryStream;Ljava/nio/file/Path;Lkotlin/io/path/ExceptionsCollector;)V", "enterDirectory", "entryName", "", "Ljava/nio/file/LinkOption;", "options", "isDirectory$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/SecureDirectoryStream;Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "isDirectory", "entry", "insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/io/path/ExceptionsCollector;)V", "insecureHandleEntry", "path", "insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/Path;Lkotlin/io/path/ExceptionsCollector;)V", "insecureEnterDirectory", "checkFileName", "checkNotSameAs$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "checkNotSameAs"}, xs="kotlin/io/path/PathsKt")
@SourceDebugExtension(value={"SMAP\nPathRecursiveFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathRecursiveFunctions.kt\nkotlin/io/path/PathsKt__PathRecursiveFunctionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,532:1\n378#1,2:536\n386#1:538\n386#1:539\n380#1,4:540\n378#1,2:544\n386#1:546\n380#1,4:547\n386#1:551\n378#1,6:552\n378#1,2:558\n386#1:560\n380#1,4:561\n1#2:533\n1869#3,2:534\n*S KotlinDebug\n*F\n+ 1 PathRecursiveFunctions.kt\nkotlin/io/path/PathsKt__PathRecursiveFunctionsKt\n*L\n394#1:536,2\n409#1:538\n412#1:539\n394#1:540,4\n420#1:544,2\n421#1:546\n420#1:547,4\n432#1:551\n440#1:552,6\n463#1:558,2\n464#1:560\n463#1:561,4\n314#1:534,2\n*E\n"})
class PathsKt__PathRecursiveFunctionsKt
extends PathsKt__PathReadWriteKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalPathApi
    @SinceKotlin(version="1.8")
    public static final Path copyToRecursively(Path $this$copyToRecursively, Path target, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> onError, boolean followLinks, boolean overwrite) {
        void var3_3;
        void var2_2;
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$copyToRecursively, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(onError, "onError");
        if (overwrite) {
            boolean bl = followLinks;
            return PathsKt.copyToRecursively($this$copyToRecursively, target, onError, bl, (arg_0, arg_1, arg_2) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$0$PathsKt__PathRecursiveFunctionsKt(bl, arg_0, arg_1, arg_2));
        }
        return PathsKt.copyToRecursively$default(path, (Path)var1_1, (Function3)var2_2, (boolean)var3_3, null, 8, null);
    }

    public static /* synthetic */ Path copyToRecursively$default(Path path, Path path2, Function3 function3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            function3 = copyToRecursively.1.INSTANCE;
        }
        return PathsKt.copyToRecursively(path, path2, (Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)function3, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalPathApi
    @SinceKotlin(version="1.8")
    public static final Path copyToRecursively(Path $this$copyToRecursively, Path target, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> onError, boolean followLinks, Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult> copyAction) {
        void var1_1;
        void var2_2;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$copyToRecursively, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(onError, "onError");
        Intrinsics.checkNotNullParameter(copyAction, "copyAction");
        Path path2 = $this$copyToRecursively;
        LinkOption[] linkOptionArray = LinkFollowing.INSTANCE.toLinkOptions(followLinks);
        linkOptionArray = Arrays.copyOf(linkOptionArray, linkOptionArray.length);
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new NoSuchFileException(((Object)$this$copyToRecursively).toString(), ((Object)target).toString(), "The source file doesn't exist.");
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists($this$copyToRecursively, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && (followLinks || !Files.isSymbolicLink($this$copyToRecursively))) {
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            boolean targetExistsAndNotSymlink = Files.exists(target, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && !Files.isSymbolicLink(target);
            if (!targetExistsAndNotSymlink || !Files.isSameFile($this$copyToRecursively, target)) {
                boolean bl;
                if (!Intrinsics.areEqual($this$copyToRecursively.getFileSystem(), target.getFileSystem())) {
                    bl = false;
                } else if (targetExistsAndNotSymlink) {
                    bl = target.toRealPath(new LinkOption[0]).startsWith($this$copyToRecursively.toRealPath(new LinkOption[0]));
                } else {
                    Path path3 = target.getParent();
                    if (path3 != null) {
                        Path it = path3;
                        LinkOption[] linkOptionArray4 = new LinkOption[]{};
                        bl = Files.exists(path3, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) && it.toRealPath(new LinkOption[0]).startsWith($this$copyToRecursively.toRealPath(new LinkOption[0]));
                    } else {
                        boolean bl2;
                        bl = bl2 = false;
                    }
                }
                if (bl) {
                    throw new FileSystemException(((Object)$this$copyToRecursively).toString(), ((Object)target).toString(), "Recursively copying a directory into its subdirectory is prohibited.");
                }
            }
        }
        Path normalizedTarget = target.normalize();
        ArrayList stack = new ArrayList();
        PathsKt.visitFileTree$default($this$copyToRecursively, 0, (boolean)var3_3, arg_0 -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$3$PathsKt__PathRecursiveFunctionsKt(stack, copyAction, path, target, normalizedTarget, (Function3)var2_2, arg_0), 1, null);
        return var1_1;
    }

    public static /* synthetic */ Path copyToRecursively$default(Path path, Path path2, Function3 function3, boolean bl, Function3 function32, int n, Object object) {
        if ((n & 2) != 0) {
            function3 = copyToRecursively.3.INSTANCE;
        }
        if ((n & 8) != 0) {
            function32 = (arg_0, arg_1, arg_2) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$1$PathsKt__PathRecursiveFunctionsKt(bl, arg_0, arg_1, arg_2);
        }
        return PathsKt.copyToRecursively(path, path2, (Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)function3, bl, function32);
    }

    @ExperimentalPathApi
    private static final FileVisitResult toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(CopyActionResult $this$toFileVisitResult) {
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toFileVisitResult.ordinal()]) {
            case 1: {
                return FileVisitResult.CONTINUE;
            }
            case 2: {
                return FileVisitResult.TERMINATE;
            }
            case 3: {
                return FileVisitResult.SKIP_SUBTREE;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @ExperimentalPathApi
    private static final FileVisitResult toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(OnErrorResult $this$toFileVisitResult) {
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toFileVisitResult.ordinal()]) {
            case 1: {
                return FileVisitResult.TERMINATE;
            }
            case 2: {
                return FileVisitResult.SKIP_SUBTREE;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @ExperimentalPathApi
    @SinceKotlin(version="1.8")
    public static final void deleteRecursively(Path $this$deleteRecursively) {
        Intrinsics.checkNotNullParameter($this$deleteRecursively, "<this>");
        List<Exception> suppressedExceptions = PathsKt__PathRecursiveFunctionsKt.deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt($this$deleteRecursively);
        if (!((Collection)suppressedExceptions).isEmpty()) {
            List<Exception> list;
            FileSystemException fileSystemException;
            FileSystemException $this$deleteRecursively_u24lambda_u240 = fileSystemException = new FileSystemException("Failed to delete one or more files. See suppressed exceptions for details.");
            list = list;
            list = list.iterator();
            while (list.hasNext()) {
                Object e = list.next();
                Exception it = (Exception)e;
                ExceptionsKt.addSuppressed($this$deleteRecursively_u24lambda_u240, (Throwable)e);
            }
            throw (Throwable)fileSystemException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Exception> deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt(Path $this$deleteRecursivelyImpl2) {
        void var1_2;
        void var2_3;
        ExceptionsCollector collector = new ExceptionsCollector(0, 1, null);
        boolean useInsecure = true;
        Path path = $this$deleteRecursivelyImpl2.getFileName();
        if (path != null) {
            Closeable closeable;
            Path fileName = path;
            Path path2 = $this$deleteRecursivelyImpl2.getParent();
            if (path2 == null) {
                path2 = $this$deleteRecursivelyImpl2.getFileSystem().getPath("", new String[0]);
            }
            Path parent = path2;
            try {
                closeable = Files.newDirectoryStream(parent);
            }
            catch (Throwable throwable) {
                closeable = null;
            }
            if (closeable != null) {
                block10: {
                    closeable = closeable;
                    Throwable throwable = null;
                    try {
                        void var3_4;
                        Closeable stream = closeable;
                        if (!(stream instanceof SecureDirectoryStream)) break block10;
                        useInsecure = false;
                        collector.setPath(parent);
                        PathsKt__PathRecursiveFunctionsKt.handleEntry$PathsKt__PathRecursiveFunctionsKt((SecureDirectoryStream)stream, (Path)var3_4, null, collector);
                    }
                    catch (Throwable throwable2) {
                        try {
                            $this$deleteRecursivelyImpl2 = throwable2;
                            throwable = throwable2;
                            throw $this$deleteRecursivelyImpl2;
                        }
                        catch (Throwable $this$deleteRecursivelyImpl2) {
                            CloseableKt.closeFinally(closeable, throwable);
                            throw $this$deleteRecursivelyImpl2;
                        }
                    }
                }
                CloseableKt.closeFinally(closeable, null);
            }
        }
        if (var2_3 != false) {
            Path path3;
            PathsKt__PathRecursiveFunctionsKt.insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(path3, null, collector);
        }
        return var1_2.getCollectedExceptions();
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectIfThrows$PathsKt__PathRecursiveFunctionsKt(ExceptionsCollector collector, Function0<Unit> function) {
        try {
            function.invoke();
            return;
        }
        catch (Exception exception) {
            void var1_2;
            ExceptionsCollector exceptionsCollector;
            exceptionsCollector.collect((Exception)var1_2);
            return;
        }
    }

    private static final <R> R tryIgnoreNoSuchFileException$PathsKt__PathRecursiveFunctionsKt(Function0<? extends R> function) {
        Function0<Object> function0;
        try {
            function0 = function.invoke();
        }
        catch (NoSuchFileException noSuchFileException) {
            function0 = null;
        }
        return (R)function0;
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleEntry$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> $this$handleEntry, Path name, Path parent, ExceptionsCollector collector) {
        void var1_2;
        void var3_4;
        collector.enterEntry(name);
        ExceptionsCollector collector$iv = collector;
        try {
            LinkOption[] entry;
            if (parent != null) {
                void var2_3;
                LinkOption[] linkOptionArray = collector.getPath();
                Intrinsics.checkNotNull(linkOptionArray);
                entry = linkOptionArray;
                PathsKt.checkFileName((Path)linkOptionArray);
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt((Path)entry, (Path)var2_3);
            }
            LinkOption[] linkOptionArray = new LinkOption[1];
            entry = linkOptionArray;
            linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
            if (PathsKt__PathRecursiveFunctionsKt.isDirectory$PathsKt__PathRecursiveFunctionsKt($this$handleEntry, name, entry)) {
                int preEnterTotalExceptions = collector.getTotalExceptions();
                PathsKt__PathRecursiveFunctionsKt.enterDirectory$PathsKt__PathRecursiveFunctionsKt($this$handleEntry, name, collector);
                if (preEnterTotalExceptions == collector.getTotalExceptions()) {
                    try {
                        $this$handleEntry.deleteDirectory(name);
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                }
            } else {
                try {
                    $this$handleEntry.deleteFile(name);
                }
                catch (NoSuchFileException noSuchFileException) {}
            }
        }
        catch (Exception exception$iv) {
            void var0_1;
            collector$iv.collect((Exception)var0_1);
        }
        var3_4.exitEntry((Path)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void enterDirectory$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> $this$enterDirectory, Path name, ExceptionsCollector collector) {
        ExceptionsCollector collector$iv = collector;
        try {
            block10: {
                block9: {
                    Throwable throwable;
                    Object object;
                    try {
                        LinkOption[] linkOptionArray = new LinkOption[1];
                        object = linkOptionArray;
                        linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
                        object = $this$enterDirectory.newDirectoryStream(throwable, (LinkOption)object);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        object = null;
                    }
                    $this$enterDirectory = object;
                    if (object == null) break block9;
                    $this$enterDirectory = (Closeable)$this$enterDirectory;
                    throwable = null;
                    try {
                        SecureDirectoryStream directoryStream = (SecureDirectoryStream)$this$enterDirectory;
                        Iterator iterator2 = directoryStream.iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                        Iterator iterator3 = iterator2;
                        while (iterator3.hasNext()) {
                            Path entry = (Path)iterator3.next();
                            Path path = entry.getFileName();
                            Intrinsics.checkNotNullExpressionValue(path, "getFileName(...)");
                            PathsKt__PathRecursiveFunctionsKt.handleEntry$PathsKt__PathRecursiveFunctionsKt(directoryStream, path, collector.getPath(), collector);
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            object = throwable2;
                            throwable = throwable2;
                            throw object;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)$this$enterDirectory, throwable);
                            throw throwable3;
                        }
                    }
                    break block10;
                }
                return;
            }
            CloseableKt.closeFinally((Closeable)$this$enterDirectory, null);
        }
        catch (Exception exception$iv) {
            void var0_1;
            void var3_4;
            var3_4.collect((Exception)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isDirectory$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> $this$isDirectory, Path entryName, LinkOption ... options) {
        Object object;
        try {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            object = $this$isDirectory.getFileAttributeView((Path)var1_1, BasicFileAttributeView.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length)).readAttributes().isDirectory();
        }
        catch (NoSuchFileException noSuchFileException) {
            object = null;
        }
        SecureDirectoryStream<Path> secureDirectoryStream = object;
        if (secureDirectoryStream != null) {
            return (Boolean)((Object)secureDirectoryStream);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(Path entry, Path parent, ExceptionsCollector collector) {
        ExceptionsCollector collector$iv = collector;
        try {
            block5: {
                block4: {
                    block3: {
                        void var2_4;
                        void var1_3;
                        if (parent != null) {
                            PathsKt.checkFileName(entry);
                            PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(entry, parent);
                        }
                        parent = entry;
                        LinkOption[] linkOptionArray = new LinkOption[1];
                        LinkOption[] linkOptionArray2 = linkOptionArray;
                        linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
                        if (!Files.isDirectory(parent, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block3;
                        int preEnterTotalExceptions = collector.getTotalExceptions();
                        PathsKt__PathRecursiveFunctionsKt.insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt(entry, collector);
                        if (var1_3 != var2_4.getTotalExceptions()) break block4;
                        break block5;
                    }
                    Files.deleteIfExists(entry);
                }
                return;
            }
            Files.deleteIfExists(entry);
        }
        catch (Exception exception$iv) {
            void var0_1;
            void var3_5;
            var3_5.collect((Exception)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt(Path path2, ExceptionsCollector collector) {
        ExceptionsCollector collector$iv = collector;
        try {
            Closeable closeable;
            block10: {
                block9: {
                    Object object;
                    try {
                        object = Files.newDirectoryStream((Path)path2);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        object = null;
                    }
                    closeable = object;
                    if (closeable == null) break block9;
                    closeable = closeable;
                    Throwable throwable = null;
                    try {
                        object = closeable;
                        Iterator iterator2 = object.iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                        object = iterator2;
                        while (object.hasNext()) {
                            Path entry = (Path)object.next();
                            Intrinsics.checkNotNull(entry);
                            PathsKt__PathRecursiveFunctionsKt.insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(entry, (Path)path2, collector);
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            path2 = throwable2;
                            throwable = throwable2;
                            throw path2;
                        }
                        catch (Throwable path2) {
                            CloseableKt.closeFinally(closeable, throwable);
                            throw path2;
                        }
                    }
                    break block10;
                }
                return;
            }
            CloseableKt.closeFinally(closeable, null);
        }
        catch (Exception exception$iv) {
            void var0_2;
            void var2_4;
            var2_4.collect((Exception)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkFileName(Path $this$checkFileName) {
        Intrinsics.checkNotNullParameter($this$checkFileName, "<this>");
        String fileName = PathsKt.getName($this$checkFileName);
        switch (fileName.hashCode()) {
            case 1472: {
                Path path;
                if (fileName.equals("..")) throw new IllegalFileNameException(path);
                return;
            }
            case 1473: {
                Path path;
                if (fileName.equals("./")) throw new IllegalFileNameException(path);
                return;
            }
            case 45724: {
                Path path;
                if (fileName.equals("..\\")) throw new IllegalFileNameException(path);
                return;
            }
            case 46: {
                Path path;
                if (fileName.equals(".")) throw new IllegalFileNameException(path);
                return;
            }
            case 1518: {
                Path path;
                if (fileName.equals(".\\")) throw new IllegalFileNameException(path);
                return;
            }
            case 45679: {
                void var1_1;
                Path path;
                if (!var1_1.equals("../")) return;
                throw new IllegalFileNameException(path);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(Path $this$checkNotSameAs, Path parent) {
        void var1_1;
        if (!Files.isSymbolicLink($this$checkNotSameAs) && Files.isSameFile($this$checkNotSameAs, (Path)var1_1)) {
            Path path;
            throw new FileSystemLoopException(((Object)path).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final CopyActionResult copyToRecursively$lambda$0$PathsKt__PathRecursiveFunctionsKt(boolean $followLinks, CopyActionContext $this$copyToRecursively, Path src, Path dst) {
        Intrinsics.checkNotNullParameter($this$copyToRecursively, "$this$copyToRecursively");
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dst, "dst");
        LinkOption[] options = LinkFollowing.INSTANCE.toLinkOptions($followLinks);
        Path path = dst;
        LinkOption[] linkOptionArray = new LinkOption[1];
        $this$copyToRecursively = linkOptionArray;
        linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
        boolean dstIsDirectory = Files.isDirectory(path, Arrays.copyOf($this$copyToRecursively, $this$copyToRecursively.length));
        LinkOption[] linkOptionArray2 = Arrays.copyOf(options, options.length);
        boolean bl = Files.isDirectory(src, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        if (!bl || !dstIsDirectory) {
            void var3_6;
            void var0_1;
            CopyOption[] copyOptionArray;
            void var1_3;
            if (var1_3 != false) {
                PathsKt.deleteRecursively(dst);
            }
            void var1_4 = copyOptionArray;
            copyOptionArray = new SpreadBuilder(2);
            copyOptionArray.addSpread(var0_1);
            copyOptionArray.add(StandardCopyOption.REPLACE_EXISTING);
            copyOptionArray = (CopyOption[])copyOptionArray.toArray(new CopyOption[copyOptionArray.size()]);
            Intrinsics.checkNotNullExpressionValue(Files.copy((Path)var1_4, (Path)var3_6, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), "copy(...)");
        }
        return CopyActionResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    private static final CopyActionResult copyToRecursively$lambda$1$PathsKt__PathRecursiveFunctionsKt(boolean $followLinks, CopyActionContext copyActionContext, Path src, Path dst) {
        boolean bl;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(copyActionContext, "<this>");
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dst, "dst");
        return var1_1.copyToIgnoringExistingDirectory((Path)var2_2, (Path)var3_3, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Path copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(Path $this_copyToRecursively, Path $target, Path normalizedTarget, Path source) {
        Path path;
        void var2_2;
        void var1_1;
        Path relativePath = PathsKt.relativeTo(source, $this_copyToRecursively);
        Path destination = var1_1.resolve(((Object)relativePath).toString());
        if (!destination.normalize().startsWith((Path)var2_2)) {
            void var3_3;
            throw new IllegalFileNameException((Path)var3_3, destination, "Copying files to outside the specified target directory is prohibited. The directory being recursively copied might contain an entry with an illegal name.");
        }
        Intrinsics.checkNotNull(destination);
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private static final FileVisitResult copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> $onError, Path $this_copyToRecursively, Path $target, Path normalizedTarget, Path source, Exception exception) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PathsKt__PathRecursiveFunctionsKt.toFileVisitResult$PathsKt__PathRecursiveFunctionsKt($onError.invoke(source, PathsKt__PathRecursiveFunctionsKt.copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt((Path)var1_1, (Path)var2_2, (Path)var3_3, source), exception));
    }

    /*
     * WARNING - void declaration
     */
    private static final FileVisitResult copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(ArrayList<Path> stack, Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult> $copyAction, Path $this_copyToRecursively, Path $target, Path normalizedTarget, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> $onError, Path source, BasicFileAttributes attributes) {
        Object object;
        try {
            void var1_2;
            if (!((Collection)stack).isEmpty()) {
                PathsKt.checkFileName(source);
                Object t = CollectionsKt.last((List)stack);
                Intrinsics.checkNotNullExpressionValue(t, "last(...)");
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(source, (Path)t);
            }
            stack = PathsKt__PathRecursiveFunctionsKt.toFileVisitResult$PathsKt__PathRecursiveFunctionsKt((CopyActionResult)((Object)var1_2.invoke(DefaultCopyActionContext.INSTANCE, source, PathsKt__PathRecursiveFunctionsKt.copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt($this_copyToRecursively, $target, normalizedTarget, source))));
        }
        catch (Exception exception) {
            void var0_1;
            void var3_4;
            void var2_3;
            object = PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt($onError, (Path)var2_3, (Path)var3_4, normalizedTarget, source, (Exception)var0_1);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit copyToRecursively$lambda$3$PathsKt__PathRecursiveFunctionsKt(ArrayList $stack, Function3 $copyAction, Path $this_copyToRecursively, Path $target, Path $normalizedTarget, Function3 $onError, FileVisitorBuilder $this$visitFileTree) {
        void var3_3;
        void var2_2;
        ArrayList arrayList;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$visitFileTree, "$this$visitFileTree");
        $this$visitFileTree.onPreVisitDirectory((arg_0, arg_1) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$3$0$PathsKt__PathRecursiveFunctionsKt($stack, $copyAction, $this_copyToRecursively, $target, $normalizedTarget, $onError, arg_0, arg_1));
        $this$visitFileTree.onVisitFile((Function2<? super Path, ? super BasicFileAttributes, ? extends FileVisitResult>)new Function2<Path, BasicFileAttributes, FileVisitResult>((ArrayList<Path>)$stack, (Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult>)var1_1, $this_copyToRecursively, $target, $normalizedTarget, (Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)$onError){
            final /* synthetic */ ArrayList<Path> $stack;
            final /* synthetic */ Function3<CopyActionContext, Path, Path, CopyActionResult> $copyAction;
            final /* synthetic */ Path $this_copyToRecursively;
            final /* synthetic */ Path $target;
            final /* synthetic */ Path $normalizedTarget;
            final /* synthetic */ Function3<Path, Path, Exception, OnErrorResult> $onError;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$stack = var1_1;
                this.$copyAction = var2_2;
                this.$this_copyToRecursively = var3_3;
                this.$target = $target;
                this.$normalizedTarget = $normalizedTarget;
                this.$onError = $onError;
                super(2, Intrinsics.Kotlin.class, "copy", "copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(Ljava/util/ArrayList;Lkotlin/jvm/functions/Function3;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function3;Ljava/nio/file/Path;Ljava/nio/file/attribute/BasicFileAttributes;)Ljava/nio/file/FileVisitResult;", 0);
            }

            /*
             * WARNING - void declaration
             */
            public final FileVisitResult invoke(Path p0, BasicFileAttributes p1) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return PathsKt__PathRecursiveFunctionsKt.access$copyToRecursively$copy(this.$stack, this.$copyAction, this.$this_copyToRecursively, this.$target, this.$normalizedTarget, this.$onError, (Path)var1_1, (BasicFileAttributes)var2_2);
            }
        });
        $this$visitFileTree.onVisitFileFailed((Function2<? super Path, ? super IOException, ? extends FileVisitResult>)new Function2<Path, Exception, FileVisitResult>((Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)$onError, $this_copyToRecursively, $target, $normalizedTarget){
            final /* synthetic */ Function3<Path, Path, Exception, OnErrorResult> $onError;
            final /* synthetic */ Path $this_copyToRecursively;
            final /* synthetic */ Path $target;
            final /* synthetic */ Path $normalizedTarget;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$onError = var1_1;
                this.$this_copyToRecursively = var2_2;
                this.$target = var3_3;
                this.$normalizedTarget = $normalizedTarget;
                super(2, Intrinsics.Kotlin.class, "error", "copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(Lkotlin/jvm/functions/Function3;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/Exception;)Ljava/nio/file/FileVisitResult;", 0);
            }

            /*
             * WARNING - void declaration
             */
            public final FileVisitResult invoke(Path p0, Exception p1) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return PathsKt__PathRecursiveFunctionsKt.access$copyToRecursively$error(this.$onError, this.$this_copyToRecursively, this.$target, this.$normalizedTarget, (Path)var1_1, (Exception)var2_2);
            }
        });
        $this$visitFileTree.onPostVisitDirectory((arg_0, arg_1) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$3$1$PathsKt__PathRecursiveFunctionsKt(arrayList, $onError, (Path)var2_2, (Path)var3_3, $normalizedTarget, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final FileVisitResult copyToRecursively$lambda$3$0$PathsKt__PathRecursiveFunctionsKt(ArrayList $stack, Function3 $copyAction, Path $this_copyToRecursively, Path $target, Path $normalizedTarget, Function3 $onError, Path directory, BasicFileAttributes attributes) {
        void var3_3;
        FileVisitResult fileVisitResult;
        FileVisitResult fileVisitResult2;
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        fileVisitResult = fileVisitResult2 = PathsKt__PathRecursiveFunctionsKt.copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt($stack, (Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult>)((Object)fileVisitResult2), (Path)((Object)fileVisitResult), (Path)var3_3, $normalizedTarget, $onError, directory, attributes);
        if (fileVisitResult2 == FileVisitResult.CONTINUE) {
            ArrayList arrayList;
            arrayList.add(directory);
        }
        return fileVisitResult2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FileVisitResult copyToRecursively$lambda$3$1$PathsKt__PathRecursiveFunctionsKt(ArrayList $stack, Function3 $onError, Path $this_copyToRecursively, Path $target, Path $normalizedTarget, Path directory, IOException exception) {
        void var3_3;
        void var2_2;
        void var1_1;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(directory, "directory");
        CollectionsKt.removeLast(arrayList);
        if (exception == null) {
            return FileVisitResult.CONTINUE;
        }
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt((Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)var1_1, (Path)var2_2, (Path)var3_3, $normalizedTarget, directory, exception);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ FileVisitResult access$copyToRecursively$copy(ArrayList stack, Function3 $copyAction, Path $this_copyToRecursively, Path $target, Path normalizedTarget, Function3 $onError, Path source, BasicFileAttributes attributes) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(stack, (Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult>)var1_1, (Path)var2_2, (Path)var3_3, normalizedTarget, $onError, source, attributes);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ FileVisitResult access$copyToRecursively$error(Function3 $onError, Path $this_copyToRecursively, Path $target, Path normalizedTarget, Path source, Exception exception) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt($onError, (Path)var1_1, (Path)var2_2, (Path)var3_3, source, exception);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CopyActionResult.values().length];
            try {
                nArray[CopyActionResult.CONTINUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CopyActionResult.TERMINATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CopyActionResult.SKIP_SUBTREE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OnErrorResult.values().length];
            try {
                nArray[OnErrorResult.TERMINATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OnErrorResult.SKIP_SUBTREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

