/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.internal.InlineOnly;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0007\u001a2\u0010\u0007\u001a\u00020\u0006*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b\u0007\u0010\b\u001a<\u0010\f\u001a\u00020\u000b*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\t2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b\f\u0010\r\u001a2\u0010\u000f\u001a\u00020\u000e*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a<\u0010\u0012\u001a\u00020\u0011*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\t2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a0\u0010\u0019\u001a\u00020\u0018*\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u001c\u0010\u001b\u001a\u00020\u0018*\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0014H\u0087\b\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001d\u0010\u001e\u001a\u00020\u001d*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a9\u0010\"\u001a\u00020\u0018*\u00020\u00002\u0006\u0010!\u001a\u00020 2\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0007\u00a2\u0006\u0004\b\"\u0010#\u001a%\u0010$\u001a\u00020\u0018*\u00020\u00002\u0006\u0010!\u001a\u00020 2\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b$\u0010%\u001aD\u0010+\u001a\u00020\u0018*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00180&H\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,\u001a(\u0010.\u001a\u00020-*\u00020\u00002\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b.\u0010/\u001a(\u00101\u001a\u000200*\u00020\u00002\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b1\u00102\u001a$\u00104\u001a\b\u0012\u0004\u0012\u00020\u001d03*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0087\b\u00a2\u0006\u0004\b4\u00105\u001aN\u00109\u001a\u00028\u0000\"\u0004\b\u0000\u00106*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0018\u00108\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d07\u0012\u0004\u0012\u00028\u00000&H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0004\b9\u0010:\u001a@\u0010=\u001a\u00020\u0000*\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020 0;2\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b=\u0010>\u001a@\u0010=\u001a\u00020\u0000*\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020 072\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0087\b\u00a2\u0006\u0004\b=\u0010?\u001a,\u0010@\u001a\u00020\u0000*\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020 0;2\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0087\b\u00a2\u0006\u0004\b@\u0010A\u001a,\u0010@\u001a\u00020\u0000*\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020 072\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0087\b\u00a2\u0006\u0004\b@\u0010B\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Ljava/nio/file/Path;", "Ljava/nio/charset/Charset;", "charset", "", "Ljava/nio/file/OpenOption;", "options", "Ljava/io/InputStreamReader;", "reader", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/io/InputStreamReader;", "", "bufferSize", "Ljava/io/BufferedReader;", "bufferedReader", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;I[Ljava/nio/file/OpenOption;)Ljava/io/BufferedReader;", "Ljava/io/OutputStreamWriter;", "writer", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStreamWriter;", "Ljava/io/BufferedWriter;", "bufferedWriter", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;I[Ljava/nio/file/OpenOption;)Ljava/io/BufferedWriter;", "", "readBytes", "(Ljava/nio/file/Path;)[B", "array", "", "writeBytes", "(Ljava/nio/file/Path;[B[Ljava/nio/file/OpenOption;)V", "appendBytes", "(Ljava/nio/file/Path;[B)V", "", "readText", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;)Ljava/lang/String;", "", "text", "writeText", "(Ljava/nio/file/Path;Ljava/lang/CharSequence;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)V", "appendText", "(Ljava/nio/file/Path;Ljava/lang/CharSequence;Ljava/nio/charset/Charset;)V", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "line", "action", "forEachLine", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)V", "Ljava/io/InputStream;", "inputStream", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "Ljava/io/OutputStream;", "outputStream", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "", "readLines", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;)Ljava/util/List;", "T", "Lkotlin/sequences/Sequence;", "block", "useLines", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "lines", "writeLines", "(Ljava/nio/file/Path;Ljava/lang/Iterable;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/sequences/Sequence;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "appendLines", "(Ljava/nio/file/Path;Ljava/lang/Iterable;Ljava/nio/charset/Charset;)Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/sequences/Sequence;Ljava/nio/charset/Charset;)Ljava/nio/file/Path;"}, xs="kotlin/io/path/PathsKt")
@SourceDebugExtension(value={"SMAP\nPathReadWrite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathReadWrite.kt\nkotlin/io/path/PathsKt__PathReadWriteKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,327:1\n1#2:328\n1#2:330\n57#3:329\n1321#4,2:331\n*S KotlinDebug\n*F\n+ 1 PathReadWrite.kt\nkotlin/io/path/PathsKt__PathReadWriteKt\n*L\n208#1:330\n208#1:329\n208#1:331,2\n*E\n"})
class PathsKt__PathReadWriteKt {
    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final InputStreamReader reader(Path $this$reader, Charset charset, OpenOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$reader, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        return new InputStreamReader(Files.newInputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ InputStreamReader reader$default(Path $this$reader_u24default, Charset charset, OpenOption[] options, int n, Object object) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$reader_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        return new InputStreamReader(Files.newInputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final BufferedReader bufferedReader(Path $this$bufferedReader, Charset charset, int bufferSize, OpenOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$bufferedReader, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        return new BufferedReader(new InputStreamReader(Files.newInputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedReader bufferedReader$default(Path $this$bufferedReader_u24default, Charset charset, int bufferSize, OpenOption[] options, int n, Object object) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$bufferedReader_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        return new BufferedReader(new InputStreamReader(Files.newInputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final OutputStreamWriter writer(Path $this$writer, Charset charset, OpenOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$writer, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        return new OutputStreamWriter(Files.newOutputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStreamWriter writer$default(Path $this$writer_u24default, Charset charset, OpenOption[] options, int n, Object object) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$writer_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        return new OutputStreamWriter(Files.newOutputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final BufferedWriter bufferedWriter(Path $this$bufferedWriter, Charset charset, int bufferSize, OpenOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$bufferedWriter, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedWriter bufferedWriter$default(Path $this$bufferedWriter_u24default, Charset charset, int bufferSize, OpenOption[] options, int n, Object object) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$bufferedWriter_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length)), (Charset)var1_1), (int)var2_2);
    }

    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final byte[] readBytes(Path $this$readBytes) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final void writeBytes(Path $this$writeBytes, byte[] array, OpenOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$writeBytes, "<this>");
        Intrinsics.checkNotNullParameter(array, "array");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        Files.write(path, (byte[])var1_1, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final void appendBytes(Path $this$appendBytes, byte[] array) throws IOException {
        void var1_1;
        OpenOption[] openOptionArray;
        Intrinsics.checkNotNullParameter($this$appendBytes, "<this>");
        Intrinsics.checkNotNullParameter(array, "array");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        Files.write((Path)openOptionArray2, (byte[])var1_1, openOptionArray);
    }

    @SinceKotlin(version="1.5")
    public static final String readText(Path $this$readText, Charset charset) throws IOException {
        Object object;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Object object2 = new OpenOption[]{};
        closeable = new InputStreamReader(Files.newInputStream((Path)((Object)closeable), Arrays.copyOf(object2, ((OpenOption[])object2).length)), (Charset)object);
        object2 = null;
        try {
            object = (InputStreamReader)closeable;
            object = TextStreamsKt.readText((Reader)object);
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                object2 = throwable;
                throw object;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally(closeable, (Throwable)object2);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return object;
    }

    public static /* synthetic */ String readText$default(Path path, Charset charset, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathsKt.readText(path, charset);
    }

    @SinceKotlin(version="1.5")
    public static final void writeText(Path $this$writeText, CharSequence text, Charset charset, OpenOption ... options) throws IOException {
        Closeable closeable;
        block7: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter($this$writeText, "<this>");
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(charset, "charset");
            Intrinsics.checkNotNullParameter(options, "options");
            void v0 = throwable;
            closeable = Files.newOutputStream((Path)((Object)closeable), (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
            throwable = null;
            try {
                OutputStream out = (OutputStream)closeable;
                if (text instanceof String) {
                    Intrinsics.checkNotNull(out);
                    FilesKt.writeTextImpl(out, (String)text, charset);
                    break block7;
                }
                CharsetEncoder encoder = FilesKt.newReplaceEncoder(charset);
                CharBuffer charBuffer = text instanceof CharBuffer ? ((CharBuffer)text).asReadOnlyBuffer() : CharBuffer.wrap(text);
                int n = Math.min(text.length(), 8192);
                Intrinsics.checkNotNull(encoder);
                ByteBuffer byteBuffer = FilesKt.byteBufferForEncoding(n, encoder);
                while (charBuffer.hasRemaining()) {
                    CoderResult coderResult = encoder.encode(charBuffer, byteBuffer, true);
                    CoderResult coderResult2 = coderResult;
                    coderResult2 = coderResult;
                    if (!(!coderResult.isError())) {
                        throw new IllegalStateException("Check failed.");
                    }
                    out.write(byteBuffer.array(), 0, byteBuffer.position());
                    byteBuffer.clear();
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally(closeable, throwable);
                    throw throwable4;
                }
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return;
    }

    public static /* synthetic */ void writeText$default(Path path, CharSequence charSequence, Charset charset, OpenOption[] openOptionArray, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        PathsKt.writeText(path, charSequence, charset, openOptionArray);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    public static final void appendText(Path $this$appendText, CharSequence text, Charset charset) throws IOException {
        void var2_2;
        void var1_1;
        OpenOption[] openOptionArray;
        Intrinsics.checkNotNullParameter($this$appendText, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        PathsKt.writeText((Path)openOptionArray2, (CharSequence)var1_1, (Charset)var2_2, openOptionArray);
    }

    public static /* synthetic */ void appendText$default(Path path, CharSequence charSequence, Charset charset, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        PathsKt.appendText(path, charSequence, charset);
    }

    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final void forEachLine(Path $this$forEachLine, Charset charset, Function1<? super String, Unit> action) throws IOException {
        Throwable throwable;
        Object object;
        Intrinsics.checkNotNullParameter($this$forEachLine, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(action, "action");
        BufferedReader bufferedReader = Files.newBufferedReader((Path)object, (Charset)((Object)throwable));
        Intrinsics.checkNotNullExpressionValue(bufferedReader, "newBufferedReader(...)");
        Reader reader = bufferedReader;
        object = reader;
        object = reader;
        object = (BufferedReader)reader;
        throwable = null;
        try {
            Object object2 = (BufferedReader)object;
            Sequence<String> sequence = TextStreamsKt.lineSequence((BufferedReader)object2);
            object2 = sequence;
            object2 = sequence;
            object2 = sequence.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                action.invoke((String)element$iv);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                CloseableKt.closeFinally((Closeable)object, throwable);
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        CloseableKt.closeFinally((Closeable)object, null);
        InlineMarker.finallyEnd(1);
        return;
    }

    static /* synthetic */ void forEachLine$default(Path $this$forEachLine_u24default, Charset charset, Function1 action, int n, Object object) throws IOException {
        Object object2;
        Throwable throwable;
        Object object3;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$forEachLine_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(action, "action");
        BufferedReader bufferedReader = Files.newBufferedReader((Path)object3, (Charset)((Object)throwable));
        Intrinsics.checkNotNullExpressionValue(bufferedReader, "newBufferedReader(...)");
        object3 = object2 = (Reader)bufferedReader;
        object3 = (BufferedReader)object2;
        throwable = null;
        try {
            object2 = (BufferedReader)object3;
            Sequence<String> sequence = TextStreamsKt.lineSequence((BufferedReader)object2);
            object2 = sequence;
            object2 = sequence;
            object2 = sequence.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                action.invoke(element$iv);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                CloseableKt.closeFinally((Closeable)object3, throwable);
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        CloseableKt.closeFinally((Closeable)object3, null);
        InlineMarker.finallyEnd(1);
        return;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final InputStream inputStream(Path $this$inputStream, OpenOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$inputStream, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        InputStream inputStream = Files.newInputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final OutputStream outputStream(Path $this$outputStream, OpenOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$outputStream, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        OutputStream outputStream = Files.newOutputStream(path, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(outputStream, "newOutputStream(...)");
        return outputStream;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final List<String> readLines(Path $this$readLines, Charset charset) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$readLines, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        List<String> list = Files.readAllLines(path, (Charset)var1_1);
        Intrinsics.checkNotNullExpressionValue(list, "readAllLines(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List readLines$default(Path $this$readLines_u24default, Charset charset, int n, Object object) throws IOException {
        void var1_1;
        Path path;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$readLines_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        List<String> list = Files.readAllLines(path, (Charset)var1_1);
        Intrinsics.checkNotNullExpressionValue(list, "readAllLines(...)");
        return list;
    }

    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final <T> T useLines(Path $this$useLines, Charset charset, Function1<? super Sequence<String>, ? extends T> block) throws IOException {
        Object r;
        Throwable throwable;
        Throwable throwable2;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$useLines, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(block, "block");
        closeable = Files.newBufferedReader((Path)((Object)closeable), (Charset)((Object)throwable2));
        throwable2 = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            Intrinsics.checkNotNull(it);
            r = throwable.invoke(TextStreamsKt.lineSequence((BufferedReader)r));
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                CloseableKt.closeFinally(closeable, throwable2);
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        CloseableKt.closeFinally(closeable, null);
        InlineMarker.finallyEnd(1);
        return (T)r;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object useLines$default(Path $this$useLines_u24default, Charset charset, Function1 block, int n, Object object) throws IOException {
        BufferedReader bufferedReader;
        void var1_2;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$useLines_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(block, "block");
        Closeable closeable = Files.newBufferedReader($this$useLines_u24default, (Charset)var1_2);
        object = null;
        try {
            void var2_3;
            BufferedReader it = (BufferedReader)closeable;
            Intrinsics.checkNotNull(it);
            bufferedReader = var2_3.invoke(TextStreamsKt.lineSequence(bufferedReader));
        }
        catch (Throwable throwable) {
            try {
                bufferedReader = throwable;
                object = throwable;
                throw bufferedReader;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                CloseableKt.closeFinally(closeable, (Throwable)object);
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        CloseableKt.closeFinally(closeable, null);
        InlineMarker.finallyEnd(1);
        return bufferedReader;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final Path writeLines(Path $this$writeLines, Iterable<? extends CharSequence> lines, Charset charset, OpenOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$writeLines, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        Path path2 = Files.write(path, (Iterable<? extends CharSequence>)var1_1, (Charset)var2_2, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "write(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path writeLines$default(Path $this$writeLines_u24default, Iterable lines, Charset charset, OpenOption[] options, int n, Object object) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$writeLines_u24default, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        Path path2 = Files.write(path, (Iterable<? extends CharSequence>)var1_1, (Charset)var2_2, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "write(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final Path writeLines(Path $this$writeLines, Sequence<? extends CharSequence> lines, Charset charset, OpenOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$writeLines, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        Path path2 = Files.write(path, SequencesKt.asIterable(var1_1), (Charset)var2_2, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "write(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path writeLines$default(Path $this$writeLines_u24default, Sequence lines, Charset charset, OpenOption[] options, int n, Object object) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$writeLines_u24default, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        Path path2 = Files.write(path, SequencesKt.asIterable(var1_1), (Charset)var2_2, (OpenOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "write(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final Path appendLines(Path $this$appendLines, Iterable<? extends CharSequence> lines, Charset charset) throws IOException {
        void var2_2;
        void var1_1;
        OpenOption[] openOptionArray;
        Intrinsics.checkNotNullParameter($this$appendLines, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        Path path = Files.write((Path)openOptionArray2, (Iterable<? extends CharSequence>)var1_1, (Charset)var2_2, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path, "write(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path appendLines$default(Path $this$appendLines_u24default, Iterable lines, Charset charset, int n, Object openOptionArray) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$appendLines_u24default, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        OpenOption[] openOptionArray2 = new OpenOption[1];
        openOptionArray = openOptionArray2;
        openOptionArray2[0] = StandardOpenOption.APPEND;
        Path path2 = Files.write(path, (Iterable<? extends CharSequence>)var1_1, (Charset)var2_2, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path2, "write(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @InlineOnly
    private static final Path appendLines(Path $this$appendLines, Sequence<? extends CharSequence> lines, Charset charset) throws IOException {
        void var2_2;
        void var1_1;
        OpenOption[] openOptionArray;
        Intrinsics.checkNotNullParameter($this$appendLines, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        Path path = Files.write((Path)openOptionArray2, SequencesKt.asIterable(var1_1), (Charset)var2_2, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path, "write(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path appendLines$default(Path $this$appendLines_u24default, Sequence lines, Charset charset, int n, Object openOptionArray) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$appendLines_u24default, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        OpenOption[] openOptionArray2 = new OpenOption[1];
        openOptionArray = openOptionArray2;
        openOptionArray2[0] = StandardOpenOption.APPEND;
        Path path2 = Files.write(path, SequencesKt.asIterable(var1_1), (Charset)var2_2, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path2, "write(...)");
        return path2;
    }
}

