/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0006*\u00020\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0006*\u00020\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\n"}, d2={"Lkotlin/io/path/PathRelativizer;", "", "<init>", "()V", "Ljava/nio/file/Path;", "path", "base", "tryRelativeTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "emptyPath", "Ljava/nio/file/Path;", "parentPath"})
final class PathRelativizer {
    public static final PathRelativizer INSTANCE = new PathRelativizer();
    private static final Path emptyPath = Paths.get("", new String[0]);
    private static final Path parentPath = Paths.get("..", new String[0]);

    private PathRelativizer() {
    }

    /*
     * WARNING - void declaration
     */
    public final Path tryRelativeTo(Path path, Path base) {
        Object object;
        void var2_2;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(base, "base");
        Path bn = base.normalize();
        Path pn = path.normalize();
        Path rn = bn.relativize(pn);
        int n = Math.min(bn.getNameCount(), pn.getNameCount());
        for (int i = 0; i < n && Intrinsics.areEqual(bn.getName(i), parentPath); ++i) {
            if (Intrinsics.areEqual(pn.getName(i), parentPath)) continue;
            throw new IllegalArgumentException("Unable to compute relative path");
        }
        if (!Intrinsics.areEqual(pn, bn) && Intrinsics.areEqual(var2_2, emptyPath)) {
            void var1_1;
            object = var1_1;
        } else {
            void var3_3;
            String rnString = ((Object)rn).toString();
            String string = rn.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue(string, "getSeparator(...)");
            object = StringsKt.endsWith$default(rnString, string, false, 2, null) ? rn.getFileSystem().getPath(StringsKt.dropLast(rnString, rn.getFileSystem().getSeparator().length()), new String[0]) : var3_3;
        }
        void r = object;
        Intrinsics.checkNotNull(object);
        return r;
    }
}

