/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.encoding;

import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.encoding.Base64;
import kotlin.io.encoding.ExperimentalEncodingApi;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J'\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0012J'\u0010\u0019\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u000f\u0010\u001a\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0016\u0010%\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010!"}, d2={"Lkotlin/io/encoding/EncodeOutputStream;", "Ljava/io/OutputStream;", "output", "Lkotlin/io/encoding/Base64;", "base64", "<init>", "(Ljava/io/OutputStream;Lkotlin/io/encoding/Base64;)V", "", "b", "", "write", "(I)V", "", "source", "offset", "length", "([BII)V", "flush", "()V", "close", "startIndex", "endIndex", "copyIntoByteBuffer", "([BII)I", "encodeByteBufferIntoOutput", "encodeIntoOutput", "checkOpen", "Ljava/io/OutputStream;", "Lkotlin/io/encoding/Base64;", "", "isClosed", "Z", "lineLength", "I", "symbolBuffer", "[B", "byteBuffer", "byteBufferLength"})
@ExperimentalEncodingApi
final class EncodeOutputStream
extends OutputStream {
    private final OutputStream output;
    private final Base64 base64;
    private boolean isClosed;
    private int lineLength;
    private final byte[] symbolBuffer;
    private final byte[] byteBuffer;
    private int byteBufferLength;

    /*
     * WARNING - void declaration
     */
    public EncodeOutputStream(OutputStream output, Base64 base64) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(base64, "base64");
        this.output = var1_1;
        this.base64 = var2_2;
        this.lineLength = this.base64.isMimeScheme$kotlin_stdlib() ? this.base64.getMimeLineLength$kotlin_stdlib() : -1;
        this.symbolBuffer = new byte[1024];
        this.byteBuffer = new byte[3];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(int b) {
        void var1_1;
        this.checkOpen();
        int n = this.byteBufferLength;
        this.byteBufferLength = n + 1;
        this.byteBuffer[n] = (byte)var1_1;
        if (this.byteBufferLength == 3) {
            this.encodeByteBufferIntoOutput();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] source, int offset, int length) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkOpen();
        if (offset < 0 || length < 0 || offset + length > source.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", source size: " + source.length);
        }
        if (length == 0) {
            return;
        }
        if (!(this.byteBufferLength < 3)) {
            throw new IllegalStateException("Check failed.");
        }
        int startIndex = offset;
        int endIndex = startIndex + length;
        if (this.byteBufferLength != 0) {
            startIndex += this.copyIntoByteBuffer(source, startIndex, endIndex);
            if (this.byteBufferLength != 0) {
                return;
            }
        }
        while (startIndex + 3 <= endIndex) {
            int n = (this.base64.isMimeScheme$kotlin_stdlib() ? this.lineLength : this.symbolBuffer.length) / 4;
            int groupsToEncode = Math.min(n, (endIndex - startIndex) / 3);
            int bytesToEncode = groupsToEncode * 3;
            int n2 = startIndex;
            int n3 = this.encodeIntoOutput(source, n2, n2 + bytesToEncode);
            if (!(n3 == groupsToEncode << 2)) {
                throw new IllegalStateException("Check failed.");
            }
            startIndex += bytesToEncode;
        }
        ArraysKt.copyInto((byte[])var1_1, this.byteBuffer, 0, startIndex, endIndex);
        this.byteBufferLength = var3_3 - var2_2;
    }

    @Override
    public final void flush() {
        this.checkOpen();
        this.output.flush();
    }

    @Override
    public final void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.byteBufferLength != 0) {
                this.encodeByteBufferIntoOutput();
            }
            this.output.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int copyIntoByteBuffer(byte[] source, int startIndex, int endIndex) {
        void var3_3;
        void var1_1;
        void var2_2;
        int bytesToCopy = Math.min(3 - this.byteBufferLength, endIndex - startIndex);
        void v0 = var2_2;
        ArraysKt.copyInto((byte[])var1_1, this.byteBuffer, this.byteBufferLength, (int)v0, (int)(v0 + bytesToCopy));
        this.byteBufferLength += bytesToCopy;
        if (this.byteBufferLength == 3) {
            this.encodeByteBufferIntoOutput();
        }
        return (int)var3_3;
    }

    private final void encodeByteBufferIntoOutput() {
        EncodeOutputStream encodeOutputStream = this;
        int n = encodeOutputStream.encodeIntoOutput(encodeOutputStream.byteBuffer, 0, this.byteBufferLength);
        if (!(n == 4)) {
            throw new IllegalStateException("Check failed.");
        }
        this.byteBufferLength = 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int encodeIntoOutput(byte[] source, int startIndex, int endIndex) {
        void var1_2;
        void var3_4;
        void var2_3;
        int symbolsEncoded = this.base64.encodeIntoByteArray(source, this.symbolBuffer, 0, (int)var2_3, (int)var3_4);
        if (this.lineLength == 0) {
            this.output.write(Base64.Default.getMimeLineSeparatorSymbols$kotlin_stdlib());
            this.lineLength = this.base64.getMimeLineLength$kotlin_stdlib();
            if (!(symbolsEncoded <= this.base64.getMimeLineLength$kotlin_stdlib())) {
                throw new IllegalStateException("Check failed.");
            }
        }
        this.output.write(this.symbolBuffer, 0, symbolsEncoded);
        this.lineLength -= symbolsEncoded;
        return (int)var1_2;
    }

    private final void checkOpen() {
        if (this.isClosed) {
            throw new IOException("The output stream is closed.");
        }
    }
}

