/*
 * Decompiled with CFR 0.152.
 */
package kotlin.internal.jdk8;

import java.time.Instant;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.internal.jdk7.JDK7PlatformImplementations;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.jdk8.PlatformThreadLocalRandom;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.time.Clock;
import kotlin.time.ExperimentalTime;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"Lkotlin/internal/jdk8/JDK8PlatformImplementations;", "Lkotlin/internal/jdk7/JDK7PlatformImplementations;", "<init>", "()V", "", "version", "", "sdkIsNullOrAtLeast", "(I)Z", "Ljava/util/regex/MatchResult;", "matchResult", "", "name", "Lkotlin/text/MatchGroup;", "getMatchResultNamedGroup", "(Ljava/util/regex/MatchResult;Ljava/lang/String;)Lkotlin/text/MatchGroup;", "Lkotlin/random/Random;", "defaultPlatformRandom", "()Lkotlin/random/Random;", "Lkotlin/time/Clock;", "getSystemClock", "()Lkotlin/time/Clock;", "ReflectSdkVersion"})
public class JDK8PlatformImplementations
extends JDK7PlatformImplementations {
    /*
     * WARNING - void declaration
     */
    private final boolean sdkIsNullOrAtLeast(int version) {
        void var1_1;
        return ReflectSdkVersion.sdkVersion == null || ReflectSdkVersion.sdkVersion >= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MatchGroup getMatchResultNamedGroup(MatchResult matchResult, String name) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        Intrinsics.checkNotNullParameter(name, "name");
        Matcher matcher = matchResult instanceof Matcher ? (Matcher)matchResult : null;
        if (matcher == null) {
            throw new UnsupportedOperationException("Retrieving groups by name is not supported on this platform.");
        }
        Matcher matcher2 = matcher;
        IntRange range = new IntRange(matcher2.start(name), matcher2.end(name) - 1);
        if (range.getStart() >= 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            String string = var1_1.group((String)var2_2);
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            return new MatchGroup(string, (IntRange)var3_3);
        }
        return null;
    }

    @Override
    public Random defaultPlatformRandom() {
        if (this.sdkIsNullOrAtLeast(34)) {
            return new PlatformThreadLocalRandom();
        }
        return super.defaultPlatformRandom();
    }

    @Override
    @ExperimentalTime
    public Clock getSystemClock() {
        if (this.sdkIsNullOrAtLeast(26)) {
            return new Clock(){

                public final kotlin.time.Instant now() {
                    Instant instant = Instant.now();
                    Intrinsics.checkNotNullExpressionValue(instant, "now(...)");
                    return InstantConversionsJDK8Kt.toKotlinInstant(instant);
                }
            };
        }
        return new Clock(){

            public final kotlin.time.Instant now() {
                return kotlin.time.Instant.Companion.fromEpochMilliseconds(System.currentTimeMillis());
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lkotlin/internal/jdk8/JDK8PlatformImplementations$ReflectSdkVersion;", "", "<init>", "()V", "", "sdkVersion", "Ljava/lang/Integer;"})
    @SourceDebugExtension(value={"SMAP\nJDK8PlatformImplementations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JDK8PlatformImplementations.kt\nkotlin/internal/jdk8/JDK8PlatformImplementations$ReflectSdkVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
    private static final class ReflectSdkVersion {
        public static final ReflectSdkVersion INSTANCE;
        @JvmField
        public static final Integer sdkVersion;

        private ReflectSdkVersion() {
        }

        static {
            int n;
            Object object;
            INSTANCE = new ReflectSdkVersion();
            try {
                object = Class.forName("android.os.Build$VERSION").getField("SDK_INT").get(null);
                object = object instanceof Integer ? (Integer)object : null;
            }
            catch (Throwable throwable) {
                object = null;
            }
            sdkVersion = object != null ? ((n = ((Number)object).intValue()) > 0 ? object : null) : null;
        }
    }
}

