/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources.vector;

import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.StrokeCap;
import androidx.compose.ui.graphics.StrokeJoin;
import androidx.compose.ui.graphics.TileMode;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0007\u0010\u0004\u001a\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\n\u0010\u0004\u001a\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\r\u0010\u0004\u001a\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0004\u001a\u001d\u0010\u0014\u001a\u00020\u0013*\u0004\u0018\u00010\u00002\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"", "color", "", "parseColorValue", "(Ljava/lang/String;)I", "fillType", "Landroidx/compose/ui/graphics/PathFillType;", "parseFillType", "strokeCap", "Landroidx/compose/ui/graphics/StrokeCap;", "parseStrokeCap", "strokeJoin", "Landroidx/compose/ui/graphics/StrokeJoin;", "parseStrokeJoin", "tileMode", "Landroidx/compose/ui/graphics/TileMode;", "parseTileMode", "Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/ui/unit/Dp;", "parseDp", "(Ljava/lang/String;Landroidx/compose/ui/unit/Density;)F"})
@SourceDebugExtension(value={"SMAP\nValueParsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueParsers.kt\norg/jetbrains/compose/resources/vector/ValueParsersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,105:1\n1#2:106\n123#3:107\n123#3:108\n*S KotlinDebug\n*F\n+ 1 ValueParsers.kt\norg/jetbrains/compose/resources/vector/ValueParsersKt\n*L\n99#1:107\n100#1:108\n*E\n"})
public final class ValueParsersKt {
    /*
     * WARNING - void declaration
     */
    public static final int parseColorValue(String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (!StringsKt.startsWith$default((String)color, (String)"#", (boolean)false, (int)2, null)) {
            color = "Invalid color value " + (String)color;
            throw new IllegalArgumentException(color.toString());
        }
        switch (((String)color).length()) {
            case 7: {
                String string = ((String)color).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return UStringsKt.toUInt((String)string, (int)16) | 0xFF000000;
            }
            case 9: {
                String string = ((String)color).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return UStringsKt.toUInt((String)string, (int)16);
            }
            case 4: {
                String string = ((String)color).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int v = UStringsKt.toUInt((String)string, (int)16);
                int n = (v >> 8 & 0xF) * 0x110000;
                n |= (v >> 4 & 0xF) * 4352;
                return (n |= (v & 0xF) * 17) | 0xFF000000;
            }
            case 5: {
                void var0_2;
                String v;
                String string = v.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int v2 = UStringsKt.toUInt((String)string, (int)16);
                int n = (v2 >> 12 & 0xF) * 0x11000000;
                n |= (v2 >> 8 & 0xF) * 0x110000;
                n |= (v2 >> 4 & 0xF) * 4352;
                return (n |= (var0_2 & 0xF) * 17) | 0xFF000000;
            }
        }
        return -16777216;
    }

    public static final int parseFillType(String fillType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fillType, (String)"fillType");
        String string2 = fillType;
        if (Intrinsics.areEqual((Object)string2, (Object)"nonZero")) {
            return PathFillType.Companion.getNonZero-Rg-k1Os();
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"evenOdd")) {
            return PathFillType.Companion.getEvenOdd-Rg-k1Os();
        }
        throw new UnsupportedOperationException("unknown fillType: " + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parseStrokeCap(String strokeCap) {
        String string;
        Intrinsics.checkNotNullParameter((Object)strokeCap, (String)"strokeCap");
        String string2 = strokeCap;
        switch (string2.hashCode()) {
            case -894674659: {
                if (string2.equals("square")) return StrokeCap.Companion.getSquare-KaPHkGw();
                throw new UnsupportedOperationException("unknown strokeCap: " + string);
            }
            case 108704142: {
                if (string2.equals("round")) return StrokeCap.Companion.getRound-KaPHkGw();
                throw new UnsupportedOperationException("unknown strokeCap: " + string);
            }
            case 3035667: {
                if (!string2.equals("butt")) throw new UnsupportedOperationException("unknown strokeCap: " + string);
                return StrokeCap.Companion.getButt-KaPHkGw();
            }
        }
        throw new UnsupportedOperationException("unknown strokeCap: " + string);
    }

    public static final int parseStrokeJoin(String strokeJoin) {
        String string;
        Intrinsics.checkNotNullParameter((Object)strokeJoin, (String)"strokeJoin");
        switch (strokeJoin) {
            case "miter": {
                return StrokeJoin.Companion.getMiter-LxFBmk8();
            }
            case "round": {
                return StrokeJoin.Companion.getRound-LxFBmk8();
            }
            case "bevel": {
                return StrokeJoin.Companion.getBevel-LxFBmk8();
            }
        }
        throw new UnsupportedOperationException("unknown strokeJoin: " + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parseTileMode(String tileMode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tileMode, (String)"tileMode");
        String string2 = tileMode;
        switch (string2.hashCode()) {
            case -1073910849: {
                if (string2.equals("mirror")) return TileMode.Companion.getMirror-3opZhB0();
                throw new UnsupportedOperationException("unknown tileMode: " + string);
            }
            case -436781190: {
                if (string2.equals("repeated")) return TileMode.Companion.getRepeated-3opZhB0();
                throw new UnsupportedOperationException("unknown tileMode: " + string);
            }
            case 94742715: {
                if (!string2.equals("clamp")) throw new UnsupportedOperationException("unknown tileMode: " + string);
                return TileMode.Companion.getClamp-3opZhB0();
            }
        }
        throw new UnsupportedOperationException("unknown tileMode: " + string);
    }

    /*
     * WARNING - void declaration
     */
    public static final float parseDp(String $this$parseDp22, Density density) {
        String $this$parseDp22;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if ($this$parseDp22 == null) {
            return Dp.constructor-impl((float)0.0f);
        }
        if (StringsKt.endsWith$default((String)$this$parseDp22, (String)"dp", (boolean)false, (int)2, null)) {
            float $this$parseDp22 = Float.parseFloat(StringsKt.removeSuffix((String)$this$parseDp22, (CharSequence)"dp"));
            return Dp.constructor-impl((float)$this$parseDp22);
        }
        if (StringsKt.endsWith$default((String)$this$parseDp22, (String)"px", (boolean)false, (int)2, null)) {
            String string;
            void var1_2;
            return var1_2.toDp-u2uoSUM(Float.parseFloat(StringsKt.removeSuffix((String)string, (CharSequence)"px")));
        }
        throw new UnsupportedOperationException("value should ends with dp or px");
    }
}

