/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.ws.MessageDeflater;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u001d\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001c\u0010\u0016J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001f\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0016\u0010\"\u001a\u0004\u0018\u00010!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010%\u001a\u0004\u0018\u00010$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0018\u0010+\u001a\u0004\u0018\u00010*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010-R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010 R\u0011\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\u0006\n\u0004\b\u0007\u0010.R\u0011\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010/R\u0014\u00100\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010)R\u0016\u00101\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010 "}, d2={"Lokhttp3/internal/ws/WebSocketWriter;", "Ljava/io/Closeable;", "", "isClient", "Lokio/BufferedSink;", "sink", "Ljava/util/Random;", "random", "perMessageDeflate", "noContextTakeover", "", "minimumDeflateSize", "<init>", "(ZLokio/BufferedSink;Ljava/util/Random;ZZJ)V", "", "close", "()V", "", "code", "Lokio/ByteString;", "reason", "writeClose", "(ILokio/ByteString;)V", "opcode", "payload", "writeControlFrame", "formatOpcode", "data", "writeMessageFrame", "writePing", "(Lokio/ByteString;)V", "writePong", "Z", "Lokio/Buffer$UnsafeCursor;", "maskCursor", "Lokio/Buffer$UnsafeCursor;", "", "maskKey", "[B", "Lokio/Buffer;", "messageBuffer", "Lokio/Buffer;", "Lokhttp3/internal/ws/MessageDeflater;", "messageDeflater", "Lokhttp3/internal/ws/MessageDeflater;", "J", "Ljava/util/Random;", "Lokio/BufferedSink;", "sinkBuffer", "writerClosed"})
@SourceDebugExtension(value={"SMAP\nWebSocketWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketWriter.kt\nokhttp3/internal/ws/WebSocketWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class WebSocketWriter
implements Closeable {
    private final boolean isClient;
    public final BufferedSink sink;
    public final Random random;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private final long minimumDeflateSize;
    private final Buffer messageBuffer;
    private final Buffer sinkBuffer;
    private boolean writerClosed;
    private MessageDeflater messageDeflater;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    /*
     * WARNING - void declaration
     */
    public WebSocketWriter(boolean isClient, BufferedSink sink, Random random, boolean perMessageDeflate, boolean noContextTakeover, long minimumDeflateSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.isClient = var1_1;
        this.sink = var2_2;
        this.random = var3_3;
        this.perMessageDeflate = perMessageDeflate;
        this.noContextTakeover = noContextTakeover;
        this.minimumDeflateSize = minimumDeflateSize;
        this.messageBuffer = new Buffer();
        this.sinkBuffer = this.sink.getBuffer();
        this.maskKey = this.isClient ? new byte[4] : null;
        this.maskCursor = this.isClient ? new Buffer.UnsafeCursor() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void writePing(ByteString payload) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.writeControlFrame(9, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writePong(ByteString payload) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.writeControlFrame(10, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeClose(int code, ByteString reason) throws IOException {
        ByteString byteString;
        ByteString payload = ByteString.EMPTY;
        if (code != 0 || reason != null) {
            void var1_1;
            if (code != 0) {
                WebSocketProtocol.INSTANCE.validateCloseCode(code);
            }
            Buffer $this$writeClose_u24lambda_u240 = new Buffer();
            $this$writeClose_u24lambda_u240.writeShort((int)var1_1);
            if (reason != null) {
                void var2_3;
                $this$writeClose_u24lambda_u240.write((ByteString)var2_3);
            }
            byteString = byteString.readByteString();
        }
        try {
            this.writeControlFrame(8, byteString);
            return;
        }
        finally {
            this.writerClosed = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeControlFrame(int opcode22, ByteString payload) throws IOException {
        int opcode22;
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int length = payload.size();
        if (!((long)length <= 125L)) {
            String opcode22 = "Payload size must be less than or equal to 125";
            throw new IllegalArgumentException(opcode22.toString());
        }
        int b0 = 0x80 | opcode22;
        this.sinkBuffer.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            void var3_4;
            this.sinkBuffer.writeByte(b1 |= 0x80);
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (var3_4 > 0) {
                long payloadStart = this.sinkBuffer.size();
                this.sinkBuffer.write(payload);
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.sinkBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(payloadStart);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            void var2_3;
            void var1_1;
            this.sinkBuffer.writeByte((int)var1_1);
            this.sinkBuffer.write((ByteString)var2_3);
        }
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMessageFrame(int formatOpcode, ByteString data) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        this.messageBuffer.write(data);
        int b0 = formatOpcode | 0x80;
        if (this.perMessageDeflate && (long)data.size() >= this.minimumDeflateSize) {
            MessageDeflater messageDeflater = this.messageDeflater;
            if (messageDeflater == null) {
                void var3_4;
                data = new MessageDeflater(this.noContextTakeover);
                MessageDeflater it = data;
                this.messageDeflater = var3_4;
                messageDeflater = data;
            }
            MessageDeflater messageDeflater2 = messageDeflater;
            messageDeflater.deflate(this.messageBuffer);
            b0 |= 0x40;
        }
        long dataSize = this.messageBuffer.size();
        this.sinkBuffer.writeByte((int)var1_1);
        int b1 = 0;
        if (this.isClient) {
            b1 = 128;
        }
        if (dataSize <= 125L) {
            this.sinkBuffer.writeByte(b1 |= (int)dataSize);
        } else if (dataSize <= 65535L) {
            this.sinkBuffer.writeByte(b1 |= 0x7E);
            this.sinkBuffer.writeShort((int)dataSize);
        } else {
            void var2_3;
            b1 |= 0x7F;
            this.sinkBuffer.writeByte((int)var2_3);
            this.sinkBuffer.writeLong(dataSize);
        }
        if (this.isClient) {
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (dataSize > 0L) {
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.messageBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(0L);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        this.sinkBuffer.write(this.messageBuffer, dataSize);
        this.sink.emit();
    }

    @Override
    public final void close() {
        MessageDeflater messageDeflater = this.messageDeflater;
        if (messageDeflater != null) {
            messageDeflater.close();
            return;
        }
    }
}

