/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.ws.MessageInflater;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001/B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u000f\u0010\u0012\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000f\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u000f\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000eR\u0016\u0010\u0015\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0016\u0010\u001e\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0016R\u0016\u0010\u001f\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0016R\u0016\u0010!\u001a\u0004\u0018\u00010 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010$\u001a\u0004\u0018\u00010#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\u0019R\u0018\u0010(\u001a\u0004\u0018\u00010'8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0016R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0016R\u0016\u0010-\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010."}, d2={"Lokhttp3/internal/ws/WebSocketReader;", "Ljava/io/Closeable;", "", "isClient", "Lokio/BufferedSource;", "source", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "frameCallback", "perMessageDeflate", "noContextTakeover", "<init>", "(ZLokio/BufferedSource;Lokhttp3/internal/ws/WebSocketReader$FrameCallback;ZZ)V", "", "close", "()V", "processNextFrame", "readControlFrame", "readHeader", "readMessage", "readMessageFrame", "readUntilNonControlFrame", "closed", "Z", "Lokio/Buffer;", "controlFrameBuffer", "Lokio/Buffer;", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "", "frameLength", "J", "isControlFrame", "isFinalFrame", "Lokio/Buffer$UnsafeCursor;", "maskCursor", "Lokio/Buffer$UnsafeCursor;", "", "maskKey", "[B", "messageFrameBuffer", "Lokhttp3/internal/ws/MessageInflater;", "messageInflater", "Lokhttp3/internal/ws/MessageInflater;", "", "opcode", "I", "readingCompressedMessage", "Lokio/BufferedSource;", "FrameCallback"})
@SourceDebugExtension(value={"SMAP\nWebSocketReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketReader.kt\nokhttp3/internal/ws/WebSocketReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class WebSocketReader
implements Closeable {
    private final boolean isClient;
    public final BufferedSource source;
    private final FrameCallback frameCallback;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private boolean closed;
    private int opcode;
    private long frameLength;
    private boolean isFinalFrame;
    private boolean isControlFrame;
    private boolean readingCompressedMessage;
    private final Buffer controlFrameBuffer;
    private final Buffer messageFrameBuffer;
    private MessageInflater messageInflater;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    /*
     * WARNING - void declaration
     */
    public WebSocketReader(boolean isClient, BufferedSource source, FrameCallback frameCallback, boolean perMessageDeflate, boolean noContextTakeover) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)frameCallback, (String)"frameCallback");
        this.isClient = var1_1;
        this.source = var2_2;
        this.frameCallback = var3_3;
        this.perMessageDeflate = perMessageDeflate;
        this.noContextTakeover = noContextTakeover;
        this.controlFrameBuffer = new Buffer();
        this.messageFrameBuffer = new Buffer();
        this.maskKey = this.isClient ? null : new byte[4];
        this.maskCursor = this.isClient ? null : new Buffer.UnsafeCursor();
    }

    public final void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
            return;
        }
        this.readMessageFrame();
    }

    /*
     * WARNING - void declaration
     */
    private final void readHeader() throws IOException, ProtocolException {
        void var2_2;
        void var1_3;
        int b0;
        if (this.closed) {
            throw new IOException("closed");
        }
        long timeoutBefore = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            b0 = Util.and(this.source.readByte(), 255);
        }
        finally {
            this.source.timeout().timeout(timeoutBefore, TimeUnit.NANOSECONDS);
        }
        this.opcode = b0 & 0xF;
        this.isFinalFrame = (b0 & 0x80) != 0;
        boolean bl = this.isControlFrame = (b0 & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean reservedFlag1 = (b0 & 0x40) != 0;
        switch (this.opcode) {
            case 1: 
            case 2: {
                boolean bl2;
                if (reservedFlag1) {
                    if (!this.perMessageDeflate) {
                        throw new ProtocolException("Unexpected rsv1 flag");
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                this.readingCompressedMessage = bl2;
                break;
            }
            default: {
                if (!reservedFlag1) break;
                throw new ProtocolException("Unexpected rsv1 flag");
            }
        }
        if (timeoutBefore = (b0 & 0x20) != 0) {
            throw new ProtocolException("Unexpected rsv2 flag");
        }
        if ((b0 = (b0 & 0x10) != 0 ? 1 : 0) != 0) {
            throw new ProtocolException("Unexpected rsv3 flag");
        }
        int b1 = Util.and(this.source.readByte(), 255);
        boolean isMasked = (b1 & 0x80) != 0;
        if (isMasked == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = var1_3 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = Util.and(this.source.readShort(), 65535);
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Util.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (var2_2 != false) {
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.source.readFully(this.maskKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readControlFrame() throws IOException {
        if (this.frameLength > 0L) {
            this.source.readFully(this.controlFrameBuffer, this.frameLength);
            if (!this.isClient) {
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.controlFrameBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(0L);
                Intrinsics.checkNotNull((Object)this.maskKey);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                return;
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                return;
            }
            case 8: {
                void var2_2;
                void var1_1;
                int code = 1005;
                String reason = "";
                long bufferSize = this.controlFrameBuffer.size();
                if (bufferSize == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (bufferSize != 0L) {
                    code = this.controlFrameBuffer.readShort();
                    reason = this.controlFrameBuffer.readUtf8();
                    String codeExceptionMessage = WebSocketProtocol.INSTANCE.closeCodeExceptionMessage(code);
                    if (codeExceptionMessage != null) {
                        void var3_4;
                        throw new ProtocolException((String)var3_4);
                    }
                }
                this.frameCallback.onReadClose((int)var1_1, (String)var2_2);
                this.closed = true;
                return;
            }
        }
        throw new ProtocolException("Unknown control opcode: " + Util.toHexString(this.opcode));
    }

    /*
     * WARNING - void declaration
     */
    private final void readMessageFrame() throws IOException {
        void var1_1;
        int opcode = this.opcode;
        if (opcode != 1 && opcode != 2) {
            throw new ProtocolException("Unknown opcode: " + Util.toHexString(opcode));
        }
        this.readMessage();
        if (this.readingCompressedMessage) {
            MessageInflater messageInflater;
            MessageInflater messageInflater2 = this.messageInflater;
            if (messageInflater2 == null) {
                void var3_3;
                MessageInflater it = messageInflater = new MessageInflater(this.noContextTakeover);
                this.messageInflater = var3_3;
                messageInflater2 = messageInflater;
            }
            messageInflater = messageInflater2;
            messageInflater2.inflate(this.messageFrameBuffer);
        }
        if (var1_1 == true) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
            return;
        }
        this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
    }

    private final void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private final void readMessage() throws IOException {
        block4: {
            do {
                if (this.closed) {
                    throw new IOException("closed");
                }
                if (this.frameLength > 0L) {
                    this.source.readFully(this.messageFrameBuffer, this.frameLength);
                    if (!this.isClient) {
                        Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                        Intrinsics.checkNotNull((Object)unsafeCursor);
                        this.messageFrameBuffer.readAndWriteUnsafe(unsafeCursor);
                        this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                        Intrinsics.checkNotNull((Object)this.maskKey);
                        WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                        this.maskCursor.close();
                    }
                }
                if (this.isFinalFrame) break block4;
                this.readUntilNonControlFrame();
            } while (this.opcode == 0);
            throw new ProtocolException("Expected continuation opcode. Got: " + Util.toHexString(this.opcode));
        }
    }

    @Override
    public final void close() throws IOException {
        MessageInflater messageInflater = this.messageInflater;
        if (messageInflater != null) {
            messageInflater.close();
            return;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH&\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\fH&\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\fH&\u00a2\u0006\u0004\b\u0011\u0010\u000e"}, d2={"Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "", "", "code", "", "reason", "", "onReadClose", "(ILjava/lang/String;)V", "text", "onReadMessage", "(Ljava/lang/String;)V", "Lokio/ByteString;", "bytes", "(Lokio/ByteString;)V", "payload", "onReadPing", "onReadPong"})
    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

