/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 v2\u00020\u00012\u00020\u0002:\u0005wvxyzBA\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J'\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020\u000b\u00a2\u0006\u0004\b!\u0010$J\u0015\u0010'\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J#\u0010,\u001a\u00020\u00122\n\u0010+\u001a\u00060)j\u0002`*2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b,\u0010-J\u001d\u00101\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001e2\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b1\u00102J\r\u00103\u001a\u00020\u0012\u00a2\u0006\u0004\b3\u0010\u0014J\u001f\u00104\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b4\u00105J\u0017\u00107\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b7\u00108J\u0017\u00107\u001a\u00020\u00122\u0006\u0010:\u001a\u000209H\u0016\u00a2\u0006\u0004\b7\u0010;J\u0017\u0010=\u001a\u00020\u00122\u0006\u0010<\u001a\u000209H\u0016\u00a2\u0006\u0004\b=\u0010;J\u0017\u0010>\u001a\u00020\u00122\u0006\u0010<\u001a\u000209H\u0016\u00a2\u0006\u0004\b>\u0010;J\u000f\u0010?\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b?\u0010\u0014J\u0017\u0010@\u001a\u00020 2\u0006\u00106\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b@\u0010AJ\u0017\u0010@\u001a\u00020 2\u0006\u0010:\u001a\u000209H\u0016\u00a2\u0006\u0004\b@\u0010BJ\u001f\u0010@\u001a\u00020 2\u0006\u0010C\u001a\u0002092\u0006\u0010D\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b@\u0010EJ\u000f\u0010H\u001a\u00020 H\u0000\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010J\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\bI\u0010\u0014J\u0013\u0010K\u001a\u00020 *\u00020\rH\u0002\u00a2\u0006\u0004\bK\u0010LR\u0016\u0010M\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0018\u0010P\u001a\u0004\u0018\u00010O8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0016\u0010R\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010NR\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010SR\u0016\u0010T\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010NR\u0014\u0010U\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u001a\u0010\b\u001a\u00020\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\b\u0010W\u001a\u0004\bX\u0010YR\u001a\u0010\\\u001a\b\u0012\u0004\u0012\u00020[0Z8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010\u000f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010^R\u0018\u0010.\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010VR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010_R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010^R\u001a\u0010`\u001a\b\u0012\u0004\u0012\u0002090Z8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010]R\u0016\u0010a\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\ba\u0010^R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010bR\u0018\u0010d\u001a\u0004\u0018\u00010c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0016\u0010f\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0018\u0010h\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010VR\u0016\u0010i\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010gR\u0016\u0010j\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bj\u0010gR\u0016\u0010k\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bk\u0010gR\u0018\u00100\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010lR\u0016\u0010n\u001a\u00020m8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0018\u0010q\u001a\u0004\u0018\u00010p8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bq\u0010rR\u0018\u0010t\u001a\u0004\u0018\u00010s8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010u"}, d2={"Lokhttp3/internal/ws/RealWebSocket;", "Lokhttp3/WebSocket;", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "Lokhttp3/Request;", "originalRequest", "Lokhttp3/WebSocketListener;", "listener", "Ljava/util/Random;", "random", "", "pingIntervalMillis", "Lokhttp3/internal/ws/WebSocketExtensions;", "extensions", "minimumDeflateSize", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/Request;Lokhttp3/WebSocketListener;Ljava/util/Random;JLokhttp3/internal/ws/WebSocketExtensions;J)V", "", "cancel", "()V", "Lokhttp3/Response;", "response", "Lokhttp3/internal/connection/Exchange;", "exchange", "checkUpgradeSuccess$okhttp", "(Lokhttp3/Response;Lokhttp3/internal/connection/Exchange;)V", "checkUpgradeSuccess", "", "code", "", "reason", "", "close", "(ILjava/lang/String;)Z", "cancelAfterCloseMillis", "(ILjava/lang/String;J)Z", "Lokhttp3/OkHttpClient;", "client", "connect", "(Lokhttp3/OkHttpClient;)V", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "failWebSocket", "(Ljava/lang/Exception;Lokhttp3/Response;)V", "name", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "streams", "initReaderAndWriter", "(Ljava/lang/String;Lokhttp3/internal/ws/RealWebSocket$Streams;)V", "loopReader", "onReadClose", "(ILjava/lang/String;)V", "text", "onReadMessage", "(Ljava/lang/String;)V", "Lokio/ByteString;", "bytes", "(Lokio/ByteString;)V", "payload", "onReadPing", "onReadPong", "runWriter", "send", "(Ljava/lang/String;)Z", "(Lokio/ByteString;)Z", "data", "formatOpcode", "(Lokio/ByteString;I)Z", "writeOneFrame$okhttp", "()Z", "writeOneFrame", "writePingFrame$okhttp", "writePingFrame", "isValid", "(Lokhttp3/internal/ws/WebSocketExtensions;)Z", "awaitingPong", "Z", "Lokhttp3/Call;", "call", "Lokhttp3/Call;", "enqueuedClose", "Lokhttp3/internal/ws/WebSocketExtensions;", "failed", "key", "Ljava/lang/String;", "Lokhttp3/WebSocketListener;", "getListener$okhttp", "()Lokhttp3/WebSocketListener;", "Ljava/util/ArrayDeque;", "", "messageAndCloseQueue", "Ljava/util/ArrayDeque;", "J", "Lokhttp3/Request;", "pongQueue", "queueSize", "Ljava/util/Random;", "Lokhttp3/internal/ws/WebSocketReader;", "reader", "Lokhttp3/internal/ws/WebSocketReader;", "receivedCloseCode", "I", "receivedCloseReason", "receivedPingCount", "receivedPongCount", "sentPingCount", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "Lokhttp3/internal/concurrent/TaskQueue;", "taskQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "Lokhttp3/internal/ws/WebSocketWriter;", "writer", "Lokhttp3/internal/ws/WebSocketWriter;", "Lokhttp3/internal/concurrent/Task;", "writerTask", "Lokhttp3/internal/concurrent/Task;", "Companion", "Close", "Message", "Streams", "WriterTask"})
@SourceDebugExtension(value={"SMAP\nRealWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,654:1\n1#2:655\n84#3,4:656\n90#3,13:664\n608#4,4:660\n*S KotlinDebug\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n*L\n269#1:656,4\n512#1:664,13\n457#1:660,4\n*E\n"})
public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    public static final Companion Companion = new Companion(null);
    private final Request originalRequest;
    private final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private WebSocketExtensions extensions;
    private long minimumDeflateSize;
    private final String key;
    private Call call;
    private Task writerTask;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private TaskQueue taskQueue;
    private String name;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue;
    private final ArrayDeque<Object> messageAndCloseQueue;
    private long queueSize;
    private boolean enqueuedClose;
    private int receivedCloseCode;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;
    private static final List<Protocol> ONLY_HTTP1 = CollectionsKt.listOf((Object)((Object)Protocol.HTTP_1_1));

    /*
     * WARNING - void declaration
     */
    public RealWebSocket(TaskRunner taskRunner, Request originalRequest, WebSocketListener listener, Random random, long pingIntervalMillis, WebSocketExtensions extensions, long minimumDeflateSize) {
        void var2_2;
        byte[] byArray;
        RealWebSocket realWebSocket;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.originalRequest = originalRequest;
        this.listener = realWebSocket;
        this.random = random;
        this.pingIntervalMillis = pingIntervalMillis;
        this.extensions = extensions;
        this.minimumDeflateSize = minimumDeflateSize;
        this.taskQueue = byArray.newQueue();
        this.pongQueue = new ArrayDeque();
        this.messageAndCloseQueue = new ArrayDeque();
        this.receivedCloseCode = -1;
        if (!Intrinsics.areEqual((Object)"GET", (Object)this.originalRequest.method())) {
            originalRequest = "Request must be GET: " + this.originalRequest.method();
            throw new IllegalArgumentException(originalRequest.toString());
        }
        byArray = new byte[16];
        originalRequest = byArray;
        ByteString.Companion companion = ByteString.Companion;
        realWebSocket = this;
        this.random.nextBytes((byte[])var2_2);
        realWebSocket.key = ByteString.Companion.of$default((ByteString.Companion)companion, (byte[])byArray, (int)0, (int)0, (int)3, null).base64();
    }

    public final WebSocketListener getListener$okhttp() {
        return this.listener;
    }

    @Override
    public final void cancel() {
        Call call = this.call;
        Intrinsics.checkNotNull((Object)call);
        call.cancel();
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(OkHttpClient client) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.originalRequest.header("Sec-WebSocket-Extensions") != null) {
            this.failWebSocket(new ProtocolException("Request header not permitted: 'Sec-WebSocket-Extensions'"), null);
            return;
        }
        OkHttpClient webSocketClient = client.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").header("Sec-WebSocket-Extensions", "permessage-deflate").build();
        Call call = this.call = (Call)new RealCall((OkHttpClient)var1_1, request, true);
        Intrinsics.checkNotNull((Object)call);
        call.enqueue(new Callback(this, (Request)var2_2){
            final /* synthetic */ RealWebSocket this$0;
            final /* synthetic */ Request $request;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$request = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object exchange = response.exchange();
                try {
                    this.this$0.checkUpgradeSuccess$okhttp(response, (Exchange)exchange);
                    Exchange exchange2 = exchange;
                    Intrinsics.checkNotNull((Object)exchange2);
                    Streams streams = exchange2.newWebSocketStreams();
                }
                catch (IOException e) {
                    this.this$0.failWebSocket(e, response);
                    Util.closeQuietly(response);
                    Exchange exchange3 = exchange;
                    if (exchange3 != null) {
                        exchange3.webSocketUpgradeFailed();
                        return;
                    }
                    return;
                }
                WebSocketExtensions extensions = WebSocketExtensions.Companion.parse(response.headers());
                RealWebSocket.access$setExtensions$p(this.this$0, extensions);
                if (!RealWebSocket.access$isValid(this.this$0, extensions)) {
                    exchange = this.this$0;
                    RealWebSocket realWebSocket = this.this$0;
                    synchronized (exchange) {
                        RealWebSocket.access$getMessageAndCloseQueue$p(realWebSocket).clear();
                        realWebSocket.close(1010, "unexpected Sec-WebSocket-Extensions in response header");
                    }
                }
                try {
                    void var2_3;
                    void var3_5;
                    String name = Util.okHttpName + " WebSocket " + this.$request.url().redact();
                    this.this$0.initReaderAndWriter(name, (Streams)var3_5);
                    this.this$0.getListener$okhttp().onOpen(this.this$0, (Response)var2_3);
                    this.this$0.loopReader();
                    return;
                }
                catch (Exception e) {
                    void var1_2;
                    this.this$0.failWebSocket((Exception)var1_2, null);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void onFailure(Call call, IOException e) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.failWebSocket((Exception)var2_2, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValid(WebSocketExtensions $this$isValid) {
        void var1_1;
        if ($this$isValid.unknownValues) {
            return false;
        }
        if ($this$isValid.clientMaxWindowBits != null) {
            return false;
        }
        return $this$isValid.serverMaxWindowBits == null || new IntRange(8, 15).contains(var1_1.serverMaxWindowBits.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public final void checkUpgradeSuccess$okhttp(Response response, Exchange exchange) throws IOException {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + ' ' + response.message() + '\'');
        }
        String headerConnection = Response.header$default(response, "Connection", null, 2, null);
        if (!StringsKt.equals((String)"Upgrade", (String)headerConnection, (boolean)true)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + '\'');
        }
        String headerUpgrade = Response.header$default(response, "Upgrade", null, 2, null);
        if (!StringsKt.equals((String)"websocket", (String)headerUpgrade, (boolean)true)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + '\'');
        }
        String headerAccept = Response.header$default(response, "Sec-WebSocket-Accept", null, 2, null);
        String acceptExpected = ByteString.Companion.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!Intrinsics.areEqual((Object)acceptExpected, (Object)headerAccept)) {
            void var1_1;
            void var3_3;
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + (String)var3_3 + "' but was '" + (String)var1_1 + '\'');
        }
        if (var2_2 == null) {
            throw new ProtocolException("Web Socket exchange missing: bad interceptor?");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void initReaderAndWriter(String name, Streams streams) throws IOException {
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        WebSocketExtensions webSocketExtensions = this.extensions;
        Intrinsics.checkNotNull((Object)webSocketExtensions);
        WebSocketExtensions extensions = webSocketExtensions;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.name = name;
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.getClient(), streams.getSink(), this.random, extensions.perMessageDeflate, extensions.noContextTakeover(streams.getClient()), this.minimumDeflateSize);
            this.writerTask = new WriterTask();
            if (this.pingIntervalMillis != 0L) {
                void var1_1;
                void this_$iv;
                long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pingIntervalMillis);
                TaskQueue taskQueue = this.taskQueue;
                String name$iv = name + " ping";
                this_$iv.schedule(new Task((String)var1_1, this, pingIntervalNanos){
                    final /* synthetic */ RealWebSocket this$0;
                    final /* synthetic */ long $pingIntervalNanos$inlined;
                    {
                        void var1_1;
                        this.this$0 = realWebSocket;
                        this.$pingIntervalNanos$inlined = l;
                        super((String)var1_1, false, 2, null);
                    }

                    public final long runOnce() {
                        this.this$0.writePingFrame$okhttp();
                        return this.$pingIntervalNanos$inlined;
                    }
                }, pingIntervalNanos);
            }
            if (!((Collection)this.messageAndCloseQueue).isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.getClient(), streams.getSource(), this, extensions.perMessageDeflate, var3_4.noContextTakeover(!var2_3.getClient()));
    }

    public final void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull((Object)webSocketReader);
            webSocketReader.processNextFrame();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadMessage(String text) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.listener.onMessage((WebSocket)this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadMessage(ByteString bytes) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listener.onMessage((WebSocket)this, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void onReadPing(ByteString payload) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add((ByteString)var1_1);
        this.runWriter();
        int n = this.receivedPingCount;
        this.receivedPingCount = n + 1;
    }

    @Override
    public final synchronized void onReadPong(ByteString payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        int n = this.receivedPongCount;
        this.receivedPongCount = n + 1;
        this.awaitingPong = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadClose(int code22, String reason) {
        Streams streams;
        int code22;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!(code22 != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Streams toClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (!(this.receivedCloseCode == -1)) {
                String code22 = "already closed";
                throw new IllegalStateException(code22.toString());
            }
            this.receivedCloseCode = code22;
            this.receivedCloseReason = reason;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                toClose = this.streams;
                this.streams = null;
                readerToClose = this.reader;
                this.reader = null;
                writerToClose = this.writer;
                this.writer = null;
                this.taskQueue.shutdown();
            }
        }
        try {
            this.listener.onClosing(this, code22, reason);
            if (toClose != null) {
                void var2_4;
                void var1_1;
                this.listener.onClosed(this, (int)var1_1, (String)var2_4);
            }
            streams = toClose;
        }
        catch (Throwable throwable) {
            void var3_7;
            Streams streams2 = (Streams)var3_7;
            if (streams2 != null) {
                Util.closeQuietly(streams2);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter == null) {
            return;
        }
        Util.closeQuietly(webSocketWriter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean send(String text) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.send(ByteString.Companion.encodeUtf8((String)var1_1), 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean send(ByteString bytes) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.send((ByteString)var1_1, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized boolean send(ByteString data, int formatOpcode) {
        void var1_1;
        void var2_2;
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)data.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)data.size();
        this.messageAndCloseQueue.add(new Message((int)var2_2, (ByteString)var1_1));
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean close(int code, String reason) {
        void var2_2;
        void var1_1;
        return this.close((int)var1_1, (String)var2_2, 60000L);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean close(int code2, String reason, long cancelAfterCloseMillis) {
        void var3_4;
        void var1_1;
        WebSocketProtocol.INSTANCE.validateCloseCode(code2);
        ByteString reasonBytes = null;
        if (reason != null && !((long)(reasonBytes = ByteString.Companion.encodeUtf8(reason)).size() <= 123L)) {
            void var2_3;
            String code2 = "reason.size() > 123: " + (String)var2_3;
            throw new IllegalArgumentException(code2.toString());
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close((int)var1_1, reasonBytes, (long)var3_4));
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void runWriter() {
        RealWebSocket $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        Task writerTask = this.writerTask;
        if (writerTask != null) {
            void var1_1;
            TaskQueue.schedule$default(this.taskQueue, (Task)var1_1, 0L, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean writeOneFrame$okhttp() throws IOException {
        Streams streams;
        ByteString pong;
        Object writer;
        Object messageOrClose = null;
        int receivedCloseCode = 0;
        String receivedCloseReason = null;
        Streams streamsToClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            block26: {
                block25: {
                    if (!this.failed) break block25;
                    return false;
                }
                writer = this.writer;
                pong = this.pongQueue.poll();
                if (pong != null) break block26;
                messageOrClose = this.messageAndCloseQueue.poll();
                if (messageOrClose instanceof Close) {
                    receivedCloseCode = this.receivedCloseCode;
                    receivedCloseReason = this.receivedCloseReason;
                    if (receivedCloseCode != -1) {
                        streamsToClose = this.streams;
                        this.streams = null;
                        readerToClose = this.reader;
                        this.reader = null;
                        writerToClose = this.writer;
                        this.writer = null;
                        this.taskQueue.shutdown();
                    } else {
                        void name$iv;
                        void $this$iv;
                        long cancelAfterCloseMillis = ((Close)messageOrClose).getCancelAfterCloseMillis();
                        TaskQueue taskQueue = this.taskQueue;
                        String string = this.name + " cancel";
                        long delayNanos$iv = TimeUnit.MILLISECONDS.toNanos(cancelAfterCloseMillis);
                        $this$iv.schedule(new Task((String)name$iv, true, this){
                            final /* synthetic */ RealWebSocket this$0;
                            {
                                void var2_2;
                                void var1_1;
                                this.this$0 = realWebSocket;
                                super((String)var1_1, (boolean)var2_2);
                            }

                            public final long runOnce() {
                                this.this$0.cancel();
                                return -1L;
                            }
                        }, delayNanos$iv);
                    }
                    break block26;
                }
                if (messageOrClose != null) break block26;
                return false;
            }
        }
        try {
            if (pong != null) {
                void var2_11;
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull((Object)webSocketWriter);
                webSocketWriter.writePong((ByteString)var2_11);
            } else if (messageOrClose instanceof Message) {
                Message message = (Message)messageOrClose;
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull((Object)webSocketWriter);
                webSocketWriter.writeMessageFrame(message.getFormatOpcode(), message.getData());
                writer = this;
                synchronized (writer) {
                    this.queueSize -= (long)message.getData().size();
                }
            } else if (messageOrClose instanceof Close) {
                void var1_9;
                void var3_1;
                Close close = (Close)var3_1;
                void v2 = var1_9;
                Intrinsics.checkNotNull((Object)v2);
                v2.writeClose(close.getCode(), close.getReason());
                if (streamsToClose != null) {
                    WebSocket webSocket = this;
                    String string = receivedCloseReason;
                    Intrinsics.checkNotNull((Object)string);
                    this.listener.onClosed(webSocket, receivedCloseCode, string);
                }
            } else {
                throw new AssertionError();
            }
            streams = streamsToClose;
        }
        catch (Throwable throwable) {
            block27: {
                Streams streams2 = streamsToClose;
                if (streams2 != null) {
                    Util.closeQuietly(streams2);
                }
                WebSocketReader webSocketReader = readerToClose;
                if (webSocketReader != null) {
                    Util.closeQuietly(webSocketReader);
                }
                WebSocketWriter webSocketWriter = writerToClose;
                if (webSocketWriter == null) break block27;
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter != null) {
            Util.closeQuietly(webSocketWriter);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void writePingFrame$okhttp() {
        int failedPing;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            WebSocketWriter webSocketWriter = this.writer;
            if (webSocketWriter == null) {
                return;
            }
            WebSocketWriter writer = webSocketWriter;
            failedPing = this.awaitingPong ? this.sentPingCount : -1;
            int n = this.sentPingCount;
            this.sentPingCount = n + 1;
            this.awaitingPong = true;
        }
        if (failedPing != -1) {
            void var2_5;
            this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (int)(var2_5 - true) + " successful ping/pongs)"), null);
            return;
        }
        try {
            void var1_3;
            var1_3.writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException e) {
            void var3_2;
            this.failWebSocket((Exception)var3_2, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void failWebSocket(Exception e, Response response) {
        Streams streams;
        WebSocketWriter writerToClose;
        WebSocketReader readerToClose;
        Streams streamsToClose;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streamsToClose = this.streams;
            this.streams = null;
            readerToClose = this.reader;
            this.reader = null;
            writerToClose = this.writer;
            this.writer = null;
            this.taskQueue.shutdown();
        }
        try {
            void var2_3;
            void var1_1;
            this.listener.onFailure(this, (Throwable)var1_1, (Response)var2_3);
            streams = streamsToClose;
        }
        catch (Throwable throwable) {
            void var3_6;
            Streams streams2 = (Streams)var3_6;
            if (streams2 != null) {
                Util.closeQuietly(streams2);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter == null) {
            return;
        }
        Util.closeQuietly(webSocketWriter);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setExtensions$p(RealWebSocket $this, WebSocketExtensions webSocketExtensions) {
        void var1_1;
        $this.extensions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isValid(RealWebSocket $this, WebSocketExtensions $receiver) {
        void var1_1;
        return $this.isValid((WebSocketExtensions)var1_1);
    }

    public static final /* synthetic */ ArrayDeque access$getMessageAndCloseQueue$p(RealWebSocket $this) {
        return $this.messageAndCloseQueue;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Close;", "", "", "code", "Lokio/ByteString;", "reason", "", "cancelAfterCloseMillis", "<init>", "(ILokio/ByteString;J)V", "J", "getCancelAfterCloseMillis", "()J", "I", "getCode", "()I", "Lokio/ByteString;", "getReason", "()Lokio/ByteString;"})
    public static final class Close {
        private final int code;
        private final ByteString reason;
        private final long cancelAfterCloseMillis;

        /*
         * WARNING - void declaration
         */
        public Close(int code, ByteString reason, long cancelAfterCloseMillis) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.code = var1_1;
            this.reason = var2_2;
            this.cancelAfterCloseMillis = var3_3;
        }

        public final int getCode() {
            return this.code;
        }

        public final ByteString getReason() {
            return this.reason;
        }

        public final long getCancelAfterCloseMillis() {
            return this.cancelAfterCloseMillis;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Companion;", "", "<init>", "()V", "", "Lokhttp3/Protocol;", "ONLY_HTTP1", "Ljava/util/List;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Message;", "", "", "formatOpcode", "Lokio/ByteString;", "data", "<init>", "(ILokio/ByteString;)V", "Lokio/ByteString;", "getData", "()Lokio/ByteString;", "I", "getFormatOpcode", "()I"})
    public static final class Message {
        private final int formatOpcode;
        private final ByteString data;

        /*
         * WARNING - void declaration
         */
        public Message(int formatOpcode, ByteString data) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.formatOpcode = var1_1;
            this.data = var2_2;
        }

        public final int getFormatOpcode() {
            return this.formatOpcode;
        }

        public final ByteString getData() {
            return this.data;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Streams;", "Ljava/io/Closeable;", "", "client", "Lokio/BufferedSource;", "source", "Lokio/BufferedSink;", "sink", "<init>", "(ZLokio/BufferedSource;Lokio/BufferedSink;)V", "Z", "getClient", "()Z", "Lokio/BufferedSink;", "getSink", "()Lokio/BufferedSink;", "Lokio/BufferedSource;", "getSource", "()Lokio/BufferedSource;"})
    public static abstract class Streams
    implements Closeable {
        private final boolean client;
        private final BufferedSource source;
        private final BufferedSink sink;

        /*
         * WARNING - void declaration
         */
        public Streams(boolean client, BufferedSource source, BufferedSink sink) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.client = var1_1;
            this.source = var2_2;
            this.sink = var3_3;
        }

        public final boolean getClient() {
            return this.client;
        }

        public final BufferedSource getSource() {
            return this.source;
        }

        public final BufferedSink getSink() {
            return this.sink;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lokhttp3/internal/ws/RealWebSocket$WriterTask;", "Lokhttp3/internal/concurrent/Task;", "<init>", "(Lokhttp3/internal/ws/RealWebSocket;)V", "", "runOnce", "()J"})
    private final class WriterTask
    extends Task {
        /*
         * WARNING - void declaration
         */
        public WriterTask() {
            void var1_1;
            super(((RealWebSocket)var1_1).name + " writer", false, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long runOnce() {
            try {
                if (RealWebSocket.this.writeOneFrame$okhttp()) {
                    return 0L;
                }
            }
            catch (IOException e) {
                void var1_1;
                RealWebSocket.this.failWebSocket((Exception)var1_1, null);
            }
            return -1L;
        }
    }
}

