/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.tls.TrustRootIndex;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R&\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015"}, d2={"Lokhttp3/internal/tls/BasicTrustRootIndex;", "Lokhttp3/internal/tls/TrustRootIndex;", "Ljava/security/cert/X509Certificate;", "caCerts", "<init>", "([Ljava/security/cert/X509Certificate;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "cert", "findByIssuerAndSignature", "(Ljava/security/cert/X509Certificate;)Ljava/security/cert/X509Certificate;", "", "hashCode", "()I", "", "Ljavax/security/auth/x500/X500Principal;", "", "subjectToCaCerts", "Ljava/util/Map;"})
@SourceDebugExtension(value={"SMAP\nBasicTrustRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicTrustRootIndex.kt\nokhttp3/internal/tls/BasicTrustRootIndex\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n372#2,7:57\n288#3,2:64\n*S KotlinDebug\n*F\n+ 1 BasicTrustRootIndex.kt\nokhttp3/internal/tls/BasicTrustRootIndex\n*L\n28#1:57,7\n37#1:64,2\n*E\n"})
public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts;

    /*
     * WARNING - void declaration
     */
    public BasicTrustRootIndex(X509Certificate ... caCerts) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)caCerts, (String)"caCerts");
        Map map = new LinkedHashMap();
        for (X509Certificate caCert : caCerts) {
            Set set;
            X500Principal key$iv;
            void $this$getOrPut$iv;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)caCert.getSubjectX500Principal(), (String)"caCert.subjectX500Principal");
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                set = answer$iv;
            } else {
                void var8_8;
                set = var8_8;
            }
            ((Set)set).add(caCert);
        }
        this.subjectToCaCerts = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final X509Certificate findByIssuerAndSignature(X509Certificate cert) {
        Object v3;
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            X500Principal issuer = cert.getIssuerX500Principal();
            Set<X509Certificate> set = this.subjectToCaCerts.get(object);
            if (set == null) {
                return null;
            }
            object = set;
            object = set;
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                boolean bl;
                Object element$iv = object.next();
                X509Certificate it = (X509Certificate)element$iv;
                try {
                    cert.verify(it.getPublicKey());
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) continue;
                v3 = var3_3;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other == this || other instanceof BasicTrustRootIndex && Intrinsics.areEqual(((BasicTrustRootIndex)var1_1).subjectToCaCerts, this.subjectToCaCerts);
    }

    public final int hashCode() {
        return ((Object)this.subjectToCaCerts).hashCode();
    }
}

