/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0083.\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00148\u0002@\u0002X\u0083.\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "<init>", "()V", "", "", "domainLabels", "findMatchingRule", "(Ljava/util/List;)Ljava/util/List;", "domain", "getEffectiveTldPlusOne", "(Ljava/lang/String;)Ljava/lang/String;", "", "readTheList", "readTheListUninterruptibly", "splitDomain", "(Ljava/lang/String;)Ljava/util/List;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "publicSuffixExceptionListBytes", "[B", "publicSuffixListBytes", "Ljava/util/concurrent/CountDownLatch;", "readCompleteLatch", "Ljava/util/concurrent/CountDownLatch;", "Companion"})
public final class PublicSuffixDatabase {
    public static final Companion Companion = new Companion(null);
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    private static final byte[] WILDCARD_LABEL;
    private static final List<String> PREVAILING_RULE;
    private static final PublicSuffixDatabase instance;

    /*
     * WARNING - void declaration
     */
    public final String getEffectiveTldPlusOne(String domain) {
        void var2_3;
        void var1_1;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        String unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkNotNullExpressionValue((Object)unicodeDomain, (String)"unicodeDomain");
        List<String> domainLabels = this.splitDomain(unicodeDomain);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (var3_4.size() + 1);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)this.splitDomain((String)var1_1)), (int)var2_3), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitDomain(String domain) {
        void var1_1;
        CharSequence charSequence = (CharSequence)domain;
        char[] cArray = new char[1];
        domain = cArray;
        cArray[0] = 46;
        List domainLabels = StringsKt.split$default((CharSequence)charSequence, (char[])domain, (boolean)false, (int)0, (int)6, null);
        if (Intrinsics.areEqual((Object)CollectionsKt.last((List)domainLabels), (Object)"")) {
            return CollectionsKt.dropLast((List)domainLabels, (int)1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findMatchingRule(List<String> domainLabels) {
        List wildcardRuleLabels;
        List exactRuleLabels;
        block28: {
            List list;
            block27: {
                void var3_6;
                char[] cArray;
                block26: {
                    List list2;
                    block25: {
                        void var2_4;
                        String rule;
                        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
                            this.readTheListUninterruptibly();
                        } else {
                            try {
                                this.readCompleteLatch.await();
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (!(this.publicSuffixListBytes != null)) {
                            String string = "Unable to load publicsuffixes.gz resource from the classpath.";
                            throw new IllegalStateException(string.toString());
                        }
                        int n = 0;
                        int n2 = domainLabels.size();
                        byte[][] byArrayArray = new byte[n2][];
                        while (n < n2) {
                            int n3 = n++;
                            String string = domainLabels.get(n3);
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                            Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(charset), (String)"this as java.lang.String).getBytes(charset)");
                        }
                        byte[][] domainLabelsUtf8Bytes = byArrayArray;
                        String exactMatch = null;
                        int n4 = ((Object[])domainLabelsUtf8Bytes).length;
                        for (int i = 0; i < n4; ++i) {
                            String rule2;
                            byte[] byArray = this.publicSuffixListBytes;
                            if (this.publicSuffixListBytes == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                                byArray = null;
                            }
                            if ((rule2 = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, i)) == null) continue;
                            exactMatch = rule2;
                            break;
                        }
                        String wildcardMatch = null;
                        if (((Object[])domainLabelsUtf8Bytes).length > 1) {
                            byte[][] labelsWithWildcard = (byte[][])((Object[])domainLabelsUtf8Bytes).clone();
                            int n5 = ((Object[])labelsWithWildcard).length - 1;
                            for (int labelIndex = 0; labelIndex < n5; ++labelIndex) {
                                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                                byte[] byArray = this.publicSuffixListBytes;
                                if (this.publicSuffixListBytes == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                                    byArray = null;
                                }
                                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, labelsWithWildcard, labelIndex)) == null) continue;
                                wildcardMatch = rule;
                                break;
                            }
                        }
                        String exception = null;
                        if (wildcardMatch != null) {
                            int n6 = ((Object[])domainLabelsUtf8Bytes).length - 1;
                            for (int labelIndex = 0; labelIndex < n6; ++labelIndex) {
                                byte[] byArray = this.publicSuffixExceptionListBytes;
                                if (this.publicSuffixExceptionListBytes == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixExceptionListBytes");
                                    byArray = null;
                                }
                                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, labelIndex)) == null) continue;
                                exception = rule;
                                break;
                            }
                        }
                        if (exception != null) {
                            String string = "!" + exception;
                            char[] cArray2 = new char[1];
                            char[] labelIndex = cArray2;
                            cArray2[0] = 46;
                            return StringsKt.split$default((CharSequence)string, (char[])labelIndex, (boolean)false, (int)0, (int)6, null);
                        }
                        if (exactMatch == null && wildcardMatch == null) {
                            return PREVAILING_RULE;
                        }
                        list2 = var2_4;
                        if (list2 == null) break block25;
                        char[] cArray3 = new char[1];
                        cArray = cArray3;
                        cArray3[0] = 46;
                        if ((list2 = StringsKt.split$default((CharSequence)((CharSequence)((Object)list2)), (char[])cArray, (boolean)false, (int)0, (int)6, null)) != null) break block26;
                    }
                    list2 = exactRuleLabels = CollectionsKt.emptyList();
                }
                if ((list = var3_6) == null) break block27;
                char[] cArray4 = new char[1];
                cArray = cArray4;
                cArray4[0] = 46;
                if ((list = StringsKt.split$default((CharSequence)((CharSequence)((Object)list)), (char[])cArray, (boolean)false, (int)0, (int)6, null)) != null) break block28;
            }
            list = wildcardRuleLabels = CollectionsKt.emptyList();
        }
        if (exactRuleLabels.size() > wildcardRuleLabels.size()) {
            return exactRuleLabels;
        }
        return wildcardRuleLabels;
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheListUninterruptibly() {
        boolean interrupted = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.interrupted();
                interrupted = true;
                continue;
            }
            catch (IOException e) {
                void var2_2;
                Platform.Companion.get().log("Failed to read public suffix list", 5, (Throwable)var2_2);
                return;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheList() throws IOException {
        try {
            Object object;
            InputStream inputStream;
            Ref.ObjectRef publicSuffixListBytes = new Ref.ObjectRef();
            Ref.ObjectRef publicSuffixExceptionListBytes = new Ref.ObjectRef();
            if (PublicSuffixDatabase.class.getResourceAsStream("publicsuffixes.gz") == null) {
                return;
            }
            InputStream resource = inputStream;
            object = (Closeable)Okio.buffer((Source)((Source)new GzipSource(Okio.source((InputStream)object))));
            Throwable throwable = null;
            try {
                BufferedSource bufferedSource = (BufferedSource)object;
                int totalBytes = bufferedSource.readInt();
                publicSuffixListBytes.element = bufferedSource.readByteArray((long)totalBytes);
                int totalExceptionBytes = bufferedSource.readInt();
                publicSuffixExceptionListBytes.element = bufferedSource.readByteArray((long)totalExceptionBytes);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            object = this;
            synchronized (object) {
                void var2_3;
                void var1_1;
                Object object2 = var1_1.element;
                Intrinsics.checkNotNull((Object)object2);
                this.publicSuffixListBytes = (byte[])object2;
                Object object3 = var2_3.element;
                Intrinsics.checkNotNull((Object)object3);
                this.publicSuffixExceptionListBytes = (byte[])object3;
            }
            return;
        }
        finally {
            this.readCompleteLatch.countDown();
        }
    }

    static {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 42;
        WILDCARD_LABEL = byArray2;
        PREVAILING_RULE = CollectionsKt.listOf((Object)"*");
        instance = new PublicSuffixDatabase();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "<init>", "()V", "Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "()Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "", "labels", "", "labelIndex", "", "binarySearch", "([B[[BI)Ljava/lang/String;", "", "PREVAILING_RULE", "Ljava/util/List;", "WILDCARD_LABEL", "[B", "instance", "Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;"})
    public static final class Companion {
        private Companion() {
        }

        public final PublicSuffixDatabase get() {
            return instance;
        }

        /*
         * WARNING - void declaration
         */
        private final String binarySearch(byte[] $this$binarySearch, byte[][] labels, int labelIndex) {
            int low = 0;
            int high = $this$binarySearch.length;
            String match = null;
            while (low < high) {
                void var1_1;
                int compareResult;
                int mid;
                for (mid = (low + high) / 2; mid >= 0 && $this$binarySearch[mid] != 10; --mid) {
                }
                ++mid;
                int end = 1;
                while ($this$binarySearch[mid + end] != 10) {
                    ++end;
                }
                int publicSuffixLength = mid + end - mid;
                int currentLabelIndex = labelIndex;
                int currentLabelByteIndex = 0;
                int publicSuffixByteIndex = 0;
                boolean expectDot = false;
                while (true) {
                    int byte0;
                    if (expectDot) {
                        byte0 = 46;
                        expectDot = false;
                    } else {
                        byte0 = Util.and(labels[currentLabelIndex][currentLabelByteIndex], 255);
                    }
                    int byte1 = Util.and($this$binarySearch[mid + publicSuffixByteIndex], 255);
                    compareResult = byte0 - byte1;
                    if (compareResult != 0) break;
                    ++currentLabelByteIndex;
                    if (++publicSuffixByteIndex == publicSuffixLength) break;
                    if (labels[currentLabelIndex].length != currentLabelByteIndex) continue;
                    if (currentLabelIndex == ((Object[])labels).length - 1) break;
                    ++currentLabelIndex;
                    currentLabelByteIndex = -1;
                    expectDot = true;
                }
                if (compareResult < 0) {
                    high = mid - 1;
                    continue;
                }
                if (compareResult > 0) {
                    low = mid + end + 1;
                    continue;
                }
                int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
                int labelBytesLeft = labels[currentLabelIndex].length - currentLabelByteIndex;
                int n = ((Object[])labels).length;
                for (int i = currentLabelIndex + 1; i < n; ++i) {
                    labelBytesLeft += labels[i].length;
                }
                if (labelBytesLeft < publicSuffixBytesLeft) {
                    high = mid - 1;
                    continue;
                }
                if (labelBytesLeft > publicSuffixBytesLeft) {
                    low = mid + end + 1;
                    continue;
                }
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                match = new String((byte[])var1_1, mid, publicSuffixLength, charset2);
                break;
            }
            return match;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ String access$binarySearch(Companion $this, byte[] $receiver, byte[][] labels, int labelIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            return $this.binarySearch((byte[])var1_1, (byte[][])var2_2, (int)var3_3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

