/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.BouncyCastlePlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.OpenJSSEPlatform;
import okhttp3.internal.platform.android.AndroidLog;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import okio.Buffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J4\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0011\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0011\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b)\u0010*J-\u0010/\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u001d2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0004\b/\u00100J!\u00102\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00112\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0004\b2\u00103J\u000f\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b5\u00106J\u0017\u00108\u001a\u0002072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b8\u00109J\u000f\u0010:\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b<\u0010\""}, d2={"Lokhttp3/internal/platform/Platform;", "", "<init>", "()V", "Ljavax/net/ssl/SSLSocket;", "sslSocket", "", "afterHandshake", "(Ljavax/net/ssl/SSLSocket;)V", "Ljavax/net/ssl/X509TrustManager;", "trustManager", "Lokhttp3/internal/tls/CertificateChainCleaner;", "buildCertificateChainCleaner", "(Ljavax/net/ssl/X509TrustManager;)Lokhttp3/internal/tls/CertificateChainCleaner;", "Lokhttp3/internal/tls/TrustRootIndex;", "buildTrustRootIndex", "(Ljavax/net/ssl/X509TrustManager;)Lokhttp3/internal/tls/TrustRootIndex;", "", "hostname", "", "Lokhttp3/Protocol;", "Lkotlin/jvm/JvmSuppressWildcards;", "protocols", "configureTlsExtensions", "(Ljavax/net/ssl/SSLSocket;Ljava/lang/String;Ljava/util/List;)V", "Ljava/net/Socket;", "socket", "Ljava/net/InetSocketAddress;", "address", "", "connectTimeout", "connectSocket", "(Ljava/net/Socket;Ljava/net/InetSocketAddress;I)V", "getPrefix", "()Ljava/lang/String;", "getSelectedProtocol", "(Ljavax/net/ssl/SSLSocket;)Ljava/lang/String;", "closer", "getStackTraceForCloseable", "(Ljava/lang/String;)Ljava/lang/Object;", "", "isCleartextTrafficPermitted", "(Ljava/lang/String;)Z", "message", "level", "", "t", "log", "(Ljava/lang/String;ILjava/lang/Throwable;)V", "stackTrace", "logCloseableLeak", "(Ljava/lang/String;Ljava/lang/Object;)V", "Ljavax/net/ssl/SSLContext;", "newSSLContext", "()Ljavax/net/ssl/SSLContext;", "Ljavax/net/ssl/SSLSocketFactory;", "newSslSocketFactory", "(Ljavax/net/ssl/X509TrustManager;)Ljavax/net/ssl/SSLSocketFactory;", "platformTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "toString", "Companion"})
public class Platform {
    public static final Companion Companion = new Companion(null);
    private static volatile Platform platform = okhttp3.internal.platform.Platform$Companion.access$findPlatform(Companion);
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public final String getPrefix() {
        return "OkHttp";
    }

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getInstance(\"TLS\")");
        return sSLContext;
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager platformTrustManager() {
        void var1_1;
        TrustManagerFactory factory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory2.init((KeyStore)null);
        Object[] objectArray = factory2.getTrustManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object trustManagers = objectArray;
        if (!(objectArray.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
            StringBuilder stringBuilder = new StringBuilder("Unexpected default trust managers: ");
            String string = Arrays.toString((Object[])trustManagers);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            trustManagers = stringBuilder.append(string).toString();
            throw new IllegalStateException(trustManagers.toString());
        }
        void v3 = var1_1[0];
        Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        return (X509TrustManager)v3;
    }

    /*
     * WARNING - void declaration
     */
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"protocols");
    }

    public void afterHandshake(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
    }

    public String getSelectedProtocol(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        var1_1.connect((SocketAddress)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message, int level, Throwable t) {
        void var3_4;
        void var1_1;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Level logLevel = level == 5 ? Level.WARNING : Level.INFO;
        logger.log((Level)var2_3, (String)var1_1, (Throwable)var3_4);
    }

    public static /* synthetic */ void log$default(Platform platform, String string, int n, Throwable throwable, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        platform.log(string, n, throwable);
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object getStackTraceForCloseable(String closer) {
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        if (logger.isLoggable(Level.FINE)) {
            void var1_1;
            return new Throwable((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void logCloseableLeak(String message, Object stackTrace) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (stackTrace == null) {
            String logMessage;
            logMessage = logMessage + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log((String)var1_1, 5, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex((X509TrustManager)var1_1));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        X509Certificate[] x509CertificateArray;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        X509Certificate[] x509CertificateArray2 = x509CertificateArray.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray2, (String)"trustManager.acceptedIssuers");
        x509CertificateArray = x509CertificateArray2;
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray2, x509CertificateArray.length));
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory newSslSocketFactory(X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        try {
            TrustManager[] trustManagerArray;
            TrustManager[] trustManagerArray2 = trustManagerArray = this.newSSLContext();
            TrustManager[] trustManagerArray3 = new TrustManager[1];
            trustManagerArray2 = trustManagerArray3;
            trustManagerArray3[0] = trustManager;
            trustManagerArray.init(null, trustManagerArray2, null);
            SSLSocketFactory sSLSocketFactory = trustManagerArray.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"newSSLContext().apply {\n\u2026ll)\n      }.socketFactory");
            return sSLSocketFactory;
        }
        catch (GeneralSecurityException e) {
            void var1_2;
            throw new AssertionError("No System TLS: " + e, (Throwable)var1_2);
        }
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000b\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u000f\u0010\u0012\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0018\u0010\u001a\u001a\u0006*\u00020\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d"}, d2={"Lokhttp3/internal/platform/Platform$Companion;", "", "<init>", "()V", "", "Lokhttp3/Protocol;", "protocols", "", "alpnProtocolNames", "(Ljava/util/List;)Ljava/util/List;", "", "concatLengthPrefixed", "(Ljava/util/List;)[B", "Lokhttp3/internal/platform/Platform;", "findAndroidPlatform", "()Lokhttp3/internal/platform/Platform;", "findJvmPlatform", "findPlatform", "get", "", "isAndroid", "()Z", "isBouncyCastlePreferred", "isConscryptPreferred", "isOpenJSSEPreferred", "Ljava/util/logging/Logger;", "logger", "Ljava/util/logging/Logger;", "platform", "Lokhttp3/internal/platform/Platform;"})
    @SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n766#2:287\n857#2,2:288\n1549#2:290\n1620#2,3:291\n*S KotlinDebug\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform$Companion\n*L\n193#1:287\n193#1:288,2\n193#1:290\n193#1:291,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final Platform get() {
            return platform;
        }

        /*
         * WARNING - void declaration
         */
        public final List<String> alpnProtocolNames(List<? extends Protocol> protocols) {
            void var1_1;
            Protocol protocol;
            Object $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            protocols = protocols;
            Object object = protocols;
            Collection destination$iv$iv = new ArrayList();
            $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv$iv = $this$filterTo$iv$iv.next();
                protocol = (Protocol)((Object)element$iv$iv);
                if (!(protocol != Protocol.HTTP_1_0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                void it;
                Collection collection;
                Object item$iv$iv = object.next();
                protocol = (Protocol)((Object)collection);
                collection = destination$iv$iv;
                collection.add(it.toString());
            }
            return (List)var1_1;
        }

        public final boolean isAndroid() {
            return Intrinsics.areEqual((Object)"Dalvik", (Object)System.getProperty("java.vm.name"));
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isConscryptPreferred() {
            void var1_1;
            String preferredProvider = Security.getProviders()[0].getName();
            return Intrinsics.areEqual((Object)"Conscrypt", (Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isOpenJSSEPreferred() {
            void var1_1;
            String preferredProvider = Security.getProviders()[0].getName();
            return Intrinsics.areEqual((Object)"OpenJSSE", (Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isBouncyCastlePreferred() {
            void var1_1;
            String preferredProvider = Security.getProviders()[0].getName();
            return Intrinsics.areEqual((Object)"BC", (Object)var1_1);
        }

        private final Platform findPlatform() {
            if (this.isAndroid()) {
                return this.findAndroidPlatform();
            }
            return this.findJvmPlatform();
        }

        private final Platform findAndroidPlatform() {
            AndroidLog.INSTANCE.enable();
            Platform platform = Android10Platform.Companion.buildIfSupported();
            if (platform == null) {
                Platform platform2 = AndroidPlatform.Companion.buildIfSupported();
                platform = platform2;
                Intrinsics.checkNotNull((Object)platform2);
            }
            return platform;
        }

        /*
         * WARNING - void declaration
         */
        private final Platform findJvmPlatform() {
            OpenJSSEPlatform openJSSE;
            BouncyCastlePlatform bc;
            ConscryptPlatform conscrypt;
            if (this.isConscryptPreferred() && (conscrypt = ConscryptPlatform.Companion.buildIfSupported()) != null) {
                return conscrypt;
            }
            if (this.isBouncyCastlePreferred() && (bc = BouncyCastlePlatform.Companion.buildIfSupported()) != null) {
                return bc;
            }
            if (this.isOpenJSSEPreferred() && (openJSSE = OpenJSSEPlatform.Companion.buildIfSupported()) != null) {
                return openJSSE;
            }
            Jdk9Platform jdk9 = Jdk9Platform.Companion.buildIfSupported();
            if (jdk9 != null) {
                return jdk9;
            }
            Platform jdkWithJettyBoot = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
            if (jdkWithJettyBoot != null) {
                void var1_1;
                return var1_1;
            }
            return new Platform();
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] concatLengthPrefixed(List<? extends Protocol> protocols) {
            void var2_2;
            Iterator<String> iterator;
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            Buffer result = new Buffer();
            for (String protocol : this.alpnProtocolNames((List<? extends Protocol>)((Object)iterator))) {
                void var3_3;
                result.writeByte(protocol.length());
                result.writeUtf8((String)var3_3);
            }
            return var2_2.readByteArray();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Platform access$findPlatform(Companion $this) {
            return $this.findPlatform();
        }
    }
}

