/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 .2\u00020\u0001:\u0003./0B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J5\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010\u001e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017J/\u0010\u001f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0017J\u001f\u0010 \u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b \u0010!J/\u0010 \u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b \u0010\u0017J/\u0010\"\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\"\u0010\u0017J/\u0010#\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b#\u0010\u0017J/\u0010$\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b$\u0010\u0017J/\u0010%\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b%\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010-"}, d2={"Lokhttp3/internal/http2/Http2Reader;", "Ljava/io/Closeable;", "Lokio/BufferedSource;", "source", "", "client", "<init>", "(Lokio/BufferedSource;Z)V", "", "close", "()V", "requireSettings", "Lokhttp3/internal/http2/Http2Reader$Handler;", "handler", "nextFrame", "(ZLokhttp3/internal/http2/Http2Reader$Handler;)Z", "readConnectionPreface", "(Lokhttp3/internal/http2/Http2Reader$Handler;)V", "", "length", "flags", "streamId", "readData", "(Lokhttp3/internal/http2/Http2Reader$Handler;III)V", "readGoAway", "padding", "", "Lokhttp3/internal/http2/Header;", "readHeaderBlock", "(IIII)Ljava/util/List;", "readHeaders", "readPing", "readPriority", "(Lokhttp3/internal/http2/Http2Reader$Handler;I)V", "readPushPromise", "readRstStream", "readSettings", "readWindowUpdate", "Z", "Lokhttp3/internal/http2/Http2Reader$ContinuationSource;", "continuation", "Lokhttp3/internal/http2/Http2Reader$ContinuationSource;", "Lokhttp3/internal/http2/Hpack$Reader;", "hpackReader", "Lokhttp3/internal/http2/Hpack$Reader;", "Lokio/BufferedSource;", "Companion", "ContinuationSource", "Handler"})
public final class Http2Reader
implements Closeable {
    public static final Companion Companion = new Companion(null);
    private final BufferedSource source;
    private final boolean client;
    private final ContinuationSource continuation;
    private final Hpack.Reader hpackReader;
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public Http2Reader(BufferedSource source, boolean client) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = var1_1;
        this.client = var2_2;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(this.continuation, 4096, 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void readConnectionPreface(Handler handler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (this.client) {
            if (!this.nextFrame(true, handler)) {
                throw new IOException("Required SETTINGS preface not received");
            }
        } else {
            ByteString connectionPreface = this.source.readByteString((long)Http2.CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format("<< CONNECTION " + connectionPreface.hex(), new Object[0]));
            }
            if (!Intrinsics.areEqual((Object)Http2.CONNECTION_PREFACE, (Object)connectionPreface)) {
                void var1_1;
                throw new IOException("Expected a connection header but was " + var1_1.utf8());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean nextFrame(boolean requireSettings, Handler handler) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        try {
            this.source.require(9L);
        }
        catch (EOFException eOFException) {
            return false;
        }
        int length = Util.readMedium(this.source);
        if (length > 16384) {
            throw new IOException("FRAME_SIZE_ERROR: " + length);
        }
        int type = Util.and(this.source.readByte(), 255);
        int flags = Util.and(this.source.readByte(), 255);
        int streamId = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(true, streamId, length, type, flags));
        }
        if (var1_1 != false && type != 4) {
            throw new IOException("Expected a SETTINGS frame but was " + Http2.INSTANCE.formattedType$okhttp(type));
        }
        switch (type) {
            case 0: {
                this.readData(handler, length, flags, streamId);
                break;
            }
            case 1: {
                this.readHeaders(handler, length, flags, streamId);
                break;
            }
            case 2: {
                this.readPriority(handler, length, flags, streamId);
                break;
            }
            case 3: {
                this.readRstStream(handler, length, flags, streamId);
                break;
            }
            case 4: {
                this.readSettings(handler, length, flags, streamId);
                break;
            }
            case 5: {
                this.readPushPromise(handler, length, flags, streamId);
                break;
            }
            case 6: {
                this.readPing(handler, length, flags, streamId);
                break;
            }
            case 7: {
                this.readGoAway(handler, length, flags, streamId);
                break;
            }
            case 8: {
                void var2_2;
                this.readWindowUpdate((Handler)var2_2, length, flags, streamId);
                break;
            }
            default: {
                void var3_3;
                this.source.skip((long)var3_3);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void readHeaders(Handler handler, int length, int flags, int streamId) throws IOException {
        void var2_3;
        void var1_1;
        void var3_4;
        int headerBlockLength;
        int padding;
        if (streamId == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0");
        }
        boolean endStream = (flags & 1) != 0;
        int n = padding = (flags & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        if ((flags & 0x20) != 0) {
            this.readPriority(handler, streamId);
            headerBlockLength -= 5;
        }
        headerBlockLength = Companion.lengthWithoutPadding(headerBlockLength, flags, padding);
        List<Header> headerBlock = this.readHeaderBlock(headerBlockLength, padding, (int)var3_4, streamId);
        var1_1.headers(endStream, streamId, -1, (List<Header>)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Header> readHeaderBlock(int length, int padding, int flags, int streamId) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.continuation.setLeft((int)var1_1);
        this.continuation.setLength(this.continuation.getLeft());
        this.continuation.setPadding((int)var2_2);
        this.continuation.setFlags((int)var3_3);
        this.continuation.setStreamId(streamId);
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    /*
     * WARNING - void declaration
     */
    private final void readData(Handler handler, int length, int flags, int streamId) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        if (streamId == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_DATA streamId == 0");
        }
        boolean inFinished = (flags & 1) != 0;
        boolean bl = (flags & 0x20) != 0;
        if (bl) {
            throw new IOException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA");
        }
        int padding = (flags & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int dataLength = Companion.lengthWithoutPadding(length, (int)var3_3, padding);
        var1_1.data(inFinished, streamId, this.source, (int)var2_2);
        this.source.skip((long)padding);
    }

    /*
     * WARNING - void declaration
     */
    private final void readPriority(Handler handler, int length, int flags, int streamId) throws IOException {
        void var1_1;
        if (length != 5) {
            void var2_2;
            throw new IOException("TYPE_PRIORITY length: " + (int)var2_2 + " != 5");
        }
        if (streamId == 0) {
            throw new IOException("TYPE_PRIORITY streamId == 0");
        }
        this.readPriority((Handler)var1_1, streamId);
    }

    /*
     * WARNING - void declaration
     */
    private final void readPriority(Handler handler, int streamId) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        int w1 = this.source.readInt();
        boolean exclusive = (w1 & Integer.MIN_VALUE) != 0;
        int streamDependency = w1 & Integer.MAX_VALUE;
        int weight = Util.and(this.source.readByte(), 255) + 1;
        var1_1.priority((int)var2_2, (int)var3_3, weight, exclusive);
    }

    /*
     * WARNING - void declaration
     */
    private final void readRstStream(Handler handler, int length, int flags, int streamId) throws IOException {
        void var2_3;
        void var1_1;
        if (length != 4) {
            throw new IOException("TYPE_RST_STREAM length: " + length + " != 4");
        }
        if (streamId == 0) {
            throw new IOException("TYPE_RST_STREAM streamId == 0");
        }
        int errorCodeInt = this.source.readInt();
        ErrorCode errorCode = ErrorCode.Companion.fromHttp2(errorCodeInt);
        if (errorCode == null) {
            throw new IOException("TYPE_RST_STREAM unexpected error code: " + errorCodeInt);
        }
        ErrorCode errorCode2 = errorCode;
        var1_1.rstStream(streamId, (ErrorCode)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private final void readSettings(Handler handler, int length, int flags, int streamId) throws IOException {
        void var3_6;
        void var1_1;
        void var2_2;
        if (streamId != 0) {
            throw new IOException("TYPE_SETTINGS streamId != 0");
        }
        if ((flags & 1) != 0) {
            if (length != 0) {
                throw new IOException("FRAME_SIZE_ERROR ack frame should be empty!");
            }
            handler.ackSettings();
            return;
        }
        if (length % 6 != 0) {
            throw new IOException("TYPE_SETTINGS length % 6 != 0: " + length);
        }
        Settings settings = new Settings();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)var2_2)), (int)6);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                int id = Util.and(this.source.readShort(), 65535);
                int value = this.source.readInt();
                switch (id) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (value == 0 || value == 1) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1");
                    }
                    case 3: {
                        id = 4;
                        break;
                    }
                    case 4: {
                        id = 7;
                        if (value >= 0) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1");
                    }
                    case 5: {
                        if (value >= 16384 && value <= 0xFFFFFF) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: " + value);
                    }
                }
                settings.set(id, value);
                if (i == n) break;
                i += n2;
            }
        }
        var1_1.settings(false, (Settings)var3_6);
    }

    /*
     * WARNING - void declaration
     */
    private final void readPushPromise(Handler handler, int length, int flags, int streamId) throws IOException {
        void var2_3;
        void var1_1;
        void var3_4;
        if (streamId == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0");
        }
        int padding = (flags & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int promisedStreamId = this.source.readInt() & Integer.MAX_VALUE;
        int headerBlockLength = Companion.lengthWithoutPadding(length - 4, flags, padding);
        List<Header> headerBlock = this.readHeaderBlock(headerBlockLength, padding, (int)var3_4, streamId);
        var1_1.pushPromise(streamId, promisedStreamId, (List<Header>)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private final void readPing(Handler handler, int length, int flags, int streamId) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (length != 8) {
            throw new IOException("TYPE_PING length != 8: " + length);
        }
        if (streamId != 0) {
            throw new IOException("TYPE_PING streamId != 0");
        }
        int payload1 = this.source.readInt();
        int payload2 = this.source.readInt();
        boolean ack = (flags & 1) != 0;
        var1_1.ping((boolean)var3_3, (int)var2_2, payload2);
    }

    /*
     * WARNING - void declaration
     */
    private final void readGoAway(Handler handler, int length, int flags, int streamId) throws IOException {
        void var3_3;
        void var1_1;
        if (length < 8) {
            throw new IOException("TYPE_GOAWAY length < 8: " + length);
        }
        if (streamId != 0) {
            throw new IOException("TYPE_GOAWAY streamId != 0");
        }
        int lastStreamId = this.source.readInt();
        int errorCodeInt = this.source.readInt();
        int opaqueDataLength = length - 8;
        ErrorCode errorCode = ErrorCode.Companion.fromHttp2(errorCodeInt);
        if (errorCode == null) {
            throw new IOException("TYPE_GOAWAY unexpected error code: " + errorCodeInt);
        }
        ErrorCode errorCode2 = errorCode;
        ByteString debugData = ByteString.EMPTY;
        if (opaqueDataLength > 0) {
            void var2_2;
            debugData = this.source.readByteString((long)var2_2);
        }
        var1_1.goAway((int)var3_3, errorCode2, debugData);
    }

    /*
     * WARNING - void declaration
     */
    private final void readWindowUpdate(Handler handler, int length, int flags, int streamId) throws IOException {
        void var1_1;
        if (length != 4) {
            void var2_2;
            throw new IOException("TYPE_WINDOW_UPDATE length !=4: " + (int)var2_2);
        }
        long increment = Util.and(this.source.readInt(), Integer.MAX_VALUE);
        if (increment == 0L) {
            throw new IOException("windowSizeIncrement was 0");
        }
        var1_1.windowUpdate(streamId, increment);
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }

    static {
        Logger logger = Logger.getLogger(Http2.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Http2::class.java.name)");
        Http2Reader.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e"}, d2={"Lokhttp3/internal/http2/Http2Reader$Companion;", "", "<init>", "()V", "", "length", "flags", "padding", "lengthWithoutPadding", "(III)I", "Ljava/util/logging/Logger;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        /*
         * WARNING - void declaration
         */
        public final int lengthWithoutPadding(int length, int flags, int padding) throws IOException {
            void var3_3;
            void var2_2;
            int result = length;
            if ((var2_2 & 8) != 0) {
                --result;
            }
            if (padding > result) {
                throw new IOException("PROTOCOL_ERROR padding " + padding + " > remaining length " + result);
            }
            return (int)(var1_1 -= var3_3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\bJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0017R\u001c\u0010\u001c\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001c\u0010\u001e\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u001c\u0010!\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010\u0015\"\u0004\b\"\u0010\u0017"}, d2={"Lokhttp3/internal/http2/Http2Reader$ContinuationSource;", "Lokio/Source;", "Lokio/BufferedSource;", "source", "<init>", "(Lokio/BufferedSource;)V", "", "close", "()V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "readContinuationHeader", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "", "flags", "I", "setFlags", "(I)V", "left", "getLeft", "()I", "setLeft", "length", "setLength", "padding", "setPadding", "Lokio/BufferedSource;", "streamId", "setStreamId"})
    public static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        private int length;
        private int flags;
        private int streamId;
        private int left;
        private int padding;

        /*
         * WARNING - void declaration
         */
        public ContinuationSource(BufferedSource source) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLength(int n) {
            void var1_1;
            this.length = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setFlags(int n) {
            void var1_1;
            this.flags = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setStreamId(int n) {
            void var1_1;
            this.streamId = var1_1;
        }

        public final int getLeft() {
            return this.left;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLeft(int n) {
            void var1_1;
            this.left = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPadding(int n) {
            void var1_1;
            this.padding = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final long read(Buffer sink, long byteCount) throws IOException {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            while (this.left == 0) {
                this.source.skip((long)this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long read = this.source.read((Buffer)var1_1, Math.min((long)var2_2, (long)this.left));
            if (read == -1L) {
                return -1L;
            }
            this.left -= (int)read;
            return read;
        }

        public final Timeout timeout() {
            return this.source.timeout();
        }

        public final void close() throws IOException {
        }

        /*
         * WARNING - void declaration
         */
        private final void readContinuationHeader() throws IOException {
            void var1_1;
            int previousStreamId = this.streamId;
            this.length = this.left = Util.readMedium(this.source);
            int type = Util.and(this.source.readByte(), 255);
            this.flags = Util.and(this.source.readByte(), 255);
            if (Companion.getLogger().isLoggable(Level.FINE)) {
                Companion.getLogger().fine(Http2.INSTANCE.frameLog(true, this.streamId, this.length, type, this.flags));
            }
            this.streamId = this.source.readInt() & Integer.MAX_VALUE;
            if (type != 9) {
                void var2_2;
                throw new IOException((int)var2_2 + " != TYPE_CONTINUATION");
            }
            if (this.streamId != var1_1) {
                throw new IOException("TYPE_CONTINUATION streamId changed");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J/\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H&\u00a2\u0006\u0004\b\u0013\u0010\u0014J5\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H&\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\u001e\u0010\u001fJ/\u0010#\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0005H&\u00a2\u0006\u0004\b#\u0010$J-\u0010'\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H&\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000fH&\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010-\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00052\u0006\u0010-\u001a\u00020,H&\u00a2\u0006\u0004\b-\u0010.J\u001f\u00101\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u00100\u001a\u00020/H&\u00a2\u0006\u0004\b1\u00102"}, d2={"Lokhttp3/internal/http2/Http2Reader$Handler;", "", "", "ackSettings", "()V", "", "inFinished", "", "streamId", "Lokio/BufferedSource;", "source", "length", "data", "(ZILokio/BufferedSource;I)V", "lastGoodStreamId", "Lokhttp3/internal/http2/ErrorCode;", "errorCode", "Lokio/ByteString;", "debugData", "goAway", "(ILokhttp3/internal/http2/ErrorCode;Lokio/ByteString;)V", "associatedStreamId", "", "Lokhttp3/internal/http2/Header;", "headerBlock", "headers", "(ZIILjava/util/List;)V", "ack", "payload1", "payload2", "ping", "(ZII)V", "streamDependency", "weight", "exclusive", "priority", "(IIIZ)V", "promisedStreamId", "requestHeaders", "pushPromise", "(IILjava/util/List;)V", "rstStream", "(ILokhttp3/internal/http2/ErrorCode;)V", "clearPrevious", "Lokhttp3/internal/http2/Settings;", "settings", "(ZLokhttp3/internal/http2/Settings;)V", "", "windowSizeIncrement", "windowUpdate", "(IJ)V"})
    public static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;
    }
}

