/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00ab\u00012\u00020\u0001:\b\u00ac\u0001\u00ab\u0001\u00ad\u0001\u00ae\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010#\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010$J#\u0010#\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b#\u0010%J/\u0010-\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b+\u0010,J-\u00100\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010*\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b.\u0010/J%\u00103\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u00a2\u0006\u0004\b1\u00102J\u001f\u00107\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u00104\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b5\u00106J\u0017\u0010:\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b8\u00109J\u0019\u0010<\u001a\u0004\u0018\u00010\u00162\u0006\u0010&\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b;\u0010\u0018J\u000f\u0010>\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b=\u0010\bJ\u0015\u0010@\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\t\u00a2\u0006\u0004\b@\u0010AJ#\u0010E\u001a\u00020\u00062\b\b\u0002\u0010B\u001a\u00020\u001b2\b\b\u0002\u0010D\u001a\u00020CH\u0007\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010J\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\bH\u0010IJ/\u0010N\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u001b2\b\u0010M\u001a\u0004\u0018\u00010L2\u0006\u0010)\u001a\u00020\u0019\u00a2\u0006\u0004\bN\u0010OJ-\u0010S\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u001b2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u00a2\u0006\u0004\bQ\u0010RJ%\u0010W\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u001b2\u0006\u0010U\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0014\u00a2\u0006\u0004\bW\u0010XJ\u001f\u0010Z\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\tH\u0000\u00a2\u0006\u0004\bY\u00106J\u001f\u0010\\\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u00104\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b[\u00106J\u001f\u0010`\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010]\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b^\u0010_R\u0016\u0010a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\ba\u0010bR\u001a\u0010c\u001a\u00020\u001b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bc\u0010d\u001a\u0004\be\u0010fR\u001a\u0010h\u001a\u00020g8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bh\u0010i\u001a\u0004\bj\u0010kR\u001a\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00140l8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bm\u0010nR\u0016\u0010o\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bo\u0010bR\u0016\u0010p\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010bR\u0016\u0010q\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bq\u0010bR\u0016\u0010r\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010bR\u0016\u0010s\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bs\u0010bR\u0016\u0010t\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010dR\"\u0010u\u001a\u00020\u00148\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bu\u0010v\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u001a\u0010|\u001a\u00020{8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b|\u0010}\u001a\u0004\b~\u0010\u007fR\u001f\u0010\u0080\u0001\u001a\u00020\u00148\u0000@\u0000X\u0080\f\u00a2\u0006\u000e\n\u0005\b\u0080\u0001\u0010v\u001a\u0005\b\u0081\u0001\u0010xR\u001d\u0010\u0083\u0001\u001a\u00030\u0082\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R*\u0010\u0087\u0001\u001a\u00030\u0082\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0087\u0001\u0010\u0084\u0001\u001a\u0006\b\u0088\u0001\u0010\u0086\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R\u0018\u0010\u008c\u0001\u001a\u00030\u008b\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008c\u0001\u0010\u008d\u0001R\u0018\u0010\u008f\u0001\u001a\u00030\u008e\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008f\u0001\u0010\u0090\u0001R!\u0010\u0092\u0001\u001a\u00020\u00192\u0007\u0010\u0091\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0007\n\u0005\b\u0092\u0001\u0010bR!\u0010\u0093\u0001\u001a\u00020\u00192\u0007\u0010\u0091\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0007\n\u0005\b\u0093\u0001\u0010bR\u0019\u0010\u0095\u0001\u001a\u00070\u0094\u0001R\u00020\u00008\u0006\u00a2\u0006\b\n\u0006\b\u0095\u0001\u0010\u0096\u0001R\u0018\u0010\u0097\u0001\u001a\u00030\u008e\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0097\u0001\u0010\u0090\u0001R\u0018\u0010\u0099\u0001\u001a\u00030\u0098\u00018\u0000X\u0080\u0004\u00a2\u0006\b\n\u0006\b\u0099\u0001\u0010\u009a\u0001R,\u0010\u009c\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u009b\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u009c\u0001\u0010\u009d\u0001\u001a\u0006\b\u009e\u0001\u0010\u009f\u0001R\u0015\u0010D\u001a\u00020C8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\bD\u0010\u00a0\u0001R)\u0010\u00a1\u0001\u001a\u00020\u00192\u0007\u0010\u0091\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u000f\n\u0005\b\u00a1\u0001\u0010b\u001a\u0006\b\u00a2\u0001\u0010\u00a3\u0001R!\u0010\u00a4\u0001\u001a\u00020\u00192\u0007\u0010\u0091\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0007\n\u0005\b\u00a4\u0001\u0010bR\u001d\u0010\u00a6\u0001\u001a\u00030\u00a5\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u00a6\u0001\u0010\u00a7\u0001\u001a\u0006\b\u00a8\u0001\u0010\u00a9\u0001R\u0018\u0010\u00aa\u0001\u001a\u00030\u008e\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00aa\u0001\u0010\u0090\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "Lokhttp3/internal/http2/Http2Connection$Builder;", "builder", "<init>", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "", "close", "()V", "Lokhttp3/internal/http2/ErrorCode;", "connectionCode", "streamCode", "Ljava/io/IOException;", "cause", "close$okhttp", "(Lokhttp3/internal/http2/ErrorCode;Lokhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)V", "e", "failConnection", "(Ljava/io/IOException;)V", "flush", "", "id", "Lokhttp3/internal/http2/Http2Stream;", "getStream", "(I)Lokhttp3/internal/http2/Http2Stream;", "", "nowNs", "", "isHealthy", "(J)Z", "associatedStreamId", "", "Lokhttp3/internal/http2/Header;", "requestHeaders", "out", "newStream", "(ILjava/util/List;Z)Lokhttp3/internal/http2/Http2Stream;", "(Ljava/util/List;Z)Lokhttp3/internal/http2/Http2Stream;", "streamId", "Lokio/BufferedSource;", "source", "byteCount", "inFinished", "pushDataLater$okhttp", "(ILokio/BufferedSource;IZ)V", "pushDataLater", "pushHeadersLater$okhttp", "(ILjava/util/List;Z)V", "pushHeadersLater", "pushRequestLater$okhttp", "(ILjava/util/List;)V", "pushRequestLater", "errorCode", "pushResetLater$okhttp", "(ILokhttp3/internal/http2/ErrorCode;)V", "pushResetLater", "pushedStream$okhttp", "(I)Z", "pushedStream", "removeStream$okhttp", "removeStream", "sendDegradedPingLater$okhttp", "sendDegradedPingLater", "statusCode", "shutdown", "(Lokhttp3/internal/http2/ErrorCode;)V", "sendConnectionPreface", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "start", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "read", "updateConnectionFlowControl$okhttp", "(J)V", "updateConnectionFlowControl", "outFinished", "Lokio/Buffer;", "buffer", "writeData", "(IZLokio/Buffer;J)V", "alternating", "writeHeaders$okhttp", "(IZLjava/util/List;)V", "writeHeaders", "reply", "payload1", "payload2", "writePing", "(ZII)V", "writeSynReset$okhttp", "writeSynReset", "writeSynResetLater$okhttp", "writeSynResetLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "(IJ)V", "writeWindowUpdateLater", "awaitPongsReceived", "J", "client", "Z", "getClient$okhttp", "()Z", "", "connectionName", "Ljava/lang/String;", "getConnectionName$okhttp", "()Ljava/lang/String;", "", "currentPushRequests", "Ljava/util/Set;", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "I", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "Lokhttp3/internal/http2/Http2Connection$Listener;", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "Lokhttp3/internal/http2/Settings;", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "Lokhttp3/internal/http2/PushObserver;", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "Lokhttp3/internal/concurrent/TaskQueue;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "<set-?>", "readBytesAcknowledged", "readBytesTotal", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "Ljava/net/Socket;", "socket", "Ljava/net/Socket;", "", "streams", "Ljava/util/Map;", "getStreams$okhttp", "()Ljava/util/Map;", "Lokhttp3/internal/concurrent/TaskRunner;", "writeBytesMaximum", "getWriteBytesMaximum", "()J", "writeBytesTotal", "Lokhttp3/internal/http2/Http2Writer;", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "Companion", "Builder", "Listener", "ReaderRunnable"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1006:1\n84#2,4:1007\n90#2,13:1014\n90#2,13:1027\n90#2,13:1069\n90#2,13:1082\n90#2,13:1095\n90#2,13:1108\n90#2,13:1121\n90#2,13:1134\n563#3:1011\n557#3:1013\n557#3:1040\n615#3,4:1041\n402#3,5:1045\n402#3,5:1053\n402#3,5:1059\n402#3,5:1064\n1#4:1012\n37#5,2:1050\n13309#6:1052\n13310#6:1058\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n152#1:1007,4\n340#1:1014,13\n361#1:1027,13\n506#1:1069,13\n554#1:1082,13\n893#1:1095,13\n911#1:1108,13\n938#1:1121,13\n952#1:1134,13\n183#1:1011\n319#1:1013\n402#1:1040\n446#1:1041,4\n448#1:1045,5\n461#1:1053,5\n467#1:1059,5\n472#1:1064,5\n455#1:1050,2\n460#1:1052\n460#1:1058\n*E\n"})
public final class Http2Connection
implements Closeable {
    public static final Companion Companion;
    private final boolean client;
    private final Listener listener;
    private final Map<Integer, Http2Stream> streams;
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    private final Settings okHttpSettings;
    private Settings peerSettings;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    private long writeBytesMaximum;
    public final Socket socket;
    private final Http2Writer writer;
    public final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    private static final Settings DEFAULT_SETTINGS;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(Builder builder) {
        Settings settings;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = ((Builder)builder).getClient$okhttp();
        this.listener = ((Builder)builder).getListener$okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = ((Builder)builder).getConnectionName$okhttp();
        this.nextStreamId = ((Builder)builder).getClient$okhttp() ? 3 : 2;
        this.taskRunner = ((Builder)builder).getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = ((Builder)builder).getPushObserver$okhttp();
        Settings settings2 = settings = new Settings();
        Http2Connection http2Connection = this;
        if (((Builder)builder).getClient$okhttp()) {
            settings2.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = ((Builder)builder).getSocket$okhttp();
        this.writer = new Http2Writer(((Builder)builder).getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(this, new Http2Reader(((Builder)builder).getSource$okhttp(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (((Builder)builder).getPingIntervalMillis$okhttp() != 0) {
            void var2_3;
            void var1_1;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(((Builder)builder).getPingIntervalMillis$okhttp());
            builder = this.writerQueue;
            String name$iv = this.connectionName + " ping";
            var1_1.schedule(new Task(name$iv, this, pingIntervalNanos){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l;
                    super((String)var1_1, false, 2, null);
                }

                public final long runOnce() {
                    boolean bl;
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl2;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl2 = true;
                        } else {
                            long l = Http2Connection.access$getIntervalPingsSent$p(this.this$0);
                            Http2Connection.access$setIntervalPingsSent$p(this.this$0, l + 1L);
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    boolean bl3 = bl;
                    if (bl3) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        return -1L;
                    }
                    this.this$0.writePing(false, 1, 0);
                    return this.$pingIntervalNanos$inlined;
                }
            }, (long)var2_3);
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final Listener getListener$okhttp() {
        return this.listener;
    }

    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLastGoodStreamId$okhttp(int n) {
        void var1_1;
        this.lastGoodStreamId = var1_1;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPeerSettings(Settings settings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.peerSettings = var1_1;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream getStream(int id) {
        void var1_1;
        return this.streams.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        void var1_2;
        void var2_3;
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
        ((Object)var2_3).notifyAll();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        void var1_1;
        this.readBytesTotal += var1_1;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            void var3_2;
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += var3_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Stream newStream(List<Header> requestHeaders, boolean out) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        return this.newStream(0, (List<Header>)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final Http2Stream newStream(int associatedStreamId2, List<Header> requestHeaders, boolean out) throws IOException {
        void var3_6;
        Http2Stream stream;
        boolean outFinished = !out;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int streamId;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean flushHeaders;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, false, null);
                boolean bl = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
            }
            if (associatedStreamId2 == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                void var2_5;
                void var1_1;
                if (!(!this.client)) {
                    String associatedStreamId2 = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(associatedStreamId2.toString());
                }
                this.writer.pushPromise((int)var1_1, streamId, (List<Header>)var2_5);
            }
        }
        if (var3_6 != false) {
            this.writer.flush();
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders$okhttp(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(alternating, (String)"alternating");
        this.writer.headers((boolean)var2_2, (int)var1_1, (List<Header>)var3_3);
    }

    public final void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                int $this$wait$iv = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min($this$wait$iv, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] writeSynReset";
        taskQueue.schedule(new Task(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynReset$okhttp(int streamId, ErrorCode statusCode) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        this.writer.rstStream((int)var1_1, (ErrorCode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        void var2_2;
        void var1_1;
        void $this$iv;
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] windowUpdate";
        $this$iv.schedule(new Task(name$iv, true, this, (int)var1_1, (long)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$unacknowledgedBytesRead$inlined = l;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            void var3_4;
            void var2_3;
            this.writer.ping(reply, (int)var2_3, (int)var3_4);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.failConnection((IOException)var1_2);
            return;
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown(ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            void var3_5;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.lastGoodStreamId;
            }
            this.writer.goAway(var3_5.element, (ErrorCode)var1_1, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    public final void close$okhttp(ErrorCode connectionCode, ErrorCode streamCode, IOException cause) {
        Http2Connection http2Connection;
        Intrinsics.checkNotNullParameter((Object)((Object)connectionCode), (String)"connectionCode");
        Intrinsics.checkNotNullParameter((Object)((Object)streamCode), (String)"streamCode");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        try {
            this.shutdown((ErrorCode)((Object)http2Connection));
        }
        catch (IOException iOException) {}
        Http2Stream[] streamsToClose = null;
        http2Connection = this;
        synchronized (http2Connection) {
            if (!this.streams.isEmpty()) {
                Http2Stream[] http2StreamArray = streamsToClose = this.streams.values();
                streamsToClose = streamsToClose.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream http2Stream;
                Http2Stream stream = http2Stream = $this$forEach$iv[i];
                try {
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {}
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final void failConnection(IOException e) {
        void var1_1;
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        this.close$okhttp(errorCode, errorCode, (IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void start(boolean sendConnectionPreface, TaskRunner taskRunner) throws IOException {
        void var3_4;
        void var2_3;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        TaskQueue windowSize = ((TaskRunner)taskRunner).newQueue();
        taskRunner = this.connectionName;
        Function0 block$iv = this.readerRunnable;
        var1_2.schedule(new Task((String)var2_3, true, (Function0<Unit>)var3_4){
            final /* synthetic */ Function0<Unit> $block;
            {
                void var2_2;
                void var1_1;
                void var3_3;
                this.$block = var3_3;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, 0L);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, TaskRunner taskRunner, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            taskRunner = TaskRunner.INSTANCE;
        }
        http2Connection.start(bl, taskRunner);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean isHealthy(long nowNs) {
        void var1_1;
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || var1_1 < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendDegradedPingLater$okhttp() {
        void var2_4;
        Object object = this;
        synchronized (object) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        object = this.writerQueue;
        String name$iv = this.connectionName + " ping";
        ((TaskQueue)object).schedule(new Task((String)var2_4, true, this){
            final /* synthetic */ Http2Connection this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean pushedStream$okhttp(int streamId) {
        void var1_1;
        return streamId != 0 && (var1_1 & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, List<Header> requestHeaders) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Object object = this;
        synchronized (object) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        object = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onRequest";
        ((TaskQueue)object).schedule(new Task(name$iv, true, this, (int)var1_1, (List)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                block5: {
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId$inlined, this.$requestHeaders$inlined);
                    try {
                        void var1_1;
                        if (var1_1 == false) break block5;
                        this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {}
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, List<Header> requestHeaders, boolean inFinished) {
        void var3_3;
        void var2_2;
        void var1_1;
        void $this$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onHeaders";
        $this$iv.schedule(new Task(name$iv, true, this, (int)var1_1, (List)var2_2, (boolean)var3_3){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                block6: {
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId$inlined, this.$requestHeaders$inlined, this.$inFinished$inlined);
                    try {
                        void var1_1;
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (var1_1 == false && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {}
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, BufferedSource source, int byteCount, boolean inFinished) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer buffer = new Buffer();
        source.require((long)byteCount);
        source.read(buffer, (long)byteCount);
        source = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onData";
        var2_2.schedule(new Task(name$iv, true, this, (int)var1_1, buffer, (int)var3_3, inFinished){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ Buffer $buffer$inlined;
            final /* synthetic */ int $byteCount$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n2;
                this.$inFinished$inlined = bl;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                block6: {
                    try {
                        void var1_1;
                        boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onData(this.$streamId$inlined, (BufferedSource)this.$buffer$inlined, this.$byteCount$inlined, this.$inFinished$inlined);
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (var1_1 == false && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {}
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onReset";
        taskQueue.schedule(new Task(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId$inlined, this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                synchronized (http2Connection) {
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$failConnection(Http2Connection $this, IOException e) {
        void var1_1;
        $this.failConnection((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.degradedPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.awaitPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setShutdown$p(Http2Connection $this, boolean bl) {
        void var1_1;
        $this.isShutdown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection $this, long l) {
        void var1_1;
        $this.writeBytesMaximum = var1_1;
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection $this) {
        return $this.intervalPingsSent;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPingsSent = var1_1;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2435 = settings = new Settings();
        settings.set(7, 65535);
        var1_1.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0019R\u001c\u0010\u0003\u001a\u00020\u00028\u0000@\u0000X\u0081\f\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00138\u0000@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\f\u001a\u00020\u000b8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b\f\u0010#\u001a\u0004\b$\u0010%R\u001c\u0010\u000f\u001a\u00020\u000e8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b\u000f\u0010&\u001a\u0004\b'\u0010(R\u001c\u0010*\u001a\u00020)8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\"\u0010\u0018\u001a\u00020\u00178\u0000@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\"\u0010\u0012\u001a\u00020\u00118\u0000@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b\u0012\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\"\u0010\u0016\u001a\u00020\u00158\u0000@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b\u0016\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010=\u001a\u0004\b>\u0010?"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "", "client", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "<init>", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "Lokhttp3/internal/http2/Http2Connection;", "build", "()Lokhttp3/internal/http2/Http2Connection;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "listener", "(Lokhttp3/internal/http2/Http2Connection$Listener;)Lokhttp3/internal/http2/Http2Connection$Builder;", "", "pingIntervalMillis", "(I)Lokhttp3/internal/http2/Http2Connection$Builder;", "Ljava/net/Socket;", "socket", "", "peerName", "Lokio/BufferedSource;", "source", "Lokio/BufferedSink;", "sink", "(Ljava/net/Socket;Ljava/lang/String;Lokio/BufferedSource;Lokio/BufferedSink;)Lokhttp3/internal/http2/Http2Connection$Builder;", "Z", "getClient$okhttp", "()Z", "connectionName", "Ljava/lang/String;", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "I", "getPingIntervalMillis$okhttp", "()I", "Lokhttp3/internal/http2/PushObserver;", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "Lokhttp3/internal/concurrent/TaskRunner;", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;"})
    public static final class Builder {
        private boolean client;
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        private Listener listener;
        private PushObserver pushObserver;
        private int pingIntervalMillis;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean client, TaskRunner taskRunner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            this.client = var1_1;
            this.taskRunner = var2_2;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket != null) {
                return socket;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSocket$okhttp(Socket socket) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"<set-?>");
            this.socket = var1_1;
        }

        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectionName");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setConnectionName$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.connectionName = var1_1;
        }

        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                return bufferedSource;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"source");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSource$okhttp(BufferedSource bufferedSource) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bufferedSource, (String)"<set-?>");
            this.source = var1_1;
        }

        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                return bufferedSink;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSink$okhttp(BufferedSink bufferedSink) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"<set-?>");
            this.sink = var1_1;
        }

        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket, String peerName, BufferedSource source, BufferedSink sink) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Builder $this$socket_u24lambda_u240 = builder = this;
            builder.setSocket$okhttp((Socket)var1_1);
            Builder builder2 = $this$socket_u24lambda_u240;
            builder2.setConnectionName$okhttp(builder2.client ? Util.okHttpName + ' ' + peerName : "MockWebServer " + (String)var2_2);
            $this$socket_u24lambda_u240.setSource$okhttp((BufferedSource)var3_3);
            $this$socket_u24lambda_u240.setSink$okhttp(sink);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder listener(Listener listener) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder2 = builder = this;
            builder.listener = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.pingIntervalMillis = var1_1;
            return builder;
        }

        public final Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "<init>", "()V", "Lokhttp3/internal/http2/Settings;", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;"})
    public static final class Companion {
        private Companion() {
        }

        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH&\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "<init>", "()V", "Lokhttp3/internal/http2/Http2Connection;", "connection", "Lokhttp3/internal/http2/Settings;", "settings", "", "onSettings", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Settings;)V", "Lokhttp3/internal/http2/Http2Stream;", "stream", "onStream", "(Lokhttp3/internal/http2/Http2Stream;)V", "Companion"})
    public static abstract class Listener {
        public static final Companion Companion = new Companion(null);
        @JvmField
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            /*
             * WARNING - void declaration
             */
            public final void onStream(Http2Stream stream) throws IOException {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                var1_1.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        /*
         * WARNING - void declaration
         */
        public void onSettings(Http2Connection connection, Settings settings) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"settings");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "<init>", "()V", "Lokhttp3/internal/http2/Http2Connection$Listener;", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\t\n\u0002\b\u0004\b\u0087\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0011\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ5\u0010#\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b%\u0010\tJ'\u0010)\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b)\u0010*J/\u0010.\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b.\u0010/J-\u00102\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0004\b2\u00103J\u001f\u00104\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b4\u00105J\u001f\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000fJ\u001f\u00108\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00107\u001a\u000206H\u0016\u00a2\u0006\u0004\b8\u00109R\u0014\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010:"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "Lokhttp3/internal/http2/Http2Reader;", "reader", "<init>", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "ackSettings", "()V", "", "clearPrevious", "Lokhttp3/internal/http2/Settings;", "settings", "applyAndAckSettings", "(ZLokhttp3/internal/http2/Settings;)V", "inFinished", "", "streamId", "Lokio/BufferedSource;", "source", "length", "data", "(ZILokio/BufferedSource;I)V", "lastGoodStreamId", "Lokhttp3/internal/http2/ErrorCode;", "errorCode", "Lokio/ByteString;", "debugData", "goAway", "(ILokhttp3/internal/http2/ErrorCode;Lokio/ByteString;)V", "associatedStreamId", "", "Lokhttp3/internal/http2/Header;", "headerBlock", "headers", "(ZIILjava/util/List;)V", "invoke", "ack", "payload1", "payload2", "ping", "(ZII)V", "streamDependency", "weight", "exclusive", "priority", "(IIIZ)V", "promisedStreamId", "requestHeaders", "pushPromise", "(IILjava/util/List;)V", "rstStream", "(ILokhttp3/internal/http2/ErrorCode;)V", "", "windowSizeIncrement", "windowUpdate", "(IJ)V", "Lokhttp3/internal/http2/Http2Reader;"})
    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1006:1\n90#2,13:1007\n90#2,13:1020\n90#2,13:1035\n90#2,13:1049\n37#3,2:1033\n37#3,2:1062\n563#4:1048\n563#4:1064\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n687#1:1007,13\n715#1:1020,13\n758#1:1035,13\n806#1:1049,13\n753#1:1033,2\n824#1:1062,2\n797#1:1048\n841#1:1064\n*E\n"})
    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        public final Http2Reader reader;
        final /* synthetic */ Http2Connection this$0;

        /*
         * WARNING - void declaration
         */
        public ReaderRunnable(Http2Connection this$0, Http2Reader reader) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.this$0 = var1_1;
            this.reader = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
                this.this$0.close$okhttp(connectionErrorCode, streamErrorCode, null);
            }
            catch (IOException iOException) {
                try {
                    IOException iOException2 = iOException;
                    errorException = iOException;
                    connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                    streamErrorCode = ErrorCode.PROTOCOL_ERROR;
                    this.this$0.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                }
                catch (Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0.close$okhttp((ErrorCode)var1_1, (ErrorCode)var2_2, (IOException)var3_3);
                    Util.closeQuietly(this.reader);
                    throw throwable;
                }
                Util.closeQuietly(this.reader);
                return;
            }
            Util.closeQuietly(this.reader);
            return;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushDataLater$okhttp(streamId, source, length, inFinished);
                return;
            }
            Http2Stream dataStream = this.this$0.getStream(streamId);
            if (dataStream == null) {
                void var2_2;
                this.this$0.writeSynResetLater$okhttp((int)var2_2, ErrorCode.PROTOCOL_ERROR);
                this.this$0.updateConnectionFlowControl$okhttp(length);
                source.skip((long)length);
                return;
            }
            dataStream.receiveData((BufferedSource)var3_3, length);
            if (var1_1 != false) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void headers(boolean inFinished, int streamId, int associatedStreamId2, List<Header> headerBlock) {
            void var1_1;
            void var4_7;
            void var3_6;
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushHeadersLater$okhttp(streamId, (List<Header>)headerBlock, inFinished);
                return;
            }
            Http2Connection associatedStreamId2 = this.this$0;
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = associatedStreamId2;
            synchronized (http2Connection2) {
                Http2Stream stream = http2Connection.getStream(streamId);
                if (stream == null) {
                    void var1_2;
                    void $this$iv;
                    void var2_4;
                    if (http2Connection.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Object headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection, false, inFinished, (Headers)headers);
                    http2Connection.setLastGoodStreamId$okhttp(streamId);
                    headers = streamId;
                    http2Connection.getStreams$okhttp().put((Integer)headers, newStream);
                    headerBlock = http2Connection.taskRunner.newQueue();
                    String name$iv = http2Connection.getConnectionName$okhttp() + '[' + (int)var2_4 + "] onStream";
                    $this$iv.schedule(new Task((String)var3_6, true, http2Connection, (Http2Stream)var1_2){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        {
                            void var2_2;
                            void var1_1;
                            this.this$0 = http2Connection;
                            this.$newStream$inlined = http2Stream;
                            super((String)var1_1, (boolean)var2_2);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final long runOnce() {
                            try {
                                this.this$0.getListener$okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException e) {
                                Platform.Companion.get().log("Http2Connection.Listener failure for " + this.this$0.getConnectionName$okhttp(), 4, e);
                                try {
                                    void var1_1;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, (IOException)var1_1);
                                }
                                catch (IOException iOException) {}
                            }
                            return -1L;
                        }
                    }, 0L);
                    return;
                }
            }
            var3_6.receiveHeaders(Util.toHeaders((List<Header>)var4_7), (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void rstStream(int streamId, ErrorCode errorCode) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushResetLater$okhttp(streamId, errorCode);
                return;
            }
            Http2Stream http2Stream = this.this$0.removeStream$okhttp((int)var1_1);
            if (http2Stream != null) {
                void var2_3;
                http2Stream.receiveRstStream((ErrorCode)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void settings(boolean clearPrevious, Settings settings) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            TaskQueue taskQueue = this.this$0.writerQueue;
            String name$iv = this.this$0.getConnectionName$okhttp() + " applyAndAckSettings";
            taskQueue.schedule(new Task(name$iv, true, this, (boolean)var1_1, (Settings)var2_2){
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious$inlined;
                final /* synthetic */ Settings $settings$inlined;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl;
                    this.$settings$inlined = settings;
                    super((String)var1_1, (boolean)var2_2);
                }

                public final long runOnce() {
                    this.this$0.applyAndAckSettings(this.$clearPrevious$inlined, this.$settings$inlined);
                    return -1L;
                }
            }, 0L);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void applyAndAckSettings(boolean clearPrevious2, Settings settings) {
            void var2_4;
            Http2Stream[] http2StreamArray;
            Settings settings2;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray2 = this.this$0.getWriter();
            Http2Connection http2Connection = this.this$0;
            Http2Stream[] http2StreamArray3 = http2StreamArray2;
            // MONITORENTER : http2StreamArray2
            Object object = http2Connection;
            // MONITORENTER : object
            Settings previousPeerSettings = http2Connection.getPeerSettings();
            Ref.ObjectRef objectRef = newPeerSettings;
            if (clearPrevious2) {
                settings2 = settings;
            } else {
                void $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244;
                Settings settings3 = clearPrevious2 = new Settings();
                Ref.ObjectRef objectRef2 = objectRef;
                $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge(previousPeerSettings);
                $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge((Settings)settings);
                objectRef = objectRef2;
                settings2 = clearPrevious2;
            }
            objectRef.element = settings2;
            long l = ((Settings)newPeerSettings.element).getInitialWindowSize();
            long delta = l - (long)previousPeerSettings.getInitialWindowSize();
            if (delta == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                http2StreamArray = null;
            } else {
                settings = http2Connection.getStreams$okhttp().values();
                Collection<Http2Stream> clearPrevious2 = settings;
                http2StreamArray = settings.toArray(new Http2Stream[0]);
            }
            Http2Stream[] streamsToNotify = http2StreamArray;
            http2Connection.setPeerSettings((Settings)newPeerSettings.element);
            settings = http2Connection.settingsListenerQueue;
            String name$iv = http2Connection.getConnectionName$okhttp() + " onSettings";
            var2_4.schedule(new Task(name$iv, true, http2Connection, newPeerSettings){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$newPeerSettings$inlined = objectRef;
                    super((String)var1_1, (boolean)var2_2);
                }

                public final long runOnce() {
                    this.this$0.getListener$okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings$inlined.element);
                    return -1L;
                }
            }, 0L);
            // MONITOREXIT : object
            try {
                void var3_5;
                http2Connection.getWriter().applyAndAckSettings((Settings)var3_5.element);
            }
            catch (IOException e) {
                Http2Connection.access$failConnection(http2Connection, e);
            }
            // MONITOREXIT : http2StreamArray3
            if (streamsToNotify == null) return;
            http2StreamArray2 = streamsToNotify;
            int n = 0;
            int n2 = http2StreamArray2.length;
            while (n < n2) {
                void var1_3;
                Http2Stream stream = http2StreamArray2[n];
                object = stream;
                // MONITORENTER : stream
                var1_3.addBytesToWriteWindow(delta);
                // MONITOREXIT : object
                ++n;
            }
        }

        @Override
        public final void ackSettings() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void ping(boolean ack2, int payload1, int payload2) {
            void var3_7;
            void var2_4;
            void name$iv;
            void var1_3;
            if (ack2) {
                Http2Connection ack2 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (ack2) {
                    switch (payload1) {
                        case 1: {
                            long l = http2Connection.intervalPongsReceived;
                            Http2Connection.access$setIntervalPongsReceived$p(http2Connection, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 2: {
                            long l = http2Connection.degradedPongsReceived;
                            Http2Connection.access$setDegradedPongsReceived$p(http2Connection, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 3: {
                            void var2_5;
                            long l = http2Connection.awaitPongsReceived;
                            Http2Connection.access$setAwaitPongsReceived$p(http2Connection, l + 1L);
                            Http2Connection $this$notifyAll$iv = http2Connection;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)var2_5).notifyAll();
                            break;
                        }
                    }
                    return;
                }
            }
            TaskQueue ack2 = this.this$0.writerQueue;
            String string = this.this$0.getConnectionName$okhttp() + " ping";
            Http2Connection http2Connection = this.this$0;
            var1_3.schedule(new Task((String)name$iv, true, http2Connection, (int)var2_4, (int)var3_7){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $payload1$inlined;
                final /* synthetic */ int $payload2$inlined;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$payload1$inlined = n;
                    this.$payload2$inlined = n2;
                    super((String)var1_1, (boolean)var2_2);
                }

                public final long runOnce() {
                    this.this$0.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                    return -1L;
                }
            }, 0L);
        }

        @Override
        public final void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Http2Stream[] http2StreamArray;
            Http2Connection http2Connection;
            Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
            http2Connection.size();
            errorCode = this.this$0;
            http2Connection = this.this$0;
            Object object = errorCode;
            synchronized (object) {
                Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                errorCode = collection;
                errorCode = collection;
                Http2Stream[] streamsCopy = collection.toArray(new Http2Stream[0]);
                Http2Connection.access$setShutdown$p(http2Connection, true);
            }
            for (Http2Stream http2Stream : (Http2Stream[])http2StreamArray) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                this.this$0.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void windowUpdate(int streamId22, long windowSizeIncrement) {
            int streamId22;
            if (streamId22 == 0) {
                Http2Connection streamId22 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (streamId22) {
                    void var2_6;
                    Http2Connection http2Connection2 = http2Connection;
                    Http2Connection.access$setWriteBytesMaximum$p(http2Connection2, http2Connection2.getWriteBytesMaximum() + windowSizeIncrement);
                    Http2Connection $this$notifyAll$iv = http2Connection;
                    Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)var2_6).notifyAll();
                    return;
                }
            }
            Http2Stream stream = this.this$0.getStream(streamId22);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    void var2_5;
                    void var1_3;
                    var1_3.addBytesToWriteWindow((long)var2_5);
                    return;
                }
            }
        }

        @Override
        public final void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            this.this$0.pushRequestLater$okhttp((int)var2_2, (List<Header>)var3_3);
        }
    }
}

