/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000bR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014"}, d2={"Lokhttp3/internal/http2/Hpack;", "", "<init>", "()V", "Lokio/ByteString;", "name", "checkLowercase", "(Lokio/ByteString;)Lokio/ByteString;", "", "", "nameToFirstIndex", "()Ljava/util/Map;", "NAME_TO_FIRST_INDEX", "Ljava/util/Map;", "getNAME_TO_FIRST_INDEX", "", "Lokhttp3/internal/http2/Header;", "STATIC_HEADER_TABLE", "[Lokhttp3/internal/http2/Header;", "getSTATIC_HEADER_TABLE", "()[Lokhttp3/internal/http2/Header;", "Reader", "Writer"})
public final class Hpack {
    public static final Hpack INSTANCE = new Hpack();
    private static final Header[] STATIC_HEADER_TABLE;
    private static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;

    private Hpack() {
    }

    public final Header[] getSTATIC_HEADER_TABLE() {
        return STATIC_HEADER_TABLE;
    }

    public final Map<ByteString, Integer> getNAME_TO_FIRST_INDEX() {
        return NAME_TO_FIRST_INDEX;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ByteString, Integer> nameToFirstIndex() {
        void var1_1;
        LinkedHashMap result = new LinkedHashMap(STATIC_HEADER_TABLE.length);
        int n = STATIC_HEADER_TABLE.length;
        for (int i = 0; i < n; ++i) {
            if (result.containsKey(Hpack.STATIC_HEADER_TABLE[i].name)) continue;
            Integer n2 = i;
            ((Map)result).put(Hpack.STATIC_HEADER_TABLE[i].name, n2);
        }
        Map<ByteString, Integer> map = Collections.unmodifiableMap((Map)var1_1);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(result)");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString checkLowercase(ByteString name) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = name.size();
        for (int i = 0; i < n; ++i) {
            byte by = name.getByte(i);
            boolean bl = 65 <= by ? by < 91 : false;
            if (!bl) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + name.utf8());
        }
        return var1_1;
    }

    static {
        Header[] headerArray = new Header[61];
        Header[] headerArray2 = headerArray;
        headerArray[0] = new Header(Header.TARGET_AUTHORITY, "");
        headerArray2[1] = new Header(Header.TARGET_METHOD, "GET");
        headerArray2[2] = new Header(Header.TARGET_METHOD, "POST");
        headerArray2[3] = new Header(Header.TARGET_PATH, "/");
        headerArray2[4] = new Header(Header.TARGET_PATH, "/index.html");
        headerArray2[5] = new Header(Header.TARGET_SCHEME, "http");
        headerArray2[6] = new Header(Header.TARGET_SCHEME, "https");
        headerArray2[7] = new Header(Header.RESPONSE_STATUS, "200");
        headerArray2[8] = new Header(Header.RESPONSE_STATUS, "204");
        headerArray2[9] = new Header(Header.RESPONSE_STATUS, "206");
        headerArray2[10] = new Header(Header.RESPONSE_STATUS, "304");
        headerArray2[11] = new Header(Header.RESPONSE_STATUS, "400");
        headerArray2[12] = new Header(Header.RESPONSE_STATUS, "404");
        headerArray2[13] = new Header(Header.RESPONSE_STATUS, "500");
        headerArray2[14] = new Header("accept-charset", "");
        headerArray2[15] = new Header("accept-encoding", "gzip, deflate");
        headerArray2[16] = new Header("accept-language", "");
        headerArray2[17] = new Header("accept-ranges", "");
        headerArray2[18] = new Header("accept", "");
        headerArray2[19] = new Header("access-control-allow-origin", "");
        headerArray2[20] = new Header("age", "");
        headerArray2[21] = new Header("allow", "");
        headerArray2[22] = new Header("authorization", "");
        headerArray2[23] = new Header("cache-control", "");
        headerArray2[24] = new Header("content-disposition", "");
        headerArray2[25] = new Header("content-encoding", "");
        headerArray2[26] = new Header("content-language", "");
        headerArray2[27] = new Header("content-length", "");
        headerArray2[28] = new Header("content-location", "");
        headerArray2[29] = new Header("content-range", "");
        headerArray2[30] = new Header("content-type", "");
        headerArray2[31] = new Header("cookie", "");
        headerArray2[32] = new Header("date", "");
        headerArray2[33] = new Header("etag", "");
        headerArray2[34] = new Header("expect", "");
        headerArray2[35] = new Header("expires", "");
        headerArray2[36] = new Header("from", "");
        headerArray2[37] = new Header("host", "");
        headerArray2[38] = new Header("if-match", "");
        headerArray2[39] = new Header("if-modified-since", "");
        headerArray2[40] = new Header("if-none-match", "");
        headerArray2[41] = new Header("if-range", "");
        headerArray2[42] = new Header("if-unmodified-since", "");
        headerArray2[43] = new Header("last-modified", "");
        headerArray2[44] = new Header("link", "");
        headerArray2[45] = new Header("location", "");
        headerArray2[46] = new Header("max-forwards", "");
        headerArray2[47] = new Header("proxy-authenticate", "");
        headerArray2[48] = new Header("proxy-authorization", "");
        headerArray2[49] = new Header("range", "");
        headerArray2[50] = new Header("referer", "");
        headerArray2[51] = new Header("refresh", "");
        headerArray2[52] = new Header("retry-after", "");
        headerArray2[53] = new Header("server", "");
        headerArray2[54] = new Header("set-cookie", "");
        headerArray2[55] = new Header("strict-transport-security", "");
        headerArray2[56] = new Header("transfer-encoding", "");
        headerArray2[57] = new Header("user-agent", "");
        headerArray2[58] = new Header("vary", "");
        headerArray2[59] = new Header("via", "");
        headerArray2[60] = new Header("www-authenticate", "");
        STATIC_HEADER_TABLE = headerArray2;
        NAME_TO_FIRST_INDEX = INSTANCE.nameToFirstIndex();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0016\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\t\u00a2\u0006\u0004\b#\u0010\u000bJ\u0017\u0010$\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b+\u0010%J\u000f\u0010,\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b,\u0010\u000bJ\u0017\u0010-\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b-\u0010%J\u000f\u0010.\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b.\u0010\u000bR\u001e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130/8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b4\u00103R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0013058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00103R\u0016\u0010\u0006\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u00103R\u0016\u00108\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b8\u00103R\u0014\u0010\u0003\u001a\u0002098\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010:"}, d2={"Lokhttp3/internal/http2/Hpack$Reader;", "", "Lokio/Source;", "source", "", "headerTableSizeSetting", "maxDynamicTableByteCount", "<init>", "(Lokio/Source;II)V", "", "adjustDynamicTableByteCount", "()V", "clearDynamicTable", "index", "dynamicTableIndex", "(I)I", "bytesToRecover", "evictToRecoverBytes", "", "Lokhttp3/internal/http2/Header;", "getAndResetHeaderList", "()Ljava/util/List;", "Lokio/ByteString;", "getName", "(I)Lokio/ByteString;", "entry", "insertIntoDynamicTable", "(ILokhttp3/internal/http2/Header;)V", "", "isStaticHeader", "(I)Z", "readByte", "()I", "readByteString", "()Lokio/ByteString;", "readHeaders", "readIndexedHeader", "(I)V", "firstByte", "prefixMask", "readInt", "(II)I", "nameIndex", "readLiteralHeaderWithIncrementalIndexingIndexedName", "readLiteralHeaderWithIncrementalIndexingNewName", "readLiteralHeaderWithoutIndexingIndexedName", "readLiteralHeaderWithoutIndexingNewName", "", "dynamicTable", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "I", "headerCount", "", "headerList", "Ljava/util/List;", "nextHeaderIndex", "Lokio/BufferedSource;", "Lokio/BufferedSource;"})
    public static final class Reader {
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        private final List<Header> headerList;
        private final BufferedSource source;
        @JvmField
        public Header[] dynamicTable;
        private int nextHeaderIndex;
        @JvmField
        public int headerCount;
        @JvmField
        public int dynamicTableByteCount;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public Reader(Source source, int headerTableSizeSetting, int maxDynamicTableByteCount) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.headerTableSizeSetting = var2_2;
            this.maxDynamicTableByteCount = var3_3;
            this.headerList = new ArrayList();
            this.source = Okio.buffer((Source)var1_1);
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Reader(Source source, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = n;
            }
            this(source, n, n2);
        }

        /*
         * WARNING - void declaration
         */
        public final List<Header> getAndResetHeaderList() {
            void var1_1;
            List result = CollectionsKt.toList((Iterable)this.headerList);
            this.headerList.clear();
            return var1_1;
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                    return;
                }
                Reader reader = this;
                reader.evictToRecoverBytes(reader.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default((Object[])this.dynamicTable, null, (int)0, (int)0, (int)6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        private final int evictToRecoverBytes(int bytesToRecover) {
            void var2_2;
            int entriesToEvict = 0;
            if (bytesToRecover > 0) {
                for (int j = this.dynamicTable.length - 1; j >= this.nextHeaderIndex && bytesToRecover > 0; --j) {
                    Header toEvict;
                    Intrinsics.checkNotNull((Object)this.dynamicTable[j]);
                    bytesToRecover -= toEvict.hpackSize;
                    this.dynamicTableByteCount -= toEvict.hpackSize;
                    int n = this.headerCount;
                    this.headerCount = n + -1;
                    ++entriesToEvict;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                this.nextHeaderIndex += entriesToEvict;
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                void var1_1;
                int index;
                int b = Util.and(this.source.readByte(), 255);
                if (b == 128) {
                    throw new IOException("index == 0");
                }
                if ((b & 0x80) == 128) {
                    index = this.readInt(b, 127);
                    this.readIndexedHeader(index - 1);
                    continue;
                }
                if (index == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((index & 0x40) == 64) {
                    index = this.readInt(index, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(index - 1);
                    continue;
                }
                if ((index & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(index, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (index == 16 || index == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                index = this.readInt(index, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName((int)(var1_1 - true));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void readIndexedHeader(int index) throws IOException {
            void var2_3;
            if (this.isStaticHeader(index)) {
                Header staticEntry = INSTANCE.getSTATIC_HEADER_TABLE()[index];
                this.headerList.add(staticEntry);
                return;
            }
            int dynamicTableIndex = this.dynamicTableIndex(index - INSTANCE.getSTATIC_HEADER_TABLE().length);
            if (dynamicTableIndex < 0 || dynamicTableIndex >= this.dynamicTable.length) {
                void var1_1;
                throw new IOException("Header index too large " + (int)(var1_1 + true));
            }
            Collection collection = this.headerList;
            Header header = this.dynamicTable[var2_3];
            Intrinsics.checkNotNull((Object)header);
            collection.add(header);
        }

        /*
         * WARNING - void declaration
         */
        private final int dynamicTableIndex(int index) {
            void var1_1;
            return this.nextHeaderIndex + 1 + var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final void readLiteralHeaderWithoutIndexingIndexedName(int index) throws IOException {
            void var2_3;
            void var1_2;
            ByteString name = this.getName(index);
            ByteString value = this.readByteString();
            this.headerList.add(new Header((ByteString)var1_2, (ByteString)var2_3));
        }

        /*
         * WARNING - void declaration
         */
        private final void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            void var2_2;
            void var1_1;
            ByteString name = INSTANCE.checkLowercase(this.readByteString());
            ByteString value = this.readByteString();
            this.headerList.add(new Header((ByteString)var1_1, (ByteString)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        private final void readLiteralHeaderWithIncrementalIndexingIndexedName(int nameIndex) throws IOException {
            void var2_3;
            void var1_2;
            ByteString name = this.getName(nameIndex);
            ByteString value = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header((ByteString)var1_2, (ByteString)var2_3));
        }

        /*
         * WARNING - void declaration
         */
        private final void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            void var2_2;
            void var1_1;
            ByteString name = INSTANCE.checkLowercase(this.readByteString());
            ByteString value = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header((ByteString)var1_1, (ByteString)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        private final ByteString getName(int index) throws IOException {
            void var2_2;
            if (this.isStaticHeader(index)) {
                return Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[index].name;
            }
            int dynamicTableIndex = this.dynamicTableIndex(index - INSTANCE.getSTATIC_HEADER_TABLE().length);
            if (dynamicTableIndex < 0 || dynamicTableIndex >= this.dynamicTable.length) {
                void var1_1;
                throw new IOException("Header index too large " + (int)(var1_1 + true));
            }
            Header header = this.dynamicTable[var2_2];
            Intrinsics.checkNotNull((Object)header);
            return header.name;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isStaticHeader(int index) {
            void var1_1;
            return index >= 0 && var1_1 <= INSTANCE.getSTATIC_HEADER_TABLE().length - 1;
        }

        /*
         * WARNING - void declaration
         */
        private final void insertIntoDynamicTable(int index, Header entry) {
            void var3_5;
            this.headerList.add(entry);
            int delta = entry.hpackSize;
            if (index != -1) {
                Header header = this.dynamicTable[this.dynamicTableIndex(index)];
                Intrinsics.checkNotNull((Object)header);
                delta -= header.hpackSize;
            }
            if (delta > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int bytesToRecover = this.dynamicTableByteCount + delta - this.maxDynamicTableByteCount;
            int entriesEvicted = this.evictToRecoverBytes(bytesToRecover);
            if (index == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    void var1_2;
                    Header[] doubled = new Header[this.dynamicTable.length << 1];
                    System.arraycopy(this.dynamicTable, 0, doubled, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = var1_2;
                }
                int n = this.nextHeaderIndex;
                this.nextHeaderIndex = n + -1;
                this.dynamicTable[n] = entry;
                n = this.headerCount;
                this.headerCount = n + 1;
            } else {
                void var2_4;
                void var1_1;
                var1_1 += this.dynamicTableIndex((int)var1_1) + entriesEvicted;
                this.dynamicTable[var1_1] = var2_4;
            }
            this.dynamicTableByteCount += var3_5;
        }

        private final int readByte() throws IOException {
            return Util.and(this.source.readByte(), 255);
        }

        /*
         * WARNING - void declaration
         */
        public final int readInt(int firstByte, int prefixMask) throws IOException {
            void var2_2;
            void var3_3;
            int b;
            int prefix = firstByte & prefixMask;
            if (prefix < prefixMask) {
                return prefix;
            }
            int result = prefixMask;
            int shift = 0;
            while (((b = this.readByte()) & 0x80) != 0) {
                result += (b & 0x7F) << shift;
                shift += 7;
            }
            return (int)(var1_1 += var3_3 << var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ByteString readByteString() throws IOException {
            void var3_4;
            void var2_3;
            int firstByte = this.readByte();
            boolean huffmanDecode = (firstByte & 0x80) == 128;
            long length = this.readInt(firstByte, 127);
            if (var2_3 != false) {
                void var1_2;
                Buffer decodeBuffer = new Buffer();
                Huffman.INSTANCE.decode(this.source, length, (BufferedSink)decodeBuffer);
                return var1_2.readByteString();
            }
            return this.source.readByteString((long)var3_4);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001d\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#R\u001e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010(R\u0016\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010(R\u0016\u0010,\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010(R\u0016\u0010-\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010(R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010.R\u0016\u0010/\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010(R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010*"}, d2={"Lokhttp3/internal/http2/Hpack$Writer;", "", "", "headerTableSizeSetting", "", "useCompression", "Lokio/Buffer;", "out", "<init>", "(IZLokio/Buffer;)V", "", "adjustDynamicTableByteCount", "()V", "clearDynamicTable", "bytesToRecover", "evictToRecoverBytes", "(I)I", "Lokhttp3/internal/http2/Header;", "entry", "insertIntoDynamicTable", "(Lokhttp3/internal/http2/Header;)V", "resizeHeaderTable", "(I)V", "Lokio/ByteString;", "data", "writeByteString", "(Lokio/ByteString;)V", "", "headerBlock", "writeHeaders", "(Ljava/util/List;)V", "value", "prefixMask", "bits", "writeInt", "(III)V", "", "dynamicTable", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "I", "emitDynamicTableSizeUpdate", "Z", "headerCount", "maxDynamicTableByteCount", "nextHeaderIndex", "Lokio/Buffer;", "smallestHeaderTableSizeSetting"})
    public static final class Writer {
        @JvmField
        public int headerTableSizeSetting;
        private final boolean useCompression;
        private final Buffer out;
        private int smallestHeaderTableSizeSetting;
        private boolean emitDynamicTableSizeUpdate;
        @JvmField
        public int maxDynamicTableByteCount;
        @JvmField
        public Header[] dynamicTable;
        private int nextHeaderIndex;
        @JvmField
        public int headerCount;
        @JvmField
        public int dynamicTableByteCount;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public Writer(int headerTableSizeSetting, boolean useCompression, Buffer out) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.headerTableSizeSetting = var1_1;
            this.useCompression = var2_2;
            this.out = var3_3;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.maxDynamicTableByteCount = this.headerTableSizeSetting;
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Writer(int n, boolean bl, Buffer buffer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 4096;
            }
            if ((n2 & 2) != 0) {
                bl = true;
            }
            this(n, bl, buffer);
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default((Object[])this.dynamicTable, null, (int)0, (int)0, (int)6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        private final int evictToRecoverBytes(int bytesToRecover) {
            void var2_2;
            int entriesToEvict = 0;
            if (bytesToRecover > 0) {
                for (int j = this.dynamicTable.length - 1; j >= this.nextHeaderIndex && bytesToRecover > 0; --j) {
                    Header header = this.dynamicTable[j];
                    Intrinsics.checkNotNull((Object)header);
                    bytesToRecover -= header.hpackSize;
                    Header header2 = this.dynamicTable[j];
                    Intrinsics.checkNotNull((Object)header2);
                    this.dynamicTableByteCount -= header2.hpackSize;
                    int n = this.headerCount;
                    this.headerCount = n + -1;
                    ++entriesToEvict;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + entriesToEvict, null);
                this.nextHeaderIndex += entriesToEvict;
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final void insertIntoDynamicTable(Header entry) {
            void var2_2;
            void var1_1;
            int delta = entry.hpackSize;
            if (delta > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int bytesToRecover = this.dynamicTableByteCount + delta - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(bytesToRecover);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] doubled = new Header[this.dynamicTable.length << 1];
                System.arraycopy(this.dynamicTable, 0, doubled, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = doubled;
            }
            int doubled = this.nextHeaderIndex;
            this.nextHeaderIndex = doubled + -1;
            this.dynamicTable[n] = var1_1;
            int n = this.headerCount;
            this.headerCount = n + 1;
            this.dynamicTableByteCount += var2_2;
        }

        public final void writeHeaders(List<Header> headerBlock) throws IOException {
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    Writer writer = this;
                    writer.writeInt(writer.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                Writer writer = this;
                writer.writeInt(writer.maxDynamicTableByteCount, 31, 32);
            }
            int n = headerBlock.size();
            for (int i = 0; i < n; ++i) {
                Header header = headerBlock.get(i);
                ByteString name = header.name.toAsciiLowercase();
                ByteString value = header.value;
                int headerIndex = -1;
                int headerNameIndex = -1;
                Integer staticIndex = INSTANCE.getNAME_TO_FIRST_INDEX().get(name);
                if (staticIndex != null) {
                    headerNameIndex = staticIndex + 1;
                    boolean bl = 2 <= headerNameIndex ? headerNameIndex < 8 : false;
                    if (bl) {
                        if (Intrinsics.areEqual((Object)Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[headerNameIndex - 1].value, (Object)value)) {
                            headerIndex = headerNameIndex;
                        } else if (Intrinsics.areEqual((Object)Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[headerNameIndex].value, (Object)value)) {
                            headerIndex = headerNameIndex + 1;
                        }
                    }
                }
                if (headerIndex == -1) {
                    int n2 = this.dynamicTable.length;
                    for (int j = this.nextHeaderIndex + 1; j < n2; ++j) {
                        Header header2 = this.dynamicTable[j];
                        Intrinsics.checkNotNull((Object)header2);
                        if (!Intrinsics.areEqual((Object)header2.name, (Object)name)) continue;
                        Header header3 = this.dynamicTable[j];
                        Intrinsics.checkNotNull((Object)header3);
                        if (Intrinsics.areEqual((Object)header3.value, (Object)value)) {
                            headerIndex = j - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                            break;
                        }
                        if (headerNameIndex != -1) continue;
                        headerNameIndex = j - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                    }
                }
                if (headerIndex != -1) {
                    this.writeInt(headerIndex, 127, 128);
                    continue;
                }
                if (headerNameIndex == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(name);
                    this.writeByteString(value);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (name.startsWith(Header.PSEUDO_PREFIX) && !Intrinsics.areEqual((Object)Header.TARGET_AUTHORITY, (Object)name)) {
                    this.writeInt(headerNameIndex, 15, 0);
                    this.writeByteString(value);
                    continue;
                }
                this.writeInt(headerNameIndex, 63, 64);
                this.writeByteString(value);
                this.insertIntoDynamicTable(header);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void writeInt(int value, int prefixMask, int bits) {
            void var1_1;
            void var3_3;
            if (value < prefixMask) {
                this.out.writeByte(bits | value);
                return;
            }
            this.out.writeByte(var3_3 | prefixMask);
            value -= prefixMask;
            while (value >= 128) {
                void var2_2;
                int b = value & 0x7F;
                this.out.writeByte(var2_2 | 0x80);
                value >>>= 7;
            }
            this.out.writeByte((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void writeByteString(ByteString data) throws IOException {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.useCompression && Huffman.INSTANCE.encodedLength(data) < data.size()) {
                void var2_2;
                Buffer huffmanBuffer = new Buffer();
                Huffman.INSTANCE.encode(data, (BufferedSink)huffmanBuffer);
                ByteString huffmanBytes = var2_2.readByteString();
                this.writeInt(huffmanBytes.size(), 127, 128);
                this.out.write((ByteString)var1_1);
                return;
            }
            this.writeInt(var1_1.size(), 127, 0);
            this.out.write((ByteString)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void resizeHeaderTable(int headerTableSizeSetting) {
            void var1_1;
            this.headerTableSizeSetting = headerTableSizeSetting;
            int effectiveHeaderTableSize = Math.min(headerTableSizeSetting, 16384);
            if (this.maxDynamicTableByteCount == effectiveHeaderTableSize) {
                return;
            }
            if (effectiveHeaderTableSize < this.maxDynamicTableByteCount) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, effectiveHeaderTableSize);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = var1_1;
            this.adjustDynamicTableByteCount();
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                    return;
                }
                Writer writer = this;
                writer.evictToRecoverBytes(writer.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }
    }
}

