/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\b\u0007\u0018\u0000 O2\u00020\u0001:\u0007PQROSTUB)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u000f\u0010\u001b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u000eJ\u000f\u0010\u001c\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b&\u0010\u001dJ\u000f\u0010'\u001a\u00020 H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010+\u001a\u00020 2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0019\u00100\u001a\u0004\u0018\u00010/2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020\u00112\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u00020\f2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b4\u00105J\u001d\u0010:\u001a\u00020\f2\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010<\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b<\u0010=R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010>R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010?\u001a\u0004\b@\u0010AR\u0014\u0010C\u001a\u00020B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010ER\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010FR\u0016\u0010H\u001a\u00020G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0018\u0010J\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0018\u0010L\u001a\u00020-*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0018\u0010L\u001a\u00020-*\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010N"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "Lokhttp3/OkHttpClient;", "client", "Lokhttp3/internal/connection/RealConnection;", "connection", "Lokio/BufferedSource;", "source", "Lokio/BufferedSink;", "sink", "<init>", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealConnection;Lokio/BufferedSource;Lokio/BufferedSink;)V", "", "cancel", "()V", "Lokhttp3/Request;", "request", "", "contentLength", "Lokio/Sink;", "createRequestBody", "(Lokhttp3/Request;J)Lokio/Sink;", "Lokio/ForwardingTimeout;", "timeout", "detachTimeout", "(Lokio/ForwardingTimeout;)V", "finishRequest", "flushRequest", "newChunkedSink", "()Lokio/Sink;", "Lokhttp3/HttpUrl;", "url", "Lokio/Source;", "newChunkedSource", "(Lokhttp3/HttpUrl;)Lokio/Source;", "length", "newFixedLengthSource", "(J)Lokio/Source;", "newKnownLengthSink", "newUnknownLengthSource", "()Lokio/Source;", "Lokhttp3/Response;", "response", "openResponseBodySource", "(Lokhttp3/Response;)Lokio/Source;", "", "expectContinue", "Lokhttp3/Response$Builder;", "readResponseHeaders", "(Z)Lokhttp3/Response$Builder;", "reportedContentLength", "(Lokhttp3/Response;)J", "skipConnectBody", "(Lokhttp3/Response;)V", "Lokhttp3/Headers;", "headers", "", "requestLine", "writeRequest", "(Lokhttp3/Headers;Ljava/lang/String;)V", "writeRequestHeaders", "(Lokhttp3/Request;)V", "Lokhttp3/OkHttpClient;", "Lokhttp3/internal/connection/RealConnection;", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/internal/http1/HeadersReader;", "headersReader", "Lokhttp3/internal/http1/HeadersReader;", "Lokio/BufferedSink;", "Lokio/BufferedSource;", "", "state", "I", "trailers", "Lokhttp3/Headers;", "isChunked", "(Lokhttp3/Request;)Z", "(Lokhttp3/Response;)Z", "Companion", "AbstractSource", "ChunkedSink", "ChunkedSource", "FixedLengthSource", "KnownLengthSink", "UnknownLengthSource"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    public static final Companion Companion = new Companion(null);
    private final OkHttpClient client;
    private final RealConnection connection;
    private final BufferedSource source;
    private final BufferedSink sink;
    private int state;
    private final HeadersReader headersReader;
    private Headers trailers;

    /*
     * WARNING - void declaration
     */
    public Http1ExchangeCodec(OkHttpClient client, RealConnection connection, BufferedSource source, BufferedSink sink) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.client = var1_1;
        this.connection = var2_2;
        this.source = var3_3;
        this.sink = sink;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isChunked(Response $this$isChunked) {
        void var1_1;
        return StringsKt.equals((String)"chunked", (String)Response.header$default((Response)var1_1, "Transfer-Encoding", null, 2, null), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isChunked(Request $this$isChunked) {
        void var1_1;
        return StringsKt.equals((String)"chunked", (String)var1_1.header("Transfer-Encoding"), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Sink createRequestBody(Request request, long contentLength) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() != null && request.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked((Request)var1_1)) {
            return this.newChunkedSink();
        }
        if (var2_2 != -1L) {
            return this.newKnownLengthSink();
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        this.getConnection().cancel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeRequestHeaders(Request request) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Proxy.Type type = this.getConnection().route().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"connection.route().proxy.type()");
        String requestLine = RequestLine.INSTANCE.get(request, type);
        this.writeRequest(var1_1.headers(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long reportedContentLength(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody(response)) {
            return 0L;
        }
        if (this.isChunked(response)) {
            return -1L;
        }
        return Util.headersContentLength((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Source openResponseBodySource(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if (this.isChunked(response)) {
            return this.newChunkedSource(response.request().url());
        }
        long contentLength = Util.headersContentLength((Response)var1_1);
        if (contentLength != -1L) {
            void var2_2;
            return this.newFixedLengthSource((long)var2_2);
        }
        return this.newUnknownLengthSource();
    }

    @Override
    public final void flushRequest() {
        this.sink.flush();
    }

    @Override
    public final void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String requestLine) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        if (!(this.state == 0)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.sink.writeUtf8(requestLine).writeUtf8("\r\n");
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 1 || this.state == 2 || this.state == 3)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        try {
            int n;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (n != 0 && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return responseBuilder;
            }
            n = statusLine.code;
            boolean bl = 102 <= n ? n < 200 : false;
            if (bl) {
                this.state = 3;
                return responseBuilder;
            }
            this.state = 4;
            return responseBuilder;
        }
        catch (EOFException e) {
            void var2_6;
            void var3_4;
            String address = this.getConnection().route().address().url().redact();
            throw new IOException("unexpected end of stream on " + (String)var3_4, (Throwable)var2_6);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new ChunkedSink(this);
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new KnownLengthSink(this);
    }

    /*
     * WARNING - void declaration
     */
    private final Source newFixedLengthSource(long length2) {
        void var1_1;
        if (!(this.state == 4)) {
            String length2 = "state: " + this.state;
            throw new IllegalStateException(length2.toString());
        }
        this.state = 5;
        return new FixedLengthSource((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final Source newChunkedSource(HttpUrl url) {
        void var1_1;
        if (!(this.state == 4)) {
            url = "state: " + this.state;
            throw new IllegalStateException(url.toString());
        }
        this.state = 5;
        return new ChunkedSource((HttpUrl)var1_1);
    }

    private final Source newUnknownLengthSource() {
        if (!(this.state == 4)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getConnection().noNewExchanges$okhttp();
        return new UnknownLengthSource();
    }

    /*
     * WARNING - void declaration
     */
    private final void detachTimeout(ForwardingTimeout timeout2) {
        void var2_2;
        void var1_1;
        Timeout oldDelegate = timeout2.delegate();
        var1_1.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        var2_2.clearTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipConnectBody(Response response) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long contentLength = Util.headersContentLength(response);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource((long)var2_2);
        Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$detachTimeout(Http1ExchangeCodec $this, ForwardingTimeout timeout2) {
        void var1_1;
        $this.detachTimeout((ForwardingTimeout)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setState$p(Http1ExchangeCodec $this, int n) {
        void var1_1;
        $this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTrailers$p(Http1ExchangeCodec $this, Headers headers) {
        void var1_1;
        $this.trailers = var1_1;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000e\u001a\u00020\u00178\u0004X\u0084\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0018"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokio/Source;", "<init>", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "", "responseBodyComplete", "()V", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "", "closed", "Z", "getClosed", "()Z", "setClosed", "(Z)V", "Lokio/ForwardingTimeout;", "Lokio/ForwardingTimeout;"})
    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        private boolean closed;
        final /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public AbstractSource(Http1ExchangeCodec this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.source.timeout());
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        /*
         * WARNING - void declaration
         */
        protected final void setClosed(boolean bl) {
            void var1_1;
            this.closed = var1_1;
        }

        public Timeout timeout() {
            return (Timeout)this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public long read(Buffer sink, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                void var2_3;
                l = this.this$0.source.read(sink, (long)var2_3);
            }
            catch (IOException e) {
                void var1_2;
                this.this$0.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
                throw var1_2;
            }
            return l;
        }

        public final void responseBodyComplete() {
            if (this.this$0.state == 6) {
                return;
            }
            if (this.this$0.state != 5) {
                throw new IllegalStateException("state: " + this.this$0.state);
            }
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 6);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0015"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink;", "Lokio/Sink;", "<init>", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "", "close", "()V", "flush", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "source", "", "byteCount", "write", "(Lokio/Buffer;J)V", "", "closed", "Z", "Lokio/ForwardingTimeout;", "Lokio/ForwardingTimeout;"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        final /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public ChunkedSink(Http1ExchangeCodec this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.sink.timeout());
        }

        public final Timeout timeout() {
            return (Timeout)this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                source = "closed";
                throw new IllegalStateException(source.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            this.this$0.sink.writeHexadecimalUnsignedLong(byteCount);
            this.this$0.sink.writeUtf8("\r\n");
            this.this$0.sink.write((Buffer)var1_1, (long)var2_2);
            this.this$0.sink.writeUtf8("\r\n");
        }

        public final synchronized void flush() {
            if (this.closed) {
                return;
            }
            this.this$0.sink.flush();
        }

        public final synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0083\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\tR\u0016\u0010\u0011\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "Lokhttp3/HttpUrl;", "url", "<init>", "(Lokhttp3/internal/http1/Http1ExchangeCodec;Lokhttp3/HttpUrl;)V", "", "close", "()V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "readChunkSize", "bytesRemainingInChunk", "J", "", "hasMoreChunks", "Z", "Lokhttp3/HttpUrl;"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class ChunkedSource
    extends AbstractSource {
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        /*
         * WARNING - void declaration
         */
        public ChunkedSource(HttpUrl url) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super((Http1ExchangeCodec)var1_1);
            this.url = var2_2;
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink, long byteCount) {
            void var2_2;
            long read;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = super.read(sink, Math.min((long)var2_2, this.bytesRemainingInChunk))) == -1L) {
                void var1_1;
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw var1_1;
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        /*
         * WARNING - void declaration
         */
        private final void readChunkSize() {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                String extensions = ((Object)StringsKt.trim((CharSequence)Http1ExchangeCodec.this.source.readUtf8LineStrict())).toString();
                if (this.bytesRemainingInChunk < 0L || ((CharSequence)extensions).length() > 0 && !StringsKt.startsWith$default((String)extensions, (String)";", (boolean)false, (int)2, null)) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + '\"');
                }
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new ProtocolException(var1_2.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Http1ExchangeCodec.access$setTrailers$p(Http1ExchangeCodec.this, Http1ExchangeCodec.this.headersReader.readHeaders());
                OkHttpClient okHttpClient = Http1ExchangeCodec.this.client;
                Intrinsics.checkNotNull((Object)okHttpClient);
                CookieJar cookieJar = okHttpClient.cookieJar();
                Headers headers = Http1ExchangeCodec.this.trailers;
                Intrinsics.checkNotNull((Object)headers);
                HttpHeaders.receiveHeaders(cookieJar, this.url, headers);
                this.responseBodyComplete();
            }
        }

        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0083\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000f"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "", "bytesRemaining", "<init>", "(Lokhttp3/internal/http1/Http1ExchangeCodec;J)V", "", "close", "()V", "Lokio/Buffer;", "sink", "byteCount", "read", "(Lokio/Buffer;J)J", "J"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        /*
         * WARNING - void declaration
         */
        public FixedLengthSource(long bytesRemaining) {
            void var2_2;
            void var1_1;
            super((Http1ExchangeCodec)var1_1);
            this.bytesRemaining = var2_2;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink, long byteCount) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = super.read(sink, Math.min(this.bytesRemaining, (long)var2_2));
            if (read == -1L) {
                void var1_1;
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw var1_1;
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return read;
        }

        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0015"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink;", "Lokio/Sink;", "<init>", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "", "close", "()V", "flush", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "source", "", "byteCount", "write", "(Lokio/Buffer;J)V", "", "closed", "Z", "Lokio/ForwardingTimeout;", "Lokio/ForwardingTimeout;"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class KnownLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        final /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public KnownLengthSink(Http1ExchangeCodec this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.sink.timeout());
        }

        public final Timeout timeout() {
            return (Timeout)this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                source = "closed";
                throw new IllegalStateException(source.toString());
            }
            Util.checkOffsetAndCount(source.size(), 0L, byteCount);
            this.this$0.sink.write((Buffer)var1_1, (long)var2_2);
        }

        public final void flush() {
            if (this.closed) {
                return;
            }
            this.this$0.sink.flush();
        }

        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0083\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "<init>", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "", "close", "()V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "", "inputExhausted", "Z"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        /*
         * WARNING - void declaration
         */
        public UnknownLengthSource() {
            void var1_1;
            super((Http1ExchangeCodec)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = super.read((Buffer)var1_1, (long)var2_2);
            if (read == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return read;
        }

        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }
}

