/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteDatabase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0002-.B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0010H\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010$R\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,"}, d2={"Lokhttp3/internal/connection/RouteSelector;", "", "Lokhttp3/Address;", "address", "Lokhttp3/internal/connection/RouteDatabase;", "routeDatabase", "Lokhttp3/Call;", "call", "Lokhttp3/EventListener;", "eventListener", "<init>", "(Lokhttp3/Address;Lokhttp3/internal/connection/RouteDatabase;Lokhttp3/Call;Lokhttp3/EventListener;)V", "", "hasNext", "()Z", "hasNextProxy", "Lokhttp3/internal/connection/RouteSelector$Selection;", "next", "()Lokhttp3/internal/connection/RouteSelector$Selection;", "Ljava/net/Proxy;", "nextProxy", "()Ljava/net/Proxy;", "proxy", "", "resetNextInetSocketAddress", "(Ljava/net/Proxy;)V", "Lokhttp3/HttpUrl;", "url", "resetNextProxy", "(Lokhttp3/HttpUrl;Ljava/net/Proxy;)V", "Lokhttp3/Address;", "Lokhttp3/Call;", "Lokhttp3/EventListener;", "", "Ljava/net/InetSocketAddress;", "inetSocketAddresses", "Ljava/util/List;", "", "nextProxyIndex", "I", "", "Lokhttp3/Route;", "postponedRoutes", "proxies", "Lokhttp3/internal/connection/RouteDatabase;", "Companion", "Selection"})
public final class RouteSelector {
    public static final Companion Companion = new Companion(null);
    private final Address address;
    private final RouteDatabase routeDatabase;
    private final Call call;
    private final EventListener eventListener;
    private List<? extends Proxy> proxies;
    private int nextProxyIndex;
    private List<? extends InetSocketAddress> inetSocketAddresses;
    private final List<Route> postponedRoutes;

    /*
     * WARNING - void declaration
     */
    public RouteSelector(Address address, RouteDatabase routeDatabase, Call call, EventListener eventListener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)routeDatabase, (String)"routeDatabase");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.address = var1_1;
        this.routeDatabase = var2_2;
        this.call = var3_3;
        this.eventListener = eventListener;
        this.proxies = CollectionsKt.emptyList();
        this.inetSocketAddresses = CollectionsKt.emptyList();
        this.postponedRoutes = new ArrayList();
        RouteSelector routeSelector = this;
        routeSelector.resetNextProxy(routeSelector.address.url(), this.address.proxy());
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || !((Collection)this.postponedRoutes).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final Selection next() throws IOException {
        void var1_1;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List routes = new ArrayList();
        while (this.hasNextProxy()) {
            Proxy proxy = this.nextProxy();
            for (InetSocketAddress inetSocketAddress : this.inetSocketAddresses) {
                Route route = new Route(this.address, proxy, inetSocketAddress);
                if (this.routeDatabase.shouldPostpone(route)) {
                    ((Collection)this.postponedRoutes).add(route);
                    continue;
                }
                ((Collection)routes).add(route);
            }
            if (!(!((Collection)routes).isEmpty())) continue;
        }
        if (routes.isEmpty()) {
            CollectionsKt.addAll((Collection)routes, (Iterable)this.postponedRoutes);
            this.postponedRoutes.clear();
        }
        return new Selection((List<Route>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void resetNextProxy(HttpUrl url, Proxy proxy) {
        void var1_1;
        void var2_2;
        this.eventListener.proxySelectStart(this.call, url);
        this.proxies = RouteSelector.resetNextProxy$selectProxies((Proxy)var2_2, url, this);
        this.nextProxyIndex = 0;
        this.eventListener.proxySelectEnd(this.call, (HttpUrl)var1_1, this.proxies);
    }

    private final boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    /*
     * WARNING - void declaration
     */
    private final Proxy nextProxy() throws IOException {
        void var1_2;
        if (!this.hasNextProxy()) {
            throw new SocketException("No route to " + this.address.url().host() + "; exhausted proxy configurations: " + this.proxies);
        }
        int n = this.nextProxyIndex;
        this.nextProxyIndex = n + 1;
        Proxy result = this.proxies.get(n);
        this.resetNextInetSocketAddress(result);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void resetNextInetSocketAddress(Proxy proxy) throws IOException {
        Iterator iterator;
        Object object;
        int socketPort;
        String socketHost2;
        List mutableInetSocketAddresses;
        this.inetSocketAddresses = mutableInetSocketAddresses = (List)new ArrayList();
        if (proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.SOCKS) {
            socketHost2 = this.address.url().host();
            socketPort = this.address.url().port();
        } else {
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                String socketHost2 = "Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass();
                throw new IllegalArgumentException(socketHost2.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)proxyAddress, (String)"proxyAddress");
            socketHost2 = Companion.getSocketHost((InetSocketAddress)proxyAddress);
            socketPort = ((InetSocketAddress)proxyAddress).getPort();
        }
        if (!(socketPort > 0 ? socketPort < 65536 : false)) {
            throw new SocketException("No route to " + socketHost2 + ':' + socketPort + "; port is out of range");
        }
        if (proxy.type() == Proxy.Type.SOCKS) {
            ((Collection)mutableInetSocketAddresses).add(InetSocketAddress.createUnresolved(socketHost2, socketPort));
            return;
        }
        if (Util.canParseAsIpAddress(socketHost2)) {
            object = CollectionsKt.listOf((Object)InetAddress.getByName(socketHost2));
        } else {
            this.eventListener.dnsStart(this.call, socketHost2);
            List<InetAddress> result = this.address.dns().lookup(socketHost2);
            if (result.isEmpty()) {
                throw new UnknownHostException(this.address.dns() + " returned no addresses for " + socketHost2);
            }
            this.eventListener.dnsEnd(this.call, socketHost2, result);
            object = iterator;
        }
        List list = object;
        iterator = object.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            InetAddress inetAddress = (InetAddress)iterator.next();
            ((Collection)mutableInetSocketAddresses).add(new InetSocketAddress((InetAddress)var3_3, socketPort));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Proxy> resetNextProxy$selectProxies(Proxy $proxy, HttpUrl $url, RouteSelector this$0) {
        Object object;
        void var2_2;
        Proxy[] proxyArray;
        Proxy proxy = $proxy;
        if (proxy != null) {
            return CollectionsKt.listOf((Object)proxy);
        }
        Object uri = proxyArray.uri();
        if (uri.getHost() == null) {
            Proxy[] proxyArray2 = new Proxy[1];
            uri = proxyArray2;
            proxyArray2[0] = Proxy.NO_PROXY;
            return Util.immutableListOf(uri);
        }
        Object proxiesOrNull = var2_2.address.proxySelector().select((URI)uri);
        proxyArray = proxiesOrNull;
        if (proxyArray == null || proxyArray.isEmpty()) {
            Proxy[] proxyArray3 = new Proxy[1];
            proxyArray = proxyArray3;
            proxyArray3[0] = Proxy.NO_PROXY;
            return Util.immutableListOf(proxyArray);
        }
        Intrinsics.checkNotNullExpressionValue((Object)proxiesOrNull, (String)"proxiesOrNull");
        return Util.toImmutableList(object);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007"}, d2={"Lokhttp3/internal/connection/RouteSelector$Companion;", "", "<init>", "()V", "Ljava/net/InetSocketAddress;", "", "getSocketHost", "(Ljava/net/InetSocketAddress;)Ljava/lang/String;", "socketHost"})
    public static final class Companion {
        private Companion() {
        }

        public final String getSocketHost(InetSocketAddress $this$socketHost) {
            InetAddress inetAddress;
            Intrinsics.checkNotNullParameter((Object)$this$socketHost, (String)"<this>");
            InetAddress inetAddress2 = $this$socketHost.getAddress();
            if (inetAddress2 == null) {
                String string = ((InetSocketAddress)((Object)inetAddress)).getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hostName");
                return string;
            }
            inetAddress = inetAddress2;
            String string = inetAddress2.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.hostAddress");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lokhttp3/internal/connection/RouteSelector$Selection;", "", "", "Lokhttp3/Route;", "routes", "<init>", "(Ljava/util/List;)V", "", "hasNext", "()Z", "next", "()Lokhttp3/Route;", "", "nextRouteIndex", "I", "Ljava/util/List;", "getRoutes", "()Ljava/util/List;"})
    public static final class Selection {
        private final List<Route> routes;
        private int nextRouteIndex;

        /*
         * WARNING - void declaration
         */
        public Selection(List<Route> routes) {
            void var1_1;
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            this.routes = var1_1;
        }

        public final List<Route> getRoutes() {
            return this.routes;
        }

        public final boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        public final Route next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.nextRouteIndex;
            this.nextRouteIndex = n + 1;
            return this.routes.get(n);
        }
    }
}

