/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.platform.Platform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ5\u0010\u0015\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00100"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "maxIdleConnections", "", "keepAliveDuration", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;)V", "Lokhttp3/Address;", "address", "Lokhttp3/internal/connection/RealCall;", "call", "", "Lokhttp3/Route;", "routes", "", "requireMultiplexed", "callAcquirePooledConnection", "(Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Ljava/util/List;Z)Z", "now", "cleanup", "(J)J", "Lokhttp3/internal/connection/RealConnection;", "connection", "connectionBecameIdle", "(Lokhttp3/internal/connection/RealConnection;)Z", "", "evictAll", "()V", "pruneAndGetAllocationCount", "(Lokhttp3/internal/connection/RealConnection;J)I", "put", "(Lokhttp3/internal/connection/RealConnection;)V", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "cleanupTask", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "keepAliveDurationNs", "J", "I", "Companion"})
@SourceDebugExtension(value={"SMAP\nRealConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,250:1\n1#2:251\n1774#3,4:252\n608#4,4:256\n608#4,4:260\n608#4,4:264\n*S KotlinDebug\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n*L\n60#1:252,4\n95#1:256,4\n106#1:260,4\n215#1:264,4\n*E\n"})
public final class RealConnectionPool {
    public static final Companion Companion = new Companion(null);
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    private final ConcurrentLinkedQueue<RealConnection> connections;

    /*
     * WARNING - void declaration
     */
    public RealConnectionPool(TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
        String string;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.maxIdleConnections = var2_2;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.cleanupQueue = ((TaskRunner)((Object)string)).newQueue();
        string = Util.okHttpName + " ConnectionPool";
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ RealConnectionPool this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2, false, 2, null);
            }

            public final long runOnce() {
                return this.this$0.cleanup(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            void var3_3;
            string = "keepAliveDuration <= 0: " + (long)var3_3;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean callAcquirePooledConnection(Address address, RealCall call, List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                block5: {
                    if (requireMultiplexed && !connection.isMultiplexed$okhttp() || !connection.isEligible$okhttp(address, routes)) break block5;
                    call.acquireConnectionNoEvents(connection);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void put(RealConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        this.connections.add((RealConnection)var1_1);
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean connectionBecameIdle(RealConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            void var1_1;
            connection.setNoNewExchanges(true);
            this.connections.remove(var1_1);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return true;
        }
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        return false;
    }

    public final void evictAll() {
        Iterator<RealConnection> iterator = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"connections.iterator()");
        Iterator<RealConnection> i = iterator;
        while (i.hasNext()) {
            RealConnection realConnection;
            RealConnection connection = i.next();
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            RealConnection realConnection2 = connection;
            synchronized (realConnection2) {
                Object object;
                if (connection.getCalls().isEmpty()) {
                    i.remove();
                    connection.setNoNewExchanges(true);
                    object = realConnection.socket();
                } else {
                    object = null;
                }
                realConnection = object;
            }
            if (realConnection == null) continue;
            Util.closeQuietly((Socket)((Object)realConnection));
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long cleanup(long now) {
        void var3_4;
        int inUseConnectionCount = 0;
        int idleConnectionCount = 0;
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = Long.MIN_VALUE;
        for (RealConnection connection2 : this.connections) {
            Intrinsics.checkNotNullExpressionValue((Object)connection2, (String)"connection");
            RealConnection realConnection = connection2;
            synchronized (realConnection) {
                if (this.pruneAndGetAllocationCount(connection2, now) > 0) {
                    int connection2 = inUseConnectionCount;
                    inUseConnectionCount = connection2 + 1;
                    Integer.valueOf(connection2);
                } else {
                    RealConnection connection2;
                    ++idleConnectionCount;
                    long idleDurationNs = now - connection2.getIdleAtNs$okhttp();
                    if (idleDurationNs > longestIdleDurationNs) {
                        longestIdleDurationNs = idleDurationNs;
                        longestIdleConnection = connection2;
                    }
                }
            }
        }
        if (longestIdleDurationNs >= this.keepAliveDurationNs || idleConnectionCount > this.maxIdleConnections) {
            RealConnection realConnection = longestIdleConnection;
            Intrinsics.checkNotNull(realConnection);
            RealConnection connection = realConnection;
            RealConnection realConnection2 = realConnection;
            synchronized (realConnection) {
                block17: {
                    void var1_1;
                    block16: {
                        if (!(!((Collection)connection.getCalls()).isEmpty())) break block16;
                        // ** MonitorExit[var7_11] (shouldn't be in output)
                        return 0L;
                    }
                    if (connection.getIdleAtNs$okhttp() + longestIdleDurationNs == var1_1) break block17;
                    // ** MonitorExit[var7_11] (shouldn't be in output)
                    return 0L;
                }
                connection.setNoNewExchanges(true);
                this.connections.remove(longestIdleConnection);
                // ** MonitorExit[var7_11] (shouldn't be in output)
                Util.closeQuietly(connection.socket());
                if (this.connections.isEmpty()) {
                    this.cleanupQueue.cancelAll();
                }
                return 0L;
            }
        }
        if (idleConnectionCount > 0) {
            return this.keepAliveDurationNs - longestIdleDurationNs;
        }
        if (var3_4 > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            void var2_2;
            void var1_1;
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull(reference, (String)"null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            RealCall.CallReference callReference = (RealCall.CallReference)reference;
            String message = "A connection to " + connection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, callReference.getCallStackTrace());
            references.remove(i);
            connection.setNoNewExchanges(true);
            if (!references.isEmpty()) continue;
            var1_1.setIdleAtNs$okhttp((long)(var2_2 - this.keepAliveDurationNs));
            return 0;
        }
        return references.size();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

