/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J7\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ?\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0018\u00a2\u0006\u0004\b \u0010!J\u0011\u0010#\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010'\u001a\u00020\u00182\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010.\u001a\u0004\b/\u00100R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00101R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R\u0016\u00103\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00105R\u0018\u00106\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00104R\u0016\u00109\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00104R\u0018\u0010;\u001a\u0004\u0018\u00010:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0018\u0010>\u001a\u0004\u0018\u00010=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?"}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/Address;", "address", "Lokhttp3/internal/connection/RealCall;", "call", "Lokhttp3/EventListener;", "eventListener", "<init>", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;)V", "Lokhttp3/OkHttpClient;", "client", "Lokhttp3/internal/http/RealInterceptorChain;", "chain", "Lokhttp3/internal/http/ExchangeCodec;", "find", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/http/RealInterceptorChain;)Lokhttp3/internal/http/ExchangeCodec;", "", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "", "connectionRetryEnabled", "Lokhttp3/internal/connection/RealConnection;", "findConnection", "(IIIIZ)Lokhttp3/internal/connection/RealConnection;", "doExtensiveHealthChecks", "findHealthyConnection", "(IIIIZZ)Lokhttp3/internal/connection/RealConnection;", "retryAfterFailure", "()Z", "Lokhttp3/Route;", "retryRoute", "()Lokhttp3/Route;", "Lokhttp3/HttpUrl;", "url", "sameHostAndPort", "(Lokhttp3/HttpUrl;)Z", "Ljava/io/IOException;", "e", "", "trackFailure", "(Ljava/io/IOException;)V", "Lokhttp3/Address;", "getAddress$okhttp", "()Lokhttp3/Address;", "Lokhttp3/internal/connection/RealCall;", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionShutdownCount", "I", "Lokhttp3/EventListener;", "nextRouteToTry", "Lokhttp3/Route;", "otherFailureCount", "refusedStreamCount", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "Lokhttp3/internal/connection/RouteSelector;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;"})
public final class ExchangeFinder {
    private final RealConnectionPool connectionPool;
    private final Address address;
    private final RealCall call;
    private final EventListener eventListener;
    private RouteSelector.Selection routeSelection;
    private RouteSelector routeSelector;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    private Route nextRouteToTry;

    /*
     * WARNING - void declaration
     */
    public ExchangeFinder(RealConnectionPool connectionPool, Address address, RealCall call, EventListener eventListener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.connectionPool = var1_1;
        this.address = var2_2;
        this.call = var3_3;
        this.eventListener = eventListener;
    }

    public final Address getAddress$okhttp() {
        return this.address;
    }

    /*
     * WARNING - void declaration
     */
    public final ExchangeCodec find(OkHttpClient client, RealInterceptorChain chain) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        try {
            void var2_2;
            void var1_1;
            RealConnection realConnection = this.findHealthyConnection(chain.getConnectTimeoutMillis$okhttp(), chain.getReadTimeoutMillis$okhttp(), chain.getWriteTimeoutMillis$okhttp(), client.pingIntervalMillis(), client.retryOnConnectionFailure(), !Intrinsics.areEqual((Object)chain.getRequest$okhttp().method(), (Object)"GET"));
            return realConnection.newCodec$okhttp((OkHttpClient)var1_1, (RealInterceptorChain)var2_2);
        }
        catch (RouteException e) {
            this.trackFailure(e.getLastConnectException());
            throw e;
        }
        catch (IOException e) {
            void var3_5;
            this.trackFailure(e);
            throw new RouteException((IOException)var3_5);
        }
    }

    private final RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException {
        while (true) {
            RealConnection candidate;
            if ((candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled)).isHealthy(doExtensiveHealthChecks)) {
                return candidate;
            }
            candidate.noNewExchanges$okhttp();
            if (this.nextRouteToTry != null) continue;
            RouteSelector.Selection selection = this.routeSelection;
            boolean bl = selection != null ? selection.hasNext() : true;
            if (bl) continue;
            RouteSelector routeSelector = this.routeSelector;
            bl = routeSelector != null ? routeSelector.hasNext() : true;
            if (!bl) break;
        }
        throw new IOException("exhausted all routes");
    }

    /*
     * Unable to fully structure code
     */
    private final RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled) throws IOException {
        block24: {
            block23: {
                if (this.call.isCanceled()) {
                    throw new IOException("Canceled");
                }
                callConnection = this.call.getConnection();
                if (callConnection != null) {
                    toClose = null;
                    var8_11 = callConnection;
                    synchronized (var8_11) {
                        if (callConnection.getNoNewExchanges() || !this.sameHostAndPort(callConnection.route().address().url())) {
                            toClose = this.call.releaseConnectionNoEvents$okhttp();
                        }
                    }
                    if (this.call.getConnection() != null) {
                        if (!(toClose == null)) {
                            callConnection = "Check failed.";
                            throw new IllegalStateException(callConnection.toString());
                        }
                        return callConnection;
                    }
                    v0 = toClose;
                    if (v0 != null) {
                        Util.closeQuietly(v0);
                    }
                    this.eventListener.connectionReleased(this.call, (Connection)callConnection);
                }
                this.refusedStreamCount = 0;
                this.connectionShutdownCount = 0;
                this.otherFailureCount = 0;
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, null, false)) {
                    v1 = this.call.getConnection();
                    Intrinsics.checkNotNull((Object)v1);
                    result = v1;
                    this.eventListener.connectionAcquired(this.call, result);
                    return result;
                }
                if (this.nextRouteToTry == null) break block23;
                routes = null;
                v2 = this.nextRouteToTry;
                Intrinsics.checkNotNull((Object)v2);
                route = v2;
                this.nextRouteToTry = null;
                break block24;
            }
            if (this.routeSelection == null) ** GOTO lbl-1000
            v3 = this.routeSelection;
            Intrinsics.checkNotNull((Object)v3);
            if (v3.hasNext()) {
                routes = null;
                v4 = this.routeSelection;
                Intrinsics.checkNotNull((Object)v4);
                route = v4.next();
            } else lbl-1000:
            // 2 sources

            {
                if ((localRouteSelector = this.routeSelector) == null) {
                    this.routeSelector = localRouteSelector = new RouteSelector(this.address, this.call.getClient().getRouteDatabase(), this.call, this.eventListener);
                }
                this.routeSelection = localRouteSelection = localRouteSelector.next();
                routes = localRouteSelection.getRoutes();
                if (this.call.isCanceled()) {
                    throw new IOException("Canceled");
                }
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, routes, false)) {
                    v5 = this.call.getConnection();
                    Intrinsics.checkNotNull((Object)v5);
                    result = v5;
                    this.eventListener.connectionAcquired(this.call, result);
                    return var1_2;
                }
                route = localRouteSelection.next();
            }
        }
        newConnection = new RealConnection(this.connectionPool, route);
        this.call.setConnectionToCancel(newConnection);
        try {
            newConnection.connect((int)var1_1, (int)var2_4, (int)var3_5, pingIntervalMillis, connectionRetryEnabled, this.call, this.eventListener);
        }
        finally {
            this.call.setConnectionToCancel(null);
        }
        this.call.getClient().getRouteDatabase().connected(newConnection.route());
        if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, routes, true)) {
            v6 = this.call.getConnection();
            Intrinsics.checkNotNull((Object)v6);
            result = v6;
            this.nextRouteToTry = route;
            Util.closeQuietly(newConnection.socket());
            this.eventListener.connectionAcquired(this.call, result);
            return result;
        }
        var9_12 = newConnection;
        synchronized (var9_12) {
            this.connectionPool.put(newConnection);
            this.call.acquireConnectionNoEvents(newConnection);
        }
        this.eventListener.connectionAcquired(this.call, newConnection);
        return newConnection;
    }

    /*
     * WARNING - void declaration
     */
    public final void trackFailure(IOException e2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        this.nextRouteToTry = null;
        if (e2 instanceof StreamResetException && ((StreamResetException)e2).errorCode == ErrorCode.REFUSED_STREAM) {
            int e2 = this.refusedStreamCount;
            this.refusedStreamCount = e2 + 1;
            return;
        }
        if (var1_1 instanceof ConnectionShutdownException) {
            int n = this.connectionShutdownCount;
            this.connectionShutdownCount = n + 1;
            return;
        }
        int n = this.otherFailureCount;
        this.otherFailureCount = n + 1;
    }

    public final boolean retryAfterFailure() {
        RouteSelector routeSelector;
        if (this.refusedStreamCount == 0 && this.connectionShutdownCount == 0 && this.otherFailureCount == 0) {
            return false;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        Route retryRoute = this.retryRoute();
        if (retryRoute != null) {
            this.nextRouteToTry = routeSelector;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        boolean bl = selection != null ? selection.hasNext() : false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector2 = this.routeSelector;
        if (routeSelector2 == null) {
            return true;
        }
        routeSelector = routeSelector2;
        return routeSelector2.hasNext();
    }

    private final Route retryRoute() {
        if (this.refusedStreamCount > 1 || this.connectionShutdownCount > 1 || this.otherFailureCount > 0) {
            return null;
        }
        RealConnection realConnection = this.call.getConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection connection = realConnection;
        RealConnection realConnection2 = realConnection;
        synchronized (realConnection) {
            Route route;
            block8: {
                block7: {
                    if (connection.getRouteFailureCount$okhttp() == 0) break block7;
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return null;
                }
                if (Util.canReuseConnectionFor(connection.route().address().url(), this.address.url())) break block8;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return null;
            }
            route = ((RealConnection)((Object)route)).route();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return route;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean sameHostAndPort(HttpUrl url) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl routeUrl = this.address.url();
        return url.port() == routeUrl.port() && Intrinsics.areEqual((Object)var1_1.host(), (Object)var2_2.host());
    }
}

